import { __extends } from "tslib";
import { Pattern } from "./Pattern";
import * as $math from "../../util/Math";
/**
 * Rectangle pattern.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/colors-gradients-and-patterns/patterns/} for more info
 */
var RectanglePattern = /** @class */ (function (_super) {
    __extends(RectanglePattern, _super);
    function RectanglePattern() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(RectanglePattern.prototype, "_beforeChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._beforeChanged.call(this);
            if (this.isDirty("gap")) {
                this._clear = true;
            }
        }
    });
    Object.defineProperty(RectanglePattern.prototype, "_draw", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._draw.call(this);
            var checkered = this.get("checkered", false);
            var centered = this.get("centered", true);
            var gap = this.get("gap", 0);
            var rotation = this.get("rotation", 0);
            var w = this.get("width", 100);
            var h = this.get("height", 100);
            var rectW = this.get("maxWidth", 5);
            var rectH = this.get("maxHeight", 5);
            var cellW = rectW + gap;
            var cellH = rectH + gap;
            var cols = Math.round(w / cellW);
            var rows = Math.round(h / cellH);
            cellW = w / cols;
            cellH = h / rows;
            if (rotation != 0) {
                // @todo this is probably not right
                this._display.x = cellW / 2 * $math.cos(rotation);
                this._display.y = -cellH / 2 * $math.sin(rotation);
            }
            for (var r = rotation == 0 ? 0 : -rows * 2; r < rows * 2; r++) {
                for (var c = rotation == 0 ? 0 : -cols * 2; c < cols * 2; c++) {
                    if (!checkered || ((r & 1) != 1 && (c & 1) != 1) || ((r & 1) == 1 && (c & 1) == 1)) {
                        var x = c * cellW;
                        var y = r * cellH;
                        if (centered) {
                            x += (cellW - rectW) / 2;
                            y += (cellH - rectH) / 2;
                        }
                        this._display.drawRect(x, y, rectW, rectH);
                    }
                }
            }
            if (checkered) {
                w = w / 2 - gap * 2;
                h = h / 2 - gap * 2;
            }
            else {
                w -= gap;
                h -= gap;
            }
            var color = this.get("color");
            var colorOpacity = this.get("colorOpacity");
            if (color || colorOpacity) {
                // this._display.lineStyle(strokeWidth, stroke, colorOpacity);
                // this._display.endStroke();
                this._display.beginFill(color, colorOpacity);
                this._display.endFill();
            }
        }
    });
    Object.defineProperty(RectanglePattern, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "RectanglePattern"
    });
    Object.defineProperty(RectanglePattern, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Pattern.classNames.concat([RectanglePattern.className])
    });
    return RectanglePattern;
}(Pattern));
export { RectanglePattern };
//# sourceMappingURL=RectanglePattern.js.map