/** @ignore */ /** */
import * as $array from "./Array";
/**
 * @ignore
 */
var Result = /** @class */ (function () {
    function Result(duration, iterations) {
        Object.defineProperty(this, "duration", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: duration
        });
        Object.defineProperty(this, "iterations", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: iterations
        });
    }
    Object.defineProperty(Result.prototype, "ms", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return this.duration / this.iterations;
        }
    });
    return Result;
}());
/**
 * @ignore
 */
function runTest(fn) {
    var iterations = 0;
    var start = Date.now();
    var end = start + 10000;
    for (;;) {
        if (!fn()) {
            return;
        }
        ++iterations;
        var now = Date.now();
        if (now >= end) {
            return new Result(now - start, iterations);
        }
    }
}
/**
 * @ignore
 */
var Benchmark = /** @class */ (function () {
    function Benchmark() {
        Object.defineProperty(this, "tests", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: []
        });
    }
    Object.defineProperty(Benchmark.prototype, "test", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (name, fn) {
            this.tests.push({ name: name, fn: fn });
        }
    });
    Object.defineProperty(Benchmark.prototype, "run", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            console.log("Benchmark starting...");
            var maxLen = 0;
            $array.each(this.tests, function (test) {
                if (!test.fn()) {
                    throw new Error(test.name + " failed");
                }
                maxLen = Math.max(maxLen, test.name.length);
            });
            var empty = runTest(function () { return true; }).ms();
            $array.each(this.tests, function (test) {
                var result = runTest(test.fn);
                if (result) {
                    console.log(test.name.padStart(maxLen) + ":  " + (result.ms() - empty).toFixed(10) + " ms");
                }
                else {
                    throw new Error(test.name + " failed");
                }
            });
            console.log("Benchmark finished");
        }
    });
    return Benchmark;
}());
export { Benchmark };
//# sourceMappingURL=Benchmark.js.map