import { __extends } from "tslib";
import { List } from "./List";
/**
 * A [[List]] that holds components data.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/data/} for more info
 */
var ListData = /** @class */ (function (_super) {
    __extends(ListData, _super);
    function ListData() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * An optional processor for data.
         *
         * @see {@link https://www.amcharts.com/docs/v5/concepts/data/#Pre_processing_data} for more info
         */
        Object.defineProperty(_this, "processor", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        return _this;
    }
    /**
     * @ignore
     */
    Object.defineProperty(ListData.prototype, "incrementRef", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () { }
    });
    /**
     * @ignore
     */
    Object.defineProperty(ListData.prototype, "decrementRef", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () { }
    });
    Object.defineProperty(ListData.prototype, "_onPush", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (newValue) {
            if (this.processor) {
                this.processor.processRow(newValue);
                //console.log(newValue)
            }
            _super.prototype._onPush.call(this, newValue);
        }
    });
    Object.defineProperty(ListData.prototype, "_onInsertIndex", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (index, newValue) {
            if (this.processor) {
                this.processor.processRow(newValue);
            }
            _super.prototype._onInsertIndex.call(this, index, newValue);
        }
    });
    Object.defineProperty(ListData.prototype, "_onSetIndex", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (index, oldValue, newValue) {
            if (this.processor) {
                this.processor.processRow(newValue);
            }
            _super.prototype._onSetIndex.call(this, index, oldValue, newValue);
        }
    });
    return ListData;
}(List));
export { ListData };
/**
 * @deprecated
 * @todo remove
 */
var JsonData = /** @class */ (function () {
    function JsonData(value) {
        Object.defineProperty(this, "processor", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "_value", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this._value = value;
    }
    Object.defineProperty(JsonData.prototype, "incrementRef", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () { }
    });
    Object.defineProperty(JsonData.prototype, "decrementRef", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () { }
    });
    return JsonData;
}());
export { JsonData };
//# sourceMappingURL=Data.js.map