import { __extends, __read, __spreadArray } from "tslib";
import { Entity } from "./Entity";
import * as $array from "./Array";
import en from "../../../locales/en";
;
var Language = /** @class */ (function (_super) {
    __extends(Language, _super);
    function Language() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(Language.prototype, "_setDefaults", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this.setPrivate("defaultLocale", en);
            _super.prototype._setDefaults.call(this);
        }
    });
    Object.defineProperty(Language.prototype, "translate", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (prompt, locale) {
            var rest = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                rest[_i - 2] = arguments[_i];
            }
            // Get langauge
            if (!locale) {
                locale = this._root.locale || this.getPrivate("defaultLocale");
            }
            // Init translation
            var translation = prompt;
            var value = locale[prompt];
            // Try to look for the translation
            if (value === null) {
                translation = "";
            }
            else if (value != null) {
                // It might be an empty string
                if (value) {
                    translation = value;
                }
            }
            else if (locale !== this.getPrivate("defaultLocale")) {
                // Try to look in default language
                return this.translate.apply(this, __spreadArray([prompt, this.getPrivate("defaultLocale")], __read(rest)));
            }
            // Replace %1, %2, etc params
            if (rest.length) {
                for (var len = rest.length, i = 0; i < len; ++i) {
                    translation = translation.split("%" + (i + 1)).join(rest[i]);
                }
            }
            // Return the translation
            return translation;
        }
    });
    Object.defineProperty(Language.prototype, "translateAny", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (prompt, locale) {
            var rest = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                rest[_i - 2] = arguments[_i];
            }
            return this.translate.apply(this, __spreadArray([prompt, locale], __read(rest)));
        }
    });
    Object.defineProperty(Language.prototype, "setTranslationAny", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (prompt, translation, locale) {
            var localeTarget = locale || this._root.locale;
            localeTarget[prompt] = translation;
        }
    });
    Object.defineProperty(Language.prototype, "translateEmpty", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (prompt, locale) {
            var rest = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                rest[_i - 2] = arguments[_i];
            }
            var translation = this.translate.apply(this, __spreadArray([prompt, locale], __read(rest)));
            return translation == prompt ? "" : translation;
        }
    });
    Object.defineProperty(Language.prototype, "translateFunc", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (prompt, locale) {
            if (this._root.locale[prompt]) {
                return this._root.locale[prompt];
            }
            // Try to look in default language
            if (locale !== this.getPrivate("defaultLocale")) {
                return this.translateFunc(prompt, this.getPrivate("defaultLocale"));
            }
            // Fail - return empty function
            return function () {
                return "";
            };
        }
    });
    Object.defineProperty(Language.prototype, "translateAll", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (list, locale) {
            var _this = this;
            // Translate all items in the list
            if (!this.isDefault()) {
                return $array.map(list, function (x) { return _this.translate(x, locale); });
            }
            else {
                return list;
            }
        }
    });
    /**
     * Returns `true` if the currently selected locale is a default locale.
     *
     * @return `true` if locale is default; `false` if it is not.
     */
    Object.defineProperty(Language.prototype, "isDefault", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return this.getPrivate("defaultLocale") === this._root.locale;
        }
    });
    return Language;
}(Entity));
export { Language };
//# sourceMappingURL=Language.js.map