import { __extends } from "tslib";
import { Entity } from "./Entity";
import { StyleRule } from "./Utils";
import { MultiDisposer, CounterDisposer } from "../../core/util/Disposer";
import * as $utils from "./Utils";
/**
 * @ignore
 */
var rules;
/**
 * @ignore
 */
function modalCSS(element, root, _prefix) {
    var ic = root.interfaceColors;
    if (!rules) {
        var disposer_1 = new MultiDisposer([
            new StyleRule(element, ".am5-modal", {
                "width": "100%",
                "height": "100%",
                "position": "relative",
                "z-index": "1000"
            }),
            new StyleRule(element, ".am5-modal-curtain", {
                "top": "0",
                "left": "0",
                "width": "100%",
                "height": "100%",
                "position": "absolute",
                "background": ic.get("background").toCSS(0.5),
                "z-index": "100"
            }),
            new StyleRule(element, ".am5-modal-wrapper", {
                "top": "0",
                "left": "0",
                "width": "100%",
                "height": "100%",
                "position": "absolute",
                "text-align": "center",
                "white-space": "nowrap",
                "background": ic.get("background").toCSS(0.5),
                "z-index": "101"
            }),
            new StyleRule(element, ".am5-modal-wrapper:before", {
                "content": "''",
                "display": "inline-block",
                "height": "100%",
                "vertical-align": "middle",
                "margin-right": "-0.25em"
            }),
            new StyleRule(element, ".am5-modal-content", {
                "display": "inline-block",
                "padding": "1em",
                "vertical-align": "middle",
                "background": ic.get("background").toCSS(),
                "border": "1px solid " + ic.get("alternativeBackground").toCSS()
            }),
        ]);
        rules = new CounterDisposer(function () {
            rules = undefined;
            disposer_1.dispose();
        });
    }
    return rules.increment();
}
/**
 * Used to display a modal dialog with HTML content.
 */
var Modal = /** @class */ (function (_super) {
    __extends(Modal, _super);
    function Modal() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    //protected _currentPass: number = 0;
    Object.defineProperty(Modal.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            // Applying themes because this will not have parents
            _super.prototype._afterNewApplyThemes.call(this);
            // Load CSS
            modalCSS($utils.getShadowRoot(this._root.dom), this._root);
            // Create elements
            var container = document.createElement("div");
            container.className = "am5-modal";
            container.style.display = "none";
            this.root.dom.appendChild(container);
            this.setPrivate("container", container);
            var curtain = document.createElement("div");
            curtain.className = "am5-modal-curtain";
            container.appendChild(curtain);
            this.setPrivate("curtain", curtain);
            $utils.addEventListener(curtain, "click", function () {
                _this.cancel();
            });
            var wrapper = document.createElement("div");
            wrapper.className = "am5-modal-wrapper";
            container.appendChild(wrapper);
            this.setPrivate("wrapper", wrapper);
            var content = document.createElement("div");
            content.className = "am5-modal-content";
            wrapper.appendChild(content);
            this.setPrivate("content", content);
            var html = this.get("content");
            if (html) {
                content.innerHTML = html;
            }
            // Close on ESC
            if ($utils.supports("keyboardevents")) {
                this._disposers.push($utils.addEventListener(document, "keydown", function (ev) {
                    if (_this.isOpen() && ev.keyCode == 27) {
                        _this.cancel();
                    }
                }));
            }
        }
    });
    Object.defineProperty(Modal.prototype, "_beforeChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._beforeChanged.call(this);
            if (this.isDirty("content")) {
                this.getPrivate("content").innerHTML = this.get("content", "");
            }
        }
    });
    /**
     * Returns `true` if modal is currently open.
     *
     * @return  Modal open?
     */
    Object.defineProperty(Modal.prototype, "isOpen", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return this.getPrivate("container").style.display != "none";
        }
    });
    /**
     * Opens modal.
     */
    Object.defineProperty(Modal.prototype, "open", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this.getPrivate("container").style.display = "block";
            this.events.dispatch("opened", {
                type: "opened",
                target: this
            });
        }
    });
    /**
     * Closes modal.
     */
    Object.defineProperty(Modal.prototype, "close", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this.getPrivate("container").style.display = "none";
            this.events.dispatch("closed", {
                type: "closed",
                target: this
            });
        }
    });
    /**
     * Closes modal and invokes `cancelled` event.
     */
    Object.defineProperty(Modal.prototype, "cancel", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this.getPrivate("container").style.display = "none";
            this.events.dispatch("cancelled", {
                type: "cancelled",
                target: this
            });
        }
    });
    /**
     * Disposes modal.
     */
    Object.defineProperty(Modal.prototype, "dispose", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype.dispose.call(this);
            this.root.dom.removeChild(this.getPrivate("container"));
        }
    });
    Object.defineProperty(Modal, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Modal"
    });
    Object.defineProperty(Modal, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Entity.classNames.concat([Modal.className])
    });
    return Modal;
}(Entity));
export { Modal };
//# sourceMappingURL=Modal.js.map