import { EventDispatcher } from "./EventDispatcher";
import { Disposer, MultiDisposer } from "./Disposer";
import * as $array from "./Array";
import * as $object from "./Object";
var TemplateState = /** @class */ (function () {
    function TemplateState(name, template, settings) {
        Object.defineProperty(this, "_settings", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "_name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "_template", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this._name = name;
        this._template = template;
        this._settings = settings;
    }
    Object.defineProperty(TemplateState.prototype, "get", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (key, fallback) {
            var value = this._settings[key];
            if (value !== undefined) {
                return value;
            }
            else {
                return fallback;
            }
        }
    });
    Object.defineProperty(TemplateState.prototype, "set", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (key, value) {
            this._settings[key] = value;
            // TODO maybe only do this if the value changed ?
            this._template._stateChanged(this._name);
        }
    });
    Object.defineProperty(TemplateState.prototype, "remove", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (key) {
            delete this._settings[key];
            // TODO maybe only do this if the value changed ?
            this._template._stateChanged(this._name);
        }
    });
    Object.defineProperty(TemplateState.prototype, "setAll", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (settings) {
            var _this = this;
            $object.keys(settings).forEach(function (key) {
                _this._settings[key] = settings[key];
            });
            this._template._stateChanged(this._name);
        }
    });
    Object.defineProperty(TemplateState.prototype, "_apply", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (other, seen) {
            $object.each(this._settings, function (key, value) {
                if (!seen[key] && !other._userSettings[key]) {
                    seen[key] = true;
                    other.setRaw(key, value);
                }
            });
        }
    });
    return TemplateState;
}());
export { TemplateState };
var TemplateStates = /** @class */ (function () {
    function TemplateStates(template) {
        Object.defineProperty(this, "_template", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "_states", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: {}
        });
        this._template = template;
    }
    Object.defineProperty(TemplateStates.prototype, "lookup", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (name) {
            return this._states[name];
        }
    });
    Object.defineProperty(TemplateStates.prototype, "create", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (name, settings) {
            var state = this._states[name];
            if (state) {
                state.setAll(settings);
                return state;
            }
            else {
                var state_1 = new TemplateState(name, this._template, settings);
                this._states[name] = state_1;
                this._template._stateChanged(name);
                return state_1;
            }
        }
    });
    Object.defineProperty(TemplateStates.prototype, "remove", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (name) {
            delete this._states[name];
            this._template._stateChanged(name);
        }
    });
    Object.defineProperty(TemplateStates.prototype, "_apply", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (entity, state) {
            $object.each(this._states, function (key, value) {
                var seen = state.states[key];
                if (seen == null) {
                    seen = state.states[key] = {};
                }
                var other = entity.states.create(key, {});
                value._apply(other, seen);
            });
        }
    });
    return TemplateStates;
}());
export { TemplateStates };
var TemplateAdapters = /** @class */ (function () {
    function TemplateAdapters() {
        Object.defineProperty(this, "_callbacks", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: {}
        });
    }
    Object.defineProperty(TemplateAdapters.prototype, "add", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (key, callback) {
            var _this = this;
            var callbacks = this._callbacks[key];
            if (callbacks === undefined) {
                callbacks = this._callbacks[key] = [];
            }
            callbacks.push(callback);
            return new Disposer(function () {
                $array.removeFirst(callbacks, callback);
                if (callbacks.length === 0) {
                    delete _this._callbacks[key];
                }
            });
        }
    });
    Object.defineProperty(TemplateAdapters.prototype, "remove", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (key) {
            var callbacks = this._callbacks[key];
            if (callbacks !== undefined) {
                delete this._callbacks[key];
            }
        }
    });
    Object.defineProperty(TemplateAdapters.prototype, "_apply", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (entity) {
            var disposers = [];
            $object.each(this._callbacks, function (key, callbacks) {
                $array.each(callbacks, function (callback) {
                    disposers.push(entity.adapters.add(key, callback));
                });
            });
            return new MultiDisposer(disposers);
        }
    });
    return TemplateAdapters;
}());
export { TemplateAdapters };
// TODO maybe extend from Properties ?
var Template = /** @class */ (function () {
    function Template(settings, isReal) {
        Object.defineProperty(this, "_settings", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "_privateSettings", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: {}
        });
        // TODO code duplication with Properties
        Object.defineProperty(this, "_settingEvents", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: {}
        });
        Object.defineProperty(this, "_privateSettingEvents", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: {}
        });
        Object.defineProperty(this, "_entities", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: []
        });
        Object.defineProperty(this, "states", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new TemplateStates(this)
        });
        Object.defineProperty(this, "adapters", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new TemplateAdapters()
        });
        Object.defineProperty(this, "events", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new EventDispatcher()
        });
        Object.defineProperty(this, "setup", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        if (!isReal) {
            throw new Error("You cannot use `new Class()`, instead use `Class.new()`");
        }
        this._settings = settings;
    }
    /**
     * Use this method to create an instance of this class.
     *
     * @see {@link https://www.amcharts.com/docs/v5/getting-started/#New_element_syntax} for more info
     * @param   root      Root element
     * @param   settings  Settings
     * @param   template  Template
     * @return            Instantiated object
     */
    Object.defineProperty(Template, "new", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (settings) {
            return new Template(settings, true);
        }
    });
    Object.defineProperty(Template.prototype, "get", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (key, fallback) {
            var value = this._settings[key];
            if (value !== undefined) {
                return value;
            }
            else {
                return fallback;
            }
        }
    });
    Object.defineProperty(Template.prototype, "setRaw", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (key, value) {
            this._settings[key] = value;
        }
    });
    Object.defineProperty(Template.prototype, "set", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (key, value) {
            var _this = this;
            if (this._settings[key] !== value) {
                this.setRaw(key, value);
                this._entities.forEach(function (entity) {
                    entity._setTemplateProperty(_this, key, value);
                });
            }
        }
    });
    Object.defineProperty(Template.prototype, "remove", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (key) {
            if (key in this._settings) {
                delete this._settings[key];
                this._entities.forEach(function (entity) {
                    entity._removeTemplateProperty(key);
                });
            }
        }
    });
    Object.defineProperty(Template.prototype, "removeAll", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            $object.each(this._settings, function (key, _value) {
                _this.remove(key);
            });
        }
    });
    Object.defineProperty(Template.prototype, "getPrivate", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (key, fallback) {
            var value = this._privateSettings[key];
            if (value !== undefined) {
                return value;
            }
            else {
                return fallback;
            }
        }
    });
    Object.defineProperty(Template.prototype, "setPrivateRaw", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (key, value) {
            this._privateSettings[key] = value;
            return value;
        }
    });
    Object.defineProperty(Template.prototype, "setPrivate", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (key, value) {
            var _this = this;
            if (this._privateSettings[key] !== value) {
                this.setPrivateRaw(key, value);
                this._entities.forEach(function (entity) {
                    entity._setTemplatePrivateProperty(_this, key, value);
                });
            }
            return value;
        }
    });
    Object.defineProperty(Template.prototype, "removePrivate", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (key) {
            if (key in this._privateSettings) {
                delete this._privateSettings[key];
                this._entities.forEach(function (entity) {
                    entity._removeTemplatePrivateProperty(key);
                });
            }
        }
    });
    Object.defineProperty(Template.prototype, "setAll", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (value) {
            var _this = this;
            $object.each(value, function (key, value) {
                _this.set(key, value);
            });
        }
    });
    // TODO code duplication with Properties
    Object.defineProperty(Template.prototype, "on", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (key, callback) {
            var _this = this;
            var events = this._settingEvents[key];
            if (events === undefined) {
                events = this._settingEvents[key] = [];
            }
            events.push(callback);
            return new Disposer(function () {
                $array.removeFirst(events, callback);
                if (events.length === 0) {
                    delete _this._settingEvents[key];
                }
            });
        }
    });
    // TODO code duplication with Properties
    Object.defineProperty(Template.prototype, "onPrivate", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (key, callback) {
            var _this = this;
            var events = this._privateSettingEvents[key];
            if (events === undefined) {
                events = this._privateSettingEvents[key] = [];
            }
            events.push(callback);
            return new Disposer(function () {
                $array.removeFirst(events, callback);
                if (events.length === 0) {
                    delete _this._privateSettingEvents[key];
                }
            });
        }
    });
    Object.defineProperty(Template.prototype, "_apply", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (entity, state) {
            var disposers = [];
            $object.each(this._settingEvents, function (key, events) {
                $array.each(events, function (event) {
                    disposers.push(entity.on(key, event));
                });
            });
            $object.each(this._privateSettingEvents, function (key, events) {
                $array.each(events, function (event) {
                    disposers.push(entity.onPrivate(key, event));
                });
            });
            this.states._apply(entity, state);
            disposers.push(this.adapters._apply(entity));
            disposers.push(entity.events.copyFrom(this.events));
            return new MultiDisposer(disposers);
        }
    });
    Object.defineProperty(Template.prototype, "_setObjectTemplate", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (entity) {
            this._entities.push(entity);
        }
    });
    Object.defineProperty(Template.prototype, "_removeObjectTemplate", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (entity) {
            $array.remove(this._entities, entity);
        }
    });
    Object.defineProperty(Template.prototype, "_stateChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (name) {
            this._entities.forEach(function (entity) {
                entity._applyStateByKey(name);
            });
        }
    });
    return Template;
}());
export { Template };
//# sourceMappingURL=Template.js.map