function parseDate(timezone, date) {
    var year = 0;
    var month = 0;
    var day = 1;
    var hour = 0;
    var minute = 0;
    var second = 0;
    var millisecond = 0;
    timezone.formatToParts(date).forEach(function (x) {
        switch (x.type) {
            case "year":
                year = +x.value;
                break;
            case "month":
                month = (+x.value) - 1;
                break;
            case "day":
                day = +x.value;
                break;
            case "hour":
                hour = +x.value;
                break;
            case "minute":
                minute = +x.value;
                break;
            case "second":
                second = +x.value;
                break;
            case "fractionalSecond":
                millisecond = +x.value;
                break;
        }
    });
    if (hour === 24) {
        hour = 0;
    }
    return { year: year, month: month, day: day, hour: hour, minute: minute, second: second, millisecond: millisecond };
}
function toUTCDate(timezone, date) {
    var _a = parseDate(timezone, date), year = _a.year, month = _a.month, day = _a.day, hour = _a.hour, minute = _a.minute, second = _a.second, millisecond = _a.millisecond;
    return Date.UTC(year, month, day, hour, minute, second, millisecond);
}
var Timezone = /** @class */ (function () {
    function Timezone(timezone, isReal) {
        Object.defineProperty(this, "_utc", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "_dtf", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        if (!isReal) {
            throw new Error("You cannot use `new Class()`, instead use `Class.new()`");
        }
        this.name = timezone;
        this._utc = new Intl.DateTimeFormat("UTC", {
            hour12: false,
            timeZone: "UTC",
            year: "numeric",
            month: "2-digit",
            day: "2-digit",
            hour: "2-digit",
            minute: "2-digit",
            second: "2-digit",
            fractionalSecondDigits: 3,
        });
        this._dtf = new Intl.DateTimeFormat("UTC", {
            hour12: false,
            timeZone: timezone,
            year: "numeric",
            month: "2-digit",
            day: "2-digit",
            hour: "2-digit",
            minute: "2-digit",
            second: "2-digit",
            fractionalSecondDigits: 3,
        });
    }
    /**
     * Use this method to create an instance of this class.
     *
     * @see {@link https://www.amcharts.com/docs/v5/getting-started/#New_element_syntax} for more info
     * @param   timezone  IANA timezone
     * @return            Instantiated object
     */
    Object.defineProperty(Timezone, "new", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (timezone) {
            return (new this(timezone, true));
        }
    });
    Object.defineProperty(Timezone.prototype, "convertLocal", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (date) {
            var offset = this.offsetUTC(date);
            var userOffset = date.getTimezoneOffset();
            var output = new Date(date);
            output.setUTCMinutes(output.getUTCMinutes() - (offset - userOffset));
            return output;
        }
    });
    Object.defineProperty(Timezone.prototype, "offsetUTC", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (date) {
            var utc = toUTCDate(this._utc, date);
            var dtf = toUTCDate(this._dtf, date);
            return (utc - dtf) / 60000;
        }
    });
    Object.defineProperty(Timezone.prototype, "parseDate", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (date) {
            return parseDate(this._dtf, date);
        }
    });
    return Timezone;
}());
export { Timezone };
//# sourceMappingURL=Timezone.js.map