import { __extends } from "tslib";
import { Theme } from "../core/Theme";
import { MultiDisposer } from "../core/util/Disposer";
import { p100, percent } from "../core/util/Percent";
import * as $array from "../core/util/Array";
/**
 * A configurable theme that dynamically adapts chart settings for best fit
 * in available space.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/responsive/} for more info
 */
var ResponsiveTheme = /** @class */ (function (_super) {
    __extends(ResponsiveTheme, _super);
    function ResponsiveTheme() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * Currently added rules.
         */
        Object.defineProperty(_this, "responsiveRules", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: []
        });
        return _this;
    }
    // Breakpoint functions (for use in `relevant` clause of the responsive rules)
    Object.defineProperty(ResponsiveTheme, "widthXXS", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (width, _height) {
            return width <= ResponsiveTheme.XXS;
        }
    });
    Object.defineProperty(ResponsiveTheme, "widthXS", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (width, _height) {
            return width <= ResponsiveTheme.XS;
        }
    });
    Object.defineProperty(ResponsiveTheme, "widthS", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (width, _height) {
            return width <= ResponsiveTheme.S;
        }
    });
    Object.defineProperty(ResponsiveTheme, "widthM", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (width, _height) {
            return width <= ResponsiveTheme.M;
        }
    });
    Object.defineProperty(ResponsiveTheme, "widthL", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (width, _height) {
            return width <= ResponsiveTheme.L;
        }
    });
    Object.defineProperty(ResponsiveTheme, "widthXL", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (width, _height) {
            return width <= ResponsiveTheme.XL;
        }
    });
    Object.defineProperty(ResponsiveTheme, "widthXXL", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (width, _height) {
            return width <= ResponsiveTheme.XXL;
        }
    });
    Object.defineProperty(ResponsiveTheme, "heightXXS", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_width, height) {
            return height <= ResponsiveTheme.XXS;
        }
    });
    Object.defineProperty(ResponsiveTheme, "heightXS", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_width, height) {
            return height <= ResponsiveTheme.XS;
        }
    });
    Object.defineProperty(ResponsiveTheme, "heightS", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_width, height) {
            return height <= ResponsiveTheme.S;
        }
    });
    Object.defineProperty(ResponsiveTheme, "heightM", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_width, height) {
            return height <= ResponsiveTheme.M;
        }
    });
    Object.defineProperty(ResponsiveTheme, "heightL", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_width, height) {
            return height <= ResponsiveTheme.L;
        }
    });
    Object.defineProperty(ResponsiveTheme, "heightXL", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_width, height) {
            return height <= ResponsiveTheme.XL;
        }
    });
    Object.defineProperty(ResponsiveTheme, "heightXXL", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_width, height) {
            return height <= ResponsiveTheme.XXL;
        }
    });
    Object.defineProperty(ResponsiveTheme, "isXXS", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (width, height) {
            return (width <= ResponsiveTheme.XXS) && (height <= ResponsiveTheme.XXS);
        }
    });
    Object.defineProperty(ResponsiveTheme, "isXS", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (width, height) {
            return (width <= ResponsiveTheme.XS) && (height <= ResponsiveTheme.XS);
        }
    });
    Object.defineProperty(ResponsiveTheme, "isS", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (width, height) {
            return (width <= ResponsiveTheme.S) && (height <= ResponsiveTheme.S);
        }
    });
    Object.defineProperty(ResponsiveTheme, "isM", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (width, height) {
            return (width <= ResponsiveTheme.M) && (height <= ResponsiveTheme.M);
        }
    });
    Object.defineProperty(ResponsiveTheme, "isL", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (width, height) {
            return (width <= ResponsiveTheme.L) && (height <= ResponsiveTheme.L);
        }
    });
    Object.defineProperty(ResponsiveTheme, "isXL", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (width, height) {
            return (width <= ResponsiveTheme.XL) && (height <= ResponsiveTheme.XL);
        }
    });
    Object.defineProperty(ResponsiveTheme, "isXXL", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (width, height) {
            return (width <= ResponsiveTheme.XXL) && (height <= ResponsiveTheme.XXL);
        }
    });
    Object.defineProperty(ResponsiveTheme, "maybeXXS", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (width, height) {
            return (width <= ResponsiveTheme.XXS) || (height <= ResponsiveTheme.XXS);
        }
    });
    Object.defineProperty(ResponsiveTheme, "maybeXS", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (width, height) {
            return (width <= ResponsiveTheme.XS) || (height <= ResponsiveTheme.XS);
        }
    });
    Object.defineProperty(ResponsiveTheme, "maybeS", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (width, height) {
            return (width <= ResponsiveTheme.S) || (height <= ResponsiveTheme.S);
        }
    });
    Object.defineProperty(ResponsiveTheme, "maybeM", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (width, height) {
            return (width <= ResponsiveTheme.M) || (height <= ResponsiveTheme.M);
        }
    });
    Object.defineProperty(ResponsiveTheme, "maybeL", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (width, height) {
            return (width <= ResponsiveTheme.L) || (height <= ResponsiveTheme.L);
        }
    });
    Object.defineProperty(ResponsiveTheme, "maybeXL", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (width, height) {
            return (width <= ResponsiveTheme.XL) || (height <= ResponsiveTheme.XL);
        }
    });
    Object.defineProperty(ResponsiveTheme, "maybeXXL", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (width, height) {
            return (width <= ResponsiveTheme.XXL) || (height <= ResponsiveTheme.XXL);
        }
    });
    /**
     * Instantiates the theme without adding default respomsive rules.
     */
    Object.defineProperty(ResponsiveTheme, "newEmpty", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (root) {
            return (new this(root, true));
        }
    });
    /**
     * Adds a responsive rule as well as retuns it.
     *
     * @see {@link https://www.amcharts.com/docs/v5/concepts/responsive/} for more info
     * @param   rule  Responsive rule
     * @return        Responsive rule
     */
    Object.defineProperty(ResponsiveTheme.prototype, "addRule", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (rule) {
            var _this = this;
            if (rule.name && !rule.template) {
                rule.template = this.rule(rule.name, rule.tags);
            }
            rule._dp = new MultiDisposer([
                this._root._rootContainer.onPrivate("width", function (_width) { if (_this._isUsed()) {
                    _this._applyRule(rule);
                } }),
                this._root._rootContainer.onPrivate("height", function (_height) { if (_this._isUsed()) {
                    _this._applyRule(rule);
                } })
            ]);
            this.responsiveRules.push(rule);
            this._applyRule(rule);
            return rule;
        }
    });
    /**
     * Removes the responsive rule.
     *
     * @param  rule  Responsive rule
     */
    Object.defineProperty(ResponsiveTheme.prototype, "removeRule", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (rule) {
            $array.remove(this.responsiveRules, rule);
            if (rule._dp) {
                rule._dp.dispose();
            }
        }
    });
    Object.defineProperty(ResponsiveTheme.prototype, "_isUsed", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return this._root._rootContainer.get("themes").indexOf(this) !== -1;
        }
    });
    Object.defineProperty(ResponsiveTheme.prototype, "_applyRule", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (rule) {
            var w = this._root._rootContainer.getPrivate("width");
            var h = this._root._rootContainer.getPrivate("height");
            var relevant = rule.relevant.call(rule, w, h);
            var applied = rule.applied;
            if (relevant) {
                if (!applied) {
                    rule.applied = true;
                    if (rule.template && rule.settings) {
                        rule.template.setAll(rule.settings);
                    }
                    if (rule.applying) {
                        rule.applying.call(rule);
                    }
                }
            }
            else if (applied) {
                rule.applied = false;
                if (rule.template) {
                    rule.template.removeAll();
                }
                if (rule.removing) {
                    rule.removing.call(rule);
                }
            }
        }
    });
    /**
     * Adds default rules for various chart types and most standard scenarios.
     */
    Object.defineProperty(ResponsiveTheme.prototype, "setupDefaultRules", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            _super.prototype.setupDefaultRules.call(this);
            var addRule = function (rule) { return _this.addRule(rule); };
            /**
             * ========================================================================
             * Universal
             * ========================================================================
             */
            addRule({
                name: "Chart",
                relevant: ResponsiveTheme.widthXXS,
                settings: {
                    paddingLeft: 0,
                    paddingRight: 0
                }
            });
            addRule({
                name: "Chart",
                relevant: ResponsiveTheme.heightXXS,
                settings: {
                    paddingTop: 0,
                    paddingBottom: 0
                }
            });
            addRule({
                name: "Bullet",
                relevant: ResponsiveTheme.isXS,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "Legend",
                relevant: ResponsiveTheme.isXS,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "HeatLegend",
                tags: ["vertical"],
                relevant: ResponsiveTheme.widthXS,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "HeatLegend",
                tags: ["horizontal"],
                relevant: ResponsiveTheme.heightXS,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "Label",
                tags: ["heatlegend", "start"],
                relevant: ResponsiveTheme.maybeXS,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "Label",
                tags: ["heatlegend", "end"],
                relevant: ResponsiveTheme.maybeXS,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "Button",
                tags: ["resize"],
                relevant: ResponsiveTheme.maybeXS,
                settings: {
                    forceHidden: true
                }
            });
            /**
             * ========================================================================
             * XY
             * ========================================================================
             */
            addRule({
                name: "AxisRendererX",
                relevant: ResponsiveTheme.heightXS,
                settings: {
                    inside: true
                }
            });
            addRule({
                name: "AxisRendererY",
                relevant: ResponsiveTheme.widthXS,
                settings: {
                    inside: true
                }
            });
            addRule({
                name: "AxisRendererXLabel",
                relevant: ResponsiveTheme.heightXS,
                settings: {
                    minPosition: 0.1,
                    maxPosition: 0.9
                }
            });
            addRule({
                name: "AxisLabel",
                tags: ["y"],
                relevant: ResponsiveTheme.widthXS,
                settings: {
                    centerY: p100,
                    maxPosition: 0.9
                }
            });
            addRule({
                name: "AxisLabel",
                tags: ["x"],
                relevant: ResponsiveTheme.heightXXS,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "AxisLabel",
                tags: ["y"],
                relevant: ResponsiveTheme.widthXXS,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "AxisTick",
                tags: ["x"],
                relevant: ResponsiveTheme.heightXS,
                settings: {
                    inside: true,
                    minPosition: 0.1,
                    maxPosition: 0.9
                }
            });
            addRule({
                name: "AxisTick",
                tags: ["y"],
                relevant: ResponsiveTheme.widthXXS,
                settings: {
                    inside: true,
                    minPosition: 0.1,
                    maxPosition: 0.9
                }
            });
            addRule({
                name: "Grid",
                relevant: ResponsiveTheme.maybeXXS,
                settings: {
                    forceHidden: true
                }
            });
            /**
             * ========================================================================
             * Radar
             * ========================================================================
             */
            addRule({
                name: "RadialLabel",
                tags: ["radial"],
                relevant: ResponsiveTheme.maybeXS,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "RadialLabel",
                tags: ["circular"],
                relevant: ResponsiveTheme.maybeS,
                settings: {
                    inside: true
                }
            });
            addRule({
                name: "AxisTick",
                relevant: ResponsiveTheme.maybeS,
                settings: {
                    inside: true
                }
            });
            addRule({
                name: "RadialLabel",
                tags: ["circular"],
                relevant: ResponsiveTheme.maybeXS,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "AxisTick",
                tags: ["circular"],
                relevant: ResponsiveTheme.maybeXS,
                settings: {
                    inside: true
                }
            });
            /**
             * ========================================================================
             * Pie
             * ========================================================================
             */
            addRule({
                name: "PieChart",
                relevant: ResponsiveTheme.maybeXS,
                settings: {
                    radius: percent(99)
                }
            });
            addRule({
                name: "PieChart",
                relevant: ResponsiveTheme.widthM,
                settings: {
                    radius: percent(99)
                }
            });
            addRule({
                name: "RadialLabel",
                tags: ["pie"],
                relevant: ResponsiveTheme.maybeXS,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "RadialLabel",
                tags: ["pie"],
                relevant: ResponsiveTheme.widthM,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "Tick",
                tags: ["pie"],
                relevant: ResponsiveTheme.maybeXS,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "Tick",
                tags: ["pie"],
                relevant: ResponsiveTheme.widthM,
                settings: {
                    forceHidden: true
                }
            });
            /**
             * ========================================================================
             * Funnel
             * ========================================================================
             */
            addRule({
                name: "FunnelSeries",
                relevant: ResponsiveTheme.widthM,
                settings: {
                    alignLabels: false
                }
            });
            addRule({
                name: "Label",
                tags: ["funnel", "vertical"],
                relevant: ResponsiveTheme.widthL,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "Tick",
                tags: ["funnel", "vertical"],
                relevant: ResponsiveTheme.widthL,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "Label",
                tags: ["funnel", "horizontal"],
                relevant: ResponsiveTheme.heightS,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "Tick",
                tags: ["funnel", "horizontal"],
                relevant: ResponsiveTheme.heightS,
                settings: {
                    forceHidden: true
                }
            });
            /**
             * ========================================================================
             * Pyramid
             * ========================================================================
             */
            addRule({
                name: "PyramidSeries",
                relevant: ResponsiveTheme.widthM,
                settings: {
                    alignLabels: false
                }
            });
            addRule({
                name: "Label",
                tags: ["pyramid", "vertical"],
                relevant: ResponsiveTheme.widthL,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "Tick",
                tags: ["pyramid", "vertical"],
                relevant: ResponsiveTheme.widthL,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "Label",
                tags: ["pyramid", "horizontal"],
                relevant: ResponsiveTheme.heightS,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "Tick",
                tags: ["pyramid", "horizontal"],
                relevant: ResponsiveTheme.heightS,
                settings: {
                    forceHidden: true
                }
            });
            /**
             * ========================================================================
             * Pictorial
             * ========================================================================
             */
            addRule({
                name: "PictorialStackedSeries",
                relevant: ResponsiveTheme.widthM,
                settings: {
                    alignLabels: false
                }
            });
            addRule({
                name: "Label",
                tags: ["pictorial", "vertical"],
                relevant: ResponsiveTheme.widthL,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "Tick",
                tags: ["pictorial", "vertical"],
                relevant: ResponsiveTheme.widthL,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "Label",
                tags: ["pictorial", "horizontal"],
                relevant: ResponsiveTheme.heightS,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "Tick",
                tags: ["pictorial", "horizontal"],
                relevant: ResponsiveTheme.heightS,
                settings: {
                    forceHidden: true
                }
            });
            /**
             * ========================================================================
             * Map
             * ========================================================================
             */
            // Nothing to do here
            /**
             * ========================================================================
             * Flow (Sankey+Chord)
             * ========================================================================
             */
            addRule({
                name: "Label",
                tags: ["flow", "horizontal"],
                relevant: ResponsiveTheme.widthS,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "Label",
                tags: ["flow", "vertical"],
                relevant: ResponsiveTheme.heightS,
                settings: {
                    forceHidden: true
                }
            });
            addRule({
                name: "Chord",
                relevant: ResponsiveTheme.maybeXS,
                settings: {
                    radius: percent(99)
                }
            });
            /**
             * ========================================================================
             * Hierarchy (Treemap, Partition, Sunburst, Pack, ForceDirected)
             * ========================================================================
             */
            addRule({
                name: "Label",
                tags: ["hierarchy", "node"],
                relevant: ResponsiveTheme.maybeXS,
                settings: {
                    forceHidden: true
                }
            });
        }
    });
    // Named pixel breakpoints
    Object.defineProperty(ResponsiveTheme, "XXS", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: 100
    });
    Object.defineProperty(ResponsiveTheme, "XS", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: 200
    });
    Object.defineProperty(ResponsiveTheme, "S", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: 300
    });
    Object.defineProperty(ResponsiveTheme, "M", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: 400
    });
    Object.defineProperty(ResponsiveTheme, "L", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: 600
    });
    Object.defineProperty(ResponsiveTheme, "XL", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: 800
    });
    Object.defineProperty(ResponsiveTheme, "XXL", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: 1000
    });
    return ResponsiveTheme;
}(Theme));
export { ResponsiveTheme };
//# sourceMappingURL=ResponsiveTheme.js.map