/**
 * angular-avatar
 * Angular Avatar is an AngularJS directive that generates a letter's avatar like Google does in several web apps. First letter of each word in a string will be used to generate the avatar.
 * @version v1.3.0 - 2016-11-07
 * @link https://github.com/ajsoriar/angular-avatar
 * @author Andres J. Soria R. <ajsoriar@gmail.com>
 * @license MIT License, http://www.opensource.org/licenses/MIT
 */
!function(){"use strict";var ngavatar=angular.module("ngAvatar",[]);ngavatar.directive("ngAvatar",[function(){return{restrict:"AE",replace:!0,scope:{initials:"@initials",width:"@width",bgcolor:"@bgColor",textColor:"@textColor",wrapper:"=wrapper",pictureResolution:"@pictureResolution",pixelated:"=pixelated",roundShape:"=roundShape","class":"@class",imgClass:"@imgClass",style:"@style",string:"@string",cornerRadius:"@cornerRadius",pictureFormat:"@pictureFormat",colorsPalette:"=colorsPalette",autoColor:"=autoColor",fontWeight:"@fontWeight",fontScale:"@fontScale",textShadow:"=textShadow",bind:"=bind",maxLength:"@maxLength",upperCase:"=upperCase"},link:function(scope,element,attrs){function checkValues(){if(void 0!=scope.bind&&(_bind=scope.bind),void 0!=scope.textColor&&(_textcolor=scope.textColor),void 0!=scope.pictureResolution&&(_picture_resolution=scope.pictureResolution),void 0!=scope.width&&(_long=scope.width),void 0!=scope.wrapper&&(_wrapper=scope.wrapper,_wrapper===!1&&(_img_width=_long)),void 0!=scope.pixelated&&(_pixelated=scope.pixelated,_pixelated===!0&&(_img_styling+="image-rendering:pixelated; image-rendering:-moz-crisp-edges;")),void 0!=scope.roundShape?(_roundShape=scope.roundShape,_roundShape&&(_wrapper_styling+="border-radius: "+_long+"px;")):void 0!=scope.cornerRadius&&(_corner_radius=scope.cornerRadius,_wrapper_styling+="border-radius: "+_corner_radius+"px;"),void 0!=scope["class"]&&(_extra_classes=scope["class"]),void 0!=scope.imgClass&&(_extra_img_classes=scope.imgClass),void 0!=scope.style&&(_extra_styles=scope.style),void 0!=scope.initials&&(_str=scope.initials),void 0!=scope.string&&(_str=getInitialsFromString(scope.string)),void 0!=scope.maxLength&&(_str=_str.substr(0,scope.maxLength)),"jpeg"===scope.pictureFormat&&(_picture_format="jpeg"),void 0!=scope.colorsPalette&&(_colors_palette=scope.colorsPalette),void 0!=scope.bgcolor)_bgcolor=scope.bgcolor;else if(void 0!=scope.autoColor&&(_autoColor=scope.autoColor,_autoColor===!0)){var i,colorIndex,lon=_str.length,charIndex=0;for(i=0;lon>i;i++)charIndex=_str.charCodeAt(i);colorIndex=charIndex%_colors_palette.length,_bgcolor=_colors_palette[colorIndex]}void 0!=scope.fontWeight&&(_font_weight=scope.fontWeight),void 0!=scope.fontScale&&(_font_scale=scope.fontScale),void 0!=scope.textShadow&&(_text_shadow=scope.textShadow),scope.upperCase===!0&&(_str=_str.toUpperCase())}function generateAvatar(name,w,h,bgcolor,textcolor,bgImage){var canvas,ctx,_font_size,WIDTH=256,HEIGHT=256;return void 0!=w&&w>0&&void 0!=h&&h>0&&(WIDTH=w,HEIGHT=h),canvas=document.createElement("canvas"),canvas.id="ngAvatar-"+Date.now(),canvas.width=WIDTH,canvas.height=HEIGHT,ctx=canvas.getContext("2d"),ctx.fillStyle=bgcolor,ctx.fillRect(0,0,WIDTH,HEIGHT),_font_size=WIDTH/(2/(_font_scale/100)),ctx.font=_font_weight+" "+_font_size+"px sans-serif",_text_shadow===!0&&(ctx.shadowColor="black",ctx.shadowOffsetX=0,ctx.shadowOffsetY=0,ctx.shadowBlur=5),ctx.textAlign="center",ctx.fillStyle=textcolor,ctx.fillText(_str,WIDTH/2,HEIGHT-HEIGHT/2+_font_size/3),canvas.toDataURL("image/"+_picture_format)}function getInitialsFromString(str){var output="",i=0,str=str.split(" "),len=str.length;for(i;len>i;i++)""!=str[i]&&(output+=str[i][0]);return output}function render(){var imgData=generateAvatar(_str,_picture_resolution,_picture_resolution,_bgcolor,_textcolor,null),html="";_wrapper&&(html+='<div class="avatar-wrapper '+_extra_classes+'" style="'+_wrapper_styling+" width:"+_long+"px; height:"+_long+"px; "+_extra_styles+'">'),html+='<img src="'+imgData+'" class="avatar-picture '+_extra_img_classes+'" style="'+_img_styling+'" width="'+_img_width+'" height="" />',_wrapper&&(html+="</div>");var replacementElement=angular.element(html);currentElement.replaceWith(replacementElement),currentElement=replacementElement}var _long=45,_picture_resolution=256,_wrapper=!0,_str="",_bgcolor="#000",_textcolor="#fff",_pixelated=!1,_img_styling="vertical-align:top;",_roundShape=!1,_wrapper_styling="border-radius:0; display:block; overflow:hidden;",_extra_classes="",_extra_img_classes="",_extra_styles="",_corner_radius="0",_picture_format="png",_colors_palette=["#bdc3c7","#6f7b87","#2c3e50","#2f3193","#662d91","#922790","#ec2176","#ed1c24","#f36622","#f8941e","#fab70f","#fdde00","#d1d219","#8ec73f","#00a650","#00aa9c","#00adef","#0081cd","#005bab"],_autoColor=!1,_font_weight=100,_font_scale=100,_text_shadow=!1,_bind=!1,_img_width="100%",currentElement=element;checkValues(),_bind===!0?(scope.$watch("string",function(value){checkValues(),render()}),scope.$watch("initials",function(value){checkValues(),render()})):render()}}}])}();