/**!
 * The MIT License
 *
 * Copyright (c) 2013 the angular-openlayers-directive Team, http://tombatossals.github.io/angular-openlayers-directive
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * angular-google-maps
 * https://github.com/tombatossals/angular-openlayers-directive
 *
 * @authors https://github.com/tombatossals/angular-openlayers-directive/graphs/contributors
 */

/*! angular-openlayers-directive 14-01-2015 */
!function(){"use strict";angular.module("openlayers-directive",["ngSanitize"]).directive("openlayers",["$log","$q","$compile","olHelpers","olMapDefaults","olData",function(a,b,c,d,e,f){return{restrict:"EA",transclude:!0,replace:!0,scope:{center:"=olCenter",defaults:"=olDefaults",view:"=olView",events:"=olEvents"},template:'<div class="angular-openlayers-map" ng-transclude></div>',controller:["$scope",function(a){var c=b.defer();a.getMap=function(){return c.promise},a.setMap=function(a){c.resolve(a)},this.getOpenlayersScope=function(){return a}}],link:function(a,b,c){var g=d.isDefined,h=d.createLayer,i=d.setMapEvents,j=d.createView,k=e.setDefaults(a);g(c.width)&&(isNaN(c.width)?b.css("width",c.width):b.css("width",c.width+"px")),g(c.height)&&(isNaN(c.height)?b.css("height",c.height):b.css("height",c.height+"px")),g(c.lat)&&(k.center.lat=parseFloat(c.lat)),g(c.lon)&&(k.center.lon=parseFloat(c.lon)),g(c.zoom)&&(k.center.zoom=parseFloat(c.zoom));var l=ol.control.defaults(k.controls),m=ol.interaction.defaults(k.interactions),n=j(k.view),o=new ol.Map({target:b[0],controls:l,interactions:m,renderer:k.renderer,view:n});if(!c.customLayers){var p={type:"Tile",source:{type:"OSM"}},q=h(p,n.getProjection());o.addLayer(q),o.set("default",!0)}if(!g(c.olCenter)){var r=ol.proj.transform([k.center.lon,k.center.lat],k.center.projection,n.getProjection());n.setCenter(r),n.setZoom(k.center.zoom)}i(k.events,o,a),a.setMap(o),f.setMap(o,c.id)}}}]),angular.module("openlayers-directive").directive("olCenter",["$log","$location","olMapDefaults","olHelpers",function(a,b,c,d){return{restrict:"A",scope:!1,replace:!1,require:"openlayers",link:function(e,f,g,h){var i=d.safeApply,j=d.isValidCenter,k=d.isDefined,l=d.isArray,m=d.isNumber,n=d.isSameCenterOnMap,o=d.setCenter,p=d.setZoom,q=h.getOpenlayersScope();q.getMap().then(function(e){var f=c.getDefaults(q),h=e.getView(),r=q.center;if(-1!==g.olCenter.search("-"))return a.error('[AngularJS - Openlayers] The "center" variable can\'t use a "-" on his key name: "'+g.center+'".'),void o(h,f.view.projection,f.center,e);k(r)||(r={}),j(r)||(a.warn("[AngularJS - Openlayers] invalid 'center'"),r.lat=f.center.lat,r.lon=f.center.lon,r.zoom=f.center.zoom,r.projection=f.center.projection),r.projection||(r.projection="pixel"!==f.view.projection?f.center.projection:"pixel"),m(r.zoom)||(r.zoom=1),o(h,f.view.projection,r,e),h.setZoom(r.zoom);var s;if(r.centerUrlHash===!0){var t=function(){var a,c=b.search();if(k(c.c)){var d=c.c.split(":");3===d.length&&(a={lat:parseFloat(d[0]),lon:parseFloat(d[1]),zoom:parseInt(d[2],10)})}return a};s=t(),q.$on("$locationChangeSuccess",function(){var a=t();a&&!n(a,e)&&i(q,function(b){b.center.lat=a.lat,b.center.lon=a.lon,b.center.zoom=a.zoom})})}var u;q.$watchCollection("center",function(b){if(b){if(b.projection||(b.projection=f.center.projection),b.autodiscover)return u||(u=new ol.Geolocation({projection:ol.proj.get(b.projection)}),u.on("change",function(){if(b.autodiscover){var a=u.getPosition();i(q,function(b){b.center.lat=a[1],b.center.lon=a[0],b.center.zoom=12,b.center.autodiscover=!1,u.setTracking(!1)})}})),void u.setTracking(!0);j(b)||(a.warn("[AngularJS - Openlayers] invalid 'center'"),b=f.center);var c=h.getCenter();if(c){if("pixel"===f.view.projection)return void h.setCenter(b.coord);var d=ol.proj.transform(c,f.view.projection,b.projection);(d[1]!==b.lat||d[0]!==b.lon)&&o(h,f.view.projection,b,e)}h.getZoom()!==b.zoom&&p(h,b.zoom,e)}}),e.on("moveend",function(){i(q,function(a){if(k(a.center)){var c=e.getView().getCenter();if(a.center.zoom=h.getZoom(),"pixel"===f.view.projection)return void(a.center.coord=c);if(a.center){var g=ol.proj.transform(c,f.view.projection,a.center.projection);if(a.center.lat=g[1],a.center.lon=g[0],d.notifyCenterUrlHashChanged(q,a.center,b.search()),l(a.center.bounds)){var i=h.calculateExtent(e.getSize()),j=a.center.projection,m=f.view.projection;a.center.bounds=ol.proj.transform(i,m,j)}}}})})})}}}]),angular.module("openlayers-directive").directive("olLayer",["$log","$q","olMapDefaults","olHelpers",function(a,b,c,d){return{restrict:"E",scope:{properties:"=olLayerProperties"},replace:!1,require:"^openlayers",link:function(a,b,e,f){var g=d.isDefined,h=d.equals,i=f.getOpenlayersScope(),j=d.createLayer,k=d.setVectorLayerEvents,l=d.detectLayerType,m=d.createStyle,n=d.isBoolean,o=d.addLayerBeforeMarkers,p=d.isNumber;i.getMap().then(function(b){var d,f=b.getView().getProjection(),q=c.setDefaults(i);if(a.$on("$destroy",function(){b.removeLayer(d)}),g(a.properties))a.$watch("properties",function(c,e){if(g(c.source)&&g(c.source.type)){if(!g(c.visible))return void(c.visible=!0);if(!g(c.opacity))return void(c.opacity=1);var i;if(g(d)){if(g(e)&&!h(c,e)){if(!h(c.source,e.source))for(var r=b.getLayers(),s=0;s<r.getLength();s++){var t=r.item(s);t===d&&(r.removeAt(s),d=j(c,f),g(d)&&(r.insertAt(s,d),"Vector"===l(c)&&k(q.events,b,a,c.name)))}n(c.visible)&&c.visible!==e.visible&&d.setVisible(c.visible),c.opacity!==e.opacity&&(p(c.opacity)||p(parseFloat(c.opacity)))&&d.setOpacity(c.opacity),g(c.style)&&!h(c.style,e.style)&&(i=angular.isFunction(c.style)?c.style:m(c.style),d.setStyle(i))}}else d=j(c,f),o(b.getLayers(),d),"Vector"===l(c)&&k(q.events,b,a,c.name),n(c.visible)&&d.setVisible(c.visible),c.opacity&&d.setOpacity(c.opacity),c.style&&(i=angular.isFunction(c.style)?c.style:m(c.style),d.setStyle(i))}},!0);else if(g(e.sourceType)&&g(e.sourceUrl)){var r={source:{url:e.sourceUrl,type:e.sourceType}};d=j(r,f),"Vector"===l(r)&&k(q.events,b,a,e.name),o(b.getLayers(),d)}})}}}]),angular.module("openlayers-directive").directive("olPath",["$log","$q","olMapDefaults","olHelpers",function(a,b,c,d){return{restrict:"E",scope:{properties:"=olGeomProperties"},require:"^openlayers",replace:!0,template:'<div class="popup-label path" ng-bind-html="message"></div>',link:function(a,b,e,f){var g=d.isDefined,h=d.createFeature,i=d.createOverlay,j=d.createVectorLayer,k=f.getOpenlayersScope();k.getMap().then(function(d){var f=c.getDefaults(k),l=f.view.projection,m=j();if(d.addLayer(m),g(e.coord)){var n=e.proj||"EPSG:4326",o=JSON.parse(e.coord),p={type:"Polygon",coord:o,projection:n},q=h(p,l);if(m.getSource().addFeature(q),e.message){a.message=e.message;var r=ol.proj.transform(o,n,l),s=i(b,r);d.addOverlay(s)}}else;})}}}]),angular.module("openlayers-directive").directive("olView",["$log","$q","olData","olMapDefaults","olHelpers",function(a,b,c,d,e){return{restrict:"A",scope:!1,replace:!1,require:"openlayers",link:function(a,b,c,f){var g=f.getOpenlayersScope(),h=e.isNumber,i=e.safeApply,j=e.createView;g.getMap().then(function(a){var b=d.getDefaults(g),c=g.view;c.projection||(c.projection=b.view.projection),c.maxZoom||(c.maxZoom=b.view.maxZoom),c.minZoom||(c.minZoom=b.view.minZoom),c.rotation||(c.rotation=b.view.rotation);var e=j(c);a.setView(e),g.$watchCollection("view",function(a){h(a.rotation)&&e.setRotation(a.rotation)}),e.on("change:rotation",function(){i(g,function(b){b.view.rotation=a.getView().getRotation()})})})}}}]),angular.module("openlayers-directive").directive("olControl",["$log","$q","olData","olMapDefaults","olHelpers",function(a,b,c,d,e){return{restrict:"E",scope:!1,replace:!1,require:"^openlayers",link:function(a,b,c,d){var f,g=d.getOpenlayersScope();g.getMap().then(function(b){var d=e.getControlClasses,g=d();c.name&&(f=new g[c.name],b.addControl(f)),a.$on("$destroy",function(){b.removeControl(f)})})}}}]),angular.module("openlayers-directive").directive("olMarker",["$log","$q","olMapDefaults","olHelpers",function(a,b,c,d){var e=function(){var a="data:image/png;base64,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";return{projection:"EPSG:4326",lat:0,lon:0,coord:[],show:!0,showOnMouseOver:!1,style:new ol.style.Style({image:new ol.style.Icon({anchor:[.5,1],anchorXUnits:"fraction",anchorYUnits:"fraction",opacity:.9,src:a})})}};return{restrict:"E",scope:{lat:"=lat",lon:"=lon",label:"=label",properties:"=olMarkerProperties"},require:"^openlayers",replace:!0,template:'<div class="popup-label" ng-bind-html="message"></div>',link:function(b,f,g,h){var i=d.isDefined,j=h.getOpenlayersScope(),k=d.createVectorLayer,l=d.createFeature,m=d.createOverlay;j.getMap().then(function(d){var h=k();h.set("markers",!0),d.addLayer(h);var n,o,p,q=e(),r=c.getDefaults(j),s=r.view.projection;return b.$on("$destroy",function(){d.removeLayer(h)}),i(b.properties)?void b.$watch("properties",function(c){i(p)||(q.projection=c.projection?c.projection:q.projection,q.coord=c.coord?c.coord:q.coord,q.lat=c.lat?c.lat:q.lat,q.lon=c.lon?c.lon:q.lon,p=l(q,s),i(p)||a.error("[AngularJS - Openlayers] Received invalid data on the marker."),h.getSource().addFeature(p)),i(n)&&d.removeOverlay(n),i(c.label)&&(b.message=c.label.message,i(b.message)&&0!==b.message.length&&(c.label&&c.label.show===!0&&(o="pixel"===q.projection?q.coord:ol.proj.transform([q.lon,q.lat],q.projection,s),n=m(f,o),d.addOverlay(n)),n&&c.label&&c.label.show===!1&&(d.removeOverlay(n),n=void 0),c.label&&c.label.show===!1&&c.label.showOnMouseOver&&d.getViewport().addEventListener("mousemove",function(a){if(!c.label.show){var b=!1,e=d.getEventPixel(a),g=d.forEachFeatureAtPixel(e,function(a){return a});g===p&&(b=!0,i(n)||(o="pixel"===q.projection?q.coord:ol.proj.transform([q.lon,q.lat],q.projection,s),n=m(f,o),d.addOverlay(n)),d.getTarget().style.cursor="pointer"),!b&&n&&(d.removeOverlay(n),n=void 0,d.getTarget().style.cursor="")}})))},!0):(q.lat=b.lat?b.lat:q.lat,q.lon=b.lon?b.lon:q.lon,q.message=g.message,p=l(q,s),i(p)||a.error("[AngularJS - Openlayers] Received invalid data on the marker."),h.getSource().addFeature(p),void(q.message&&(b.message=g.message,o=ol.proj.transform([q.lon,q.lat],q.projection,s),n=m(f,o),d.addOverlay(n))))})}}}]),angular.module("openlayers-directive").service("olData",["$log","$q","olHelpers",function(a,b,c){var d=c.obtainEffectiveMapId,e={},f=function(a,b){var c=d(a,b);a[c].resolvedDefer=!0},g=function(a,c){var e,f=d(a,c);return angular.isDefined(a[f])&&a[f].resolvedDefer!==!0?e=a[f].defer:(e=b.defer(),a[f]={defer:e,resolvedDefer:!1}),e},h=function(a,b){var c,e=d(a,b);return c=angular.isDefined(a[e])&&a[e].resolvedDefer!==!1?a[e].defer:g(a,b)};this.setMap=function(a,b){var c=g(e,b);c.resolve(a),f(e,b)},this.getMap=function(a){var b=h(e,a);return b.promise}}]),angular.module("openlayers-directive").factory("olHelpers",["$q","$log",function(a,b){var c=function(a){return angular.isDefined(a)},d=function(a,b,c){"pointermove"===b?a.on("pointermove",function(d){var e=d.coordinate;c.$emit("openlayers.map."+b,{lat:e[1],lon:e[0],projection:a.getView().getProjection().getCode()})}):"singleclick"===b&&a.on("singleclick",function(d){var e=d.coordinate;c.$emit("openlayers.map."+b,{lat:e[1],lon:e[0],projection:a.getView().getProjection().getCode()})})},e=["Road","Aerial","AerialWithLabels","collinsBart","ordnanceSurvey"],f=function(){return{attribution:ol.control.Attribution,fullscreen:ol.control.FullScreen,mouseposition:ol.control.MousePosition,rotate:ol.control.Rotate,scaleline:ol.control.ScaleLine,zoom:ol.control.Zoom,zoomslider:ol.control.ZoomSlider,zoomtoextent:ol.control.ZoomToExtent}},g=["osm","sat","hyb"],h=function(a){var b,c;return a.fill&&(b=new ol.style.Fill({color:a.fill.color})),a.stroke&&(c=new ol.style.Stroke({color:a.stroke.color,width:a.stroke.width})),new ol.style.Style({fill:b,stroke:c})},i=function(a){if(a.type)return a.type;switch(a.source.type){case"ImageWMS":return"Image";case"ImageStatic":return"Image";case"GeoJSON":return"Vector";case"TopoJSON":return"Vector";default:return"Tile"}},j=function(a){var d;switch(a.projection){case"pixel":if(!c(a.extent))return void b.error("[AngularJS - Openlayers] - You must provide the extent of the image if using pixel projection");d=new ol.proj.Projection({code:"pixel",units:"pixels",extent:a.extent});break;default:d=new ol.proj.get(a.projection)}return d},k=function(a){return-1!==["watercolor","terrain","toner"].indexOf(a)},l=function(a,d){var f;switch(a.type){case"ImageWMS":a.url&&a.params||b.error("[AngularJS - Openlayers] - ImageWMS Layer needs valid server url and params properties"),f=new ol.source.ImageWMS({url:a.url,crossOrigin:a.crossOrigin?a.crossOrigin:"anonymous",params:a.params});break;case"TileWMS":a.url&&a.params||b.error("[AngularJS - Openlayers] - TileWMS Layer needs valid url and params properties"),f=new ol.source.TileWMS({url:a.url,crossOrigin:a.crossOrigin?a.crossOrigin:"anonymous",params:a.params});break;case"OSM":if(a.attribution){var h=[];c(a.attribution)&&h.unshift(new ol.Attribution({html:a.attribution})),f=new ol.source.OSM({attributions:h})}else f=new ol.source.OSM;a.url&&f.setUrl(a.url);break;case"BingMaps":if(!a.key)return void b.error("[AngularJS - Openlayers] - You need an API key to show the Bing Maps.");f=new ol.source.BingMaps({key:a.key,imagerySet:a.imagerySet?a.imagerySet:e[0]});break;case"MapQuest":if(!a.layer||-1===g.indexOf(a.layer))return void b.error("[AngularJS - Openlayers] - MapQuest layers needs a valid 'layer' property.");f=new ol.source.MapQuest({layer:a.layer});break;case"GeoJSON":if(!a.geojson&&!a.url)return void b.error("[AngularJS - Openlayers] - You need a geojson property to add a GeoJSON layer.");c(a.url)?f=new ol.source.GeoJSON({projection:d,url:a.url}):(c(a.geojson.projection)||(a.geojson.projection=d),f=new ol.source.GeoJSON(a.geojson));break;case"TopoJSON":if(!a.topojson&&!a.url)return void b.error("[AngularJS - Openlayers] - You need a topojson property to add a TopoJSON layer.");f=new ol.source.TopoJSON(a.url?{projection:d,url:a.url}:a.topojson);break;case"TileJSON":f=new ol.source.TileJSON({url:a.url,crossOrigin:"anonymous"});break;case"KML":f=new ol.source.KML({url:a.url,projection:a.projection,radius:a.radius,extractStyles:!1});break;case"Stamen":if(!a.layer||!k(a.layer))return void b.error("[AngularJS - Openlayers] - You need a valid Stamen layer.");f=new ol.source.Stamen({layer:a.layer});break;case"ImageStatic":if(!a.url||!angular.isArray(a.imageSize)||2!==a.imageSize.length)return void b.error("[AngularJS - Openlayers] - You need a image URL to create a ImageStatic layer.");f=new ol.source.ImageStatic({url:a.url,imageSize:a.imageSize,projection:d,imageExtent:d.getExtent()})}return f};return{isDefined:c,isNumber:function(a){return angular.isNumber(a)},createView:function(a){var b=j(a);return new ol.View({projection:b,maxZoom:a.maxZoom,minZoom:a.minZoom})},isDefinedAndNotNull:function(a){return angular.isDefined(a)&&null!==a},isString:function(a){return angular.isString(a)},isArray:function(a){return angular.isArray(a)},isObject:function(a){return angular.isObject(a)},equals:function(a,b){return angular.equals(a,b)},isValidCenter:function(a){return angular.isDefined(a)&&("boolean"==typeof a.autodiscover||angular.isNumber(a.lat)&&angular.isNumber(a.lon)||angular.isArray(a.coord)&&2===a.coord.length&&angular.isNumber(a.coord[0])&&angular.isNumber(a.coord[1])||angular.isArray(a.bounds)&&4===a.bounds.length&&angular.isNumber(a.bounds[0])&&angular.isNumber(a.bounds[1])&&angular.isNumber(a.bounds[1])&&angular.isNumber(a.bounds[2]))},safeApply:function(a,b){var c=a.$root.$$phase;"$apply"===c||"$digest"===c?a.$eval(b):a.$apply(b)},isSameCenterOnMap:function(a,b){var c=a.projection||"EPSG:4326",d=[a.lon,a.lat],e=b.getView().getProjection(),f=ol.proj.transform(b.getView().getCenter(),e,c),g=b.getView().getZoom();return f[1].toFixed(4)===d[1].toFixed(4)&&f[0].toFixed(4)===d[0].toFixed(4)&&g===a.zoom?!0:!1},setCenter:function(a,b,c,d){if(d&&a.getCenter()){var e=ol.animation.pan({duration:150,source:a.getCenter()});d.beforeRender(e)}if(c.projection===b)a.setCenter([c.lon,c.lat]);else{var f=[c.lon,c.lat];a.setCenter(ol.proj.transform(f,c.projection,b))}},setZoom:function(a,b,c){var d=ol.animation.zoom({duration:150,resolution:c.getView().getResolution()});c.beforeRender(d),a.setZoom(b)},isBoolean:function(a){return"boolean"==typeof a},obtainEffectiveMapId:function(a,c){var d,e;if(angular.isDefined(c))d=c;else if(1===Object.keys(a).length)for(e in a)a.hasOwnProperty(e)&&(d=e);else 0===Object.keys(a).length?d="main":b.error("[AngularJS - Openlayers] - You have more than 1 map on the DOM, you must provide the map ID to the olData.getXXX call");return d},createStyle:h,setMapEvents:function(a,b,e){if(c(a)&&angular.isArray(a.map))for(var f in a.map){var g=a.map[f];d(b,g,e)}},setVectorLayerEvents:function(a,b,d,e){c(a)&&angular.isArray(a.layers)&&angular.forEach(a.layers,function(a){angular.element(b.getViewport()).on(a,function(f){var g=b.getEventPixel(f),h=b.forEachFeatureAtPixel(g,function(a){return a});c(h)&&d.$emit("openlayers.layers."+e+"."+a,h,f)})})},detectLayerType:i,createLayer:function(a,b){var c,d=i(a),e=l(a.source,b);if(e){switch(d){case"Image":c=new ol.layer.Image({source:e});break;case"Tile":c=new ol.layer.Tile({source:e});break;case"Heatmap":c=new ol.layer.Heatmap({source:e});break;case"Vector":c=new ol.layer.Vector({source:e})}return c}},createVectorLayer:function(){return new ol.layer.Vector({source:new ol.source.Vector})},notifyCenterUrlHashChanged:function(a,b,d){if(b.centerUrlHash){var e=b.lat.toFixed(4)+":"+b.lon.toFixed(4)+":"+b.zoom;c(d.c)&&d.c===e||a.$emit("centerUrlHash",e)}},getControlClasses:f,detectControls:function(a){var b={},c=f();return a.forEach(function(a){for(var d in c)a instanceof c[d]&&(b[d]=a)}),b},createFeature:function(a,b){var d;switch(a.type){case"Polygon":d=new ol.geom.Polygon(a.coord);break;default:d=new ol.geom.Point(c(a.coord)&&"pixel"===a.projection?a.coord:[a.lon,a.lat])}c(a.projection)&&"pixel"!==a.projection&&(d=d.transform(a.projection,b));var e=new ol.Feature({geometry:d});return c(a.style)&&e.setStyle(a.style),e},addLayerBeforeMarkers:function(a,b){for(var d,e=0;e<a.getLength();e++){var f=a.item(e);if(f.get("markers")){d=e;break}}if(c(d)){var g=a.item(d);a.setAt(d,b),a.push(g)}else a.push(b)},createOverlay:function(a,b){a.css("display","block");var c=new ol.Overlay({position:b,element:a,positioning:"center-left"});return c}}}]),angular.module("openlayers-directive").factory("olMapDefaults",["$q","olHelpers",function(a,b){var c=function(){return{view:{projection:"EPSG:3857",minZoom:void 0,maxZoom:void 0,rotation:0,extent:void 0},center:{lat:0,lon:0,zoom:1,autodiscover:!1,bounds:[],centerUrlHash:!1,projection:"EPSG:4326"},events:{map:[],markers:[],layers:[]},controls:{attribution:!0,rotate:!1,zoom:!0},interactions:{mouseWheelZoom:!1},renderer:"canvas"}},d=b.isDefined,e={};return{getDefaults:function(a){if(!d(a))for(var b in e)return e[b];return e[a.$id]},setDefaults:function(a){var b=a.defaults,f=a.$id,g=c();return d(b)&&(d(b.layers)&&(g.layers=angular.copy(b.layers)),d(b.controls)&&(g.controls=angular.copy(b.controls)),d(b.events)&&(g.events=angular.copy(b.events)),d(b.interactions)&&(g.interactions=angular.copy(b.interactions)),d(b.renderer)&&(g.renderer=b.renderer),d(b.view)&&(g.view.maxZoom=b.view.maxZoom||g.view.maxZoom,g.view.minZoom=b.view.minZoom||g.view.minZoom,g.view.projection=b.view.projection||g.view.projection,g.view.extent=b.view.extent||g.view.extent)),e[f]=g,g}}}])}();