angular.module('pascalprecht.translate')

/**
 * @ngdoc factory
 * @name pascalprecht.translate.factory:$translateMissingTranslationHandlerLog
 * @requires $log
 *
 * @description
 * Uses angular's `$log` service to give a warning when trying to translate a
 * translation id which doesn't exist.
 *
 * @return Handler function
 */
.factory('$translateMissingTranslationHandlerLog', ['$log', function ($log) {

  return function (translationId) {
    $log.warn('Translation for ' + translationId + ' doesn\'t exist');
  };
}]);
