library angular2.transform.common.registered_type;

import 'package:analyzer/analyzer.dart';
import 'package:angular2/src/transform/common/names.dart';

/// A call to `Reflector#registerType` generated by `DirectiveProcessor`.
class RegisteredType {
  /// The type registered by this call.
  final Identifier typeName;
  /// The actual call to `Reflector#registerType`.
  final MethodInvocation registerMethod;
  /// The factory method registered.
  final Expression factoryFn;
  /// The parameters registered.
  final Expression parameters;
  /// The annotations registered.
  final Expression annotations;

  RegisteredType._(this.typeName, this.registerMethod, this.factoryFn,
      this.parameters, this.annotations);

  /// Creates a {@link RegisteredType} given a {@link MethodInvocation} node representing
  /// a call to `registerType`.
  factory RegisteredType.fromMethodInvocation(MethodInvocation registerMethod) {
    var visitor = new _ParseRegisterTypeVisitor();
    registerMethod.accept(visitor);
    return new RegisteredType._(visitor.typeName, registerMethod,
        visitor.factoryFn, visitor.parameters, visitor.annotations);
  }
}

class _ParseRegisterTypeVisitor extends Object
    with RecursiveAstVisitor<Object> {
  Identifier typeName;
  Expression factoryFn;
  Expression parameters;
  Expression annotations;

  @override
  Object visitMethodInvocation(MethodInvocation node) {
    assert('${node.methodName}' == REGISTER_TYPE_METHOD_NAME);

    // The first argument to a `registerType` call is the type.
    typeName = node.argumentList.arguments[0] is Identifier
        ? node.argumentList.arguments[0]
        : null;
    return super.visitMethodInvocation(node);
  }

  @override
  Object visitMapLiteralEntry(MapLiteralEntry node) {
    if (node.key is StringLiteral) {
      var key = stringLiteralToString(node.key);
      switch (key) {
        case 'annotations':
          annotations = node.value;
          break;
        case 'factory':
          factoryFn = node.value;
          break;
        case 'parameters':
          parameters = node.value;
          break;
      }
    }
    // Do not need to descend any further.
    return null;
  }
}
