/* jshint expr:true */
define(['jquery', 'aui/internal/skate', 'aui/form-validation', '../../helpers/all.js', 'aui/select'], function ($, skate, validator, helpers) {
    'use strict';
    describe('Form validation component integration', function () {
        var clock;

        afterEach(function () {
            $('.tipsy').remove();
        });

        function pressKey (keyCode) {
            helpers.pressKey(keyCode);
        }

        function fieldValidationState (el) {
            return $(el).attr('data-aui-validation-state');
        }

        describe('with single select', function() {
            var singleSelect;

            beforeEach(function () {
                clock = sinon.useFakeTimers();
                singleSelect = createAndSkate(
                    '<aui-select data-aui-validation-field data-aui-validation-required="required">' +
                        '<aui-option>Option 1</aui-option>' +
                        '<aui-option>Option 2</aui-option>' +
                        '<aui-option>Option 3</aui-option>' +
                    '</aui-select>'
                );
            });

            afterEach(function () {
                clock.restore();
            });

            function focusSingleSelectInput () {
                singleSelect._input.focus();
            }

            function createAndSkate (html) {
                var fixtures = helpers.fixtures({
                    html: html
                });
                return skate.init(fixtures.html);
            }

            it('validates successfully with the required validator', function() {
                focusSingleSelectInput();
                helpers.fakeTypingOut('Option 1');
                pressKey(AJS.keyCode.ENTER);
                fieldValidationState(singleSelect).should.equal('valid');
            });

            it('invalidates successfully with the required validator', function () {
                validator.validate(singleSelect);
                fieldValidationState(singleSelect).should.equal('invalid');
            });
        });
    });
});