# Welcome to Base
A super simple, responsive framework built for all devices big, small and in-between

## Reasons to use base for your next web project
### Responsive Design
Created to work on all devices big and small, Base has got you covered for your next exciting web project.

### Awesome Foundation
Built on Normalize.css, it includes all the foundation styles for typography, lists, tables, blockquotes, forms and more.

### Cross-Browser
Perfected to work with older browsers (IE7+) and modern browsers such as Chrome, Safari, Firefox and Opera.

### Base is Awesome!
Preview the [docs](http://matthewhartman.github.io/base/docs/) to see the Base framework in all its glory! :)

## Repo Contents
- index.html: Basic HTML template which includes jQuery
- style.css: Base stylesheet for typography, headings, tables, form elements, etc
- readme.markdown - The Read Me file for Base (feel free to delete this)
- .htaccess - Apache server caching, compression, and other configuration defaults for Grade-A performance (taken from [HTML5 Boilerplate](https://github.com/h5bp/html5-boilerplate)
- less (folder):
  - style.less - The base stylesheet in LESS format
    - base (folder):
      - _blockquotes.less (Styles for blockquotes)
      - _buttons.less (Base Buttons)
      - _code.less (Styles for code blocks)
      - _desktop-grid.less (Tablet grid and helpers)
      - _forms.less (Styles for form elements)
      - _global.less (Global typography and heading styles)
      - _grid.less (Base Grid)
      - _helpers.less (Base helpers)
      - _lists.less (Styles for ordered, unordered lists and navigation)
      - _mixins.less (Basic Mixins which include font-size properties and more)
      - _print.less (Basic print stylesheet - taken from HTML5 Boilerplate)
      - _resets.less (Global Resets)
      - _tables.less (Styles for tables)
      - _tablet-grid.less (Tablet grid and helpers)
      - _variables.less (Base variables including default font sizes and colours)
- scss (folder):
  - style.scss - The base stylesheet in SCSS format
  - base (folder):
    - _blockquotes.scss (Styles for blockquotes)
    - _buttons.scss (Base Buttons)
    - _code.scss (Styles for code blocks)
    - _desktop-grid.scss (Tablet grid and helpers)
    - _forms.scss (Styles for form elements)
    - _global.scss (Global typography and heading styles)
    - _grid.scss (Base Grid)
    - _helpers.scss (Base helpers)
    - _lists.scss (Styles for ordered, unordered lists and navigation)
    - _mixins.scss (Basic Mixins which include font-size properties and more)
    - _print.scss (Basic print stylesheet - taken from HTML5 Boilerplate)
    - _resets.scss (Global Resets)
    - _tables.scss (Styles for tables)
    - _tablet-grid.scss (Tablet grid and helpers)
    - _variables.scss (Base variables including default font sizes and colours)
- images (folder):
 - favicon.ico: Standard 32x32 favicon
 - apple-touch-icon (x3): All three sizes of Apple touch icons for iPhone 3, iPad and iPhone 4 with retina.
- js (folder):
  - default.js - Default javascript file (includes combined plugins and scripts)
  - modernizr.js - Custom build of Modernizr to check for JS and SVG support

Base was built by Matthew Hartman [(@hartmanmatthew)](http://twitter.com/hartmanmatthew), a passionate front end developer based in Melbourne, Australia.

## Thank You / Credits
- [base_css-rails](https://github.com/rkrdo/base_css-rails) - a gem that adds the Base framework to the application's asset pipeline by Ricardo Cruz
- Thanks to Beau Smith (@beau) for the custom breakpoint suggestion
- Thanks to HTML5 framework for the .htaccess file
- Nicolas Gallagher (@necolas) for Normalize.css and Micro ClearFix
- Tristan McNab for adding bower support

## MIT Open Source License
Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
