/*global Autolinker */
/**
 * @class Autolinker.match.Twitter
 * @extends Autolinker.match.Match
 *
 * Represents a Twitter match found in an input string which should be Autolinked.
 *
 * See this class's superclass ({@link Autolinker.match.Match}) for more details.
 */
Autolinker.match.Twitter = Autolinker.Util.extend( Autolinker.match.Match, {

	/**
	 * @protected
	 * @property {String} twitterHandle (required)
	 *
	 * The Twitter handle that was matched, without the '@' character.
	 */


	/**
	 * @constructor
	 * @param {String} matchedText The original text that was matched.
	 * @param {Number} offset The offset of where the match was made in the
	 *   input string.
	 * @param {String} twitterHandle The Twitter handle that was matched,
	 *   without the '@' character.
	 */
	constructor : function( matchedText, offset, twitterHandle ) {
		Autolinker.match.Match.prototype.constructor.call( this, matchedText, offset );

		// @if DEBUG
		if( !twitterHandle ) throw new Error( '`twitterHandle` arg required' );
		// @endif

		this.twitterHandle = twitterHandle;
	},


	/**
	 * Returns the type of match that this class represents.
	 *
	 * @return {String}
	 */
	getType : function() {
		return 'twitter';
	},


	/**
	 * Returns the twitter handle, without the '@' character.
	 *
	 * @return {String}
	 */
	getTwitterHandle : function() {
		return this.twitterHandle;
	},


	/**
	 * Returns the anchor href that should be generated for the match.
	 *
	 * @return {String}
	 */
	getAnchorHref : function() {
		return 'https://twitter.com/' + this.twitterHandle;
	},


	/**
	 * Returns the anchor text that should be generated for the match.
	 *
	 * @return {String}
	 */
	getAnchorText : function() {
		return '@' + this.twitterHandle;
	}

} );