var nl = {};
module["exports"] = nl;
nl.title = "Dutch";
nl.address = {
  "city_prefix": [
    "Noord",
    "Oost",
    "West",
    "Zuid",
    "Nieuw",
    "Oud"
  ],
  "city_suffix": [
    "dam",
    "berg",
    " aan de Rijn",
    " aan de IJssel",
    "swaerd",
    "endrecht",
    "recht",
    "ambacht",
    "enmaes",
    "wijk",
    "sland",
    "stroom",
    "sluus",
    "dijk",
    "dorp",
    "burg",
    "veld",
    "sluis",
    "koop",
    "lek",
    "hout",
    "geest",
    "kerk",
    "woude",
    "hoven",
    "hoten",
    "ingen",
    "plas",
    "meer"
  ],
  "city": [
    "#{Name.first_name}#{city_suffix}",
    "#{Name.last_name}#{city_suffix}",
    "#{city_prefix} #{Name.first_name}#{city_suffix}",
    "#{city_prefix} #{Name.last_name}#{city_suffix}"
  ],
  "country": [
    "Afghanistan",
    "Akrotiri",
    "Albanië",
    "Algerije",
    "Amerikaanse Maagdeneilanden",
    "Amerikaans-Samoa",
    "Andorra",
    "Angola",
    "Anguilla",
    "Antarctica",
    "Antigua en Barbuda",
    "Arctic Ocean",
    "Argentinië",
    "Armenië",
    "Aruba",
    "Ashmore and Cartier Islands",
    "Atlantic Ocean",
    "Australië",
    "Azerbeidzjan",
    "Bahama's",
    "Bahrein",
    "Bangladesh",
    "Barbados",
    "Belarus",
    "België",
    "Belize",
    "Benin",
    "Bermuda",
    "Bhutan",
    "Bolivië",
    "Bosnië-Herzegovina",
    "Botswana",
    "Bouvet Island",
    "Brazilië",
    "British Indian Ocean Territory",
    "Britse Maagdeneilanden",
    "Brunei",
    "Bulgarije",
    "Burkina Faso",
    "Burundi",
    "Cambodja",
    "Canada",
    "Caymaneilanden",
    "Centraal-Afrikaanse Republiek",
    "Chili",
    "China",
    "Christmas Island",
    "Clipperton Island",
    "Cocos (Keeling) Islands",
    "Colombia",
    "Comoren (Unie)",
    "Congo (Democratische Republiek)",
    "Congo (Volksrepubliek)",
    "Cook",
    "Coral Sea Islands",
    "Costa Rica",
    "Cuba",
    "Cyprus",
    "Denemarken",
    "Dhekelia",
    "Djibouti",
    "Dominica",
    "Dominicaanse Republiek",
    "Duitsland",
    "Ecuador",
    "Egypte",
    "El Salvador",
    "Equatoriaal-Guinea",
    "Eritrea",
    "Estland",
    "Ethiopië",
    "European Union",
    "Falkland",
    "Faroe Islands",
    "Fiji",
    "Filipijnen",
    "Finland",
    "Frankrijk",
    "Frans-Polynesië",
    "French Southern and Antarctic Lands",
    "Gabon",
    "Gambia",
    "Gaza Strip",
    "Georgië",
    "Ghana",
    "Gibraltar",
    "Grenada",
    "Griekenland",
    "Groenland",
    "Guam",
    "Guatemala",
    "Guernsey",
    "Guinea",
    "Guinee-Bissau",
    "Guyana",
    "Haïti",
    "Heard Island and McDonald Islands",
    "Heilige Stoel",
    "Honduras",
    "Hongarije",
    "Hongkong",
    "Ierland",
    "IJsland",
    "India",
    "Indian Ocean",
    "Indonesië",
    "Irak",
    "Iran",
    "Isle of Man",
    "Israël",
    "Italië",
    "Ivoorkust",
    "Jamaica",
    "Jan Mayen",
    "Japan",
    "Jemen",
    "Jersey",
    "Jordanië",
    "Kaapverdië",
    "Kameroen",
    "Kazachstan",
    "Kenia",
    "Kirgizstan",
    "Kiribati",
    "Koeweit",
    "Kroatië",
    "Laos",
    "Lesotho",
    "Letland",
    "Libanon",
    "Liberia",
    "Libië",
    "Liechtenstein",
    "Litouwen",
    "Luxemburg",
    "Macao",
    "Macedonië",
    "Madagaskar",
    "Malawi",
    "Maldiven",
    "Maleisië",
    "Mali",
    "Malta",
    "Marokko",
    "Marshall Islands",
    "Mauritanië",
    "Mauritius",
    "Mayotte",
    "Mexico",
    "Micronesia, Federated States of",
    "Moldavië",
    "Monaco",
    "Mongolië",
    "Montenegro",
    "Montserrat",
    "Mozambique",
    "Myanmar",
    "Namibië",
    "Nauru",
    "Navassa Island",
    "Nederland",
    "Nederlandse Antillen",
    "Nepal",
    "Ngwane",
    "Nicaragua",
    "Nieuw-Caledonië",
    "Nieuw-Zeeland",
    "Niger",
    "Nigeria",
    "Niue",
    "Noordelijke Marianen",
    "Noord-Korea",
    "Noorwegen",
    "Norfolk Island",
    "Oekraïne",
    "Oezbekistan",
    "Oman",
    "Oostenrijk",
    "Pacific Ocean",
    "Pakistan",
    "Palau",
    "Panama",
    "Papoea-Nieuw-Guinea",
    "Paracel Islands",
    "Paraguay",
    "Peru",
    "Pitcairn",
    "Polen",
    "Portugal",
    "Puerto Rico",
    "Qatar",
    "Roemenië",
    "Rusland",
    "Rwanda",
    "Saint Helena",
    "Saint Lucia",
    "Saint Vincent en de Grenadines",
    "Saint-Pierre en Miquelon",
    "Salomon",
    "Samoa",
    "San Marino",
    "São Tomé en Principe",
    "Saudi-Arabië",
    "Senegal",
    "Servië",
    "Seychellen",
    "Sierra Leone",
    "Singapore",
    "Sint-Kitts en Nevis",
    "Slovenië",
    "Slowakije",
    "Soedan",
    "Somalië",
    "South Georgia and the South Sandwich Islands",
    "Southern Ocean",
    "Spanje",
    "Spratly Islands",
    "Sri Lanka",
    "Suriname",
    "Svalbard",
    "Syrië",
    "Tadzjikistan",
    "Taiwan",
    "Tanzania",
    "Thailand",
    "Timor Leste",
    "Togo",
    "Tokelau",
    "Tonga",
    "Trinidad en Tobago",
    "Tsjaad",
    "Tsjechië",
    "Tunesië",
    "Turkije",
    "Turkmenistan",
    "Turks-en Caicoseilanden",
    "Tuvalu",
    "Uganda",
    "Uruguay",
    "Vanuatu",
    "Venezuela",
    "Verenigd Koninkrijk",
    "Verenigde Arabische Emiraten",
    "Verenigde Staten van Amerika",
    "Vietnam",
    "Wake Island",
    "Wallis en Futuna",
    "Wereld",
    "West Bank",
    "Westelijke Sahara",
    "Zambia",
    "Zimbabwe",
    "Zuid-Afrika",
    "Zuid-Korea",
    "Zweden",
    "Zwitserland"
  ],
  "building_number": [
    "#",
    "##",
    "###",
    "###a",
    "###b",
    "###c",
    "### I",
    "### II",
    "### III"
  ],
  "street_suffix": [
    "straat",
    "laan",
    "weg",
    "plantsoen",
    "park"
  ],
  "secondary_address": [
    "1 hoog",
    "2 hoog",
    "3 hoog"
  ],
  "street_name": [
    "#{Name.first_name}#{street_suffix}",
    "#{Name.last_name}#{street_suffix}"
  ],
  "street_address": [
    "#{street_name} #{building_number}"
  ],
  "postcode": [
    "#### ??"
  ],
  "state": [
    "Noord-Holland",
    "Zuid-Holland",
    "Utrecht",
    "Zeeland",
    "Overijssel",
    "Gelderland",
    "Drenthe",
    "Friesland",
    "Groningen",
    "Noord-Brabant",
    "Limburg",
    "Flevoland"
  ],
  "default_country": [
    "Nederland"
  ]
};
nl.company = {
  "suffix": [
    "BV",
    "V.O.F.",
    "Group",
    "en Zonen"
  ]
};
nl.internet = {
  "free_email": [
    "gmail.com",
    "yahoo.com",
    "hotmail.com"
  ],
  "domain_suffix": [
    "nl",
    "com",
    "net",
    "org"
  ]
};
nl.lorem = {
  "words": [
    "alias",
    "consequatur",
    "aut",
    "perferendis",
    "sit",
    "voluptatem",
    "accusantium",
    "doloremque",
    "aperiam",
    "eaque",
    "ipsa",
    "quae",
    "ab",
    "illo",
    "inventore",
    "veritatis",
    "et",
    "quasi",
    "architecto",
    "beatae",
    "vitae",
    "dicta",
    "sunt",
    "explicabo",
    "aspernatur",
    "aut",
    "odit",
    "aut",
    "fugit",
    "sed",
    "quia",
    "consequuntur",
    "magni",
    "dolores",
    "eos",
    "qui",
    "ratione",
    "voluptatem",
    "sequi",
    "nesciunt",
    "neque",
    "dolorem",
    "ipsum",
    "quia",
    "dolor",
    "sit",
    "amet",
    "consectetur",
    "adipisci",
    "velit",
    "sed",
    "quia",
    "non",
    "numquam",
    "eius",
    "modi",
    "tempora",
    "incidunt",
    "ut",
    "labore",
    "et",
    "dolore",
    "magnam",
    "aliquam",
    "quaerat",
    "voluptatem",
    "ut",
    "enim",
    "ad",
    "minima",
    "veniam",
    "quis",
    "nostrum",
    "exercitationem",
    "ullam",
    "corporis",
    "nemo",
    "enim",
    "ipsam",
    "voluptatem",
    "quia",
    "voluptas",
    "sit",
    "suscipit",
    "laboriosam",
    "nisi",
    "ut",
    "aliquid",
    "ex",
    "ea",
    "commodi",
    "consequatur",
    "quis",
    "autem",
    "vel",
    "eum",
    "iure",
    "reprehenderit",
    "qui",
    "in",
    "ea",
    "voluptate",
    "velit",
    "esse",
    "quam",
    "nihil",
    "molestiae",
    "et",
    "iusto",
    "odio",
    "dignissimos",
    "ducimus",
    "qui",
    "blanditiis",
    "praesentium",
    "laudantium",
    "totam",
    "rem",
    "voluptatum",
    "deleniti",
    "atque",
    "corrupti",
    "quos",
    "dolores",
    "et",
    "quas",
    "molestias",
    "excepturi",
    "sint",
    "occaecati",
    "cupiditate",
    "non",
    "provident",
    "sed",
    "ut",
    "perspiciatis",
    "unde",
    "omnis",
    "iste",
    "natus",
    "error",
    "similique",
    "sunt",
    "in",
    "culpa",
    "qui",
    "officia",
    "deserunt",
    "mollitia",
    "animi",
    "id",
    "est",
    "laborum",
    "et",
    "dolorum",
    "fuga",
    "et",
    "harum",
    "quidem",
    "rerum",
    "facilis",
    "est",
    "et",
    "expedita",
    "distinctio",
    "nam",
    "libero",
    "tempore",
    "cum",
    "soluta",
    "nobis",
    "est",
    "eligendi",
    "optio",
    "cumque",
    "nihil",
    "impedit",
    "quo",
    "porro",
    "quisquam",
    "est",
    "qui",
    "minus",
    "id",
    "quod",
    "maxime",
    "placeat",
    "facere",
    "possimus",
    "omnis",
    "voluptas",
    "assumenda",
    "est",
    "omnis",
    "dolor",
    "repellendus",
    "temporibus",
    "autem",
    "quibusdam",
    "et",
    "aut",
    "consequatur",
    "vel",
    "illum",
    "qui",
    "dolorem",
    "eum",
    "fugiat",
    "quo",
    "voluptas",
    "nulla",
    "pariatur",
    "at",
    "vero",
    "eos",
    "et",
    "accusamus",
    "officiis",
    "debitis",
    "aut",
    "rerum",
    "necessitatibus",
    "saepe",
    "eveniet",
    "ut",
    "et",
    "voluptates",
    "repudiandae",
    "sint",
    "et",
    "molestiae",
    "non",
    "recusandae",
    "itaque",
    "earum",
    "rerum",
    "hic",
    "tenetur",
    "a",
    "sapiente",
    "delectus",
    "ut",
    "aut",
    "reiciendis",
    "voluptatibus",
    "maiores",
    "doloribus",
    "asperiores",
    "repellat"
  ],
  "supplemental": [
    "abbas",
    "abduco",
    "abeo",
    "abscido",
    "absconditus",
    "absens",
    "absorbeo",
    "absque",
    "abstergo",
    "absum",
    "abundans",
    "abutor",
    "accedo",
    "accendo",
    "acceptus",
    "accipio",
    "accommodo",
    "accusator",
    "acer",
    "acerbitas",
    "acervus",
    "acidus",
    "acies",
    "acquiro",
    "acsi",
    "adamo",
    "adaugeo",
    "addo",
    "adduco",
    "ademptio",
    "adeo",
    "adeptio",
    "adfectus",
    "adfero",
    "adficio",
    "adflicto",
    "adhaero",
    "adhuc",
    "adicio",
    "adimpleo",
    "adinventitias",
    "adipiscor",
    "adiuvo",
    "administratio",
    "admiratio",
    "admitto",
    "admoneo",
    "admoveo",
    "adnuo",
    "adopto",
    "adsidue",
    "adstringo",
    "adsuesco",
    "adsum",
    "adulatio",
    "adulescens",
    "adultus",
    "aduro",
    "advenio",
    "adversus",
    "advoco",
    "aedificium",
    "aeger",
    "aegre",
    "aegrotatio",
    "aegrus",
    "aeneus",
    "aequitas",
    "aequus",
    "aer",
    "aestas",
    "aestivus",
    "aestus",
    "aetas",
    "aeternus",
    "ager",
    "aggero",
    "aggredior",
    "agnitio",
    "agnosco",
    "ago",
    "ait",
    "aiunt",
    "alienus",
    "alii",
    "alioqui",
    "aliqua",
    "alius",
    "allatus",
    "alo",
    "alter",
    "altus",
    "alveus",
    "amaritudo",
    "ambitus",
    "ambulo",
    "amicitia",
    "amiculum",
    "amissio",
    "amita",
    "amitto",
    "amo",
    "amor",
    "amoveo",
    "amplexus",
    "amplitudo",
    "amplus",
    "ancilla",
    "angelus",
    "angulus",
    "angustus",
    "animadverto",
    "animi",
    "animus",
    "annus",
    "anser",
    "ante",
    "antea",
    "antepono",
    "antiquus",
    "aperio",
    "aperte",
    "apostolus",
    "apparatus",
    "appello",
    "appono",
    "appositus",
    "approbo",
    "apto",
    "aptus",
    "apud",
    "aqua",
    "ara",
    "aranea",
    "arbitro",
    "arbor",
    "arbustum",
    "arca",
    "arceo",
    "arcesso",
    "arcus",
    "argentum",
    "argumentum",
    "arguo",
    "arma",
    "armarium",
    "armo",
    "aro",
    "ars",
    "articulus",
    "artificiose",
    "arto",
    "arx",
    "ascisco",
    "ascit",
    "asper",
    "aspicio",
    "asporto",
    "assentator",
    "astrum",
    "atavus",
    "ater",
    "atqui",
    "atrocitas",
    "atrox",
    "attero",
    "attollo",
    "attonbitus",
    "auctor",
    "auctus",
    "audacia",
    "audax",
    "audentia",
    "audeo",
    "audio",
    "auditor",
    "aufero",
    "aureus",
    "auris",
    "aurum",
    "aut",
    "autem",
    "autus",
    "auxilium",
    "avaritia",
    "avarus",
    "aveho",
    "averto",
    "avoco",
    "baiulus",
    "balbus",
    "barba",
    "bardus",
    "basium",
    "beatus",
    "bellicus",
    "bellum",
    "bene",
    "beneficium",
    "benevolentia",
    "benigne",
    "bestia",
    "bibo",
    "bis",
    "blandior",
    "bonus",
    "bos",
    "brevis",
    "cado",
    "caecus",
    "caelestis",
    "caelum",
    "calamitas",
    "calcar",
    "calco",
    "calculus",
    "callide",
    "campana",
    "candidus",
    "canis",
    "canonicus",
    "canto",
    "capillus",
    "capio",
    "capitulus",
    "capto",
    "caput",
    "carbo",
    "carcer",
    "careo",
    "caries",
    "cariosus",
    "caritas",
    "carmen",
    "carpo",
    "carus",
    "casso",
    "caste",
    "casus",
    "catena",
    "caterva",
    "cattus",
    "cauda",
    "causa",
    "caute",
    "caveo",
    "cavus",
    "cedo",
    "celebrer",
    "celer",
    "celo",
    "cena",
    "cenaculum",
    "ceno",
    "censura",
    "centum",
    "cerno",
    "cernuus",
    "certe",
    "certo",
    "certus",
    "cervus",
    "cetera",
    "charisma",
    "chirographum",
    "cibo",
    "cibus",
    "cicuta",
    "cilicium",
    "cimentarius",
    "ciminatio",
    "cinis",
    "circumvenio",
    "cito",
    "civis",
    "civitas",
    "clam",
    "clamo",
    "claro",
    "clarus",
    "claudeo",
    "claustrum",
    "clementia",
    "clibanus",
    "coadunatio",
    "coaegresco",
    "coepi",
    "coerceo",
    "cogito",
    "cognatus",
    "cognomen",
    "cogo",
    "cohaero",
    "cohibeo",
    "cohors",
    "colligo",
    "colloco",
    "collum",
    "colo",
    "color",
    "coma",
    "combibo",
    "comburo",
    "comedo",
    "comes",
    "cometes",
    "comis",
    "comitatus",
    "commemoro",
    "comminor",
    "commodo",
    "communis",
    "comparo",
    "compello",
    "complectus",
    "compono",
    "comprehendo",
    "comptus",
    "conatus",
    "concedo",
    "concido",
    "conculco",
    "condico",
    "conduco",
    "confero",
    "confido",
    "conforto",
    "confugo",
    "congregatio",
    "conicio",
    "coniecto",
    "conitor",
    "coniuratio",
    "conor",
    "conqueror",
    "conscendo",
    "conservo",
    "considero",
    "conspergo",
    "constans",
    "consuasor",
    "contabesco",
    "contego",
    "contigo",
    "contra",
    "conturbo",
    "conventus",
    "convoco",
    "copia",
    "copiose",
    "cornu",
    "corona",
    "corpus",
    "correptius",
    "corrigo",
    "corroboro",
    "corrumpo",
    "coruscus",
    "cotidie",
    "crapula",
    "cras",
    "crastinus",
    "creator",
    "creber",
    "crebro",
    "credo",
    "creo",
    "creptio",
    "crepusculum",
    "cresco",
    "creta",
    "cribro",
    "crinis",
    "cruciamentum",
    "crudelis",
    "cruentus",
    "crur",
    "crustulum",
    "crux",
    "cubicularis",
    "cubitum",
    "cubo",
    "cui",
    "cuius",
    "culpa",
    "culpo",
    "cultellus",
    "cultura",
    "cum",
    "cunabula",
    "cunae",
    "cunctatio",
    "cupiditas",
    "cupio",
    "cuppedia",
    "cupressus",
    "cur",
    "cura",
    "curatio",
    "curia",
    "curiositas",
    "curis",
    "curo",
    "curriculum",
    "currus",
    "cursim",
    "curso",
    "cursus",
    "curto",
    "curtus",
    "curvo",
    "curvus",
    "custodia",
    "damnatio",
    "damno",
    "dapifer",
    "debeo",
    "debilito",
    "decens",
    "decerno",
    "decet",
    "decimus",
    "decipio",
    "decor",
    "decretum",
    "decumbo",
    "dedecor",
    "dedico",
    "deduco",
    "defaeco",
    "defendo",
    "defero",
    "defessus",
    "defetiscor",
    "deficio",
    "defigo",
    "defleo",
    "defluo",
    "defungo",
    "degenero",
    "degero",
    "degusto",
    "deinde",
    "delectatio",
    "delego",
    "deleo",
    "delibero",
    "delicate",
    "delinquo",
    "deludo",
    "demens",
    "demergo",
    "demitto",
    "demo",
    "demonstro",
    "demoror",
    "demulceo",
    "demum",
    "denego",
    "denique",
    "dens",
    "denuncio",
    "denuo",
    "deorsum",
    "depereo",
    "depono",
    "depopulo",
    "deporto",
    "depraedor",
    "deprecator",
    "deprimo",
    "depromo",
    "depulso",
    "deputo",
    "derelinquo",
    "derideo",
    "deripio",
    "desidero",
    "desino",
    "desipio",
    "desolo",
    "desparatus",
    "despecto",
    "despirmatio",
    "infit",
    "inflammatio",
    "paens",
    "patior",
    "patria",
    "patrocinor",
    "patruus",
    "pauci",
    "paulatim",
    "pauper",
    "pax",
    "peccatus",
    "pecco",
    "pecto",
    "pectus",
    "pecunia",
    "pecus",
    "peior",
    "pel",
    "ocer",
    "socius",
    "sodalitas",
    "sol",
    "soleo",
    "solio",
    "solitudo",
    "solium",
    "sollers",
    "sollicito",
    "solum",
    "solus",
    "solutio",
    "solvo",
    "somniculosus",
    "somnus",
    "sonitus",
    "sono",
    "sophismata",
    "sopor",
    "sordeo",
    "sortitus",
    "spargo",
    "speciosus",
    "spectaculum",
    "speculum",
    "sperno",
    "spero",
    "spes",
    "spiculum",
    "spiritus",
    "spoliatio",
    "sponte",
    "stabilis",
    "statim",
    "statua",
    "stella",
    "stillicidium",
    "stipes",
    "stips",
    "sto",
    "strenuus",
    "strues",
    "studio",
    "stultus",
    "suadeo",
    "suasoria",
    "sub",
    "subito",
    "subiungo",
    "sublime",
    "subnecto",
    "subseco",
    "substantia",
    "subvenio",
    "succedo",
    "succurro",
    "sufficio",
    "suffoco",
    "suffragium",
    "suggero",
    "sui",
    "sulum",
    "sum",
    "summa",
    "summisse",
    "summopere",
    "sumo",
    "sumptus",
    "supellex",
    "super",
    "suppellex",
    "supplanto",
    "suppono",
    "supra",
    "surculus",
    "surgo",
    "sursum",
    "suscipio",
    "suspendo",
    "sustineo",
    "suus",
    "synagoga",
    "tabella",
    "tabernus",
    "tabesco",
    "tabgo",
    "tabula",
    "taceo",
    "tactus",
    "taedium",
    "talio",
    "talis",
    "talus",
    "tam",
    "tamdiu",
    "tamen",
    "tametsi",
    "tamisium",
    "tamquam",
    "tandem",
    "tantillus",
    "tantum",
    "tardus",
    "tego",
    "temeritas",
    "temperantia",
    "templum",
    "temptatio",
    "tempus",
    "tenax",
    "tendo",
    "teneo",
    "tener",
    "tenuis",
    "tenus",
    "tepesco",
    "tepidus",
    "ter",
    "terebro",
    "teres",
    "terga",
    "tergeo",
    "tergiversatio",
    "tergo",
    "tergum",
    "termes",
    "terminatio",
    "tero",
    "terra",
    "terreo",
    "territo",
    "terror",
    "tersus",
    "tertius",
    "testimonium",
    "texo",
    "textilis",
    "textor",
    "textus",
    "thalassinus",
    "theatrum",
    "theca",
    "thema",
    "theologus",
    "thermae",
    "thesaurus",
    "thesis",
    "thorax",
    "thymbra",
    "thymum",
    "tibi",
    "timidus",
    "timor",
    "titulus",
    "tolero",
    "tollo",
    "tondeo",
    "tonsor",
    "torqueo",
    "torrens",
    "tot",
    "totidem",
    "toties",
    "totus",
    "tracto",
    "trado",
    "traho",
    "trans",
    "tredecim",
    "tremo",
    "trepide",
    "tres",
    "tribuo",
    "tricesimus",
    "triduana",
    "triginta",
    "tripudio",
    "tristis",
    "triumphus",
    "trucido",
    "truculenter",
    "tubineus",
    "tui",
    "tum",
    "tumultus",
    "tunc",
    "turba",
    "turbo",
    "turpe",
    "turpis",
    "tutamen",
    "tutis",
    "tyrannus",
    "uberrime",
    "ubi",
    "ulciscor",
    "ullus",
    "ulterius",
    "ultio",
    "ultra",
    "umbra",
    "umerus",
    "umquam",
    "una",
    "unde",
    "undique",
    "universe",
    "unus",
    "urbanus",
    "urbs",
    "uredo",
    "usitas",
    "usque",
    "ustilo",
    "ustulo",
    "usus",
    "uter",
    "uterque",
    "utilis",
    "utique",
    "utor",
    "utpote",
    "utrimque",
    "utroque",
    "utrum",
    "uxor",
    "vaco",
    "vacuus",
    "vado",
    "vae",
    "valde",
    "valens",
    "valeo",
    "valetudo",
    "validus",
    "vallum",
    "vapulus",
    "varietas",
    "varius",
    "vehemens",
    "vel",
    "velociter",
    "velum",
    "velut",
    "venia",
    "venio",
    "ventito",
    "ventosus",
    "ventus",
    "venustas",
    "ver",
    "verbera",
    "verbum",
    "vere",
    "verecundia",
    "vereor",
    "vergo",
    "veritas",
    "vero",
    "versus",
    "verto",
    "verumtamen",
    "verus",
    "vesco",
    "vesica",
    "vesper",
    "vespillo",
    "vester",
    "vestigium",
    "vestrum",
    "vetus",
    "via",
    "vicinus",
    "vicissitudo",
    "victoria",
    "victus",
    "videlicet",
    "video",
    "viduata",
    "viduo",
    "vigilo",
    "vigor",
    "vilicus",
    "vilis",
    "vilitas",
    "villa",
    "vinco",
    "vinculum",
    "vindico",
    "vinitor",
    "vinum",
    "vir",
    "virga",
    "virgo",
    "viridis",
    "viriliter",
    "virtus",
    "vis",
    "viscus",
    "vita",
    "vitiosus",
    "vitium",
    "vito",
    "vivo",
    "vix",
    "vobis",
    "vociferor",
    "voco",
    "volaticus",
    "volo",
    "volubilis",
    "voluntarius",
    "volup",
    "volutabrum",
    "volva",
    "vomer",
    "vomica",
    "vomito",
    "vorago",
    "vorax",
    "voro",
    "vos",
    "votum",
    "voveo",
    "vox",
    "vulariter",
    "vulgaris",
    "vulgivagus",
    "vulgo",
    "vulgus",
    "vulnero",
    "vulnus",
    "vulpes",
    "vulticulus",
    "vultuosus",
    "xiphias"
  ]
};
nl.name = {
  "first_name": [
    "Amber",
    "Anna",
    "Anne",
    "Anouk",
    "Bas",
    "Bram",
    "Britt",
    "Daan",
    "Emma",
    "Eva",
    "Femke",
    "Finn",
    "Fleur",
    "Iris",
    "Isa",
    "Jan",
    "Jasper",
    "Jayden",
    "Jesse",
    "Johannes",
    "Julia",
    "Julian",
    "Kevin",
    "Lars",
    "Lieke",
    "Lisa",
    "Lotte",
    "Lucas",
    "Luuk",
    "Maud",
    "Max",
    "Mike",
    "Milan",
    "Nick",
    "Niels",
    "Noa",
    "Rick",
    "Roos",
    "Ruben",
    "Sander",
    "Sanne",
    "Sem",
    "Sophie",
    "Stijn",
    "Sven",
    "Thijs",
    "Thijs",
    "Thomas",
    "Tim",
    "Tom"
  ],
  "tussenvoegsel": [
    "van",
    "van de",
    "van den",
    "van 't",
    "van het",
    "de",
    "den"
  ],
  "last_name": [
    "Bakker",
    "Beek",
    "Berg",
    "Boer",
    "Bos",
    "Bosch",
    "Brink",
    "Broek",
    "Brouwer",
    "Bruin",
    "Dam",
    "Dekker",
    "Dijk",
    "Dijkstra",
    "Graaf",
    "Groot",
    "Haan",
    "Hendriks",
    "Heuvel",
    "Hoek",
    "Jacobs",
    "Jansen",
    "Janssen",
    "Jong",
    "Klein",
    "Kok",
    "Koning",
    "Koster",
    "Leeuwen",
    "Linden",
    "Maas",
    "Meer",
    "Meijer",
    "Mulder",
    "Peters",
    "Ruiter",
    "Schouten",
    "Smit",
    "Smits",
    "Stichting",
    "Veen",
    "Ven",
    "Vermeulen",
    "Visser",
    "Vliet",
    "Vos",
    "Vries",
    "Wal",
    "Willems",
    "Wit"
  ],
  "prefix": [
    "Dhr.",
    "Mevr. Dr.",
    "Bsc",
    "Msc",
    "Prof."
  ],
  "suffix": [
    "Jr.",
    "Sr.",
    "I",
    "II",
    "III",
    "IV",
    "V"
  ],
  "name": [
    "#{prefix} #{first_name} #{last_name}",
    "#{first_name} #{last_name} #{suffix}",
    "#{first_name} #{last_name}",
    "#{first_name} #{last_name}",
    "#{first_name} #{tussenvoegsel} #{last_name}",
    "#{first_name} #{tussenvoegsel} #{last_name}"
  ]
};
nl.phone_number = {
  "formats": [
    "(####) ######",
    "##########",
    "06########",
    "06 #### ####"
  ]
};
