var Company = function (faker) {
  
  var self = this;
  var f = faker.fake;
  
  this.suffixes = function () {
    // Don't want the source array exposed to modification, so return a copy
    return faker.definitions.company.suffix.slice(0);
  }

  this.companyName = function (format) {

    var formats = [
      '{{name.lastName}} {{company.companySuffix}}',
      '{{name.lastName}} - {{name.lastName}}',
      '{{name.lastName}}, {{name.lastName}} and {{name.lastName}}'
    ];

    if (typeof format !== "number") {
      format = faker.random.number(formats.length - 1);
    }

    return f(formats[format]);
  }

  this.companySuffix = function () {
      return faker.random.arrayElement(faker.company.suffixes());
  }

  this.catchPhrase = function () {
    return f('{{company.catchPhraseAdjective}} {{company.catchPhraseDescriptor}} {{company.catchPhraseNoun}}')
  }

  this.bs = function () {
    return f('{{company.bsAdjective}} {{company.bsBuzz}} {{company.bsNoun}}');
  }

  this.catchPhraseAdjective = function () {
      return faker.random.arrayElement(faker.definitions.company.adjective);
  }

  this.catchPhraseDescriptor = function () {
      return faker.random.arrayElement(faker.definitions.company.descriptor);
  }

  this.catchPhraseNoun = function () {
      return faker.random.arrayElement(faker.definitions.company.noun);
  }

  this.bsAdjective = function () {
      return faker.random.arrayElement(faker.definitions.company.bs_adjective);
  }

  this.bsBuzz = function () {
      return faker.random.arrayElement(faker.definitions.company.bs_verb);
  }

  this.bsNoun = function () {
      return faker.random.arrayElement(faker.definitions.company.bs_noun);
  }
  
}

module['exports'] = Company;