var _Date = function (faker) {
  var self = this;
  self.past = function (years, refDate) {
      var date = (refDate) ? new Date(Date.parse(refDate)) : new Date();
      var range = {
        min: 1000,
        max: (years || 1) * 365 * 24 * 3600 * 1000
      };

      var past = date.getTime();
      past -= faker.random.number(range); // some time from now to N years ago, in milliseconds
      date.setTime(past);

      return date;
  };

  self.future = function (years, refDate) {
      var date = (refDate) ? new Date(Date.parse(refDate)) : new Date();
      var range = {
        min: 1000,
        max: (years || 1) * 365 * 24 * 3600 * 1000
      };

      var future = date.getTime();
      future += faker.random.number(range); // some time from now to N years later, in milliseconds
      date.setTime(future);

      return date;
  };

  self.between = function (from, to) {
      var fromMilli = Date.parse(from);
      var dateOffset = faker.random.number(Date.parse(to) - fromMilli);

      var newDate = new Date(fromMilli + dateOffset);

      return newDate;
  };

  self.recent = function (days) {
      var date = new Date();
      var range = {
        min: 1000,
        max: (days || 1) * 24 * 3600 * 1000
      };

      var future = date.getTime();
      future -= faker.random.number(range); // some time from now to N days ago, in milliseconds
      date.setTime(future);

      return date;
  };

  self.month = function (options) {
      options = options || {};

      var type = 'wide';
      if (options.abbr) {
          type = 'abbr';
      }
      if (options.context && typeof faker.definitions.date.month[type + '_context'] !== 'undefined') {
          type += '_context';
      }

      var source = faker.definitions.date.month[type];

      return faker.random.arrayElement(source);
  };

  self.weekday = function (options) {
      options = options || {};

      var type = 'wide';
      if (options.abbr) {
          type = 'abbr';
      }
      if (options.context && typeof faker.definitions.date.weekday[type + '_context'] !== 'undefined') {
          type += '_context';
      }

      var source = faker.definitions.date.weekday[type];

      return faker.random.arrayElement(source);
  };
  
  return self;
  
};

module['exports'] = _Date;