var Image = function (faker) {

  var self = this;

  self.image = function () {
    var categories = ["abstract", "animals", "business", "cats", "city", "food", "nightlife", "fashion", "people", "nature", "sports", "technics", "transport"];
    return self[faker.random.arrayElement(categories)]();
  };
  self.avatar = function () {
    return faker.internet.avatar();
  };
  self.imageUrl = function (width, height, category) {
      var width = width || 640;
      var height = height || 480;

      var url ='http://lorempixel.com/' + width + '/' + height;
      if (typeof category !== 'undefined') {
        url += '/' + category;
      }
      return url;
  };
  self.abstract = function (width, height) {
    return faker.image.imageUrl(width, height, 'abstract');
  };
  self.animals = function (width, height) {
    return faker.image.imageUrl(width, height, 'animals');
  };
  self.business = function (width, height) {
    return faker.image.imageUrl(width, height, 'business');
  };
  self.cats = function (width, height) {
    return faker.image.imageUrl(width, height, 'cats');
  };
  self.city = function (width, height) {
    return faker.image.imageUrl(width, height, 'city');
  };
  self.food = function (width, height) {
    return faker.image.imageUrl(width, height, 'food');
  };
  self.nightlife = function (width, height) {
    return faker.image.imageUrl(width, height, 'nightlife');
  };
  self.fashion = function (width, height) {
    return faker.image.imageUrl(width, height, 'fashion');
  };
  self.people = function (width, height) {
    return faker.image.imageUrl(width, height, 'people');
  };
  self.nature = function (width, height) {
    return faker.image.imageUrl(width, height, 'nature');
  };
  self.sports = function (width, height) {
    return faker.image.imageUrl(width, height, 'sports');
  };
  self.technics = function (width, height) {
    return faker.image.imageUrl(width, height, 'technics');
  };
  self.transport = function (width, height) {
    return faker.image.imageUrl(width, height, 'transport');
  }  
}

module["exports"] = Image;