# v3.12.0

## Summary

The v3.12.0 release includes features and fixes from 71 pull requests since the v3.11.2 release.  New features and improvements include:

* Tile coordinate wrapping for raster reprojection.
* Support for multi-line labels.
* Allow rendering geometries to an arbitrary canvas (useful for vector legends).

## Upgrade notes

#### `ol.Map#forEachFeatureAtPixel` changes

The optional `layerFilter` function is now also called for unmanaged layers. To get the same behaviour as before, wrap your layer filter code in an if block like this:
```js
function layerFilter(layer) {
  if (map.getLayers().getArray().indexOf(layer) !== -1) {
    // existing layer filter code
  }
}
```

## Full list of changes

 * [#4559](https://github.com/openlayers/ol3/pull/4559) - Fix up failing KML test in Firefox ([@bartvde](https://github.com/bartvde))
 * [#4561](https://github.com/openlayers/ol3/pull/4561) - Exclude feature loader MVT test from IE9 ([@bartvde](https://github.com/bartvde))
 * [#4552](https://github.com/openlayers/ol3/pull/4552) - Make sure compiled code calls ol.VectorTile#setProjection ([@ahocevar](https://github.com/ahocevar))
 * [#4551](https://github.com/openlayers/ol3/pull/4551) - Handle tile coordinate wrapping when reprojecting raster tiles ([@klokantech](https://github.com/klokantech))
 * [#4544](https://github.com/openlayers/ol3/pull/4544) - Update vector-tile to version 1.2.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4537](https://github.com/openlayers/ol3/pull/4537) - Allow specifying non default DPI on ol.source.TileArcGISRest ([@bartvde](https://github.com/bartvde))
 * [#4548](https://github.com/openlayers/ol3/pull/4548) - Improve vector tile related docs ([@ahocevar](https://github.com/ahocevar))
 * [#4549](https://github.com/openlayers/ol3/pull/4549) - Update vector label example ([@tsauerwein](https://github.com/tsauerwein))
 * [#4512](https://github.com/openlayers/ol3/pull/4512) - Support for multi-line labels (improved) ([@flightaware](https://github.com/flightaware))
 * [#4546](https://github.com/openlayers/ol3/pull/4546) - Update coveralls to version 2.11.6 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4539](https://github.com/openlayers/ol3/pull/4539) - Ignore index.html in example list ([@fredj](https://github.com/fredj))
 * [#4536](https://github.com/openlayers/ol3/pull/4536) - Register the change callback when the tile is enqueued ([@fredj](https://github.com/fredj))
 * [#4528](https://github.com/openlayers/ol3/pull/4528) - Remove redundant code from ol.featureloader.tile ([@ahocevar](https://github.com/ahocevar))
 * [#4535](https://github.com/openlayers/ol3/pull/4535) - Do not use an array for a single style ([@ahocevar](https://github.com/ahocevar))
 * [#4532](https://github.com/openlayers/ol3/pull/4532) - Mark olx.source.WMTSOptions#dimensions as not null ([@fredj](https://github.com/fredj))
 * [#4530](https://github.com/openlayers/ol3/pull/4530) - Remove use of goog.isNull ([@fredj](https://github.com/fredj))
 * [#4529](https://github.com/openlayers/ol3/pull/4529) - Update coding style rules ([@fredj](https://github.com/fredj))
 * [#4518](https://github.com/openlayers/ol3/pull/4518) - Add support for OSM vector tiles ([@ahocevar](https://github.com/ahocevar))
 * [#4524](https://github.com/openlayers/ol3/pull/4524) - Add example for rendering custom point symbols ([@ahocevar](https://github.com/ahocevar))
 * [#4523](https://github.com/openlayers/ol3/pull/4523) - Allow rendering geometries to an arbitrary canvas ([@ahocevar](https://github.com/ahocevar))
 * [#4525](https://github.com/openlayers/ol3/pull/4525) - Make render tests work on more devices ([@ahocevar](https://github.com/ahocevar))
 * [#4515](https://github.com/openlayers/ol3/pull/4515) - Accept HTMLCanvasElement for an icon's img ([@ahocevar](https://github.com/ahocevar))
 * [#4521](https://github.com/openlayers/ol3/pull/4521) - Fix imagestyle docs ([@ahocevar](https://github.com/ahocevar))
 * [#4508](https://github.com/openlayers/ol3/pull/4508) - Remove unused files ([@fredj](https://github.com/fredj))
 * [#4487](https://github.com/openlayers/ol3/pull/4487) - Remove fallback css color ([@fredj](https://github.com/fredj))
 * [#4502](https://github.com/openlayers/ol3/pull/4502) - Improve ol.source.WMTS.optionsFromCapabilities jsdoc layout ([@fredj](https://github.com/fredj))
 * [#4511](https://github.com/openlayers/ol3/pull/4511) - Minor code cleanup ([@fredj](https://github.com/fredj))
 * [#4510](https://github.com/openlayers/ol3/pull/4510) - Adding a check just in case the projection is not defined/supported ([@GeoCat](https://github.com/GeoCat))
 * [#4505](https://github.com/openlayers/ol3/pull/4505) - Remove use of goog.object.getKeys ([@fredj](https://github.com/fredj))
 * [#4472](https://github.com/openlayers/ol3/pull/4472) - Do not ignore layer filter for unmanaged layers ([@ahocevar](https://github.com/ahocevar))
 * [#4476](https://github.com/openlayers/ol3/pull/4476) - Remove use of goog.functions.constant ([@fredj](https://github.com/fredj))
 * [#4484](https://github.com/openlayers/ol3/pull/4484) - Remove use of goog.dom.createDom ([@fredj](https://github.com/fredj))
 * [#4486](https://github.com/openlayers/ol3/pull/4486) - Remove note about DragZoom and vector support ([@fredj](https://github.com/fredj))
 * [#4483](https://github.com/openlayers/ol3/pull/4483) - Remove use of goog.object.containsKey ([@fredj](https://github.com/fredj))
 * [#4475](https://github.com/openlayers/ol3/pull/4475) - Fix up failing tests in Internet Explorer ([@bartvde](https://github.com/bartvde))
 * [#4485](https://github.com/openlayers/ol3/pull/4485) - Use appendChild instead of goog.dom.append ([@fredj](https://github.com/fredj))
 * [#4481](https://github.com/openlayers/ol3/pull/4481) - Remove blur workaround in ol.control.Attribution ([@fredj](https://github.com/fredj))
 * [#4479](https://github.com/openlayers/ol3/pull/4479) - Export ol.interaction.Interaction#getMap function ([@fredj](https://github.com/fredj))
 * [#4478](https://github.com/openlayers/ol3/pull/4478) - Fix olx.control.FullScreenOptions#label apidoc ([@fredj](https://github.com/fredj))
 * [#4477](https://github.com/openlayers/ol3/pull/4477) - Replace goog.nullFunction with ol.nullFunction ([@fredj](https://github.com/fredj))
 * [#4474](https://github.com/openlayers/ol3/pull/4474) - Remove use of goog.dom.createElement and goog.dom.createTextNode ([@fredj](https://github.com/fredj))
 * [#4469](https://github.com/openlayers/ol3/pull/4469) - Upgrade to JSTS 0.17.0 in example ([@bjornharrtell](https://github.com/bjornharrtell))
 * [#4465](https://github.com/openlayers/ol3/pull/4465) - Update handlebars to version 4.0.5 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4464](https://github.com/openlayers/ol3/pull/4464) - Merge in changes from the 3.11.2 release. ([@openlayers](https://github.com/openlayers))
 * [#4463](https://github.com/openlayers/ol3/pull/4463) - Remove use of goog.array.sort ([@fredj](https://github.com/fredj))
 * [#4450](https://github.com/openlayers/ol3/pull/4450) - Fix select interaction regression caused by #4391 ([@ahocevar](https://github.com/ahocevar))
 * [#4458](https://github.com/openlayers/ol3/pull/4458) - Remove extra space in type annotation ([@fredj](https://github.com/fredj))
 * [#4420](https://github.com/openlayers/ol3/pull/4420) - Remove Bootstrap and jQuery from example snippets. ([@openlayers](https://github.com/openlayers))
 * [#4442](https://github.com/openlayers/ol3/pull/4442) - Use jsdoc@3.4.0. ([@tschaub](https://github.com/tschaub))
 * [#4449](https://github.com/openlayers/ol3/pull/4449) - Change the label of the full screen button to be more intuitive ([@bartvde](https://github.com/bartvde))
 * [#4448](https://github.com/openlayers/ol3/pull/4448) - Check ol.source.UrlTile#urls property for null value ([@fredj](https://github.com/fredj))
 * [#4440](https://github.com/openlayers/ol3/pull/4440) - Raster reprojection tutorial ([@klokantech](https://github.com/klokantech))
 * [#4439](https://github.com/openlayers/ol3/pull/4439) - Allow '' for crossOrigin (as Anonymous alias) ([@ahocevar](https://github.com/ahocevar))
 * [#4429](https://github.com/openlayers/ol3/pull/4429) - Dispatch a change event only if the value changes ([@fredj](https://github.com/fredj))
 * [#4435](https://github.com/openlayers/ol3/pull/4435) - Remove unnecessary cast ([@fredj](https://github.com/fredj))
 * [#4434](https://github.com/openlayers/ol3/pull/4434) - Remove unused local variables ([@fredj](https://github.com/fredj))
 * [#4433](https://github.com/openlayers/ol3/pull/4433) - Remove unused local variables ([@fredj](https://github.com/fredj))
 * [#4140](https://github.com/openlayers/ol3/pull/4140) - Add flight animation example ([@tsauerwein](https://github.com/tsauerwein))
 * [#4428](https://github.com/openlayers/ol3/pull/4428) - Add imageSize regression test for ol.source.ImageWMS ([@ahocevar](https://github.com/ahocevar))
 * [#4426](https://github.com/openlayers/ol3/pull/4426) - Improve ol.source.StaticImage ([@ahocevar](https://github.com/ahocevar))
 * [#4425](https://github.com/openlayers/ol3/pull/4425) - Test number property with !== undefined ([@fredj](https://github.com/fredj))
 * [#4423](https://github.com/openlayers/ol3/pull/4423) - Update mocha to version 2.3.4 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4416](https://github.com/openlayers/ol3/pull/4416) - Update clean-css to version 3.4.8 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4415](https://github.com/openlayers/ol3/pull/4415) - Scale StaticImage image to imageExtent ([@ahocevar](https://github.com/ahocevar))
 * [#4414](https://github.com/openlayers/ol3/pull/4414) - Remove ol.ImageUrlFunction ([@ahocevar](https://github.com/ahocevar))
 * [#4389](https://github.com/openlayers/ol3/pull/4389) - Smooth transitions on parameter changes ([@elemoine](https://github.com/elemoine))
 * [#4410](https://github.com/openlayers/ol3/pull/4410) - Merge in changes from the 3.11.1 release. ([@openlayers](https://github.com/openlayers))
 * [#4401](https://github.com/openlayers/ol3/pull/4401) - Allow style function to return a style. ([@tschaub](https://github.com/tschaub))
 * [#4404](https://github.com/openlayers/ol3/pull/4404) - Set correctly the opt_this parameter when writing a KML document ([@oterral](https://github.com/oterral))
 * [#4397](https://github.com/openlayers/ol3/pull/4397) - Update glob to version 6.0.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4362](https://github.com/openlayers/ol3/pull/4362) - Rotate control now takes optional resetNorth function. ([@tamarmot](https://github.com/tamarmot))
