# 3.2.0

## Summary

The 3.1.0 release includes 70 merged pull requests since 3.1.0.  Of note, the KML format [now parses `NetworkingLink` tags](https://github.com/openlayers/ol3/pull/3171).  The [measure example](http://openlayers.org/en/v3.2.0/examples/measure.html) was [reworked](https://github.com/openlayers/ol3/pull/3206) to display measurements and help messages while drawing.  A WMTS GetCapabilities format was [added](https://github.com/openlayers/ol3/pull/3026).  The WebGL renderer [now supports feature hit detection](https://github.com/openlayers/ol3/pull/3065) (on point features).  And you can now [detect](https://github.com/openlayers/ol3/pull/3172) features/colored pixels on image and tile layers!  See the full list of [changes](#changes) below.

## Upgrade notes

The 3.2.0 release maintains a backwards-compatible API with the 3.1.0 release, so upgrades should be painless.  Some special considerations below.

 * You should not call `view.setRotation` with `undefined`, to reset the view rotation to `0` then use `view.setRotation(0)` (see [#3176](https://github.com/openlayers/ol3/pull/3176)).

 * If you use `$(map.getViewport()).on('mousemove')` to detect features when the mouse is hovered on the map, you should now rely on the `pointermove` map event type and check in the `pointermove` listener that the `dragging` event property is `false` (see [#3190](https://github.com/openlayers/ol3/pull/3190)).

## Changes

 * [#3171](https://github.com/openlayers/ol3/pull/3171) - KML: Parsing of NetworkLink tag ([@oterral](https://github.com/oterral))
 * [#3209](https://github.com/openlayers/ol3/pull/3209) - Coding style fixes ([@fredj](https://github.com/fredj))
 * [#3208](https://github.com/openlayers/ol3/pull/3208) - Add setters and getters for imageLoadFunction ([@bartvde](https://github.com/bartvde))
 * [#3019](https://github.com/openlayers/ol3/pull/3019) - Add option to allow Select interaction logic to select overlapping features ([@bjornharrtell](https://github.com/bjornharrtell))
 * [#3206](https://github.com/openlayers/ol3/pull/3206) - Add tooltip to show measure + help message while drawing ([@pgiraud](https://github.com/pgiraud))
 * [#3205](https://github.com/openlayers/ol3/pull/3205) - Use ol.extent.createOrUpdateFromCoordinate ([@fredj](https://github.com/fredj))
 * [#3026](https://github.com/openlayers/ol3/pull/3026) - Add support of reading WMTS Get Cap document ([@htulipe](https://github.com/htulipe))
 * [#3201](https://github.com/openlayers/ol3/pull/3201) - Pass on opt_fast to parent clear function in ol.source.ServerVector (r=@elemoine,@gberaudo) ([@bartvde](https://github.com/bartvde))
 * [#3199](https://github.com/openlayers/ol3/pull/3199) - Minor jsdoc fixes ([@fredj](https://github.com/fredj))
 * [#3059](https://github.com/openlayers/ol3/pull/3059) - Cache the buffered extent value ([@fredj](https://github.com/fredj))
 * [#3196](https://github.com/openlayers/ol3/pull/3196) - Remove unnecessary newlines ([@fredj](https://github.com/fredj))
 * [#3099](https://github.com/openlayers/ol3/pull/3099) - Fix up parsing of OGR GML with ol.format.GML ([@bartvde](https://github.com/bartvde))
 * [#3195](https://github.com/openlayers/ol3/pull/3195) - Coding style ([@fredj](https://github.com/fredj))
 * [#3192](https://github.com/openlayers/ol3/pull/3192) - Add "url" option to ol.source.MapQuest ([@elemoine](https://github.com/elemoine))
 * [#3172](https://github.com/openlayers/ol3/pull/3172) - Introduce forEachLayerAtPixel ([@tsauerwein](https://github.com/tsauerwein))
 * [#3178](https://github.com/openlayers/ol3/pull/3178) - GeoJSON externs fixes ([@fredj](https://github.com/fredj))
 * [#3179](https://github.com/openlayers/ol3/pull/3179) - Disallow undefined values for ol.layer.Base ([@fredj](https://github.com/fredj))
 * [#3161](https://github.com/openlayers/ol3/pull/3161) - Doc fix. writeFeaturesNode receives an array of Feature ([@3x0dv5](https://github.com/3x0dv5))
 * [#3169](https://github.com/openlayers/ol3/pull/3169) - Fix default icon style in kml format ([@oterral](https://github.com/oterral))
 * [#3190](https://github.com/openlayers/ol3/pull/3190) - Introduce `dragging` flag for MapBrowserEvent ([@tsauerwein](https://github.com/tsauerwein))
 * [#3135](https://github.com/openlayers/ol3/pull/3135) - Make changing the label of ZoomToExtent/FullScreen control consistent ([@tsauerwein](https://github.com/tsauerwein))
 * [#3186](https://github.com/openlayers/ol3/pull/3186) - Take the pixel ratio into account when clipping the layer ([@fredj](https://github.com/fredj))
 * [#3183](https://github.com/openlayers/ol3/pull/3183) - Allow other params than 'mode' in example page query string. ([@htulipe](https://github.com/htulipe))
 * [#2791](https://github.com/openlayers/ol3/pull/2791) - Re enable rotation button transition ([@fredj](https://github.com/fredj))
 * [#3180](https://github.com/openlayers/ol3/pull/3180) - Add a getMap function to ol.FeatureOverlay (r=@ahocevar) ([@bartvde](https://github.com/bartvde))
 * [#3176](https://github.com/openlayers/ol3/pull/3176) - Disallowed undefined rotation value ([@fredj](https://github.com/fredj))
 * [#3177](https://github.com/openlayers/ol3/pull/3177) - Add example showing how to style polygon vertices ([@tsauerwein](https://github.com/tsauerwein))
 * [#3174](https://github.com/openlayers/ol3/pull/3174) - Use view.getRotation or view.getResolution instead of view.getState ([@fredj](https://github.com/fredj))
 * [#3170](https://github.com/openlayers/ol3/pull/3170) - Coding style ([@fredj](https://github.com/fredj))
 * [#3108](https://github.com/openlayers/ol3/pull/3108) - Support skipping features in the WebGL renderer ([@tsauerwein](https://github.com/tsauerwein))
 * [#3163](https://github.com/openlayers/ol3/pull/3163) - Use the layerStatesArray property from the frameState ([@fredj](https://github.com/fredj))
 * [#3159](https://github.com/openlayers/ol3/pull/3159) - Don't pass specific options to the parent constructor ([@fredj](https://github.com/fredj))
 * [#3066](https://github.com/openlayers/ol3/pull/3066) - Introduce hasFeatureAtPixel ([@tsauerwein](https://github.com/tsauerwein))
 * [#3065](https://github.com/openlayers/ol3/pull/3065) - Add hit-detection support for WebGL ([@tsauerwein](https://github.com/tsauerwein))
 * [#3128](https://github.com/openlayers/ol3/pull/3128) - Allow rendering of feature when download of icon failed ([@oterral](https://github.com/oterral))
 * [#3156](https://github.com/openlayers/ol3/pull/3156) - Move readProjectionFrom* functions to the base classes ([@fredj](https://github.com/fredj))
 * [#3107](https://github.com/openlayers/ol3/pull/3107) - Also listen on loading images ([@elemoine](https://github.com/elemoine))
 * [#3153](https://github.com/openlayers/ol3/pull/3153) - Add missing GeoJSONFeature#bbox property ([@fredj](https://github.com/fredj))
 * [#3154](https://github.com/openlayers/ol3/pull/3154) - Remove unnecessary newlines ([@fredj](https://github.com/fredj))
 * [#3146](https://github.com/openlayers/ol3/pull/3146) - Enable tests for ol.geom.flat.reverse ([@icholy](https://github.com/icholy))
 * [#3152](https://github.com/openlayers/ol3/pull/3152) - Update closure-library and closure-util version ([@fredj](https://github.com/fredj))
 * [#3145](https://github.com/openlayers/ol3/pull/3145) - Add wrapX option to source.OSM and source.BingMaps ([@elemoine](https://github.com/elemoine))
 * [#3139](https://github.com/openlayers/ol3/pull/3139) - Add ol.control.Control#setTarget ([@elemoine](https://github.com/elemoine))
 * [#3144](https://github.com/openlayers/ol3/pull/3144) - Update CONTRIBUTING style guide with recent guidelines ([@bartvde](https://github.com/bartvde))
 * [#3136](https://github.com/openlayers/ol3/pull/3136) - Use array.length = 0 instead of goog.array.clear ([@fredj](https://github.com/fredj))
 * [#3140](https://github.com/openlayers/ol3/pull/3140) - Avoid use of goog.array.clone with arrays. ([@tschaub](https://github.com/tschaub))
 * [#3122](https://github.com/openlayers/ol3/pull/3122) - Revert "Use offsetX and offsetY if available" ([@fredj](https://github.com/fredj))
 * [#2385](https://github.com/openlayers/ol3/pull/2385) - Option to update vector layers while animating ([@ahocevar](https://github.com/ahocevar))
 * [#3129](https://github.com/openlayers/ol3/pull/3129) - Only update the rbush item if the extent has changed ([@fredj](https://github.com/fredj))
 * [#3117](https://github.com/openlayers/ol3/pull/3117) - Add pixelRatio support for DOM vector renderer ([@ahocevar](https://github.com/ahocevar))
 * [#3124](https://github.com/openlayers/ol3/pull/3124) - Add a space between scale -value and -unit ([@sirtet](https://github.com/sirtet))
 * [#3130](https://github.com/openlayers/ol3/pull/3130) - Document default value ([@fredj](https://github.com/fredj))
 * [#3105](https://github.com/openlayers/ol3/pull/3105) - ol.geom.Geometry#getExtent re-factoring ([@fredj](https://github.com/fredj))
 * [#3118](https://github.com/openlayers/ol3/pull/3118) - Bugfix: "Cannot read property 'firstElementChild' of null" (WFS) ([@naturalatlas](https://github.com/naturalatlas))
 * [#3114](https://github.com/openlayers/ol3/pull/3114) - Specify node version in CONTRIBUTING.md ([@elemoine](https://github.com/elemoine))
 * [#3106](https://github.com/openlayers/ol3/pull/3106) - Don't pass specific options to the parent constructor ([@fredj](https://github.com/fredj))
 * [#3110](https://github.com/openlayers/ol3/pull/3110) - Use svg instead of png to get better image quality ([@PeterDaveHello](https://github.com/PeterDaveHello))
 * [#2707](https://github.com/openlayers/ol3/pull/2707) - Generate source map of minified ol.js ([@gberaudo](https://github.com/gberaudo))
 * [#3104](https://github.com/openlayers/ol3/pull/3104) - Don't pass renderBuffer option to the parent constructor ([@fredj](https://github.com/fredj))
 * [#3096](https://github.com/openlayers/ol3/pull/3096) - popup example cleanup / simplification ([@fredj](https://github.com/fredj))
 * [#3072](https://github.com/openlayers/ol3/pull/3072) - Optimize canvas hit detection by rendering features in a limited extent. ([@tschaub](https://github.com/tschaub))
 * [#3101](https://github.com/openlayers/ol3/pull/3101) - Use bracket notation instead of goog.object functions. ([@tschaub](https://github.com/tschaub))
 * [#3079](https://github.com/openlayers/ol3/pull/3079) - Exclude source files from docs. ([@tschaub](https://github.com/tschaub))
 * [#3100](https://github.com/openlayers/ol3/pull/3100) - Assert that ol.layer.Tile#getPreload is always set ([@fredj](https://github.com/fredj))
 * [#3084](https://github.com/openlayers/ol3/pull/3084) - Changes from the v3.1.x branch. ([@openlayers](https://github.com/openlayers))
 * [#3094](https://github.com/openlayers/ol3/pull/3094) - Remove AUTHORS.md. ([@tschaub](https://github.com/tschaub))
 * [#3089](https://github.com/openlayers/ol3/pull/3089) - Fixed URL link for test README ([@mike-mcgann](https://github.com/mike-mcgann))
 * [#2894](https://github.com/openlayers/ol3/pull/2894) - Simplify CSS code in custom-controls example ([@fredj](https://github.com/fredj))
 * [#3085](https://github.com/openlayers/ol3/pull/3085) - Fixed documentation typo for return value of ol.proj.Projection.isGlobal(). ([@mike-mcgann](https://github.com/mike-mcgann))
 * [#3073](https://github.com/openlayers/ol3/pull/3073) - Make map's deviceOptions map options ([@ahocevar](https://github.com/ahocevar))
