## Upgrade notes

* The `ol.events.condition.mouseMove` function was replaced by `ol.events.condition.pointerMove` (see [#3281](https://github.com/openlayers/ol3/pull/3281)). For example, if you use `ol.events.condition.mouseMove` as the condition in a `Select` interaction then you now need to use `ol.events.condition.pointerMove`:

  ```js
  var selectInteraction = new ol.interaction.Select({
    condition: ol.events.condition.pointerMove
    // …
  });
  ```

## Overview of all changes

 * [#3263](https://github.com/openlayers/ol3/pull/3263) - Support ArcGIS Rest Services ([@cwgrant](https://github.com/cwgrant))
 * [#3295](https://github.com/openlayers/ol3/pull/3295) - Add RESTful to WMTS GetCapabilities optionsFromCapabilities ([@sarametz](https://github.com/sarametz))
 * [#3304](https://github.com/openlayers/ol3/pull/3304) - Remove scale line inner padding ([@fredj](https://github.com/fredj))
 * [#3296](https://github.com/openlayers/ol3/pull/3296) - Add upgrade-notes.md file ([@elemoine](https://github.com/elemoine))
 * [#3303](https://github.com/openlayers/ol3/pull/3303) - Add constant for us-ft units ([@ahocevar](https://github.com/ahocevar))
 * [#3018](https://github.com/openlayers/ol3/pull/3018) - Add SelectEvent to interaction ([@bjornharrtell](https://github.com/bjornharrtell))
 * [#3301](https://github.com/openlayers/ol3/pull/3301) - Select interaction unit tests ([@bjornharrtell](https://github.com/bjornharrtell))
 * [#3298](https://github.com/openlayers/ol3/pull/3298) - Make ol.source.Source inherit from ol.Object ([@fredj](https://github.com/fredj))
 * [#3297](https://github.com/openlayers/ol3/pull/3297) - Add getters to ol.source.WMTS ([@fredj](https://github.com/fredj))
 * [#3281](https://github.com/openlayers/ol3/pull/3281) - Fix mouseMove event type comparison for IE10-11, pointermove ([@adube](https://github.com/adube))
 * [#3293](https://github.com/openlayers/ol3/pull/3293) - Add missing opacity option for ol.style.IconOptions ([@ahocevar](https://github.com/ahocevar))
 * [#3284](https://github.com/openlayers/ol3/pull/3284) - Fix jsdoc type for arrays of listening keys ([@fredj](https://github.com/fredj))
 * [#3278](https://github.com/openlayers/ol3/pull/3278) - Add goog.provide for ol.DrawEventType ([@elemoine](https://github.com/elemoine))
 * [#3272](https://github.com/openlayers/ol3/pull/3272) - Added getter function to return the wrapped source within the cluster ([@acanimal](https://github.com/acanimal))
 * [#3275](https://github.com/openlayers/ol3/pull/3275) - Add ol.layer.Heatmap#blur getter and setter ([@fredj](https://github.com/fredj))
 * [#3142](https://github.com/openlayers/ol3/pull/3142) - WMTS Get Cap document with updated WMTS.optionsFromCapabilities function ([@sarametz](https://github.com/sarametz))
 * [#3271](https://github.com/openlayers/ol3/pull/3271) - [wip] Fix misplaced comment blocks ([@fredj](https://github.com/fredj))
 * [#3273](https://github.com/openlayers/ol3/pull/3273) - Remove unused createGetTileIfLoadedFunction function. ([@tschaub](https://github.com/tschaub))
 * [#3270](https://github.com/openlayers/ol3/pull/3270) - Make ol.Overlay autoPan default to false ([@elemoine](https://github.com/elemoine))
 * [#3268](https://github.com/openlayers/ol3/pull/3268) - Fix autoPan in examples with ol.Overlay on hover ([@tsauerwein](https://github.com/tsauerwein))
 * [#3256](https://github.com/openlayers/ol3/pull/3256) - Add autoPan option to ol.Overlay ([@tsauerwein](https://github.com/tsauerwein))
 * [#3261](https://github.com/openlayers/ol3/pull/3261) - Fix forEachCorner extent, add TopLeft ([@adube](https://github.com/adube))
 * [#3260](https://github.com/openlayers/ol3/pull/3260) - Remove unused goog.require ([@fredj](https://github.com/fredj))
 * [#3246](https://github.com/openlayers/ol3/pull/3246) - Avoid creating unnecessary images in tile layers. ([@tschaub](https://github.com/tschaub))
 * [#3254](https://github.com/openlayers/ol3/pull/3254) - Use lineCap, lineJoin and miterLimit stroke properties in RegularShape ([@fredj](https://github.com/fredj))
 * [#3252](https://github.com/openlayers/ol3/pull/3252) - Avoid leaking global listenerSpy. ([@tschaub](https://github.com/tschaub))
 * [#3248](https://github.com/openlayers/ol3/pull/3248) - Add tile loading events to image tile sources. ([@tschaub](https://github.com/tschaub))
 * [#3240](https://github.com/openlayers/ol3/pull/3240) - Changes from the v3.2.x branch. ([@openlayers](https://github.com/openlayers))
 * [#3233](https://github.com/openlayers/ol3/pull/3233) - Four small fixes. ([@stweil](https://github.com/stweil))
 * [#3232](https://github.com/openlayers/ol3/pull/3232) - Fix typos found by codespell. ([@stweil](https://github.com/stweil))
 * [#3231](https://github.com/openlayers/ol3/pull/3231) - Make ol.layer.Heatmap#radius configurable ([@fredj](https://github.com/fredj))
 * [#3225](https://github.com/openlayers/ol3/pull/3225) - Respect attributions passed to TileJSON source. ([@tschaub](https://github.com/tschaub))
 * [#3223](https://github.com/openlayers/ol3/pull/3223) - Resize the canvas when the tile size changes. ([@tschaub](https://github.com/tschaub))
 * [#3224](https://github.com/openlayers/ol3/pull/3224) - Provide the ability to get the layer name from a MapQuest source ([@bartvde](https://github.com/bartvde))
 * [#3222](https://github.com/openlayers/ol3/pull/3222) - Add geodesic option for measure ([@bartvde](https://github.com/bartvde))
 * [#3221](https://github.com/openlayers/ol3/pull/3221) - Select the uppermost feature ([@fredj](https://github.com/fredj))
 * [#3211](https://github.com/openlayers/ol3/pull/3211) - Bing https logo fix. ([@photostu](https://github.com/photostu))
 * [#3215](https://github.com/openlayers/ol3/pull/3215) - Allow reuse of layer rendering code without creating a map. ([@tschaub](https://github.com/tschaub))
