# v3.14.0

## Summary

The v3.14.0 release includes features and fixes from 93 pull requests since the v3.13.1 release.  New features and improvements include:

* New `source` option for the `ol.control.FullScreen`, to allow including other elements besides the map in a full screen view (#4679).
* New `target` property for the Drag&Drop interaction allows using a different drop target than the map viewport (#4876).
* `ol.style.RegularShape` has a new `rotateWithView` option, for controlling how regular shape symbols are rendered on rotated views (#4698).
* New `layers` option for `ol.format.WMSGetFeatureInfo` format, to selectively only read features from specific layers (#4700).
* New `precision` parameter for formatting coordinates with `ol.coordinate.toStringHDMS` (#4787).
* Smarter tile queue for improved tile loading user experience when more than one tile layer is used (#4794).
* Improved rendering performance for tile layers by rendering tiles directly to the map canvas (#4597).
* The `goog.events` event system was replaced with our own lightweight event system. This significally reduces the build size (#4711). Replacement of other `goog.*` components with ES5 features or custom code marks a huge step towards the complete removal of the Closure Library dependency. 

## Upgrade notes

#### Internet Explorer 9 support

As of this release, OpenLayers requires a `requestAnimationFrame`/`cancelAnimationFrame` polyfill for IE 9 support. See https://cdn.polyfill.io/v2/docs/features/#requestAnimationFrame.

#### Layer pre-/postcompose event changes

It is the responsibility of the application to undo any canvas transform changes at the end of a layer 'precompose' or 'postcompose' handler. Previously, it was ok to set a null transform. The API now guarantees a device pixel coordinate system on the canvas with its origin in the top left corner of the map. However, applications should not rely on the underlying canvas being the same size as the visible viewport.

Old code:
```js
layer.on('precompose', function(e) {
  // rely on canvas dimensions to move coordinate origin to center
  e.context.translate(e.context.canvas.width / 2, e.context.canvas.height / 2);
  e.context.scale(3, 3);
  // draw an x in the center of the viewport
  e.context.moveTo(-20, -20);
  e.context.lineTo(20, 20);
  e.context.moveTo(-20, 20);
  e.context.lineTo(20, -20);
  // rely on the canvas having a null transform
  e.context.setTransform(1, 0, 0, 1, 0, 0);
});
```
New code:
```js
layer.on('precompose', function(e) {
  // use map size and pixel ratio to move coordinate origin to center
  var size = map.getSize();
  var pixelRatio = e.frameState.pixelRatio;
  e.context.translate(size[0] / 2 * pixelRatio, size[1] / 2 * pixelRatio);
  e.context.scale(3, 3);
  // draw an x in the center of the viewport
  e.context.moveTo(-20, -20);
  e.context.lineTo(20, 20);
  e.context.moveTo(-20, 20);
  e.context.lineTo(20, -20);
  // undo all transforms
  e.context.scale(1 / 3, 1 / 3);
  e.context.translate(-size[0] / 2 * pixelRatio, -size[1] / 2 * pixelRatio);
});
```

## Full list of changes

 * [#4896](https://github.com/openlayers/ol3/pull/4896) - Ignore XML sequence when comparing GML ([@ahocevar](https://github.com/ahocevar))
 * [#4890](https://github.com/openlayers/ol3/pull/4890) - ol.format.KML cleanup ([@fredj](https://github.com/fredj))
 * [#4894](https://github.com/openlayers/ol3/pull/4894) - Only run raster operations after image sources have loaded. ([@tschaub](https://github.com/tschaub))
 * [#4892](https://github.com/openlayers/ol3/pull/4892) - Stricter check for ImageData constructor ([@ahocevar](https://github.com/ahocevar))
 * [#4891](https://github.com/openlayers/ol3/pull/4891) - Fix tests so they all pass in IE9 ([@ahocevar](https://github.com/ahocevar))
 * [#4889](https://github.com/openlayers/ol3/pull/4889) - Use requestAnimation polyfill for examples and update release notes ([@ahocevar](https://github.com/ahocevar))
 * [#4887](https://github.com/openlayers/ol3/pull/4887) - Use less aggressive DOM function overrides ([@ahocevar](https://github.com/ahocevar))
 * [#4885](https://github.com/openlayers/ol3/pull/4885) - Mark overlayContainer and overlayContainerStopEvent as non-nullable ([@fredj](https://github.com/fredj))
 * [#4884](https://github.com/openlayers/ol3/pull/4884) - Remove use of goog.math.isFiniteNumber() ([@fredj](https://github.com/fredj))
 * [#4881](https://github.com/openlayers/ol3/pull/4881) - Update jquery to version 2.2.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4780](https://github.com/openlayers/ol3/pull/4780) - Adapt the code for the new closure-compiler version ([@fredj](https://github.com/fredj))
 * [#3453](https://github.com/openlayers/ol3/pull/3453) - Consider multi in add/remove/toggle select logic ([@bjornharrtell](https://github.com/bjornharrtell))
 * [#4876](https://github.com/openlayers/ol3/pull/4876) - Add `target` property to Drag&Drop interaction ([@tsauerwein](https://github.com/tsauerwein))
 * [#4854](https://github.com/openlayers/ol3/pull/4854) - Always report skipped feature hits for the original layer ([@ahocevar](https://github.com/ahocevar))
 * [#4877](https://github.com/openlayers/ol3/pull/4877) - Update eslint to version 2.2.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4870](https://github.com/openlayers/ol3/pull/4870) - Reuse dragListenerKeys_ local variable ([@fredj](https://github.com/fredj))
 * [#4721](https://github.com/openlayers/ol3/pull/4721) - Fix reprojection of raster sources with gutter ([@klokantech](https://github.com/klokantech))
 * [#4874](https://github.com/openlayers/ol3/pull/4874) - Assert we have a feature id ([@bartvde](https://github.com/bartvde))
 * [#4869](https://github.com/openlayers/ol3/pull/4869) - Improve precision of ol.reproj.render ([@klokantech](https://github.com/klokantech))
 * [#4866](https://github.com/openlayers/ol3/pull/4866) - Use requestAnimationFrame polyfill (for IE9) ([@ahocevar](https://github.com/ahocevar))
 * [#4863](https://github.com/openlayers/ol3/pull/4863) - Remove use of goog.dom.createElement ([@fredj](https://github.com/fredj))
 * [#4864](https://github.com/openlayers/ol3/pull/4864) - Use querySelectorAll instead of goog.dom.getElementsByClass ([@fredj](https://github.com/fredj))
 * [#4597](https://github.com/openlayers/ol3/pull/4597) - Render tiles directly to the map canvas ([@ahocevar](https://github.com/ahocevar))
 * [#4862](https://github.com/openlayers/ol3/pull/4862) - Add OSGeo badge ([@ahocevar](https://github.com/ahocevar))
 * [#4845](https://github.com/openlayers/ol3/pull/4845) - Fix geolocation error cast ([@gberaudo](https://github.com/gberaudo))
 * [#4851](https://github.com/openlayers/ol3/pull/4851) - Don't use goog.isBoolean() ([@marcjansen](https://github.com/marcjansen))
 * [#4852](https://github.com/openlayers/ol3/pull/4852) - Don't use goog.isString() ([@marcjansen](https://github.com/marcjansen))
 * [#4849](https://github.com/openlayers/ol3/pull/4849) - Fix docs of LogoOptions.prototype.src ([@openlayers](https://github.com/openlayers))
 * [#4794](https://github.com/openlayers/ol3/pull/4794) - Make tile loading count no longer depend on source count ([@ahocevar](https://github.com/ahocevar))
 * [#4843](https://github.com/openlayers/ol3/pull/4843) - Remove use of goog.dom.getParentElement ([@fredj](https://github.com/fredj))
 * [#4839](https://github.com/openlayers/ol3/pull/4839) - Add template type to ol.Collection ([@fredj](https://github.com/fredj))
 * [#4847](https://github.com/openlayers/ol3/pull/4847) - Update eslint to version 2.1.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4632](https://github.com/openlayers/ol3/pull/4632) - Overloading fill color (polygon or text) with CanvasPattern and CanvasGradient ([@bjnsn](https://github.com/bjnsn))
 * [#4842](https://github.com/openlayers/ol3/pull/4842) - Remove use of goog.dom.createDom ([@fredj](https://github.com/fredj))
 * [#4808](https://github.com/openlayers/ol3/pull/4808) - Type cleanup ([@fredj](https://github.com/fredj))
 * [#4737](https://github.com/openlayers/ol3/pull/4737) - Use olx.format.ReadOptions in ol.interaction.DragAndDrop ([@fredj](https://github.com/fredj))
 * [#4830](https://github.com/openlayers/ol3/pull/4830) - Make sure window.proj4 is always restored in tests ([@ahocevar](https://github.com/ahocevar))
 * [#4838](https://github.com/openlayers/ol3/pull/4838) - Use regular expression instead of String#endsWith() check ([@ahocevar](https://github.com/ahocevar))
 * [#4837](https://github.com/openlayers/ol3/pull/4837) - Update metalsmith-layouts to version 1.5.4 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4836](https://github.com/openlayers/ol3/pull/4836) - Use lowercase for all user agent checks ([@ahocevar](https://github.com/ahocevar))
 * [#4833](https://github.com/openlayers/ol3/pull/4833) - Upgrade linter and config. ([@tschaub](https://github.com/tschaub))
 * [#4831](https://github.com/openlayers/ol3/pull/4831) - Add navigation header to examples page ([@jonataswalker](https://github.com/jonataswalker))
 * [#4824](https://github.com/openlayers/ol3/pull/4824) - Don't use goog.string.newlines.* ([@marcjansen](https://github.com/marcjansen))
 * [#4825](https://github.com/openlayers/ol3/pull/4825) - Don't use goog.string.isEmpty ([@marcjansen](https://github.com/marcjansen))
 * [#4823](https://github.com/openlayers/ol3/pull/4823) - Fix type for layers option on ol.interaction.Select ([@ahocevar](https://github.com/ahocevar))
 * [#4815](https://github.com/openlayers/ol3/pull/4815) - wrapX false in synthetic examples ([@fredj](https://github.com/fredj))
 * [#4810](https://github.com/openlayers/ol3/pull/4810) - Add checks for undefined in controls ([@gberaudo](https://github.com/gberaudo))
 * [#4787](https://github.com/openlayers/ol3/pull/4787) - Add precision parameter for HDMS coordinate ([@pfanguin](https://github.com/pfanguin))
 * [#4811](https://github.com/openlayers/ol3/pull/4811) - Make ol.style.Style a @struct ([@fredj](https://github.com/fredj))
 * [#4800](https://github.com/openlayers/ol3/pull/4800) - Update phantomjs-prebuilt to version 2.1.4 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4792](https://github.com/openlayers/ol3/pull/4792) - Use ol.events.listen instead of ol.Observable#on ([@fredj](https://github.com/fredj))
 * [#4796](https://github.com/openlayers/ol3/pull/4796) - Remove use of goog.isString() ([@marcjansen](https://github.com/marcjansen))
 * [#4795](https://github.com/openlayers/ol3/pull/4795) - Cleanup after goog.array, goog.object and goog.isDef removal ([@ahocevar](https://github.com/ahocevar))
 * [#4791](https://github.com/openlayers/ol3/pull/4791) - Remove unnecessary cast ([@fredj](https://github.com/fredj))
 * [#4778](https://github.com/openlayers/ol3/pull/4778) - Remove use of goog.object. ([@tschaub](https://github.com/tschaub))
 * [#4789](https://github.com/openlayers/ol3/pull/4789) - Use ol.array instead of goog.array ([@fredj](https://github.com/fredj))
 * [#4788](https://github.com/openlayers/ol3/pull/4788) - Remove unnecessary newlines ([@fredj](https://github.com/fredj))
 * [#4731](https://github.com/openlayers/ol3/pull/4731) - Remove all remaining unnecessary casts ([@gberaudo](https://github.com/gberaudo))
 * [#4776](https://github.com/openlayers/ol3/pull/4776) - Correct assertion message in ol.array.binarySearch-test ([@marcjansen](https://github.com/marcjansen))
 * [#4711](https://github.com/openlayers/ol3/pull/4711) - Removal of goog.events.* ([@ahocevar](https://github.com/ahocevar))
 * [#4777](https://github.com/openlayers/ol3/pull/4777) - Fix source.UrlTile URL expansion ([@gberaudo](https://github.com/gberaudo))
 * [#4730](https://github.com/openlayers/ol3/pull/4730) - Document ol.Geolocation error event ([@fredj](https://github.com/fredj))
 * [#4772](https://github.com/openlayers/ol3/pull/4772) - Use node.setAttribute to set namespaceURI of a node ([@adube](https://github.com/adube))
 * [#4774](https://github.com/openlayers/ol3/pull/4774) - Update graceful-fs to version 4.1.3 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4680](https://github.com/openlayers/ol3/pull/4680) - Remove goog array. ([@nicholas-l](https://github.com/nicholas-l))
 * [#4771](https://github.com/openlayers/ol3/pull/4771) - Use innerHTML instead of innerText to populate the status element ([@fredj](https://github.com/fredj))
 * [#4769](https://github.com/openlayers/ol3/pull/4769) - Add opaque option to olx.source.OSMOptions ([@fredj](https://github.com/fredj))
 * [#4736](https://github.com/openlayers/ol3/pull/4736) - Properly detect feature on unmanaged layer for toggle selection ([@ahocevar](https://github.com/ahocevar))
 * [#4756](https://github.com/openlayers/ol3/pull/4756) - Remove VectorTile getSource re-definition of return value ([@adube](https://github.com/adube))
 * [#4733](https://github.com/openlayers/ol3/pull/4733) - Avoid rendering too big and too small images for vector tiles ([@ahocevar](https://github.com/ahocevar))
 * [#4754](https://github.com/openlayers/ol3/pull/4754) - Upgrade to mocha@2.4.5. ([@tschaub](https://github.com/tschaub))
 * [#4750](https://github.com/openlayers/ol3/pull/4750) - Update metalsmith-layouts to version 1.4.4 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4751](https://github.com/openlayers/ol3/pull/4751) - Update phantomjs to version 2.1.3 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4741](https://github.com/openlayers/ol3/pull/4741) - Report on installed versions in Travis. ([@openlayers](https://github.com/openlayers))
 * [#4742](https://github.com/openlayers/ol3/pull/4742) - Upgrade to eslint@2.0.0-beta.2. ([@tschaub](https://github.com/tschaub))
 * [#4746](https://github.com/openlayers/ol3/pull/4746) - Downgrade to mocha@2.3.4. ([@tschaub](https://github.com/tschaub))
 * [#4740](https://github.com/openlayers/ol3/pull/4740) - Update fs-extra to version 0.26.5 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4738](https://github.com/openlayers/ol3/pull/4738) - Add unit tests for ol.control.Rotate and ol.control.Zoom ([@fredj](https://github.com/fredj))
 * [#4718](https://github.com/openlayers/ol3/pull/4718) - Improve raster reprojection behavior when tiles fail to load ([@klokantech](https://github.com/klokantech))
 * [#4734](https://github.com/openlayers/ol3/pull/4734) - Update sinon to version 1.17.3 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4726](https://github.com/openlayers/ol3/pull/4726) - Update mocha to version 2.4.2 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4725](https://github.com/openlayers/ol3/pull/4725) - Untangle vector tile feature reprojection ([@ahocevar](https://github.com/ahocevar))
 * [#4735](https://github.com/openlayers/ol3/pull/4735) - Add default value for defaultDataProjection ([@fredj](https://github.com/fredj))
 * [#4732](https://github.com/openlayers/ol3/pull/4732) - Fix '@see' link in src/ol/deviceorientation.js ([@fredj](https://github.com/fredj))
 * [#4720](https://github.com/openlayers/ol3/pull/4720) - Improve tileLoadFunction docs ([@ahocevar](https://github.com/ahocevar))
 * [#4717](https://github.com/openlayers/ol3/pull/4717) - Update phantomjs to version 2.1.2 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4679](https://github.com/openlayers/ol3/pull/4679) - Add a source option for the full screen control ([@gaf-ag](https://github.com/gaf-ag))
 * [#4712](https://github.com/openlayers/ol3/pull/4712) - Add missing JSDoc tags ([@fredj](https://github.com/fredj))
 * [#4700](https://github.com/openlayers/ol3/pull/4700) - Add 'layers' option for WMSGetFeatureInfo format ([@adube](https://github.com/adube))
 * [#4705](https://github.com/openlayers/ol3/pull/4705) - Remove remaining unnecessary ol.source.State casts ([@gberaudo](https://github.com/gberaudo))
 * [#4703](https://github.com/openlayers/ol3/pull/4703) - Source options fixes. ([@gberaudo](https://github.com/gberaudo))
 * [#4698](https://github.com/openlayers/ol3/pull/4698) - Add rotateWithView option to ol.style.RegularShape ([@fredj](https://github.com/fredj))
 * [#4697](https://github.com/openlayers/ol3/pull/4697) - Bind tileUrlFunction to the source ([@gberaudo](https://github.com/gberaudo))
