# v3.15.0

## Summary

The v3.15.0 release includes features and fixes from 136 pull requests since the v3.14.2 release.  New features and improvements include:

 * Make ol.source.Cluster more flexible by adding a geometryFunction option (#4917).
 * Add new CartoDB tile source (#4926).
 * Improved rendering performance for vector layers by batching polygon fill and stroke instructions (#5149).
 * Make the tile cache size configurable (#4805).
 * Add new ol.geom.Geometry#rotate function (#4984).
 * Accept simpler forms of specifying attribution(s) for sources (#5007).
 * Support zooming out for ol.interaction.DragZoom (#5031).

## Upgrade notes

### v3.15.0

#### Internet Explorer 9 support

As of this release, OpenLayers requires a `classList` polyfill for IE 9 support. See https://cdn.polyfill.io/v2/docs/features#Element_prototype_classList.

#### Immediate rendering API

Listeners for `precompose`, `render`, and `postcompose` receive an event with a `vectorContext` property with methods for immediate vector rendering.  The previous geometry drawing methods have been replaced with a single `vectorContext.drawGeometry(geometry)` method.  If you were using any of the following experimental methods on the vector context, replace them with `drawGeometry`:

 * Removed experimental geometry drawing methods: `drawPointGeometry`, `drawLineStringGeometry`, `drawPolygonGeometry`, `drawMultiPointGeometry`, `drawMultiLineStringGeometry`, `drawMultiPolygonGeometry`, and `drawCircleGeometry` (all have been replaced with `drawGeometry`).

In addition, the previous methods for setting style parts have been replaced with a single `vectorContext.setStyle(style)` method.  If you were using any of the following experimental methods on the vector context, replace them with `setStyle`:

 * Removed experimental style setting methods: `setFillStrokeStyle`, `setImageStyle`, `setTextStyle` (all have been replaced with `setStyle`).

Below is an example of how the vector context might have been used in the past:

```js
// OLD WAY, NO LONGER SUPPORTED
map.on('postcompose', function(event) {
  event.vectorContext.setFillStrokeStyle(style.getFill(), style.getStroke());
  event.vectorContext.drawPointGeometry(geometry);
});
```

Here is an example of how you could accomplish the same with the new methods:
```js
// NEW WAY, USE THIS INSTEAD OF THE CODE ABOVE
map.on('postcompose', function(event) {
  event.vectorContext.setStyle(style);
  event.vectorContext.drawGeometry(geometry);
});
```

A final change to the immediate rendering API is that `vectorContext.drawFeature()` calls are now "immediate" as well.  The drawing now occurs synchronously.  This means that any `zIndex` in a style passed to `drawFeature()` will be ignored.  To achieve `zIndex` ordering, order your calls to `drawFeature()` instead.

#### Removal of `ol.DEFAULT_TILE_CACHE_HIGH_WATER_MARK`

The `ol.DEFAULT_TILE_CACHE_HIGH_WATER_MARK` define has been removed. The size of the cache can now be defined on every tile based `ol.source`:
```js
new ol.layer.Tile({
  source: new ol.source.OSM({
    cacheSize: 128
  })
})
```
The default cache size is `2048`.

## Full list of changes

 * [#4775](https://github.com/openlayers/ol3/pull/4775) - Remove goog.math.modulo and goog.math.lerp ([@nicholas-l](https://github.com/nicholas-l))
 * [#5152](https://github.com/openlayers/ol3/pull/5152) - Cartodb cleanup ([@fredj](https://github.com/fredj))
 * [#4804](https://github.com/openlayers/ol3/pull/4804) - Use Array.isArray instead of goog.isArray ([@fredj](https://github.com/fredj))
 * [#5149](https://github.com/openlayers/ol3/pull/5149) - Batch polygon fill and stroke instructions ([@ahocevar](https://github.com/ahocevar))
 * [#5159](https://github.com/openlayers/ol3/pull/5159) - Update eslint to version 2.6.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5160](https://github.com/openlayers/ol3/pull/5160) - Update clean-css to version 3.4.11 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5157](https://github.com/openlayers/ol3/pull/5157) - Improve docs for measure example ([@probins](https://github.com/probins))
 * [#5155](https://github.com/openlayers/ol3/pull/5155) - Fix ol.source.Zoomify tests on firefox ([@fredj](https://github.com/fredj))
 * [#5086](https://github.com/openlayers/ol3/pull/5086) - Get rid of goog.functions ([@bjornharrtell](https://github.com/bjornharrtell))
 * [#5105](https://github.com/openlayers/ol3/pull/5105) - Support minZoom in ol.source.Stamen ([@fredj](https://github.com/fredj))
 * [#4926](https://github.com/openlayers/ol3/pull/4926) - Add CartoDB tile source. ([@aisaacs](https://github.com/aisaacs))
 * [#5151](https://github.com/openlayers/ol3/pull/5151) - Use fs-extra as fs, remove usage of graceful-fs ([@marcjansen](https://github.com/marcjansen))
 * [#5124](https://github.com/openlayers/ol3/pull/5124) - Removed goog.dom.classlist ([@nicholas-l](https://github.com/nicholas-l))
 * [#5150](https://github.com/openlayers/ol3/pull/5150) - Use fs-extra instead of wrench ([@fredj](https://github.com/fredj))
 * [#5109](https://github.com/openlayers/ol3/pull/5109) - Add some tests for ol.source.TileUTFGrid ([@marcjansen](https://github.com/marcjansen))
 * [#5139](https://github.com/openlayers/ol3/pull/5139) - Update closure-util to version 1.13.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5141](https://github.com/openlayers/ol3/pull/5141) - Reuse dragListenerKeys_ variable in ol.control.ZoomSlider ([@fredj](https://github.com/fredj))
 * [#5118](https://github.com/openlayers/ol3/pull/5118) - Remove goog.dom.classlist usage ([@fredj](https://github.com/fredj))
 * [#5115](https://github.com/openlayers/ol3/pull/5115) - Clarify that lineDash has no effect in IE 10 and below ([@marcjansen](https://github.com/marcjansen))
 * [#5136](https://github.com/openlayers/ol3/pull/5136) - Update eslint to version 2.5.3 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5123](https://github.com/openlayers/ol3/pull/5123) - Update coveralls to version 2.11.9 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5131](https://github.com/openlayers/ol3/pull/5131) - Update phantomjs-prebuilt to version 2.1.7 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5122](https://github.com/openlayers/ol3/pull/5122) - Update browser support info in intro tutorial ([@probins](https://github.com/probins))
 * [#5112](https://github.com/openlayers/ol3/pull/5112) - Add decimals option to format write ([@probins](https://github.com/probins))
 * [#5120](https://github.com/openlayers/ol3/pull/5120) - Add tileJSON option to ol.source.TileUTFGrid ([@ahocevar](https://github.com/ahocevar))
 * [#5119](https://github.com/openlayers/ol3/pull/5119) - Add ol.source.Raster events on API docs page ([@drnextgis](https://github.com/drnextgis))
 * [#5116](https://github.com/openlayers/ol3/pull/5116) - Improve examples pages on mobile devices a bit ([@ahocevar](https://github.com/ahocevar))
 * [#5113](https://github.com/openlayers/ol3/pull/5113) - Memory leak in ol.control.FullScreen ([@AvatharDG](https://github.com/AvatharDG))
 * [#5111](https://github.com/openlayers/ol3/pull/5111) - Remove CSS filter in examples ([@fredj](https://github.com/fredj))
 * [#5108](https://github.com/openlayers/ol3/pull/5108) - Remove unused ol.xml.getAttributeNodeNS function ([@fredj](https://github.com/fredj))
 * [#5106](https://github.com/openlayers/ol3/pull/5106) - Get rid of goog.math.Vec2 ([@fredj](https://github.com/fredj))
 * [#5096](https://github.com/openlayers/ol3/pull/5096) - Add tests for ol.source.Zoomify ([@marcjansen](https://github.com/marcjansen))
 * [#5102](https://github.com/openlayers/ol3/pull/5102) - Fix typo in API docs ([@openlayers](https://github.com/openlayers))
 * [#5098](https://github.com/openlayers/ol3/pull/5098) - Reintroduce log messages for relevant WebGL assertions ([@bjornharrtell](https://github.com/bjornharrtell))
 * [#5094](https://github.com/openlayers/ol3/pull/5094) - FAQ: answer question 4 ([@probins](https://github.com/probins))
 * [#5092](https://github.com/openlayers/ol3/pull/5092) - add raster.jsdoc ([@drnextgis](https://github.com/drnextgis))
 * [#5081](https://github.com/openlayers/ol3/pull/5081) - Snap to vertices or edges ([@drnextgis](https://github.com/drnextgis))
 * [#5090](https://github.com/openlayers/ol3/pull/5090) - Update custom-builds.md ([@probins](https://github.com/probins))
 * [#5089](https://github.com/openlayers/ol3/pull/5089) - Test for both transform coords should use roughlyEqual ([@probins](https://github.com/probins))
 * [#5080](https://github.com/openlayers/ol3/pull/5080) - Fix geojson write GeometryCollection ([@probins](https://github.com/probins))
 * [#5088](https://github.com/openlayers/ol3/pull/5088) - DEVELOPING.md: remove section on running Travis on fork ([@probins](https://github.com/probins))
 * [#5087](https://github.com/openlayers/ol3/pull/5087) - assertion to check that there's a DOM node for target element ([@drnextgis](https://github.com/drnextgis))
 * [#5069](https://github.com/openlayers/ol3/pull/5069) - Update jquery to version 2.2.2 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5083](https://github.com/openlayers/ol3/pull/5083) - Remove unnecessary lineTo calls in immediate polygon rendering ([@tschaub](https://github.com/tschaub))
 * [#5082](https://github.com/openlayers/ol3/pull/5082) - Get rid of goog.log. ([@bjornharrtell](https://github.com/bjornharrtell))
 * [#5079](https://github.com/openlayers/ol3/pull/5079) - Correcting a typo in the upgrade notes ([@tschaub](https://github.com/tschaub))
 * [#5076](https://github.com/openlayers/ol3/pull/5076) - Update phantomjs-prebuilt to version 2.1.6 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5077](https://github.com/openlayers/ol3/pull/5077) - Make immediate API uniformly synchronous. ([@tschaub](https://github.com/tschaub))
 * [#5072](https://github.com/openlayers/ol3/pull/5072) - Add setStyle() and drawGeometry() to the immediate rendering API. ([@tschaub](https://github.com/tschaub))
 * [#5074](https://github.com/openlayers/ol3/pull/5074) - Do not rotate map canvas after composition ([@ahocevar](https://github.com/ahocevar))
 * [#5071](https://github.com/openlayers/ol3/pull/5071) - correct way to determine freehand mode is enabled ([@drnextgis](https://github.com/drnextgis))
 * [#5066](https://github.com/openlayers/ol3/pull/5066) - Add more getters to ol.source.Vector ([@bartvde](https://github.com/bartvde))
 * [#5064](https://github.com/openlayers/ol3/pull/5064) - Fix inconsistency in geom docs ([@probins](https://github.com/probins))
 * [#5063](https://github.com/openlayers/ol3/pull/5063) - Remove inappropriate information from API docs ([@drnextgis](https://github.com/drnextgis))
 * [#5061](https://github.com/openlayers/ol3/pull/5061) - Remove redundant required option ([@drnextgis](https://github.com/drnextgis))
 * [#5058](https://github.com/openlayers/ol3/pull/5058) - Note in docs that DOM renderer can also render vectors ([@probins](https://github.com/probins))
 * [#5056](https://github.com/openlayers/ol3/pull/5056) - Note in docs that WebGL can render points ([@probins](https://github.com/probins))
 * [#5055](https://github.com/openlayers/ol3/pull/5055) - Fix cruft on kml scale output ([@probins](https://github.com/probins))
 * [#5051](https://github.com/openlayers/ol3/pull/5051) - Handle aborted tiles in ol.TileQueue ([@fredj](https://github.com/fredj))
 * [#5049](https://github.com/openlayers/ol3/pull/5049) - Supported browsers all have getComputedStyle ([@marcjansen](https://github.com/marcjansen))
 * [#5048](https://github.com/openlayers/ol3/pull/5048) - Add tests for ol.dom methods ([@marcjansen](https://github.com/marcjansen))
 * [#5031](https://github.com/openlayers/ol3/pull/5031) - support zooming out for ol.interaction.DragZoom ([@drnextgis](https://github.com/drnextgis))
 * [#5036](https://github.com/openlayers/ol3/pull/5036) - Use imgSize when provided ([@ahocevar](https://github.com/ahocevar))
 * [#5020](https://github.com/openlayers/ol3/pull/5020) - Update gaze to version 1.0.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5039](https://github.com/openlayers/ol3/pull/5039) - Update fs-extra to version 0.26.6 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5033](https://github.com/openlayers/ol3/pull/5033) - Document GPX geometry output types ([@probins](https://github.com/probins))
 * [#5024](https://github.com/openlayers/ol3/pull/5024) - Resize the map canvas less aggressively ([@ahocevar](https://github.com/ahocevar))
 * [#5000](https://github.com/openlayers/ol3/pull/5000) - Remove use of goog.math.Size and goog.style.setBorderBoxSize ([@fredj](https://github.com/fredj))
 * [#5027](https://github.com/openlayers/ol3/pull/5027) - Clarify default value of featureProjection on geometry write ([@probins](https://github.com/probins))
 * [#5019](https://github.com/openlayers/ol3/pull/5019) - Update eslint to version 2.4.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5016](https://github.com/openlayers/ol3/pull/5016) - Add basic tests for ol.geom.flat.center ([@marcjansen](https://github.com/marcjansen))
 * [#5015](https://github.com/openlayers/ol3/pull/5015) - Update proj4 to version 2.3.14 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5013](https://github.com/openlayers/ol3/pull/5013) - Fix typo in test description ([@openlayers](https://github.com/openlayers))
 * [#5007](https://github.com/openlayers/ol3/pull/5007) - Accept simpler forms of specifying attribution(s) for sources. ([@marcjansen](https://github.com/marcjansen))
 * [#5011](https://github.com/openlayers/ol3/pull/5011) - Add missing setProjection function to ol.VectorTile API ([@ahocevar](https://github.com/ahocevar))
 * [#5010](https://github.com/openlayers/ol3/pull/5010) - Add and fix API docs for ol.events.Event stack ([@ahocevar](https://github.com/ahocevar))
 * [#5009](https://github.com/openlayers/ol3/pull/5009) - Update tutorials ([@gberaudo](https://github.com/gberaudo))
 * [#5006](https://github.com/openlayers/ol3/pull/5006) - Use the maintained slimerjs package ([@ahocevar](https://github.com/ahocevar))
 * [#5003](https://github.com/openlayers/ol3/pull/5003) - Add 'function' jsdoc tag to ol.geom.Geometry#rotate ([@fredj](https://github.com/fredj))
 * [#5002](https://github.com/openlayers/ol3/pull/5002) - Update eslint-config-openlayers to version 4.1.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4999](https://github.com/openlayers/ol3/pull/4999) - Remove use of goog.dom.removeNode ([@fredj](https://github.com/fredj))
 * [#4990](https://github.com/openlayers/ol3/pull/4990) - Add new ol.source.TileJSON#getTileJSON function ([@fredj](https://github.com/fredj))
 * [#4998](https://github.com/openlayers/ol3/pull/4998) - Remove unused ol.Map#isDef function ([@fredj](https://github.com/fredj))
 * [#4995](https://github.com/openlayers/ol3/pull/4995) - Remove unused ol.color functions. ([@tschaub](https://github.com/tschaub))
 * [#4991](https://github.com/openlayers/ol3/pull/4991) - Do not remove listeners while dispatching event ([@ahocevar](https://github.com/ahocevar))
 * [#4984](https://github.com/openlayers/ol3/pull/4984) - Add new ol.geom.Geometry#rotate function ([@fredj](https://github.com/fredj))
 * [#4994](https://github.com/openlayers/ol3/pull/4994) - Add alpha default value to ol.Color array form ([@jonataswalker](https://github.com/jonataswalker))
 * [#4992](https://github.com/openlayers/ol3/pull/4992) - Allow configuration of the test reporter ([@marcjansen](https://github.com/marcjansen))
 * [#4988](https://github.com/openlayers/ol3/pull/4988) - Update phantomjs-prebuilt to version 2.1.5 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4983](https://github.com/openlayers/ol3/pull/4983) - Update Bing Maps Portal url ([@ahocevar](https://github.com/ahocevar))
 * [#4981](https://github.com/openlayers/ol3/pull/4981) - Remove the viewport on map dispose ([@fredj](https://github.com/fredj))
 * [#4980](https://github.com/openlayers/ol3/pull/4980) - Remove unused goog.require ([@fredj](https://github.com/fredj))
 * [#4977](https://github.com/openlayers/ol3/pull/4977) - Add basic tests for ol.geom.flat.length methods ([@marcjansen](https://github.com/marcjansen))
 * [#4973](https://github.com/openlayers/ol3/pull/4973) - Update eslint to version 2.3.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4971](https://github.com/openlayers/ol3/pull/4971) - Release v3.14.2 ([@openlayers](https://github.com/openlayers))
 * [#4970](https://github.com/openlayers/ol3/pull/4970) - Tests for ol.Disposable. ([@tschaub](https://github.com/tschaub))
 * [#4967](https://github.com/openlayers/ol3/pull/4967) - Add missing goog.inherits for ol.render.canvas.Immediate ([@fredj](https://github.com/fredj))
 * [#4955](https://github.com/openlayers/ol3/pull/4955) - Remove IE workarounds in src/ol/xml.js ([@fredj](https://github.com/fredj))
 * [#4960](https://github.com/openlayers/ol3/pull/4960) - Simplify clipping of lower resolution regions ([@ahocevar](https://github.com/ahocevar))
 * [#4950](https://github.com/openlayers/ol3/pull/4950) - Remove use of goog.Disposable(). ([@tschaub](https://github.com/tschaub))
 * [#4963](https://github.com/openlayers/ol3/pull/4963) - Handle more XHR errors in the TileJSON source ([@tschaub](https://github.com/tschaub))
 * [#4962](https://github.com/openlayers/ol3/pull/4962) - Skip tests where features are not available ([@tschaub](https://github.com/tschaub))
 * [#4956](https://github.com/openlayers/ol3/pull/4956) - Fix Examples layout page ([@jonataswalker](https://github.com/jonataswalker))
 * [#4958](https://github.com/openlayers/ol3/pull/4958) - Stop wheel events instead of DOMMouseScroll events ([@fredj](https://github.com/fredj))
 * [#4947](https://github.com/openlayers/ol3/pull/4947) - IE support for ol.source.Raster. ([@tschaub](https://github.com/tschaub))
 * [#4944](https://github.com/openlayers/ol3/pull/4944) - Update resemblejs to version 2.2.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4942](https://github.com/openlayers/ol3/pull/4942) - Remove unused files in examples/data/ ([@fredj](https://github.com/fredj))
 * [#4805](https://github.com/openlayers/ol3/pull/4805) - Add new cacheSize option to ol.source ([@fredj](https://github.com/fredj))
 * [#4940](https://github.com/openlayers/ol3/pull/4940) - Release v3.14.1 ([@openlayers](https://github.com/openlayers))
 * [#4939](https://github.com/openlayers/ol3/pull/4939) - Fix rendering of opaque layers with opacity != 1 ([@ahocevar](https://github.com/ahocevar))
 * [#4938](https://github.com/openlayers/ol3/pull/4938) - Get rid of goog.dom.getFirstElementChild ([@fredj](https://github.com/fredj))
 * [#4937](https://github.com/openlayers/ol3/pull/4937) - Get rid of goog.json ([@fredj](https://github.com/fredj))
 * [#4936](https://github.com/openlayers/ol3/pull/4936) - Remove jquery from getfeatureinfo-layers example ([@fredj](https://github.com/fredj))
 * [#4930](https://github.com/openlayers/ol3/pull/4930) - Use ADVANCED instead of ADVANCED_OPTIMIZATIONS ([@fredj](https://github.com/fredj))
 * [#4917](https://github.com/openlayers/ol3/pull/4917) - Make ol.source.Cluster more flexible by adding a geometryFunction option ([@ahocevar](https://github.com/ahocevar))
 * [#4918](https://github.com/openlayers/ol3/pull/4918) - Don't change the canvas size to clear it ([@fredj](https://github.com/fredj))
 * [#4923](https://github.com/openlayers/ol3/pull/4923) - Update custom-builds.md ([@xlhomme](https://github.com/xlhomme))
 * [#4929](https://github.com/openlayers/ol3/pull/4929) - Update clean-css to version 3.4.10 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4928](https://github.com/openlayers/ol3/pull/4928) - Upgrade to JSTS 1.0.2 in example ([@bjornharrtell](https://github.com/bjornharrtell))
 * [#4927](https://github.com/openlayers/ol3/pull/4927) - Upgrade JSTS in example. ([@bjornharrtell](https://github.com/bjornharrtell))
 * [#4809](https://github.com/openlayers/ol3/pull/4809) - Fix multipolygon clone. ([@fperucic](https://github.com/fperucic))
 * [#4924](https://github.com/openlayers/ol3/pull/4924) - Update coveralls to version 2.11.8 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4921](https://github.com/openlayers/ol3/pull/4921) - Unlisten before calling listener and bind to target by default ([@ahocevar](https://github.com/ahocevar))
 * [#4868](https://github.com/openlayers/ol3/pull/4868) - Allow to refresh a source and reload its data. ([@sebasbaumh](https://github.com/sebasbaumh))
 * [#4903](https://github.com/openlayers/ol3/pull/4903) - Remove use of goog.style.getRelativePosition ([@fredj](https://github.com/fredj))
 * [#4902](https://github.com/openlayers/ol3/pull/4902) - Remove use of goog.style.getClientPosition ([@fredj](https://github.com/fredj))
 * [#4916](https://github.com/openlayers/ol3/pull/4916) - Fix ol.format.GeoJSON#writeFeatureObject return type ([@fredj](https://github.com/fredj))
 * [#4909](https://github.com/openlayers/ol3/pull/4909) - Add ol.renderer.dom.VectorLayer#clearFrame ([@fredj](https://github.com/fredj))
 * [#4915](https://github.com/openlayers/ol3/pull/4915) - Use {} instead of Object ([@fredj](https://github.com/fredj))
 * [#4914](https://github.com/openlayers/ol3/pull/4914) - Export ol.proj.equivalent ([@sebasbaumh](https://github.com/sebasbaumh))
 * [#4908](https://github.com/openlayers/ol3/pull/4908) - Remove use of goog.math.Rect ([@fredj](https://github.com/fredj))
 * [#4900](https://github.com/openlayers/ol3/pull/4900) - Make ol.format.XML a @struct ([@fredj](https://github.com/fredj))
 * [#4880](https://github.com/openlayers/ol3/pull/4880) - Update closure-util to version 1.11.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4905](https://github.com/openlayers/ol3/pull/4905) - Remove use of goog.style.setPosition ([@fredj](https://github.com/fredj))
 * [#4879](https://github.com/openlayers/ol3/pull/4879) - Update metalsmith-layouts to version 1.6.4 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4901](https://github.com/openlayers/ol3/pull/4901) - Release v3.14.0 ([@openlayers](https://github.com/openlayers))
 * [#4899](https://github.com/openlayers/ol3/pull/4899) - Use ol.format.GMLBase#srsName instead of undeclared srsName_ ([@fredj](https://github.com/fredj))
