# v3.19.0

## Summary

The v3.19.0 release includes features and fixes from a little more than 120 pull requests with more than 380 commits. Most of the changes are bug fixes, documentation enhancements or target the continuing removal of the dependency on Closure Library. Some notable new or enhanced features are:

* Vector fills with `CanvasGradient` or `CanvasPattern` now move and rotate with the map which is far more intuitive ([#5950](https://github.com/openlayers/ol3/pull/5950))
* Drawing in `freehand`-mode also became more intuitive ([#5970](https://github.com/openlayers/ol3/pull/5970), [#5973](https://github.com/openlayers/ol3/pull/5973), [#5975](https://github.com/openlayers/ol3/pull/5975))
* When tiles of different resolutions are combined for a layer (which is the case before all tiles of the best resolution have been loaded), lower resolution tiles now align with higher resolution tiles resulting in a map without gaps ([#5890](https://github.com/openlayers/ol3/pull/5890))
* Styles can now easily be cloned ([#5832](https://github.com/openlayers/ol3/pull/5832))

Additionally the [openlayers.org](https://openlayers.org) homepage is now available via the `https`-protocol.

## Upgrade notes

#### `ol.style.Fill` with `CanvasGradient` or `CanvasPattern`

Previously, gradients and patterns were aligned with the canvas, so they did not
move and rotate with the map. This was changed to a more expected behavior by anchoring the fill to the map origin (usually at map coordinate `[0, 0]`).

#### `goog.DEBUG` define was renamed to `ol.DEBUG`

As last step in the removal of the dependency on Google Closure Library, the `goog.DEBUG` compiler define was renamed to `ol.DEBUG`. Please change accordingly in your custom build configuration json files.

#### `ol.format.ogc.filter` namespace was renamed to `ol.format.filter`

`ol.format.ogc.filter` was simplified to `ol.format.filter`; to upgrade your code, simply remove the `ogc` string from the name.
For example: `ol.format.ogc.filter.and` to `ol.format.filter.and`.

#### Changes only relevant to those who compile their applications together with the Closure Compiler

A number of internal types have been renamed.  This will not affect those who use the API provided by the library, but if you are compiling your application together with OpenLayers and using type names, you'll need to do the following:

 * rename `ol.CollectionProperty` to `ol.Collection.Property`
 * rename `ol.DeviceOrientationProperty` to `ol.DeviceOrientation.Property`
 * rename `ol.DragBoxEvent` to `ol.interaction.DragBox.Event`
 * rename `ol.DragBoxEventType` to `ol.interaction.DragBox.EventType`
 * rename `ol.GeolocationProperty` to `ol.Geolocation.Property`
 * rename `ol.OverlayPositioning` to `ol.Overlay.Positioning`
 * rename `ol.OverlayProperty` to `ol.Overlay.Property`
 * rename `ol.control.MousePositionProperty` to `ol.control.MousePosition.Property`
 * rename `ol.format.IGCZ` to `ol.format.IGC.Z`
 * rename `ol.interaction.InteractionProperty` to `ol.interaction.Interaction.Property`
 * rename `ol.interaction.DrawMode` to `ol.interaction.Draw.Mode`
 * rename `ol.interaction.DrawEvent` to `ol.interaction.Draw.Event`
 * rename `ol.interaction.DrawEventType` to `ol.interaction.Draw.EventType`
 * rename `ol.interaction.ExtentEvent` to `ol.interaction.Extent.Event`
 * rename `ol.interaction.ExtentEventType` to `ol.interaction.Extent.EventType`
 * rename `ol.interaction.DragAndDropEvent` to `ol.interaction.DragAndDrop.Event`
 * rename `ol.interaction.DragAndDropEventType` to `ol.interaction.DragAndDrop.EventType`
 * rename `ol.interaction.ModifyEvent` to `ol.interaction.Modify.Event`
 * rename `ol.interaction.SelectEvent` to `ol.interaction.Select.Event`
 * rename `ol.interaction.SelectEventType` to `ol.interaction.Select.EventType`
 * rename `ol.interaction.TranslateEvent` to `ol.interaction.Translate.Event`
 * rename `ol.interaction.TranslateEventType` to `ol.interaction.Translate.EventType`
 * rename `ol.layer.GroupProperty` to `ol.layer.Group.Property`
 * rename `ol.layer.HeatmapLayerProperty` to `ol.layer.Heatmap.Property`
 * rename `ol.layer.TileProperty` to `ol.layer.Tile.Property`
 * rename `ol.layer.VectorTileRenderType` to `ol.layer.VectorTile.RenderType`
 * rename `ol.MapEventType` to `ol.MapEvent.Type`
 * rename `ol.MapProperty` to `ol.Map.Property`
 * rename `ol.ModifyEventType` to `ol.interaction.Modify.EventType`
 * rename `ol.RendererType` to `ol.renderer.Type`
 * rename `ol.render.EventType` to `ol.render.Event.Type`
 * rename `ol.source.ImageEvent` to `ol.source.Image.Event`
 * rename `ol.source.ImageEventType` to `ol.source.Image.EventType`
 * rename `ol.source.RasterEvent` to `ol.source.Raster.Event`
 * rename `ol.source.RasterEventType` to `ol.source.Raster.EventType`
 * rename `ol.source.TileEvent` to `ol.source.Tile.Event`
 * rename `ol.source.TileEventType` to `ol.source.Tile.EventType`
 * rename `ol.source.VectorEvent` to `ol.source.Vector.Event`
 * rename `ol.source.VectorEventType` to `ol.source.Vector.EventType`
 * rename `ol.source.wms.ServerType` to `ol.source.WMSServerType`
 * rename `ol.source.WMTSRequestEncoding` to `ol.source.WMTS.RequestEncoding`
 * rename `ol.style.IconAnchorUnits` to `ol.style.Icon.AnchorUnits`
 * rename `ol.style.IconOrigin` to `ol.style.Icon.Origin`

## Full list of changes

 * [#6007](https://github.com/openlayers/ol3/pull/6007) - Add note to example that canvas.toBlob() is required ([@marcjansen](https://github.com/marcjansen))
 * [#5979](https://github.com/openlayers/ol3/pull/5979) - Use FileSaver.js in export-map example ([@fredj](https://github.com/fredj))
 * [#6004](https://github.com/openlayers/ol3/pull/6004) - Bring back the vector-osm example, using a different service ([@ahocevar](https://github.com/ahocevar))
 * [#6002](https://github.com/openlayers/ol3/pull/6002) - Use tile pixel ratio for gutter calculation ([@ahocevar](https://github.com/ahocevar))
 * [#5991](https://github.com/openlayers/ol3/pull/5991) - Only test ol.format.MVT if ArrayBuffer.isView is supported ([@openlayers](https://github.com/openlayers))
 * [#6000](https://github.com/openlayers/ol3/pull/6000) - Fix mockup of tile layer to keep drawImage arguments in range ([@ahocevar](https://github.com/ahocevar))
 * [#5997](https://github.com/openlayers/ol3/pull/5997) - Always load a gated URL polyfill when testing ([@marcjansen](https://github.com/marcjansen))
 * [#5963](https://github.com/openlayers/ol3/pull/5963) - Remove the vertex on ol.interaction.Modify deactivation ([@fredj](https://github.com/fredj))
 * [#5994](https://github.com/openlayers/ol3/pull/5994) - Setup a loaded image with src for TileLayer test ([@marcjansen](https://github.com/marcjansen))
 * [#5989](https://github.com/openlayers/ol3/pull/5989) - Remove vector-osm example ([@openlayers](https://github.com/openlayers))
 * [#5985](https://github.com/openlayers/ol3/pull/5985) - Update Mapzen urls to new scheme ([@ahocevar](https://github.com/ahocevar))
 * [#5984](https://github.com/openlayers/ol3/pull/5984) - Less examples with mixed content ([@ahocevar](https://github.com/ahocevar))
 * [#5986](https://github.com/openlayers/ol3/pull/5986) - Update eslint to version 3.8.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5982](https://github.com/openlayers/ol3/pull/5982) - Use a https enabled GeoServer ([@ahocevar](https://github.com/ahocevar))
 * [#5977](https://github.com/openlayers/ol3/pull/5977) - Convenience function for drawing boxes ([@tschaub](https://github.com/tschaub))
 * [#5978](https://github.com/openlayers/ol3/pull/5978) - Update async to version 2.1.2 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5975](https://github.com/openlayers/ol3/pull/5975) - Finish drawing on pointerup when in freehand mode ([@tschaub](https://github.com/tschaub))
 * [#5976](https://github.com/openlayers/ol3/pull/5976) - Use https where available ([@tschaub](https://github.com/tschaub))
 * [#5973](https://github.com/openlayers/ol3/pull/5973) - Add a freehand option to the draw interaction ([@tschaub](https://github.com/tschaub))
 * [#5964](https://github.com/openlayers/ol3/pull/5964) - Set one-off transform instead of transforming back and forth ([@ahocevar](https://github.com/ahocevar))
 * [#5970](https://github.com/openlayers/ol3/pull/5970) - Allow circles, squares, and boxes to be drawn in freehand mode ([@tschaub](https://github.com/tschaub))
 * [#5972](https://github.com/openlayers/ol3/pull/5972) - Update eslint to version 3.8.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5969](https://github.com/openlayers/ol3/pull/5969) - Test all, not just one ([@ahocevar](https://github.com/ahocevar))
 * [#5967](https://github.com/openlayers/ol3/pull/5967) - Add missing jsdoc to ol.render.canvas.Replay#fill_ function ([@fredj](https://github.com/fredj))
 * [#5962](https://github.com/openlayers/ol3/pull/5962) - Use same proj4js version in examples and tests ([@ahocevar](https://github.com/ahocevar))
 * [#5961](https://github.com/openlayers/ol3/pull/5961) - Remove unused error codes ([@ahocevar](https://github.com/ahocevar))
 * [#5960](https://github.com/openlayers/ol3/pull/5960) - More renaming to have one provide per file ([@fredj](https://github.com/fredj))
 * [#5959](https://github.com/openlayers/ol3/pull/5959) - Remove unnecessary and misleading assertion ([@ahocevar](https://github.com/ahocevar))
 * [#5950](https://github.com/openlayers/ol3/pull/5950) - Move gradient and pattern fills with the view ([@ahocevar](https://github.com/ahocevar))
 * [#5957](https://github.com/openlayers/ol3/pull/5957) - Update async to version 2.1.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5956](https://github.com/openlayers/ol3/pull/5956) - Update async to version 2.1.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5955](https://github.com/openlayers/ol3/pull/5955) - Add getters to BingMaps source for api key and imagerySet ([@bartvde](https://github.com/bartvde))
 * [#5944](https://github.com/openlayers/ol3/pull/5944) - Allow readFeature and readFeatures to be called with GeoJSON geometries ([@tschaub](https://github.com/tschaub))
 * [#5949](https://github.com/openlayers/ol3/pull/5949) - Add prose documentation for ol.AttributionLike ([@marcjansen](https://github.com/marcjansen))
 * [#5948](https://github.com/openlayers/ol3/pull/5948) - Fix API docs of ol.Feature#getStyle ([@marcjansen](https://github.com/marcjansen))
 * [#5946](https://github.com/openlayers/ol3/pull/5946) - Update mocha to version 3.1.2 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5941](https://github.com/openlayers/ol3/pull/5941) - Update mocha to version 3.1.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5890](https://github.com/openlayers/ol3/pull/5890) - No gaps between tiles of different resolutions ([@ahocevar](https://github.com/ahocevar))
 * [#5935](https://github.com/openlayers/ol3/pull/5935) - Keep transformed coordinates within valid y range ([@tschaub](https://github.com/tschaub))
 * [#5937](https://github.com/openlayers/ol3/pull/5937) - One provide per file for vector tiles ([@ahocevar](https://github.com/ahocevar))
 * [#5933](https://github.com/openlayers/ol3/pull/5933) - Update phantomjs-prebuilt to version 2.1.13 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5932](https://github.com/openlayers/ol3/pull/5932) - Update eslint to version 3.7.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5931](https://github.com/openlayers/ol3/pull/5931) - Update jsdoc to version 3.4.2 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5923](https://github.com/openlayers/ol3/pull/5923) - Update pbf to version 3.0.2 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5926](https://github.com/openlayers/ol3/pull/5926) - Ensure correct type of event.element ([@adube](https://github.com/adube))
 * [#5928](https://github.com/openlayers/ol3/pull/5928) - Update eslint to version 3.7.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5919](https://github.com/openlayers/ol3/pull/5919) - Update resemblejs to version 2.2.2 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5909](https://github.com/openlayers/ol3/pull/5909) - Update jquery to version 3.1.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5917](https://github.com/openlayers/ol3/pull/5917) - Accept feature projection in GeoJSON constructor ([@tschaub](https://github.com/tschaub))
 * [#5918](https://github.com/openlayers/ol3/pull/5918) - Update mocha to version 3.1.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5916](https://github.com/openlayers/ol3/pull/5916) - Update eslint to version 3.6.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5914](https://github.com/openlayers/ol3/pull/5914) - Allow clipping by MultiPolygon ([@tschaub](https://github.com/tschaub))
 * [#5894](https://github.com/openlayers/ol3/pull/5894) - Reuse arrays for rendered tiles and extent ([@ahocevar](https://github.com/ahocevar))
 * [#5895](https://github.com/openlayers/ol3/pull/5895) - Always use the frameState's extent ([@ahocevar](https://github.com/ahocevar))
 * [#5911](https://github.com/openlayers/ol3/pull/5911) - Update eslint to version 3.6.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5903](https://github.com/openlayers/ol3/pull/5903) - Rename ol.format.ogc.filter namespace to ol.format.filter ([@fredj](https://github.com/fredj))
 * [#5913](https://github.com/openlayers/ol3/pull/5913) - Update clean-css to version 3.4.20 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5776](https://github.com/openlayers/ol3/pull/5776) - Add ol.style.Circle#setRadius ([@jonataswalker](https://github.com/jonataswalker))
 * [#5905](https://github.com/openlayers/ol3/pull/5905) - Update pbf to version 3.0.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5904](https://github.com/openlayers/ol3/pull/5904) - Fix changelog/upgrade-notes.md formating ([@fredj](https://github.com/fredj))
 * [#5906](https://github.com/openlayers/ol3/pull/5906) - Update glob to version 7.1.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5898](https://github.com/openlayers/ol3/pull/5898) - Update sinon to version 1.17.6 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5888](https://github.com/openlayers/ol3/pull/5888) - Remove unused functions ([@fredj](https://github.com/fredj))
 * [#5900](https://github.com/openlayers/ol3/pull/5900) - Update coveralls to version 2.11.14 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5897](https://github.com/openlayers/ol3/pull/5897) - Show NEXRAD data in WMS Time example ([@ahocevar](https://github.com/ahocevar))
 * [#5896](https://github.com/openlayers/ol3/pull/5896) - Remove plain string from Map renderer option ([@probins](https://github.com/probins))
 * [#5893](https://github.com/openlayers/ol3/pull/5893) - Fix fillStyle or strokeStyle defined assertion ([@ahocevar](https://github.com/ahocevar))
 * [#5892](https://github.com/openlayers/ol3/pull/5892) - Remove getRendererFromQueryString from examples ([@probins](https://github.com/probins))
 * [#5889](https://github.com/openlayers/ol3/pull/5889) - Update coveralls to version 2.11.13 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5886](https://github.com/openlayers/ol3/pull/5886) - Remove unused functions ([@fredj](https://github.com/fredj))
 * [#5885](https://github.com/openlayers/ol3/pull/5885) - Remove unused pruneTileRange function ([@bartvde](https://github.com/bartvde))
 * [#5853](https://github.com/openlayers/ol3/pull/5853) - Allow more than one digit range in ol.TileUrlFunction.expandUrl ([@fredj](https://github.com/fredj))
 * [#5445](https://github.com/openlayers/ol3/pull/5445) - Select interaction default styling function can now handle geometry less features ([@fblackburn](https://github.com/fblackburn))
 * [#5884](https://github.com/openlayers/ol3/pull/5884) - Fix jsdoc tag indentation ([@fredj](https://github.com/fredj))
 * [#5863](https://github.com/openlayers/ol3/pull/5863) - Allow CanvasPattern or CanvasGradient as stroke style ([@fredj](https://github.com/fredj))
 * [#5838](https://github.com/openlayers/ol3/pull/5838) - Require ol where ol.DEBUG is being used ([@marcjansen](https://github.com/marcjansen))
 * [#5878](https://github.com/openlayers/ol3/pull/5878) - Smarter handling of closed rings and closePath() instructions ([@ahocevar](https://github.com/ahocevar))
 * [#5880](https://github.com/openlayers/ol3/pull/5880) - More work towards one provide per file ([@marcjansen](https://github.com/marcjansen))
 * [#5857](https://github.com/openlayers/ol3/pull/5857) - Fixed issue with multi option of ol.interaction.Select ([@KlausBenndorf](https://github.com/KlausBenndorf))
 * [#5876](https://github.com/openlayers/ol3/pull/5876) - Use clone method in kml format ([@KlausBenndorf](https://github.com/KlausBenndorf))
 * [#5832](https://github.com/openlayers/ol3/pull/5832) - Add clone methods to styles ([@KlausBenndorf](https://github.com/KlausBenndorf))
 * [#5869](https://github.com/openlayers/ol3/pull/5869) - Update jsdoc to version 3.4.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5872](https://github.com/openlayers/ol3/pull/5872) - Keep ol.Color as Array<number> ([@tschaub](https://github.com/tschaub))
 * [#5870](https://github.com/openlayers/ol3/pull/5870) - Update eslint to version 3.5.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5867](https://github.com/openlayers/ol3/pull/5867) - Add dedicated example using CanvasPattern and CanvasGradient for styling vectors ([@marcjansen](https://github.com/marcjansen))
 * [#5864](https://github.com/openlayers/ol3/pull/5864) - More renaming ([@fredj](https://github.com/fredj))
 * [#5861](https://github.com/openlayers/ol3/pull/5861) - More renaming to have one provide per file ([@fredj](https://github.com/fredj))
 * [#5860](https://github.com/openlayers/ol3/pull/5860) - Rename ol.MapProperty and ol.interaction.DragAndDropEvent* ([@fredj](https://github.com/fredj))
 * [#5855](https://github.com/openlayers/ol3/pull/5855) - Rename ol.DragBoxEvent* to ol.interaction.DragBox.Event* ([@fredj](https://github.com/fredj))
 * [#5859](https://github.com/openlayers/ol3/pull/5859) - Rename ol.RendererType to ol.renderer.Type ([@fredj](https://github.com/fredj))
 * [#5846](https://github.com/openlayers/ol3/pull/5846) - Remove unused goog.require('ol') ([@probins](https://github.com/probins))
 * [#5854](https://github.com/openlayers/ol3/pull/5854) - Use a canvas pattern in the vector-layer example ([@fredj](https://github.com/fredj))
 * [#5852](https://github.com/openlayers/ol3/pull/5852) - ol.interaction.extent cleanup ([@fredj](https://github.com/fredj))
 * [#5851](https://github.com/openlayers/ol3/pull/5851) - Remove unused imageByContext_ in ol.ImageTile ([@fredj](https://github.com/fredj))
 * [#5849](https://github.com/openlayers/ol3/pull/5849) - Remove 'global' from externs/closure-compiler.js ([@fredj](https://github.com/fredj))
 * [#5837](https://github.com/openlayers/ol3/pull/5837) - Remove ol.global ([@tschaub](https://github.com/tschaub))
 * [#5842](https://github.com/openlayers/ol3/pull/5842) - Remove extra provide causing a circular dependency ([@ahocevar](https://github.com/ahocevar))
 * [#5795](https://github.com/openlayers/ol3/pull/5795) - Render older loaded tiles while waiting for new tiles ([@thomasmoelhave](https://github.com/thomasmoelhave))
 * [#5840](https://github.com/openlayers/ol3/pull/5840) - Rename source.wms.ServerType ➛ source.WMSServerType ([@marcjansen](https://github.com/marcjansen))
 * [#5839](https://github.com/openlayers/ol3/pull/5839) - Rename source.VectorEvent(*) to source.Vector.Event(*) ([@marcjansen](https://github.com/marcjansen))
 * [#5835](https://github.com/openlayers/ol3/pull/5835) - document and test ol.getUid sequence behavior ([@thomasmoelhave](https://github.com/thomasmoelhave))
 * [#5834](https://github.com/openlayers/ol3/pull/5834) - Rename goog.DEBUG to ol.DEBUG ([@thomasmoelhave](https://github.com/thomasmoelhave))
 * [#5815](https://github.com/openlayers/ol3/pull/5815) - Remove the DOM renderer ([@tschaub](https://github.com/tschaub))
 * [#5828](https://github.com/openlayers/ol3/pull/5828) - Always close polygon rings ([@ahocevar](https://github.com/ahocevar))
 * [#5794](https://github.com/openlayers/ol3/pull/5794) - Fix more missing requires ([@openlayers](https://github.com/openlayers))
 * [#5820](https://github.com/openlayers/ol3/pull/5820) - Change ol.format.Format to ol.format.Feature in format/readme.md ([@fredj](https://github.com/fredj))
 * [#5819](https://github.com/openlayers/ol3/pull/5819) - Add ArrayBuffer.isView method in externs/closure-compiler.js ([@fredj](https://github.com/fredj))
 * [#5793](https://github.com/openlayers/ol3/pull/5793) - Closure bye bye ([@ahocevar](https://github.com/ahocevar))
 * [#5809](https://github.com/openlayers/ol3/pull/5809) - Reuse ol.LayerState object ([@fredj](https://github.com/fredj))
 * [#5811](https://github.com/openlayers/ol3/pull/5811) - Use ol.global.getComputedStyle instead of window.getComputedStyle ([@fredj](https://github.com/fredj))
 * [#5810](https://github.com/openlayers/ol3/pull/5810) - ESLint rule typo ([@gberaudo](https://github.com/gberaudo))
 * [#5807](https://github.com/openlayers/ol3/pull/5807) - Update pbf to version 3.0.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5806](https://github.com/openlayers/ol3/pull/5806) - Fix olx.style.TextOptions.rotateWithView option in externs ([@fredj](https://github.com/fredj))
 * [#5770](https://github.com/openlayers/ol3/pull/5770) - Update ol.source.Vector comments ([@fredj](https://github.com/fredj))
 * [#5803](https://github.com/openlayers/ol3/pull/5803) - V3.18.1 ([@openlayers](https://github.com/openlayers))
 * [#5801](https://github.com/openlayers/ol3/pull/5801) - Remove ol.style.ImageState and use ol.ImageState instead ([@fredj](https://github.com/fredj))
 * [#5790](https://github.com/openlayers/ol3/pull/5790) - Fix vector tile rotation on HiDPI devices ([@ahocevar](https://github.com/ahocevar))
 * [#5798](https://github.com/openlayers/ol3/pull/5798) - Move to 90° along the circle, not 0° ([@ahocevar](https://github.com/ahocevar))
 * [#5800](https://github.com/openlayers/ol3/pull/5800) - Wrap values in <Literal> for InBetween filter ([@tsauerwein](https://github.com/tsauerwein))
 * [#5769](https://github.com/openlayers/ol3/pull/5769) - Only call addToDrawing if sketchFeature ([@bartvde](https://github.com/bartvde))
 * [#5745](https://github.com/openlayers/ol3/pull/5745) - removed dependencies on goog.object.clone and fixed placemark rendering ([@tamarmot](https://github.com/tamarmot))
 * [#5290](https://github.com/openlayers/ol3/pull/5290) - Add extent interaction ([@tbarsballe](https://github.com/tbarsballe))
 * [#5786](https://github.com/openlayers/ol3/pull/5786) - Update eslint to version 3.4.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5785](https://github.com/openlayers/ol3/pull/5785) - Release v3.18.0 ([@openlayers](https://github.com/openlayers))
