# v3.5.0

## Summary

The 3.5.0 release includes features and fixes from a whopping 129 pull requests since 3.4.0.  This release removes a number of "experimental" features from the API, so take a close look at the notes below when upgrading.

## Upgrade notes

### `ol.Object` and `bindTo`

* The following experimental methods have been removed from `ol.Object`: `bindTo`, `unbind`, and `unbindAll`.  If you want to get notification about `ol.Object` property changes, you can listen for the `'propertychange'` event (e.g. `object.on('propertychange', listener)`).  Two-way binding can be set up at the application level using property change listeners.  See [#3472](https://github.com/openlayers/ol3/pull/3472) for details on the change.

* The experimental `ol.dom.Input` component has been removed.  If you need to synchronize the state of a dom Input element with an `ol.Object`, this can be accomplished using listeners for change events.  For example, you might bind the state of a checkbox type input with a layer's visibility like this:

  ```js
  var layer = new ol.layer.Tile();
  var checkbox = document.querySelector('#checkbox');

  checkbox.addEventListener('change', function() {
    var checked = this.checked;
    if (checked !== layer.getVisible()) {
      layer.setVisible(checked);
    }
  });

  layer.on('change:visible', function() {
    var visible = this.getVisible();
    if (visible !== checkbox.checked) {
      checkbox.checked = visible;
    }
  });
  ```

### New Vector API

* The following experimental vector classes have been removed: `ol.source.GeoJSON`, `ol.source.GML`, `ol.source.GPX`, `ol.source.IGC`, `ol.source.KML`, `ol.source.OSMXML`, and `ol.source.TopoJSON`. You now will use `ol.source.Vector` instead.

  For example, if you used `ol.source.GeoJSON` as follows:

  ```js
  var source = new ol.source.GeoJSON({
    url: 'features.json',
    projection: 'EPSG:3857'
  });
  ```

  you will need to change your code to:

  ```js
  var source = new ol.source.Vector({
    url: 'features.json',
    format: new ol.format.GeoJSON()
  });
  ```

  See https://openlayers.org/en/master/examples/vector-layer.html for a real example.

  Note that you no longer need to set a `projection` on the source!

  Previously the vector data was loaded at source construction time, and, if the data projection and the source projection were not the same, the vector data was transformed to the source projection before being inserted (as features) into the source.

  The vector data is now loaded at render time, when the view projection is known. And the vector data is transformed to the view projection if the data projection and the source projection are not the same.

  If you still want to "eagerly" load the source you will use something like this:

  ```js
  var source = new ol.source.Vector();
  $.ajax('features.json').then(function(response) {
    var geojsonFormat = new ol.format.GeoJSON();
    var features = geojsonFormat.readFeatures(response,
        {featureProjection: 'EPSG:3857'});
    source.addFeatures(features);
  });
  ```

  The above code uses jQuery to send an Ajax request, but you can obviously use any Ajax library.

  See https://openlayers.org/en/master/examples/igc.html for a real example.

* Note about KML

  If you used `ol.source.KML`'s `extractStyles` or `defaultStyle` options, you will now have to set these options on `ol.format.KML` instead. For example, if you used:

  ```js
  var source = new ol.source.KML({
    url: 'features.kml',
    extractStyles: false,
    projection: 'EPSG:3857'
  });
  ```

  you will now use:

  ```js
  var source = new ol.source.Vector({
    url: 'features.kml',
    format: new ol.format.KML({
      extractStyles: false
    })
  });
  ```

* The `ol.source.ServerVector` class has been removed. If you used it, for example as follows:

  ```js
  var source = new ol.source.ServerVector({
    format: new ol.format.GeoJSON(),
    loader: function(extent, resolution, projection) {
      var url = …;
      $.ajax(url).then(function(response) {
        source.addFeatures(source.readFeatures(response));
      });
    },
    strategy: ol.loadingstrategy.bbox,
    projection: 'EPSG:3857'
  });
  ```

  you will need to change your code to:

  ```js
  var source = new ol.source.Vector({
    loader: function(extent, resolution, projection) {
      var url = …;
      $.ajax(url).then(function(response) {
        var format = new ol.format.GeoJSON();
        var features = format.readFeatures(response,
            {featureProjection: projection});
        source.addFeatures(features);
      });
    },
    strategy: ol.loadingstrategy.bbox
  });
  ```

  See https://openlayers.org/en/master/examples/vector-osm.html for a real example.

* The experimental `ol.loadingstrategy.createTile` function has been renamed to `ol.loadingstrategy.tile`. The signature of the function hasn't changed. See https://openlayers.org/en/master/examples/vector-osm.html for an example.

### Change to `ol.style.Icon`

* When manually loading an image for `ol.style.Icon`, the image size should now be set
with the `imgSize` option and not with `size`. `size` is supposed to be used for the
size of a sub-rectangle in an image sprite.

### Support for non-square tiles

The return value of `ol.tilegrid.TileGrid#getTileSize()` will now be an `ol.Size` array instead of a number if non-square tiles (i.e. an `ol.Size` array instead of a number as `tilsSize`) are used. To always get an `ol.Size`, the new `ol.size.toSize()` was added.

### Change to `ol.interaction.Draw`

When finishing a draw, the `drawend` event is now dispatched before the feature is inserted to either the source or the collection. This change allows application code to finish setting up the feature.

### Misc.

If you compile your application together with the library and use the `ol.feature.FeatureStyleFunction` type annotation (this should be extremely rare), the type is now named `ol.FeatureStyleFunction`.

## New features and fixes

 * [#3646](https://github.com/openlayers/ol3/pull/3646) - Use graceful-fs in place of fs ([@elemoine](https://github.com/elemoine))
 * [#3645](https://github.com/openlayers/ol3/pull/3645) - Fix test-coverage.js script ([@elemoine](https://github.com/elemoine))
 * [#3640](https://github.com/openlayers/ol3/pull/3640) - Make make fail on requires and whitespace errors ([@elemoine](https://github.com/elemoine))
 * [#3644](https://github.com/openlayers/ol3/pull/3644) - added altclick select to selectfeatures example ([@t27](https://github.com/t27))
 * [#3612](https://github.com/openlayers/ol3/pull/3612) - Add ol.source.WMTS#getUrls and getRequestEncoding ([@elemoine](https://github.com/elemoine))
 * [#3616](https://github.com/openlayers/ol3/pull/3616) - Add support for freehand drawing to the Draw interaction ([@ahocevar](https://github.com/ahocevar))
 * [#3634](https://github.com/openlayers/ol3/pull/3634) - Remove unused local variable ([@fredj](https://github.com/fredj))
 * [#3629](https://github.com/openlayers/ol3/pull/3629) - Problems with XYZ coordinates in snap interaction ([@tsauerwein](https://github.com/tsauerwein))
 * [#3633](https://github.com/openlayers/ol3/pull/3633) - Add a Makefile section to .editorconfig ([@elemoine](https://github.com/elemoine))
 * [#3632](https://github.com/openlayers/ol3/pull/3632) - Make host-examples target copy index.js ([@elemoine](https://github.com/elemoine))
 * [#3631](https://github.com/openlayers/ol3/pull/3631) - Restore Modify interaction constructor test ([@bjornharrtell](https://github.com/bjornharrtell))
 * [#3630](https://github.com/openlayers/ol3/pull/3630) - Initial tests for Modify interaction vertex creation ([@bjornharrtell](https://github.com/bjornharrtell))
 * [#3527](https://github.com/openlayers/ol3/pull/3527) - Replace pake with make? ([@elemoine](https://github.com/elemoine))
 * [#3624](https://github.com/openlayers/ol3/pull/3624) - Add a one sentence summary for several exportable symbols ([@marcjansen](https://github.com/marcjansen))
 * [#3623](https://github.com/openlayers/ol3/pull/3623) - ol3 overwrites WMS format_options instead of extending them. ([@bartvde](https://github.com/bartvde))
 * [#3621](https://github.com/openlayers/ol3/pull/3621) - Fix typo in documentation comment ([@openlayers](https://github.com/openlayers))
 * [#3614](https://github.com/openlayers/ol3/pull/3614) - GML2 parser does not parse all features ([@bartvde](https://github.com/bartvde))
 * [#3619](https://github.com/openlayers/ol3/pull/3619) - Add a one sentence summary for ol.geom.* exportable symbols ([@marcjansen](https://github.com/marcjansen))
 * [#3618](https://github.com/openlayers/ol3/pull/3618) - Replace non-breaking space (U+00A0) with regular space (U+0020). ([@tschaub](https://github.com/tschaub))
 * [#3617](https://github.com/openlayers/ol3/pull/3617) - Add ol.size.hasArea. ([@tschaub](https://github.com/tschaub))
 * [#3597](https://github.com/openlayers/ol3/pull/3597) - Remove dead link in api doc ([@fredj](https://github.com/fredj))
 * [#3613](https://github.com/openlayers/ol3/pull/3613) - Add a one sentence summary for ol.interaction* exportable symbols ([@marcjansen](https://github.com/marcjansen))
 * [#3611](https://github.com/openlayers/ol3/pull/3611) - Improve error handling in Esri JSON format ([@bartvde](https://github.com/bartvde))
 * [#3560](https://github.com/openlayers/ol3/pull/3560) - Add an example showing how to create a permalink ([@tsauerwein](https://github.com/tsauerwein))
 * [#3571](https://github.com/openlayers/ol3/pull/3571) - Add wrapX support for vector layers (canvas renderer only) ([@ahocevar](https://github.com/ahocevar))
 * [#3605](https://github.com/openlayers/ol3/pull/3605) - vector-esri-edit.html uses non api method ([@bartvde](https://github.com/bartvde))
 * [#3602](https://github.com/openlayers/ol3/pull/3602) - Rename ol.feature.FeatureStyleFunction to ol.FeatureStyleFunction. ([@tschaub](https://github.com/tschaub))
 * [#3604](https://github.com/openlayers/ol3/pull/3604) - Add charset so that zoom out button shows correctly ([@bartvde](https://github.com/bartvde))
 * [#3603](https://github.com/openlayers/ol3/pull/3603) - Reformat upgrade-notes.md ([@elemoine](https://github.com/elemoine))
 * [#3599](https://github.com/openlayers/ol3/pull/3599) - Improve docs for source.Vector options ([@probins](https://github.com/probins))
 * [#3598](https://github.com/openlayers/ol3/pull/3598) - Remove unnecessary entry in `.gitignore`. ([@tschaub](https://github.com/tschaub))
 * [#3595](https://github.com/openlayers/ol3/pull/3595) - Add featureloader.jsdoc ([@probins](https://github.com/probins))
 * [#3593](https://github.com/openlayers/ol3/pull/3593) - Add /examples/index.js to .gitignore ([@fredj](https://github.com/fredj))
 * [#3592](https://github.com/openlayers/ol3/pull/3592) - Remove reference to binding in Collection docs ([@probins](https://github.com/probins))
 * [#3591](https://github.com/openlayers/ol3/pull/3591) - Only draw the layer if visible and inside the resolution range ([@fredj](https://github.com/fredj))
 * [#3528](https://github.com/openlayers/ol3/pull/3528) - Fix memory leak when removing layers from ol.layer.Group ([@fredj](https://github.com/fredj))
 * [#3549](https://github.com/openlayers/ol3/pull/3549) - Move ol.*_DURATION const to a constructor option ([@fredj](https://github.com/fredj))
 * [#3587](https://github.com/openlayers/ol3/pull/3587) - Handle left/right segment intersections for top/bottom spans. ([@tschaub](https://github.com/tschaub))
 * [#3516](https://github.com/openlayers/ol3/pull/3516) - Remove ol.format.BinaryFeature. ([@tschaub](https://github.com/tschaub))
 * [#3586](https://github.com/openlayers/ol3/pull/3586) - Simplify dragAndDropInteraction in examples. ([@probins](https://github.com/probins))
 * [#3555](https://github.com/openlayers/ol3/pull/3555) - Esri JSON support ([@bartvde](https://github.com/bartvde))
 * [#3583](https://github.com/openlayers/ol3/pull/3583) - Add a one sentence summary for ol.proj.* and ol.layer.* exportable symbols ([@marcjansen](https://github.com/marcjansen))
 * [#3581](https://github.com/openlayers/ol3/pull/3581) - Always show links to related API documentation. ([@tschaub](https://github.com/tschaub))
 * [#3582](https://github.com/openlayers/ol3/pull/3582) - Index what the examples require. ([@tschaub](https://github.com/tschaub))
 * [#3580](https://github.com/openlayers/ol3/pull/3580) - Add a one sentence summary for ol.source.* exportable symbols ([@marcjansen](https://github.com/marcjansen))
 * [#3551](https://github.com/openlayers/ol3/pull/3551) - Automatically add links to API-docs in examples ([@marcjansen](https://github.com/marcjansen))
 * [#3575](https://github.com/openlayers/ol3/pull/3575) - Check proj equivalence by code. ([@nd0ut](https://github.com/nd0ut))
 * [#3579](https://github.com/openlayers/ol3/pull/3579) - Use HTTPS were available. ([@tschaub](https://github.com/tschaub))
 * [#3558](https://github.com/openlayers/ol3/pull/3558) - Example sources in examples dir and built examples in build/examples. ([@tschaub](https://github.com/tschaub))
 * [#3550](https://github.com/openlayers/ol3/pull/3550) - Reduce differences between the rendering test runner and the standard test runner. ([@tschaub](https://github.com/tschaub))
 * [#3576](https://github.com/openlayers/ol3/pull/3576) - Add KML options related note the upgrade notes ([@elemoine](https://github.com/elemoine))
 * [#3573](https://github.com/openlayers/ol3/pull/3573) - Modify draw interaction dispatch order ([@gberaudo](https://github.com/gberaudo))
 * [#3572](https://github.com/openlayers/ol3/pull/3572) - Do not return a null tileSize ([@ahocevar](https://github.com/ahocevar))
 * [#3570](https://github.com/openlayers/ol3/pull/3570) - Add missing @api ([@gberaudo](https://github.com/gberaudo))
 * [#3569](https://github.com/openlayers/ol3/pull/3569) - Fix link to Bootstrap documentation ([@fredj](https://github.com/fredj))
 * [#3559](https://github.com/openlayers/ol3/pull/3559) - Add support for non-square tiles ([@ahocevar](https://github.com/ahocevar))
 * [#3568](https://github.com/openlayers/ol3/pull/3568) - Move extractStyles option to ol.format.KML ([@fredj](https://github.com/fredj))
 * [#3562](https://github.com/openlayers/ol3/pull/3562) - Simplify .ol-zoomslider and .ol-overviewmap CSS ([@fredj](https://github.com/fredj))
 * [#3565](https://github.com/openlayers/ol3/pull/3565) - Move extractStyles option to ol.format.KML ([@fredj](https://github.com/fredj))
 * [#3523](https://github.com/openlayers/ol3/pull/3523) - Update proj4 version to 2.3.6 ([@fredj](https://github.com/fredj))
 * [#3556](https://github.com/openlayers/ol3/pull/3556) - Minor TileUTFGrid error fix ([@klokantech](https://github.com/klokantech))
 * [#3557](https://github.com/openlayers/ol3/pull/3557) - Update FastClick externs to version 1.0.6 ([@fredj](https://github.com/fredj))
 * [#3517](https://github.com/openlayers/ol3/pull/3517) - Add tests for previously untested classes ([@marcjansen](https://github.com/marcjansen))
 * [#3548](https://github.com/openlayers/ol3/pull/3548) - Write the error stack instead of the error itself. ([@tschaub](https://github.com/tschaub))
 * [#3542](https://github.com/openlayers/ol3/pull/3542) - Generate example index and rebuild examples on source changes. ([@tschaub](https://github.com/tschaub))
 * [#3530](https://github.com/openlayers/ol3/pull/3530) - external resources not correctly in inline source of example ([@bartvde](https://github.com/bartvde))
 * [#3448](https://github.com/openlayers/ol3/pull/3448) - Fix WebGL image layer rendering on retina displays ([@elemoine](https://github.com/elemoine))
 * [#3544](https://github.com/openlayers/ol3/pull/3544) - Update comments about remaining GeoJSON work. ([@tschaub](https://github.com/tschaub))
 * [#3531](https://github.com/openlayers/ol3/pull/3531) - Fix PointerEventHandler exception with Overlay containing SVG and IE9 ([@mantonovic](https://github.com/mantonovic))
 * [#3521](https://github.com/openlayers/ol3/pull/3521) - Remove goog.isDefAndNotNull test on ol.layer.Group#getLayers result ([@fredj](https://github.com/fredj))
 * [#3481](https://github.com/openlayers/ol3/pull/3481) - Proposal for a simpler vector API ([@elemoine](https://github.com/elemoine))
 * [#3472](https://github.com/openlayers/ol3/pull/3472) - Remove the experimental bindTo method from ol.Object. ([@tschaub](https://github.com/tschaub))
 * [#3505](https://github.com/openlayers/ol3/pull/3505) - Add a Create Custom Builds tutorial ([@elemoine](https://github.com/elemoine))
 * [#3513](https://github.com/openlayers/ol3/pull/3513) - Remove layerGroup.setLayers(null) test ([@fredj](https://github.com/fredj))
 * [#3511](https://github.com/openlayers/ol3/pull/3511) - Add goog.provide's ([@elemoine](https://github.com/elemoine))
 * [#3509](https://github.com/openlayers/ol3/pull/3509) - Dispatch change event even when geometry is set to null ([@pgiraud](https://github.com/pgiraud))
 * [#3510](https://github.com/openlayers/ol3/pull/3510) - Use sinon.spy to ensure change event is dispatched ([@pgiraud](https://github.com/pgiraud))
 * [#3504](https://github.com/openlayers/ol3/pull/3504) - Rework build-examples.js task. ([@tschaub](https://github.com/tschaub))
 * [#3470](https://github.com/openlayers/ol3/pull/3470) - Add rendering tests ([@tsauerwein](https://github.com/tsauerwein))
 * [#3413](https://github.com/openlayers/ol3/pull/3413) - Add support for generic external modules with Browserify ([@tsauerwein](https://github.com/tsauerwein))
 * [#3503](https://github.com/openlayers/ol3/pull/3503) - Use vector source instead of feature overlay in snap example. ([@tschaub](https://github.com/tschaub))
 * [#3495](https://github.com/openlayers/ol3/pull/3495) - Initial basic project setup tutorial ([@bjornharrtell](https://github.com/bjornharrtell))
 * [#3488](https://github.com/openlayers/ol3/pull/3488) - Add docs for exportable symbols. ([@tschaub](https://github.com/tschaub))
 * [#3441](https://github.com/openlayers/ol3/pull/3441) - Add a "Compile Application and OpenLayers 3 Together" tutorial ([@elemoine](https://github.com/elemoine))
 * [#3499](https://github.com/openlayers/ol3/pull/3499) - Update to closure-util 1.4.0 ([@elemoine](https://github.com/elemoine))
 * [#3494](https://github.com/openlayers/ol3/pull/3494) - Mark VectorContext @api ([@gberaudo](https://github.com/gberaudo))
 * [#3409](https://github.com/openlayers/ol3/pull/3409) - AssertionError in WMTS.optionsFromCapabilities. ([@bartvde](https://github.com/bartvde))
 * [#3493](https://github.com/openlayers/ol3/pull/3493) - Add image loading events to ol.source.ImageStatic ([@tsauerwein](https://github.com/tsauerwein))
 * [#3490](https://github.com/openlayers/ol3/pull/3490) - Add .editorconfig and instructions on its use. ([@tschaub](https://github.com/tschaub))
 * [#3489](https://github.com/openlayers/ol3/pull/3489) - Use an abstract base class instead of IVectorContext. ([@gberaudo](https://github.com/gberaudo))
 * [#3483](https://github.com/openlayers/ol3/pull/3483) - Clarify view.setRotation docs ([@tsauerwein](https://github.com/tsauerwein))
 * [#3485](https://github.com/openlayers/ol3/pull/3485) - build.py graceful interrupt ([@malaretv](https://github.com/malaretv))
 * [#3484](https://github.com/openlayers/ol3/pull/3484) - Make sure we copy the example css if it exists ([@bartvde](https://github.com/bartvde))
 * [#3462](https://github.com/openlayers/ol3/pull/3462) - Remove ol.format.GMLBase from the API ([@ahocevar](https://github.com/ahocevar))
 * [#3445](https://github.com/openlayers/ol3/pull/3445) - Start a FAQ document. ([@marcjansen](https://github.com/marcjansen))
 * [#3468](https://github.com/openlayers/ol3/pull/3468) - Use the coveralls executable. ([@marcjansen](https://github.com/marcjansen))
 * [#3415](https://github.com/openlayers/ol3/pull/3415) - Stable Only unchecked by default. ([@malaretv](https://github.com/malaretv))
 * [#3420](https://github.com/openlayers/ol3/pull/3420) - Unregister viewport size listener on setTarget(null) ([@elemoine](https://github.com/elemoine))
 * [#3456](https://github.com/openlayers/ol3/pull/3456) - Updated menu on the JSDOC template (non-responsive) ([@klokan](https://github.com/klokan))
 * [#3475](https://github.com/openlayers/ol3/pull/3475) - Template examples ([@openlayers](https://github.com/openlayers))
 * [#3455](https://github.com/openlayers/ol3/pull/3455) - Fix pre-loaded icons images for WebGL ([@tsauerwein](https://github.com/tsauerwein))
 * [#3473](https://github.com/openlayers/ol3/pull/3473) - Add more tests for ol.coordinate. ([@marcjansen](https://github.com/marcjansen))
 * [#3464](https://github.com/openlayers/ol3/pull/3464) - Mark more of the API stable. ([@tschaub](https://github.com/tschaub))
 * [#3469](https://github.com/openlayers/ol3/pull/3469) - Update README. ([@malaretv](https://github.com/malaretv))
 * [#3467](https://github.com/openlayers/ol3/pull/3467) - Update the coveralls badge. ([@openlayers](https://github.com/openlayers))
 * [#3466](https://github.com/openlayers/ol3/pull/3466) - Include coveralls code-coverage badge in README. ([@marcjansen](https://github.com/marcjansen))
 * [#3457](https://github.com/openlayers/ol3/pull/3457) - Integrate istanbul for test coverage ([@marcjansen](https://github.com/marcjansen))
 * [#3446](https://github.com/openlayers/ol3/pull/3446) - Add updateWhileInteracting to olx.layer.VectorOptions ([@elemoine](https://github.com/elemoine))
 * [#3438](https://github.com/openlayers/ol3/pull/3438) - Parser documentation and XML readme ([@gberaudo](https://github.com/gberaudo))
 * [#3449](https://github.com/openlayers/ol3/pull/3449) - Fix assertion message ([@gberaudo](https://github.com/gberaudo))
 * [#3440](https://github.com/openlayers/ol3/pull/3440) - Add fromLonLat and toLonLat convenience functions ([@ahocevar](https://github.com/ahocevar))
 * [#3423](https://github.com/openlayers/ol3/pull/3423) - Parse extrude and altitude mode ([@gberaudo](https://github.com/gberaudo))
 * [#3431](https://github.com/openlayers/ol3/pull/3431) - Better typing ([@fredj](https://github.com/fredj))
 * [#3436](https://github.com/openlayers/ol3/pull/3436) - Mention readme.md files as help for contributors ([@ahocevar](https://github.com/ahocevar))
 * [#3433](https://github.com/openlayers/ol3/pull/3433) - Add missing goog.provide/goog.require ol.source.TileEvent ([@fredj](https://github.com/fredj))
 * [#3422](https://github.com/openlayers/ol3/pull/3422) - Fix Select behavior when multi is false ([@elemoine](https://github.com/elemoine))
 * [#3428](https://github.com/openlayers/ol3/pull/3428) - Reorder assertions and variable declarations. ([@marcjansen](https://github.com/marcjansen))
 * [#3414](https://github.com/openlayers/ol3/pull/3414) - Add missing ol.style.AtlasManager goog.require ([@fredj](https://github.com/fredj))
 * [#3429](https://github.com/openlayers/ol3/pull/3429) - Adding missing provide for SelectFilterFunction ([@pgiraud](https://github.com/pgiraud))
 * [#3426](https://github.com/openlayers/ol3/pull/3426) - Add assertion messages for all assertion statements ([@bartvde](https://github.com/bartvde))
 * [#3425](https://github.com/openlayers/ol3/pull/3425) - Fix typo in ol.js ([@elemoine](https://github.com/elemoine))
 * [#3424](https://github.com/openlayers/ol3/pull/3424) - Remove `@api` annotation from `ol.WEBGL_MAX_TEXTURE_SIZE`. ([@tschaub](https://github.com/tschaub))
 * [#3419](https://github.com/openlayers/ol3/pull/3419) - Remove describe.only ([@elemoine](https://github.com/elemoine))
 * [#3417](https://github.com/openlayers/ol3/pull/3417) - ol.interaction.Snap extent fix ([@fperucic](https://github.com/fperucic))
 * [#3410](https://github.com/openlayers/ol3/pull/3410) - Add ol.Object.unset() method ([@gberaudo](https://github.com/gberaudo))
 * [#3402](https://github.com/openlayers/ol3/pull/3402) - Add "filter" option to Select interaction ([@elemoine](https://github.com/elemoine))
 * [#3416](https://github.com/openlayers/ol3/pull/3416) - Remove unnecessary typecasts in examples ([@fredj](https://github.com/fredj))
 * [#3411](https://github.com/openlayers/ol3/pull/3411) - Listen for a 'change:geometry' event ([@fperucic](https://github.com/fperucic))
 * [#3109](https://github.com/openlayers/ol3/pull/3109) - Snap feature ([@fperucic](https://github.com/fperucic))
 * [#3407](https://github.com/openlayers/ol3/pull/3407) - Add v3.4.0 empty section to upgrade notes ([@bartvde](https://github.com/bartvde))
