# v3.9.0

## Summary

The v3.9.0 release includes features and fixes from 62 pull requests since the v3.8.2 release. New features include:

* [#3986](https://github.com/openlayers/ol3/pull/3986) - Modify 'url' option of ol.source.Vector to accept a function ([@alvinlindstam](https://github.com/alvinlindstam))
* [#4069](https://github.com/openlayers/ol3/pull/4069) - Add Z-index to layers ([@gberaudo](https://github.com/gberaudo))
* [#4044](https://github.com/openlayers/ol3/pull/4044) - Add ol.interaction.Draw#continueDrawing ([@elemoine](https://github.com/elemoine))
* [#4008](https://github.com/openlayers/ol3/pull/4008) - Add a Translate interaction ([@elemoine](https://github.com/elemoine))

See the complete list below for details. And see the following notes to know how to upgrade from v3.8.x to v3.9.0.

## Upgrade notes

#### `ol.style.Circle` changes

The experimental `getAnchor`, `getOrigin`, and `getSize` methods have been removed.  The anchor and origin of a circle symbolizer are not modifiable, so these properties should not need to be accessed.  The radius and stroke width can be used to calculate the rendered size of a circle symbolizer if needed:

```js
// calculate rendered size of a circle symbolizer
var width = 2 * circle.getRadius();
if (circle.getStroke()) {
  width += circle.getStroke().getWidth() + 1;
}
```

## New features and fixes

 * [#4055](https://github.com/openlayers/ol3/pull/4055) - Improve graticule perf ([@fgravin](https://github.com/fgravin))
 * [#4088](https://github.com/openlayers/ol3/pull/4088) - Update jshint to v2.8.0 ([@fredj](https://github.com/fredj))
 * [#4089](https://github.com/openlayers/ol3/pull/4089) - SelectEventType in ol.interaction namespace ([@pgiraud](https://github.com/pgiraud))
 * [#4095](https://github.com/openlayers/ol3/pull/4095) - Zoom to the extent of the drag box. ([@tschaub](https://github.com/tschaub))
 * [#4084](https://github.com/openlayers/ol3/pull/4084) - Fewer circle exports. ([@tschaub](https://github.com/tschaub))
 * [#4094](https://github.com/openlayers/ol3/pull/4094) - Allow source.setAttributions() to be exported. ([@tschaub](https://github.com/tschaub))
 * [#4096](https://github.com/openlayers/ol3/pull/4096) - Reinstate inheritdoc to fix #4082 ([@bjornharrtell](https://github.com/bjornharrtell))
 * [#4091](https://github.com/openlayers/ol3/pull/4091) - Remove unused ol.renderer.webgl.Map.DEFAULT_COLOR_VALUES_ ([@fredj](https://github.com/fredj))
 * [#4092](https://github.com/openlayers/ol3/pull/4092) - Minor coding style fixes ([@fredj](https://github.com/fredj))
 * [#4083](https://github.com/openlayers/ol3/pull/4083) - Add API descriptions. ([@tschaub](https://github.com/tschaub))
 * [#4078](https://github.com/openlayers/ol3/pull/4078) - Enable all the compiler checks ([@fredj](https://github.com/fredj))
 * [#4085](https://github.com/openlayers/ol3/pull/4085) - Parse nested document tag ([@oterral](https://github.com/oterral))
 * [#4060](https://github.com/openlayers/ol3/pull/4060) - Remove unnecessary cast ([@fredj](https://github.com/fredj))
 * [#4064](https://github.com/openlayers/ol3/pull/4064) - Use a private variable to cache the default style array ([@fredj](https://github.com/fredj))
 * [#4081](https://github.com/openlayers/ol3/pull/4081) - Update link to workshop. ([@tschaub](https://github.com/tschaub))
 * [#4062](https://github.com/openlayers/ol3/pull/4062) - Remove ol.xml.makeParsersNS and use ol.xml.makeStructureNS instead ([@fredj](https://github.com/fredj))
 * [#3986](https://github.com/openlayers/ol3/pull/3986) - Modify 'url' option of ol.source.Vector to accept a function ([@alvinlindstam](https://github.com/alvinlindstam))
 * [#4077](https://github.com/openlayers/ol3/pull/4077) - Add missing const jsdoc annotation ([@fredj](https://github.com/fredj))
 * [#4080](https://github.com/openlayers/ol3/pull/4080) - Remove unused goog.require in examples ([@fredj](https://github.com/fredj))
 * [#4041](https://github.com/openlayers/ol3/pull/4041) - Fix custom build issue ([@elemoine](https://github.com/elemoine))
 * [#4059](https://github.com/openlayers/ol3/pull/4059) - Clarify drag interaction example to inform about ol.interaction.Translate ([@alvinlindstam](https://github.com/alvinlindstam))
 * [#4069](https://github.com/openlayers/ol3/pull/4069) - Add Z-index to layers ([@gberaudo](https://github.com/gberaudo))
 * [#4076](https://github.com/openlayers/ol3/pull/4076) - Add assertion for required option 'code' on ol.proj.Projection ([@weskamm](https://github.com/weskamm))
 * [#4075](https://github.com/openlayers/ol3/pull/4075) - setOpacity of Image undefined ([@bartvde](https://github.com/bartvde))
 * [#4044](https://github.com/openlayers/ol3/pull/4044) - Add ol.interaction.Draw#continueDrawing ([@elemoine](https://github.com/elemoine))
 * [#4073](https://github.com/openlayers/ol3/pull/4073) - Better type definition ([@fredj](https://github.com/fredj))
 * [#4072](https://github.com/openlayers/ol3/pull/4072) - Update to closure-util 1.7.0 ([@elemoine](https://github.com/elemoine))
 * [#4070](https://github.com/openlayers/ol3/pull/4070) - Make the debug server work regardless of the current working directory. ([@tschaub](https://github.com/tschaub))
 * [#4067](https://github.com/openlayers/ol3/pull/4067) - Fix bootstrap class name in examples ([@fredj](https://github.com/fredj))
 * [#4050](https://github.com/openlayers/ol3/pull/4050) - Use view.getRotation and view.getResolution instead of view.getState ([@fredj](https://github.com/fredj))
 * [#4051](https://github.com/openlayers/ol3/pull/4051) - Move wrench node package to devDependencies ([@fredj](https://github.com/fredj))
 * [#4047](https://github.com/openlayers/ol3/pull/4047) - Remove pystache dependency ([@fredj](https://github.com/fredj))
 * [#4027](https://github.com/openlayers/ol3/pull/4027) - closure-compiler v20150729 compatibility ([@fredj](https://github.com/fredj))
 * [#4040](https://github.com/openlayers/ol3/pull/4040) - Better docs for ol.ENABLE_[WEBGL|CANVAS|DOM] ([@elemoine](https://github.com/elemoine))
 * [#4032](https://github.com/openlayers/ol3/pull/4032) - Improve ol.Overlay extensibility ([@gberaudo](https://github.com/gberaudo))
 * [#4037](https://github.com/openlayers/ol3/pull/4037) - Don't install python packages in before_install ([@fredj](https://github.com/fredj))
 * [#4028](https://github.com/openlayers/ol3/pull/4028) - Update to closure-util 1.6 ([@elemoine](https://github.com/elemoine))
 * [#4014](https://github.com/openlayers/ol3/pull/4014) - Remove deprecated checkStructDictInheritance ([@fredj](https://github.com/fredj))
 * [#3987](https://github.com/openlayers/ol3/pull/3987) - Remove unnecessary cast ([@fredj](https://github.com/fredj))
 * [#4035](https://github.com/openlayers/ol3/pull/4035) - Remove unused sphere and ellipsoid methods. ([@tschaub](https://github.com/tschaub))
 * [#4031](https://github.com/openlayers/ol3/pull/4031) - Fixing size of popup ([@pgiraud](https://github.com/pgiraud))
 * [#4023](https://github.com/openlayers/ol3/pull/4023) - Render map when layer.setMap(map) called ([@elemoine](https://github.com/elemoine))
 * [#4026](https://github.com/openlayers/ol3/pull/4026) - Fix Font Awesome CSS class in examples ([@fredj](https://github.com/fredj))
 * [#4024](https://github.com/openlayers/ol3/pull/4024) - Correct documentation for ol.FeatureStyleFunction ([@marcjansen](https://github.com/marcjansen))
 * [#4011](https://github.com/openlayers/ol3/pull/4011) - Make Modify interaction listen to feature changes ([@elemoine](https://github.com/elemoine))
 * [#3917](https://github.com/openlayers/ol3/pull/3917) - Resolved issue with cluster source reloading ([@cmiles74](https://github.com/cmiles74))
 * [#4015](https://github.com/openlayers/ol3/pull/4015) - Add a getUrls Method to ol.source.XYZ ([@weskamm](https://github.com/weskamm))
 * [#4019](https://github.com/openlayers/ol3/pull/4019) - Simplify .editorconfig file ([@marcjansen](https://github.com/marcjansen))
 * [#4002](https://github.com/openlayers/ol3/pull/4002) - Update closure-library to latest commit ([@fredj](https://github.com/fredj))
 * [#4018](https://github.com/openlayers/ol3/pull/4018) - Fix rotate buttons in animation example ([@marcjansen](https://github.com/marcjansen))
 * [#4013](https://github.com/openlayers/ol3/pull/4013) - Use a more recent version of marked ([@marcjansen](https://github.com/marcjansen))
 * [#4017](https://github.com/openlayers/ol3/pull/4017) - Do not overwrite projections in the registry simply by using `new ol.proj.Projection()` ([@ahocevar](https://github.com/ahocevar))
 * [#4008](https://github.com/openlayers/ol3/pull/4008) - Add a Translate interaction ([@elemoine](https://github.com/elemoine))
 * [#3230](https://github.com/openlayers/ol3/pull/3230) - Add stroke to default editing style for geometry collections ([@pgiraud](https://github.com/pgiraud))
 * [#4007](https://github.com/openlayers/ol3/pull/4007) - Do not use Function.prototype.bind in examples ([@elemoine](https://github.com/elemoine))
 * [#4006](https://github.com/openlayers/ol3/pull/4006) - Fix typo (vegetaion -> vegetation) ([@elemoine](https://github.com/elemoine))
 * [#3993](https://github.com/openlayers/ol3/pull/3993) - Replace base symbols with overridden ones when generating info.json ([@ahocevar](https://github.com/ahocevar))
 * [#3992](https://github.com/openlayers/ol3/pull/3992) - Fix typo in Makefile ([@fredj](https://github.com/fredj))
 * [#3989](https://github.com/openlayers/ol3/pull/3989) - Handle JSONP errors in ol.source.TileJSON ([@fredj](https://github.com/fredj))
 * [#3983](https://github.com/openlayers/ol3/pull/3983) - Remove doc footer with timestamp. ([@tschaub](https://github.com/tschaub))
 * [#3984](https://github.com/openlayers/ol3/pull/3984) - Style source control links in examples. ([@tschaub](https://github.com/tschaub))
 * [#3982](https://github.com/openlayers/ol3/pull/3982) - Rebuild examples if package.json changes. ([@tschaub](https://github.com/tschaub))
