# v3.6.0

## Summary

The v3.6.0 release includes features and fixes from 40 pull requests since v3.5.0. To simplify the code base, there were some changes to "experimental" features. Please follow the upgrade notes to make your applications work with the latest release.

## Upgrade notes

### `ol.interaction.Draw` changes

* The `minPointsPerRing` config option has been renamed to `minPoints`. It is now also available for linestring drawing, not only for polygons.
* The `ol.DrawEvent` and `ol.DrawEventType` types were renamed to `ol.interaction.DrawEvent` and `ol.interaction.DrawEventType`. This has an impact on your code only if your code is compiled together with ol3.

### `ol.tilegrid` changes

* The `ol.tilegrid.XYZ` constructor has been replaced by a static `ol.tilegrid.createXYZ()` function. The `ol.tilegrid.createXYZ()` function takes the same arguments as the previous `ol.tilegrid.XYZ` constructor, but returns an `ol.tilegrid.TileGrid` instance.
* The internal tile coordinate scheme for XYZ sources has been changed. Previously, the `y` of tile coordinates was transformed to the coordinates used by sources by calculating `-y-1`. Now, it is transformed by calculating `height-y-1`, where height is the number of rows of the tile grid at the zoom level of the tile coordinate.
* The `widths` constructor option of `ol.tilegrid.TileGrid` and subclasses is no longer available, and it is no longer necessary to get proper wrapping at the 180° meridian. However, for `ol.tilegrid.WMTS`, there is a new option `sizes`, where each entry is an `ol.Size` with the `width` ('TileMatrixWidth' in WMTS capabilities) as first and the `height` ('TileMatrixHeight') as second entry of the array. For other tile grids, users can
now specify an `extent` instead of `widths`. These settings are used to restrict the range of tiles that sources will request.
* For `ol.source.TileWMS`, the default value of `warpX` used to be `undefined`, meaning that WMS requests with out-of-extent tile BBOXes would be sent. Now `wrapX` can only be `true` or `false`, and the new default is `true`. No application code changes should be required, but the resulting WMS requests for out-of-extent tiles will no longer use out-of-extent BBOXes, but ones that are shifted to real-world coordinates.

## New features and fixes

 * [#3764](https://github.com/openlayers/ol3/pull/3764) - Add tests and implementation for intersectsExtent (ol.geom.Geometry) ([@alvinlindstam](https://github.com/alvinlindstam))
 * [#3757](https://github.com/openlayers/ol3/pull/3757) - Add mapBrowserEvent as a member of ol.SelectEvent ([@bjornharrtell](https://github.com/bjornharrtell))
 * [#3759](https://github.com/openlayers/ol3/pull/3759) - Mark tilegrid.createTileCoordTransform() @api ([@gberaudo](https://github.com/gberaudo))
 * [#3747](https://github.com/openlayers/ol3/pull/3747) - Make tileCoordTransform a member again ([@ahocevar](https://github.com/ahocevar))
 * [#3751](https://github.com/openlayers/ol3/pull/3751) - Do not rely on remote services for tests ([@ahocevar](https://github.com/ahocevar))
 * [#3749](https://github.com/openlayers/ol3/pull/3749) - Fix typo in API docs ([@marcjansen](https://github.com/marcjansen))
 * [#3739](https://github.com/openlayers/ol3/pull/3739) - Simplify detection of scientific notation in WKT format ([@marcjansen](https://github.com/marcjansen))
 * [#3741](https://github.com/openlayers/ol3/pull/3741) - Enhance docs of arguments and return values of callbacks / filters ([@marcjansen](https://github.com/marcjansen))
 * [#3740](https://github.com/openlayers/ol3/pull/3740) - Add @fires to select interaction ([@probins](https://github.com/probins))
 * [#3738](https://github.com/openlayers/ol3/pull/3738) - Improve doucmentation for ol.TileUrlFunctionType ([@ahocevar](https://github.com/ahocevar))
 * [#3736](https://github.com/openlayers/ol3/pull/3736) - Fix invalid example HTML markup ([@fredj](https://github.com/fredj))
 * [#3735](https://github.com/openlayers/ol3/pull/3735) - Snap example: remove featureoverlay from tags ([@probins](https://github.com/probins))
 * [#3732](https://github.com/openlayers/ol3/pull/3732) - Add a method to bind button bluring on mouseout/focusout ([@marcjansen](https://github.com/marcjansen))
 * [#3659](https://github.com/openlayers/ol3/pull/3659) - Revert "Implement ol.renderer.Layer#forEachFeatureAtCoordinate" ([@fredj](https://github.com/fredj))
 * [#3683](https://github.com/openlayers/ol3/pull/3683) - Improve Map docs for layers and layergroups ([@probins](https://github.com/probins))
 * [#3720](https://github.com/openlayers/ol3/pull/3720) - Add missing goog.provides in drawinteraction.js ([@elemoine](https://github.com/elemoine))
 * [#3725](https://github.com/openlayers/ol3/pull/3725) - Document default value for olx.interaction.ModifyOptions#pixelTolerance ([@fredj](https://github.com/fredj))
 * [#3722](https://github.com/openlayers/ol3/pull/3722) - Use the correct TileCoord transform function ([@ahocevar](https://github.com/ahocevar))
 * [#3692](https://github.com/openlayers/ol3/pull/3692) - Updates for building on Windows using Cygwin. ([@bill-chadwick](https://github.com/bill-chadwick))
 * [#3718](https://github.com/openlayers/ol3/pull/3718) - Add a assertion for renderOrder ([@tsauerwein](https://github.com/tsauerwein))
 * [#3711](https://github.com/openlayers/ol3/pull/3711) - Fix and test ol.color.blend ([@marcjansen](https://github.com/marcjansen))
 * [#3673](https://github.com/openlayers/ol3/pull/3673) - More control over ol.interaction.Draw, to allow e.g. square drawing ([@ahocevar](https://github.com/ahocevar))
 * [#3710](https://github.com/openlayers/ol3/pull/3710) - Add more tests for ol.extent ([@marcjansen](https://github.com/marcjansen))
 * [#3709](https://github.com/openlayers/ol3/pull/3709) - vector-wfs example does not work in JSFiddle ([@bartvde](https://github.com/bartvde))
 * [#3699](https://github.com/openlayers/ol3/pull/3699) - Add support for scientific notation to WKT format ([@marcjansen](https://github.com/marcjansen))
 * [#3696](https://github.com/openlayers/ol3/pull/3696) - Add an example for various blend modes ([@marcjansen](https://github.com/marcjansen))
 * [#3697](https://github.com/openlayers/ol3/pull/3697) - Use a valid SPDX license expression ([@marcjansen](https://github.com/marcjansen))
 * [#3694](https://github.com/openlayers/ol3/pull/3694) - Correct typo in upgrade-notes ([@probins](https://github.com/probins))
 * [#3693](https://github.com/openlayers/ol3/pull/3693) - Fix ol.extent.containsExtent documentation ([@tremby](https://github.com/tremby))
 * [#3689](https://github.com/openlayers/ol3/pull/3689) - Fix WMTS.optionsFromCapabilities if no OperationsMetadata section ([@probins](https://github.com/probins))
 * [#3688](https://github.com/openlayers/ol3/pull/3688) - Add two missing properties to extern of WebGLContextAttributes ([@fredj](https://github.com/fredj))
 * [#3682](https://github.com/openlayers/ol3/pull/3682) - Add a note about using the collection in addLayer ([@bartvde](https://github.com/bartvde))
 * [#3649](https://github.com/openlayers/ol3/pull/3649) - More specific regex in serve.js ([@elemoine](https://github.com/elemoine))
 * [#3677](https://github.com/openlayers/ol3/pull/3677) - Add metadata to examples, ([@tschaub](https://github.com/tschaub))
 * [#3672](https://github.com/openlayers/ol3/pull/3672) - Add link to FAQ-document and fix internal links ([@marcjansen](https://github.com/marcjansen))
 * [#3665](https://github.com/openlayers/ol3/pull/3665) - Add proj4js and projection definition files to example resources ([@marcjansen](https://github.com/marcjansen))
 * [#3662](https://github.com/openlayers/ol3/pull/3662) - Clarify docs for renderBuffer option ([@tsauerwein](https://github.com/tsauerwein))
 * [#3664](https://github.com/openlayers/ol3/pull/3664) - Link to download page. ([@tschaub](https://github.com/tschaub))
 * [#3639](https://github.com/openlayers/ol3/pull/3639) - Add extent support to ol.tilegrid.TileGrid ([@ahocevar](https://github.com/ahocevar))
 * [#3663](https://github.com/openlayers/ol3/pull/3663) - Readme should not include the version number. ([@tschaub](https://github.com/tschaub))
 * [#3637](https://github.com/openlayers/ol3/pull/3637) - Implement ol.renderer.Layer#forEachFeatureAtCoordinate ([@fredj](https://github.com/fredj))
