# v3.7.0

## Summary

The v3.7.0 release includes features and fixes from 43 pull requests since v3.6.0. To simplify the code base, there were some changes to "experimental" features. Please follow the upgrade notes to make your applications work with the latest release.

## Upgrade notes

#### Removal of `ol.FeatureOverlay`

Instead of an `ol.FeatureOverlay`, we now use an `ol.layer.Vector` with an
`ol.source.Vector`. If you previously had:
```js
var featureOverlay = new ol.FeatureOverlay({
  map: map,
  style: overlayStyle
});
featureOverlay.addFeature(feature);
featureOverlay.removeFeature(feature);
var collection = featureOverlay.getFeatures();
```
you will have to change this to:
```js
var collection = new ol.Collection();
var featureOverlay = new ol.layer.Vector({
  map: map,
  source: new ol.source.Vector({
    features: collection,
    useSpatialIndex: false // optional, might improve performance
  }),
  style: overlayStyle,
  updateWhileAnimating: true, // optional, for instant visual feedback
  updateWhileInteracting: true // optional, for instant visual feedback
});
featureOverlay.getSource().addFeature(feature);
featureOverlay.getSource().removeFeature(feature);
```

With the removal of `ol.FeatureOverlay`, `zIndex` symbolizer properties of overlays are no longer stacked per map, but per layer/overlay. If you previously had multiple feature overlays where you controlled the rendering order of features by using `zIndex` symbolizer properties, you can now achieve the same rendering order only if all overlay features are on the same layer.

Note that `ol.FeatureOverlay#getFeatures()` returned an `{ol.Collection.<ol.Feature>}`, whereas `ol.source.Vector#getFeatures()` returns an `{Array.<ol.Feature>}`.

#### `ol.TileCoord` changes

Until now, the API exposed two different types of `ol.TileCoord` tile coordinates: internal ones that increase left to right and upward, and transformed ones that may increase downward, as defined by a transform function on the tile grid. With this change, the API now only exposes tile coordinates that increase left to right and upward.

Previously, tile grids created by OpenLayers either had their origin at the top-left or at the bottom-left corner of the extent. To make it easier for application developers to transform tile coordinates to the common XYZ tiling scheme, all tile grids that OpenLayers creates internally have their origin now at the top-left corner of the extent.

This change affects applications that configure a custom `tileUrlFunction` for an `ol.source.Tile`. Previously, the `tileUrlFunction` was called with rather unpredictable tile coordinates, depending on whether a tile coordinate transform took place before calling the `tileUrlFunction`. Now it is always called with OpenLayers tile coordinates. To transform these into the common XYZ tiling scheme, a custom `tileUrlFunction` has to change the `y` value (tile row) of the `ol.TileCoord`:
```js
function tileUrlFunction = function(tileCoord, pixelRatio, projection) {
  var urlTemplate = '{z}/{x}/{y}';
  return urlTemplate
      .replace('{z}', tileCoord[0].toString())
      .replace('{x}', tileCoord[1].toString())
      .replace('{y}', (-tileCoord[2] - 1).toString());
}
```

The `ol.tilegrid.TileGrid#createTileCoordTransform()` function which could be used to get the tile grid's tile coordinate transform function has been removed. This function was confusing and should no longer be needed now that application developers get tile coordinates in a known layout.

The code snippets below show how your application code needs to be changed:

Old application code (with `ol.tilegrid.TileGrid#createTileCoordTransform()`):
```js
var transform = source.getTileGrid().createTileCoordTransform();
var tileUrlFunction = function(tileCoord, pixelRatio, projection) {
  tileCoord = transform(tileCoord, projection);
  return 'http://mytiles.com/' +
      tileCoord[0] + '/' + tileCoord[1] + '/' + tileCoord[2] + '.png';
};
```
Old application code (with custom `y` transform):
```js
var tileUrlFunction = function(tileCoord, pixelRatio, projection) {
  var z = tileCoord[0];
  var yFromBottom = tileCoord[2];
  var resolution = tileGrid.getResolution(z);
  var tileHeight = ol.size.toSize(tileSize)[1];
  var matrixHeight =
      Math.floor(ol.extent.getHeight(extent) / tileHeight / resolution);
  return 'http://mytiles.com/' +
      tileCoord[0] + '/' + tileCoord[1] + '/' +
      (matrixHeight - yFromBottom - 1) + '.png';

};
```
New application code (simple -y - 1 transform):
```js
var tileUrlFunction = function(tileCoord, pixelRatio, projection) {
  return 'http://mytiles.com/' +
      tileCoord[0] + '/' + tileCoord[1] + '/' + (-tileCoord[2] - 1) + '.png';
};
```

#### Removal of `ol.tilegrid.Zoomify`

The replacement of `ol.tilegrid.Zoomify` is a plain `ol.tilegrid.TileGrid`, configured with `extent`, `origin` and `resolutions`. If the `size` passed to the `ol.source.Zoomify` source is `[width, height]`, then the extent for the tile grid will be `[0, -height, width, 0]`, and the origin will be `[0, 0]`.

#### Replace `ol.View.fitExtent()` and `ol.View.fitGeometry()` with `ol.View.fit()`
* This combines two previously distinct functions into one more flexible call which takes either a geometry or an extent.
* Rename all calls to `fitExtent` and `fitGeometry` to `fit`.

#### Change to `ol.interaction.Modify`

When single clicking a line or boundary within the `pixelTolerance`, a vertex is now created.

## New features and fixes
 
 * [#3867](https://github.com/openlayers/openlayers/pull/3867) - Do not require projection extent for x-wrapping tile sources ([@ahocevar](https://github.com/ahocevar))
 * [#3635](https://github.com/openlayers/openlayers/pull/3635) - Create vertex on boundary single click ([@bjornharrtell](https://github.com/bjornharrtell))
 * [#3806](https://github.com/openlayers/openlayers/pull/3806) - Do not clip canvas for vector layers when wrapping the world ([@ahocevar](https://github.com/ahocevar))
 * [#3461](https://github.com/openlayers/openlayers/pull/3461) - High level Modify interaction events ([@bjornharrtell](https://github.com/bjornharrtell))
 * [#3865](https://github.com/openlayers/openlayers/pull/3865) - ol.View#fit() ([@bartvde](https://github.com/bartvde))
 * [#3864](https://github.com/openlayers/openlayers/pull/3864) - Check projection.canWrapX() before wrapping tiles ([@klokantech](https://github.com/klokantech))
 * [#3863](https://github.com/openlayers/openlayers/pull/3863) - Handle CDATA in attribute parsing for GML format ([@nhambletCCRI](https://github.com/nhambletCCRI))
 * [#3860](https://github.com/openlayers/openlayers/pull/3860) - Update example layout. ([@tschaub](https://github.com/tschaub))
 * [#3861](https://github.com/openlayers/openlayers/pull/3861) - Don't force 'dom' renderer ([@openlayers](https://github.com/openlayers))
 * [#3855](https://github.com/openlayers/openlayers/pull/3855) - Adding an example with WMTS tiles from IGN Geoportail ([@pgiraud](https://github.com/pgiraud))
 * [#3856](https://github.com/openlayers/openlayers/pull/3856) - ol.source.TileVector(): bind success function of tileLoadFunction to source ([@plepe](https://github.com/plepe))
 * [#3848](https://github.com/openlayers/openlayers/pull/3848) - Check for exports before define. ([@tschaub](https://github.com/tschaub))
 * [#3845](https://github.com/openlayers/openlayers/pull/3845) - Prevent null array to be passed to an ol.Collection ([@fredj](https://github.com/fredj))
 * [#3849](https://github.com/openlayers/openlayers/pull/3849) - Pad min. and sec. with leading zeros in DMS notation ([@pgiraud](https://github.com/pgiraud))
 * [#3842](https://github.com/openlayers/openlayers/pull/3842) - Adding a feature-animation example ([@pgiraud](https://github.com/pgiraud))
 * [#3833](https://github.com/openlayers/openlayers/pull/3833) - Enable use of custom XHR loader for TileVector sources ([@bjornharrtell](https://github.com/bjornharrtell))
 * [#3834](https://github.com/openlayers/openlayers/pull/3834) - ArcGIS tiled example broken in Chrome ([@bartvde](https://github.com/bartvde))
 * [#3829](https://github.com/openlayers/openlayers/pull/3829) - incorrect assert message ([@kzr-pzr](https://github.com/kzr-pzr))
 * [#3828](https://github.com/openlayers/openlayers/pull/3828) - Fix typo in upgrade notes ([@ahocevar](https://github.com/ahocevar))
 * [#3826](https://github.com/openlayers/openlayers/pull/3826) - Allow custom tileGrid in ol.source.XYZ ([@klokantech](https://github.com/klokantech))
 * [#3815](https://github.com/openlayers/openlayers/pull/3815) - Simplify tilegrid API and internals ([@ahocevar](https://github.com/ahocevar))
 * [#3820](https://github.com/openlayers/openlayers/pull/3820) - Make unmanaged vector layers behave more like ol.FeatureOverlay ([@ahocevar](https://github.com/ahocevar))
 * [#3822](https://github.com/openlayers/openlayers/pull/3822) - Correct docs for updateWhileInteracting ([@probins](https://github.com/probins))
 * [#3818](https://github.com/openlayers/openlayers/pull/3818) - Make geometry.transform api stable again. ([@probins](https://github.com/probins))
 * [#3801](https://github.com/openlayers/openlayers/pull/3801) - Respect the tile grid's extent in ol.source.TileVector ([@ahocevar](https://github.com/ahocevar))
 * [#3810](https://github.com/openlayers/openlayers/pull/3810) - Improve TileGrid documentation and examples ([@ahocevar](https://github.com/ahocevar))
 * [#3808](https://github.com/openlayers/openlayers/pull/3808) - Correct typo in OverlayOptions ([@probins](https://github.com/probins))
 * [#3766](https://github.com/openlayers/openlayers/pull/3766) - Add a clickTolerance option to the Draw interaction ([@elemoine](https://github.com/elemoine))
 * [#3804](https://github.com/openlayers/openlayers/pull/3804) - Remove sentence that was only meant for WMTS tile grids ([@ahocevar](https://github.com/ahocevar))
 * [#3800](https://github.com/openlayers/openlayers/pull/3800) - Remove further references to FeatureOverlay ([@probins](https://github.com/probins))
 * [#3780](https://github.com/openlayers/openlayers/pull/3780) - Only expose transformed tile coordinates to the API ([@ahocevar](https://github.com/ahocevar))
 * [#3793](https://github.com/openlayers/openlayers/pull/3793) - Use 'managed' instead of 'unmanaged' in LayerState ([@ahocevar](https://github.com/ahocevar))
 * [#3792](https://github.com/openlayers/openlayers/pull/3792) - Link to correct layer base class ([@marcjansen](https://github.com/marcjansen))
 * [#3791](https://github.com/openlayers/openlayers/pull/3791) - Remove docs referring to removed feature overlay ([@marcjansen](https://github.com/marcjansen))
 * [#3790](https://github.com/openlayers/openlayers/pull/3790) - Remove unnecessary quotes around object keys ([@fredj](https://github.com/fredj))
 * [#3787](https://github.com/openlayers/openlayers/pull/3787) - Add 'unmanaged' to ol.layer.LayerState ([@ahocevar](https://github.com/ahocevar))
 * [#3784](https://github.com/openlayers/openlayers/pull/3784) - Always write the GeoJSONFeature geometry property ([@fredj](https://github.com/fredj))
 * [#3783](https://github.com/openlayers/openlayers/pull/3783) - Fix broken wmts-hidpi example ([@ahocevar](https://github.com/ahocevar))
 * [#3782](https://github.com/openlayers/openlayers/pull/3782) - Fix assert documentation typo ([@gberaudo](https://github.com/gberaudo))
 * [#3758](https://github.com/openlayers/openlayers/pull/3758) - Removal of ol.FeatureOverlay ([@ahocevar](https://github.com/ahocevar))
 * [#3775](https://github.com/openlayers/openlayers/pull/3775) - Add ol-touch but keep ol-viewport className. ([@pgiraud](https://github.com/pgiraud))
 * [#3713](https://github.com/openlayers/openlayers/pull/3713) - Add missing propertyNames member for olx.format.WFSWriteGetFeatureOptions ([@bartvde](https://github.com/bartvde))
 * [#3763](https://github.com/openlayers/openlayers/pull/3763) - Standardise draw/modify descriptions ([@probins](https://github.com/probins))
