# v3.13.0

## Summary

The v3.13.0 release includes features and fixes from 68 pull requests since the v3.12.1 release.  New features and improvements include:

* Improved tiles rendering for the canvas renderer
* Improved MapQuest rendering
* Add color option to ol.style.Icon
* Load TileJSON sources via XMLHttpRequest by default
* Add new ol.geom.LineString#getCoordinateAt function
* Simplify meters per unit handling
* Use ESLint as a replacement for gjslint.py and jshint

## Upgrade notes

#### `proj4js` integration

Before this release, OpenLayers depended on the global proj4 namespace. When using a module loader like Browserify, you might not want to depend on the global `proj4` namespace. You can use the `ol.proj.setProj4` function to set the proj4 function object. For example in a browserify ES6 environment:

```js
import ol from 'openlayers';
import proj4 from 'proj4';
ol.proj.setProj4(proj4);
```

#### `ol.source.TileJSON` changes

The `ol.source.TileJSON` now uses `XMLHttpRequest` to load the TileJSON instead of JSONP with callback.
When using server without proper CORS support, `jsonp: true` option can be passed to the constructor to get the same behavior as before:
```js
new ol.source.TileJSON({
  url: 'http://serverwithoutcors.com/tilejson.json',
  jsonp: true
})
```
Also for Mapbox v3, make sure you use urls ending with `.json` (which are able to handle both `XMLHttpRequest` and JSONP) instead of `.jsonp`.


## Full list of changes

 * [#4694](https://github.com/openlayers/openlayers/pull/4694) - Fix eslint errors in wms-time example ([@fredj](https://github.com/fredj))
 * [#4527](https://github.com/openlayers/openlayers/pull/4527) - Add support for smooth TileWMS dimensions ([@bartvde](https://github.com/bartvde))
 * [#4691](https://github.com/openlayers/openlayers/pull/4691) - Updated Bing Maps key. ([@tschaub](https://github.com/tschaub))
 * [#4673](https://github.com/openlayers/openlayers/pull/4673) - Respect fixed tile url functions when setting url(s) ([@ahocevar](https://github.com/ahocevar))
 * [#4689](https://github.com/openlayers/openlayers/pull/4689) - Revert "Do not render in handleDownEvent" ([@openlayers](https://github.com/openlayers))
 * [#4688](https://github.com/openlayers/openlayers/pull/4688) - Give map a focus-outline in accessible-example ([@marcjansen](https://github.com/marcjansen))
 * [#4642](https://github.com/openlayers/openlayers/pull/4642) - Move the icon style color to its own example ([@alexbrault](https://github.com/alexbrault))
 * [#4685](https://github.com/openlayers/openlayers/pull/4685) - Remove bin/check-whitespace.py ([@fredj](https://github.com/fredj))
 * [#4684](https://github.com/openlayers/openlayers/pull/4684) - Update eslint-config-openlayers to version 3.0.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4677](https://github.com/openlayers/openlayers/pull/4677) - Make pixel projection handling work in compiled mode ([@ahocevar](https://github.com/ahocevar))
 * [#4639](https://github.com/openlayers/openlayers/pull/4639) - Remove use of goog.bind and use ES5 .bind. ([@nicholas-l](https://github.com/nicholas-l))
 * [#4655](https://github.com/openlayers/openlayers/pull/4655) - Update browserify to version 13.0.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4666](https://github.com/openlayers/openlayers/pull/4666) - Add a 'boxdrag' event to ol.interaction.DragBox. Resolves #4563 . ([@WeaveTeam](https://github.com/WeaveTeam))
 * [#4669](https://github.com/openlayers/openlayers/pull/4669) - Remove reference to Closure Linter in CONTRIBUTING.md ([@fredj](https://github.com/fredj))
 * [#4665](https://github.com/openlayers/openlayers/pull/4665) - Update istanbul to version 0.4.2 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4663](https://github.com/openlayers/openlayers/pull/4663) - Update glob to version 6.0.4 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4667](https://github.com/openlayers/openlayers/pull/4667) - Fix rendering of transparent MapQuest layer type ([@klokantech](https://github.com/klokantech))
 * [#4661](https://github.com/openlayers/openlayers/pull/4661) - Fixes #4654 Developer Documentation Updated ([@gaf-ag](https://github.com/gaf-ag))
 * [#4658](https://github.com/openlayers/openlayers/pull/4658) - Update jquery to version 2.2.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4659](https://github.com/openlayers/openlayers/pull/4659) - Make sure icons show up in Safari ([@bartvde](https://github.com/bartvde))
 * [#4652](https://github.com/openlayers/openlayers/pull/4652) - Use map.getTargetElement instead of map.getTarget ([@fredj](https://github.com/fredj))
 * [#4649](https://github.com/openlayers/openlayers/pull/4649) - Missing parameter description for ol.source.Tile#getOpaque ([@klokantech](https://github.com/klokantech))
 * [#4602](https://github.com/openlayers/openlayers/pull/4602) - Use ESLint. ([@tschaub](https://github.com/tschaub))
 * [#4628](https://github.com/openlayers/openlayers/pull/4628) - Fix for reprojecting opaque tile sources ([@klokantech](https://github.com/klokantech))
 * [#4618](https://github.com/openlayers/openlayers/pull/4618) - Update resemblejs to version 2.1.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4647](https://github.com/openlayers/openlayers/pull/4647) - Proper rounding for possibly negative numbers ([@ahocevar](https://github.com/ahocevar))
 * [#4641](https://github.com/openlayers/openlayers/pull/4641) - Remove extra options from icon example. ([@tschaub](https://github.com/tschaub))
 * [#4629](https://github.com/openlayers/openlayers/pull/4629) - Simplify scaleline calculation ([@ahocevar](https://github.com/ahocevar))
 * [#4457](https://github.com/openlayers/openlayers/pull/4457) - Add color option to ol.style.Icon ([@alexbrault](https://github.com/alexbrault))
 * [#4638](https://github.com/openlayers/openlayers/pull/4638) - Do not rely on projection extent ([@ahocevar](https://github.com/ahocevar))
 * [#4635](https://github.com/openlayers/openlayers/pull/4635) - Update async to version 1.5.2 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4581](https://github.com/openlayers/openlayers/pull/4581) - Do not render in handleDownEvent ([@ahocevar](https://github.com/ahocevar))
 * [#4541](https://github.com/openlayers/openlayers/pull/4541) - Add new ol.geom.LineString#getCoordinateAt function ([@fredj](https://github.com/fredj))
 * [#4489](https://github.com/openlayers/openlayers/pull/4489) - Update phantomjs to version 1.9.19 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4625](https://github.com/openlayers/openlayers/pull/4625) - Use XHR by default to load TileJSON in ol.source.TileJSON ([@klokantech](https://github.com/klokantech))
 * [#4622](https://github.com/openlayers/openlayers/pull/4622) - Update fs-extra to version 0.26.4 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4630](https://github.com/openlayers/openlayers/pull/4630) - Simplify meters per unit handling ([@ahocevar](https://github.com/ahocevar))
 * [#4490](https://github.com/openlayers/openlayers/pull/4490) - Update istanbul to version 0.4.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4574](https://github.com/openlayers/openlayers/pull/4574) - Added boxEndCondition to DragBoxOptions to replace the hardcoded chec… ([@WeaveTeam](https://github.com/WeaveTeam))
 * [#4553](https://github.com/openlayers/openlayers/pull/4553) - Update mustache to version 2.2.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4626](https://github.com/openlayers/openlayers/pull/4626) - Fixed documentation error ([@simonseyock](https://github.com/simonseyock))
 * [#4606](https://github.com/openlayers/openlayers/pull/4606) - Include originating MapBrowserEvent in ol.DragBoxEvent ([@fredj](https://github.com/fredj))
 * [#4614](https://github.com/openlayers/openlayers/pull/4614) - Remove checksum interface. ([@tschaub](https://github.com/tschaub))
 * [#4613](https://github.com/openlayers/openlayers/pull/4613) - Include own layer in layerFilter and only select unselected features ([@ahocevar](https://github.com/ahocevar))
 * [#4612](https://github.com/openlayers/openlayers/pull/4612) - Set oli.source.VectorEvent#feature to ol.Feature|undefined ([@fredj](https://github.com/fredj))
 * [#4620](https://github.com/openlayers/openlayers/pull/4620) - Fix olx.format.PolylineOptions#factor type ([@fredj](https://github.com/fredj))
 * [#4621](https://github.com/openlayers/openlayers/pull/4621) - Fix olx.format.GPXOptions#readExtensions type ([@fredj](https://github.com/fredj))
 * [#4619](https://github.com/openlayers/openlayers/pull/4619) - Add option to load TileJSON via XHR ([@klokantech](https://github.com/klokantech))
 * [#4617](https://github.com/openlayers/openlayers/pull/4617) - Add missing return type to GeoJSON format ([@gberaudo](https://github.com/gberaudo))
 * [#4615](https://github.com/openlayers/openlayers/pull/4615) - Adjust copyright to include 2016 ([@marcjansen](https://github.com/marcjansen))
 * [#4616](https://github.com/openlayers/openlayers/pull/4616) - Update closure-util to version 1.10.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4596](https://github.com/openlayers/openlayers/pull/4596) - Use consistent tile coordinate keys ([@ahocevar](https://github.com/ahocevar))
 * [#4609](https://github.com/openlayers/openlayers/pull/4609) - Add ol.proj.setProj4 function ([@bartvde](https://github.com/bartvde))
 * [#4603](https://github.com/openlayers/openlayers/pull/4603) - Update async to version 1.5.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4604](https://github.com/openlayers/openlayers/pull/4604) - Update clean-css to version 3.4.9 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4600](https://github.com/openlayers/openlayers/pull/4600) - Update glob to version 6.0.3 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4595](https://github.com/openlayers/openlayers/pull/4595) - Pass 'opaque' option on to superclass ([@ahocevar](https://github.com/ahocevar))
 * [#4598](https://github.com/openlayers/openlayers/pull/4598) - Make ol.source.Tile#getTilePixelRatio work correctly for all sources ([@klokantech](https://github.com/klokantech))
 * [#4594](https://github.com/openlayers/openlayers/pull/4594) - Fix for TileQueue gradually choking up when using raster reprojection ([@klokantech](https://github.com/klokantech))
 * [#4557](https://github.com/openlayers/openlayers/pull/4557) - Conditionally render tiles to a separate tile canvas ([@ahocevar](https://github.com/ahocevar))
 * [#4580](https://github.com/openlayers/openlayers/pull/4580) - Update fs-extra to version 0.26.3 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4579](https://github.com/openlayers/openlayers/pull/4579) - Release v3.12.1 ([@openlayers](https://github.com/openlayers))
 * [#4578](https://github.com/openlayers/openlayers/pull/4578) - Fix apidoc landing page markup ([@ahocevar](https://github.com/ahocevar))
 * [#4575](https://github.com/openlayers/openlayers/pull/4575) - Update rbush to version 1.4.2 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4571](https://github.com/openlayers/openlayers/pull/4571) - Correct typedef of selectinteraction options obj ([@marcjansen](https://github.com/marcjansen))
 * [#4570](https://github.com/openlayers/openlayers/pull/4570) - Rename defaultSort to numberSafeCompareFunction on ol.array ([@bartvde](https://github.com/bartvde))
 * [#4567](https://github.com/openlayers/openlayers/pull/4567) - Always pass on a compare function to sort ([@bartvde](https://github.com/bartvde))
 * [#4001](https://github.com/openlayers/openlayers/pull/4001) - Export PDF's using jsPDF ([@bartvde](https://github.com/bartvde))
