# v3.17.0

## Summary

The v3.17.0 release includes features and fixes from 60 pull requests since the v3.16.0 release. Most of the changes are bug fixes and continuing removal of the dependency on Closure Library.

## Upgrade notes

#### `ol.source.MapQuest` removal

Because of changes at MapQuest (see: https://lists.openstreetmap.org/pipermail/talk/2016-June/076106.html) we had to remove the MapQuest source for now (see https://github.com/openlayers/openlayers/issues/5484 for details).

#### `ol.interaction.ModifyEvent` changes

The event object previously had a `mapBrowserPointerEvent` property, which has been renamed to `mapBrowserEvent`.

#### Removal of ol.raster namespace

Users compiling their code with the library and using types in the `ol.raster` namespace should note that this has now been removed. `ol.raster.Pixel` has been deleted, and the other types have been renamed as follows, and your code may need changing if you use these:
* `ol.raster.Operation` to `ol.RasterOperation`
* `ol.raster.OperationType` to `ol.RasterOperationType`

#### All typedefs now in ol namespace

Users compiling their code with the library should note that the following typedefs have been renamed; your code may need changing if you use these:
* ol.events.ConditionType to ol.EventsConditionType
* ol.events.EventTargetLike to ol.EventTargetLike
* ol.events.Key to ol.EventsKey
* ol.events.ListenerFunctionType to ol.EventsListenerFunctionType
* ol.interaction.DragBoxEndConditionType to ol.DragBoxEndConditionType
* ol.interaction.DrawGeometryFunctionType to ol.DrawGeometryFunctionType
* ol.interaction.SegmentDataType to ol.ModifySegmentDataType
* ol.interaction.SelectFilterFunction to ol.SelectFilterFunction
* ol.interaction.SnapResultType to ol.SnapResultType
* ol.interaction.SnapSegmentDataType to ol.SnapSegmentDataType
* ol.proj.ProjectionLike to ol.ProjectionLike
* ol.style.AtlasBlock to ol.AtlasBlock
* ol.style.AtlasInfo to ol.AtlasInfo
* ol.style.AtlasManagerInfo to ol.AtlasManagerInfo
* ol.style.CircleRenderOptions to ol.CircleRenderOptions
* ol.style.ImageOptions to ol.StyleImageOptions
* ol.style.GeometryFunction to ol.StyleGeometryFunction
* ol.style.RegularShapeRenderOptions to ol.RegularShapeRenderOptions
* ol.style.StyleFunction to ol.StyleFunction

## Full list of changes

 * [#5539](https://github.com/openlayers/openlayers/pull/5539) - Remove outdated comments re goog.dom ([@probins](https://github.com/probins))
 * [#5543](https://github.com/openlayers/openlayers/pull/5543) - Update rbush to 2.0.1 ([@tsauerwein](https://github.com/tsauerwein))
 * [#5540](https://github.com/openlayers/openlayers/pull/5540) - Remove MapQuest source ([@bartvde](https://github.com/bartvde))
 * [#5538](https://github.com/openlayers/openlayers/pull/5538) - Replace remaining goog.inherits ([@probins](https://github.com/probins))
 * [#5536](https://github.com/openlayers/openlayers/pull/5536) - Update to layer-extent example ([@tschaub](https://github.com/tschaub))
 * [#5482](https://github.com/openlayers/openlayers/pull/5482) - Fix for regression in tile layer extent ([@ischneider](https://github.com/ischneider))
 * [#5475](https://github.com/openlayers/openlayers/pull/5475) - Remove goog.provide from enums only used internally or in olx.js ([@probins](https://github.com/probins))
 * [#5424](https://github.com/openlayers/openlayers/pull/5424) - Don't dispatch select event if no feature is selected or deselected ([@fredj](https://github.com/fredj))
 * [#5522](https://github.com/openlayers/openlayers/pull/5522) - Add 'condition' option to ol.interaction.DragPanOptions in olx.js ([@SamuelBerger](https://github.com/SamuelBerger))
 * [#5443](https://github.com/openlayers/openlayers/pull/5443) - Remove olx.source.WMTSOptions#maxZoom option ([@fredj](https://github.com/fredj))
 * [#5497](https://github.com/openlayers/openlayers/pull/5497) - Update istanbul to version 0.4.4 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5523](https://github.com/openlayers/openlayers/pull/5523) - Update closure-util to version 1.15.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5508](https://github.com/openlayers/openlayers/pull/5508) - Fix problems with ol.format.WFS in compiled mode ([@tsauerwein](https://github.com/tsauerwein))
 * [#5512](https://github.com/openlayers/openlayers/pull/5512) - Use forEachTileCoord name instead of forEachTileCoordInExtentAndZ ([@ahocevar](https://github.com/ahocevar))
 * [#5513](https://github.com/openlayers/openlayers/pull/5513) - Add getters for min and max resolution of the view ([@bartvde](https://github.com/bartvde))
 * [#5471](https://github.com/openlayers/openlayers/pull/5471) - Fix GPX write of xsi ns ([@probins](https://github.com/probins))
 * [#5134](https://github.com/openlayers/openlayers/pull/5134) - Remove goog.dom ([@nicholas-l](https://github.com/nicholas-l))
 * [#5511](https://github.com/openlayers/openlayers/pull/5511) - Do not optimize lines away entirely ([@ahocevar](https://github.com/ahocevar))
 * [#5509](https://github.com/openlayers/openlayers/pull/5509) - Make it easier to work with tile ranges in custom source implementations ([@ahocevar](https://github.com/ahocevar))
 * [#5498](https://github.com/openlayers/openlayers/pull/5498) - Update eslint to version 2.13.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5495](https://github.com/openlayers/openlayers/pull/5495) - Get rid of goog.isFunction ([@fredj](https://github.com/fredj))
 * [#5499](https://github.com/openlayers/openlayers/pull/5499) - Update glob to version 7.0.5 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5125](https://github.com/openlayers/openlayers/pull/5125) - Remove goog style ([@nicholas-l](https://github.com/nicholas-l))
 * [#5494](https://github.com/openlayers/openlayers/pull/5494) - Remove goog.global ([@probins](https://github.com/probins))
 * [#5492](https://github.com/openlayers/openlayers/pull/5492) - Update eslint to version 2.13.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5490](https://github.com/openlayers/openlayers/pull/5490) - Update glob to version 7.0.4 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5460](https://github.com/openlayers/openlayers/pull/5460) - Update eslint to version 2.12.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5479](https://github.com/openlayers/openlayers/pull/5479) - Update slimerjs to version 0.906.2 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5474](https://github.com/openlayers/openlayers/pull/5474) - Update clean-css to version 3.4.18 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5450](https://github.com/openlayers/openlayers/pull/5450) - Remove sub-namespaces from all remaining typedefs ([@probins](https://github.com/probins))
 * [#5465](https://github.com/openlayers/openlayers/pull/5465) - Fix custom icon positions and rotation ([@ahocevar](https://github.com/ahocevar))
 * [#5469](https://github.com/openlayers/openlayers/pull/5469) - Fix typo ([@gberaudo](https://github.com/gberaudo))
 * [#5453](https://github.com/openlayers/openlayers/pull/5453) - Reference ol.MapBrowserEvent instead of ol.MapBrowserPointerEvent ([@ahocevar](https://github.com/ahocevar))
 * [#5208](https://github.com/openlayers/openlayers/pull/5208) - Stop GPX writing rtept properties ([@probins](https://github.com/probins))
 * [#5452](https://github.com/openlayers/openlayers/pull/5452) - Update eslint-config-openlayers to version 5.0.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5432](https://github.com/openlayers/openlayers/pull/5432) - Remove use of goog.uri ([@bjornharrtell](https://github.com/bjornharrtell))
 * [#5449](https://github.com/openlayers/openlayers/pull/5449) - Make example data/ paths absolute for source view and JSFiddle ([@ahocevar](https://github.com/ahocevar))
 * [#5399](https://github.com/openlayers/openlayers/pull/5399) - Remove ol.raster namespace ([@probins](https://github.com/probins))
 * [#5270](https://github.com/openlayers/openlayers/pull/5270) - Load erroneous image in ol.Image#load and ol.ImageTile#load ([@fredj](https://github.com/fredj))
 * [#5194](https://github.com/openlayers/openlayers/pull/5194) - Get rid of goog.inherits and goog.base ([@fredj](https://github.com/fredj))
 * [#5427](https://github.com/openlayers/openlayers/pull/5427) - Document typedefs and enums used by API symbols ([@ahocevar](https://github.com/ahocevar))
 * [#5438](https://github.com/openlayers/openlayers/pull/5438) - Don't make ol.format.ogc.filter.Filter inherit from ol.Object ([@fredj](https://github.com/fredj))
 * [#5433](https://github.com/openlayers/openlayers/pull/5433) - Update clean-css to version 3.4.17 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5434](https://github.com/openlayers/openlayers/pull/5434) - Fix externs in closure compiler tutorial ([@tsauerwein](https://github.com/tsauerwein))
 * [#5426](https://github.com/openlayers/openlayers/pull/5426) - Fix icon example to anchor popup to feature location ([@frankrowe](https://github.com/frankrowe))
 * [#5421](https://github.com/openlayers/openlayers/pull/5421) - Correct typo in config/jsdoc/api/readme.md ([@probins](https://github.com/probins))
 * [#5417](https://github.com/openlayers/openlayers/pull/5417) - Update clean-css to version 3.4.16 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5413](https://github.com/openlayers/openlayers/pull/5413) - Update clean-css to version 3.4.15 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5410](https://github.com/openlayers/openlayers/pull/5410) - Update eslint to version 2.11.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5408](https://github.com/openlayers/openlayers/pull/5408) - Update pbf to version 2.0.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5404](https://github.com/openlayers/openlayers/pull/5404) - Update eslint to version 2.11.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5402](https://github.com/openlayers/openlayers/pull/5402) - Pass in srsName option to writeTransaction ([@anzhihun](https://github.com/anzhihun))
 * [#5393](https://github.com/openlayers/openlayers/pull/5393) - Update mocha to version 2.5.3 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5394](https://github.com/openlayers/openlayers/pull/5394) - Update resemblejs to version 2.2.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5390](https://github.com/openlayers/openlayers/pull/5390) - Fix the requestEncoding automatic selection ([@fredj](https://github.com/fredj))
 * [#5392](https://github.com/openlayers/openlayers/pull/5392) - Update closure-util to version 1.14.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5388](https://github.com/openlayers/openlayers/pull/5388) - Update mocha to version 2.5.2 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5382](https://github.com/openlayers/openlayers/pull/5382) - Handle UTC midnight wrap around, fixes #5371 ([@twpayne](https://github.com/twpayne))
 * [#5381](https://github.com/openlayers/openlayers/pull/5381) - Update mocha to version 2.5.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5383](https://github.com/openlayers/openlayers/pull/5383) - Update clean-css to version 3.4.13 🚀 ([@openlayers](https://github.com/openlayers))
