# 6.0.0

Wow.  The 6.0 release includes changes from 1780 commits in 544 pull requests since the 5.3 release.  Thanks to all who contributed to this effort.

A major feature in this release is the ability to compose layers with different renderer types.  Previously, the map used a single rendering strategy, and all layers in your map had to implement that strategy.  Now it is possible to have a map with layers that use different rendering technologies.  This makes it possible, for example, to have Canvas (2D) layer composed together with a WebGL based layer in the same map.  It is also possible to create layers with custom renderers.  So you could have a map that uses another library (like d3) to render one layer and use OpenLayers to render the other layers.  We will continue to take advantage of this new flexibility in future releases.

In addition, the 6.0 release includes a number of vector tile rendering improvements, and should have a lower memory footprint overall.  The release also includes a number of experimental features that are not yet part of the stable API.  Take a look through the examples for a new WebGL based renderer and the experimental `useGeographic()` function.  Watch upcoming releases for more detail on these.

This release includes a number of backwards incompatible changes.  Take a careful look at the notes below when upgrading your application from the 5.3 release.

#### Backwards incompatible changes

##### Usage of `map.forEachLayerAtPixel`

Due to performance considerations, the layers in a map will sometimes be rendered into one
single canvas instead of separate elements.
This means `map.forEachLayerAtPixel` will bring up false positives.

The easiest solution to avoid that is to assign different `className` properties to each layer like so:
```js
new Layer({
   // ...
   className: 'my-layer'
})
```

Please note that this may incur a significant performance loss when dealing with many layers and/or
targetting mobile devices.

##### Removal of `TOUCH` constant from `ol/has`

If you were previously using this constant, you can check if `'ontouchstart'` is defined in `window` instead.

```js
if ('ontouchstart' in window) {
  // ...
}
```

##### Removal of `GEOLOCATION` constant from `ol/has`

If you were previously using this constant, you can check if `'geolocation'` is defined in `navigator` instead.

```js
if ('geolocation' in navigator) {
  // ...
}
```

##### Removal of CSS print rules

The CSS media print rules were removed from the `ol.css` file. To get the previous behavior, use the following CSS:

```css
@media print {
  .ol-control {
    display: none;
  }
}
```

##### Removal of optional this arguments

The optional this (i.e. opt_this) arguments were removed from the following methods.
Please use closures, the es6 arrow function or the bind method to achieve this effect (Bind is explained here:
https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/bind).

* `forEachCorner` in `ol/extent`
* `LRUCache#forEach`
* `RBush#forEach` and `RBush#forEachInExtent`

##### The `setCenter`, `setZoom`, `setResolution` and `setRotation` methods on `ol/View` do not bypass constraints anymore

Previously, these methods allowed setting values that were inconsistent with the given view constraints.
This is no longer the case and all changes to the view state now follow the same logic:
target values are provided and constraints are applied on these to determine the actual values to be used.

##### Removal of the `constrainResolution` option on `View.fit`, `PinchZoom`, `MouseWheelZoom` and `ol/interaction.js`

The `constrainResolution` option is now only supported by the `View` class. A `View.setConstrainResolution` method was added as well.

Generally, the responsibility of applying center/rotation/resolutions constraints was moved from interactions and controls to the `View` class.

##### The view `extent` option now applies to the whole viewport

Previously, this options only constrained the view *center*. This behaviour can still be obtained by specifying `constrainCenterOnly` in the view options.

As a side effect, the view `rotate` method is gone and has been replaced with `adjustRotation` which takes a delta as input.

##### The view is constrained so only one world is visible

Previously, maps showed multiple worlds at low zoom levels. In addition, it used to be possible to pan off the north or south edge of the world.  Now, the view is restricted to show only one world, and you cannot pan off the edge. To get the previous behavior, configure the `ol/View` with `multiWorld: true`.

##### Removal of deprecated methods

The `inherits` function that was used to inherit the prototype methods from one constructor into another has been removed.
The standard ECMAScript classes should be used instead.

The deprecated `getSnapToPixel` and `setSnapToPixel` functions from the `ImageStyle` class have been removed.

##### New internal tile coordinates

Previously, the internal tile coordinates used in the library had an unusual row order – the origin of the tile coordinate system was at the top left as expected, but the rows increased upwards.  This meant that all tile coordinates within a tile grid's extent had negative `y` values.

Now, the internal tile coordinates used in the library have the same row order as standard (e.g. XYZ) tile coordinates.  The origin is at the top left (as before), and rows or `y` values increase downward.  So the top left tile of a tile grid is now `0, 0`, whereas it was `0, -1` before.

```
x, y values for tile coordinates

origin
  *__________________________
  |        |        |        |
  |  0, 0  |  1, 0  |  2, 0  |
  |________|________|________|
  |        |        |        |
  |  0, 1  |  1, 1  |  2, 1  |
  |________|________|________|
  |        |        |        |
  |  0, 2  |  1, 2  |  2, 2  |
  |________|________|________|
```

This change should only affect you if you were using a custom `tileLoadFunction` or `tileUrlFunction`.  For example, if you used to have a `tileUrlFunction` that looked like this:

```js
// before
function tileUrlFunction(tileCoord) {
  const z = tileCoord[0];
  const x = tileCoord[1];
  const y = -tileCoord[2] - 1;
  // do something with z, x, y
}
```

You would now do something like this:
```js
// after
function tileUrlFunction(tileCoord) {
  const z = tileCoord[0];
  const x = tileCoord[1];
  const y = tileCoord[2];
  // do something with z, x, y
}
```

In addition (this should be exceedingly rare), if you previously created a `ol/tilegrid/WMTS` by hand and you were providing an array of `sizes`, you no longer have to provide a negative height if your tile origin is the top-left corner (the common case).  On the other hand, if you are providing a custom array of `sizes` and your origin is the bottom of the grid (this is uncommon), your height values must now be negative.

##### Removal of the "vector" render mode for vector tile layers

If you were previously using `VectorTile` layers with `renderMode: 'vector'`, you have to remove this configuration option. That mode was removed. `'hybrid'` (default) and `'image'` are still available.

##### Removal of the "renderMode" option for vector layers

If you were previously using `Vector` layers with `renderMode: 'image'`, you have to remove this configuration option. Instead, use the new `ol/layer/VectorImage` layer with your `ol/source/Vector`.

##### New declutter behavior

If a map has more than one layer with `declutter` set to true, decluttering now considers all `Vector` and `VectorTile` layers, instead of decluttering each layer separately. Only `VectorImage` layers continue to be decluttered separately. The higher the z-index of a layer, the higher the priority of its decluttered items.

Within a layer, the declutter order has changed. Previously, styles with a lower `zIndex` were prioritized over those with a higher `zIndex`. Now the opposite order is used.

On vector layers, even if decluttered images or texts have a lower z-Index than polygons or lines, they will now be rendered on top of the polygons or lines. For vector tile layers, this was the case already in previous releases.

##### New `prerender` and `postrender` layer events replace old `precompose`, `render` and `postcompose` events

If you were previously registering for `precompose` and `postcompose` events, you should now register for `prerender` and `postrender` events on layers.  Instead of the previous `render` event, you should now listen for `postrender`. Layers are no longer composed to a single Canvas element.  Instead, they are added to the map viewport as individual elements.

##### New `getVectorContext` function provides access to the immediate vector rendering API

Previously, render events included a `vectorContext` property that allowed you to render features or geometries directly to the map.  This is still possible, but you now have to explicitly create a vector context with the `getVectorContext` function.  This change makes the immediate rendering API an explicit dependency if your application uses it.  If you don't use this API, your application bundle will not include the vector rendering modules (as it did before).

Here is an abbreviated example of how to use the `getVectorContext` function:

```js
import {getVectorContext} from 'ol/render';

// construct your map and layers as usual

layer.on('postrender', function(event) {
  const vectorContext = getVectorContext(event);
  // use any of the drawing methods on the vector context
});
```

##### Layers can only be added to a single map

Previously, it was possible to render a single layer in two maps.  Now, each layer can only belong to a single map (in the same way that a single DOM element can only have one parent).

##### The `OverviewMap` requires a list of layers.

Due to the constraint above (layers can only be added to a single map), the overview map needs to be constructed with a list of layers.

##### The `ol/Graticule` has been replaced by `ol/layer/Graticule`

Previously, a graticule was not a layer.  Now it is.  See the graticule example for details on how to add a graticule layer to your map.

##### `ol/format/Feature` API change

The `getLastExtent()` method, which was required for custom `tileLoadFunction`s in `ol/source/Vector`, has been removed because it is no longer needed (see below).

##### `ol/VectorTile` API changes

* Removal of the `getProjection()` and `setProjection()` methods. These were used in custom `tileLoadFunction`s on `ol/source/VectorTile`, which work differently now (see below).
* Removal of the `getExtent()` and `setExtent()` methods. These were used in custom `tileLoadFunction`s on `ol/source/VectorTile`, which work differently now (see below).

##### Custom tileLoadFunction on a VectorTile source needs changes

Previously, applications needed to call `setProjection()` and `setExtent()` on the tile in a custom `tileLoadFunction` on `ol/source/VectorTile`. The format's `getLastExtent()` method was used to get the extent. All this is no longer needed. Instead, the `extent` (first argument to the loader function) and `projection` (third argument to the loader function) are simply passed as `extent` and `featureProjection` options to the format's `readFeatures()` method.

Example for an old `tileLoadFunction`:

```js
function(tile, url) {
  tile.setLoader(function() {
    fetch(url).then(function(response) {
      response.arrayBuffer().then(function(data) {
        var format = tile.getFormat();
        tile.setProjection(format.readProjection(data));
        tile.setFeatures(format.readFeatures(data, {
          // featureProjection is not required for ol/format/MVT
          featureProjection: map.getView().getProjection()
        }));
        tile.setExtent(format.getLastExtent());
      })
    })
  }
});
```

This function needs to be changed to:

```js
function(tile, url) {
  tile.setLoader(function(extent, resolution, projection) {
    fetch(url).then(function(response) {
      response.arrayBuffer().then(function(data) {
        var format = tile.getFormat();
        tile.setFeatures(format.readFeatures(data, {
          // extent is only required for ol/format/MVT
          extent: extent,
          featureProjection: projection
        }));
      })
    })
  }
});
```

##### Drop of support for the experimental WebGL renderer

The WebGL map and layers renderers are gone, replaced by a `WebGLHelper` function that provides a lightweight,
low-level access to the WebGL API. This is implemented in a new `WebGLPointsLayer` which does simple rendering of large number
of points with custom shaders.

This is now used in the `Heatmap` layer.

The removed classes and components are:
* `WebGLMap` and `WebGLMapRenderer`
* `WebGLLayerRenderer`
* `WebGLImageLayer` and `WebGLImageLayerRenderer`
* `WebGLTileLayer` and `WebGLTileLayerRenderer`
* `WebGLVectorLayer` and `WebGLVectorLayerRenderer`
* `WebGLReplay` and derived classes, along with associated shaders
* `WebGLReplayGroup`
* `WebGLImmediateRenderer`
* `WebGLMap`
* The shader build process using `mustache` and the `Makefile` at the root

##### Removal of the AtlasManager

Following the removal of the experimental WebGL renderer, the AtlasManager has been removed as well. The atlas was only used by this renderer.
The non API `getChecksum` functions of the style is also removed.

##### Change of the behavior of the vector source's clear() and refresh() methods

The `ol/source/Vector#clear()` method no longer triggers a reload of the data from the server. If you were previously using `clear()` to refetch from the server, you now have to use `refresh()`.

The `ol/source/Vector#refresh()` method now removes all features from the source and triggers a reload of the data from the server. If you were previously using the `refresh()` method to re-render a vector layer, you should instead call `ol/layer/Vector#changed()`.

##### Renaming of `getGetFeatureInfoUrl` to `getFeatureInfoUrl`

The `getGetFeatureInfoUrl` of `ol/source/ImageWMS` and `ol/source/TileWMS` is now called `getFeatureInfoUrl`.

##### `getFeaturesAtPixel` always returns an array

`getFeaturesAtPixel` now returns an empty array instead of null if no features were found.

##### Hit detection with unfilled styles

Hit detection over styled Circle geometry and Circle and RegularShape styles is now consistent with that for styled Polygon geometry. There is no hit detection over the interior of unfilled shapes. To get the previous behavior, specify a Fill style with transparent color.

#### Other changes

##### Allow declutter in image render mode

It is now possible to configure vector tile layers with `declutter: true` and `renderMode: 'image'`. However, note that decluttering will be done per tile, resulting in labels and point symbols getting cut off at tile boundaries.
Until now, using both options forced the render mode to be `hybrid`.

##### Always load tiles while animating or interacting

`ol/PluggableMap` and subclasses no longer support the `loadTilesWhileAnimating` and `loadTilesWhileInteracting` options. These options were used to enable tile loading during animations and interactions. With the new DOM composition render strategy, it is no longer necessary to postpone tile loading until after animations or interactions.

## Changes

 * [#10036](https://github.com/openlayers/openlayers/pull/10036) - uploading local resources to codesandbox ([@KlausBenndorf](https://github.com/KlausBenndorf))
 * [#10035](https://github.com/openlayers/openlayers/pull/10035) - Support building the legacy build on windows ([@tschaub](https://github.com/tschaub))
 * [#10034](https://github.com/openlayers/openlayers/pull/10034) - Mark experimental examples as experimental ([@openlayers](https://github.com/openlayers))
 * [#10009](https://github.com/openlayers/openlayers/pull/10009) - Geometry editing with a user projection ([@tschaub](https://github.com/tschaub))
 * [#10024](https://github.com/openlayers/openlayers/pull/10024) - Allow EventTarget to use a different default target ([@ahocevar](https://github.com/ahocevar))
 * [#10031](https://github.com/openlayers/openlayers/pull/10031) - Cache starting coordinates and add mapBrowserEvent to translateEvent ([@flexjoly](https://github.com/flexjoly))
 * [#10029](https://github.com/openlayers/openlayers/pull/10029) - Fix link to map default controls ([@ahocevar](https://github.com/ahocevar))
 * [#10032](https://github.com/openlayers/openlayers/pull/10032) - Do not remove listeners that do not exist ([@ahocevar](https://github.com/ahocevar))
 * [#10030](https://github.com/openlayers/openlayers/pull/10030) - Add a rule to disallow describe.only() and it.only() in tests ([@tschaub](https://github.com/tschaub))
 * [#10023](https://github.com/openlayers/openlayers/pull/10023) - Enhance regular shape example docs ([@marcjansen](https://github.com/marcjansen))
 * [#10025](https://github.com/openlayers/openlayers/pull/10025) - Bugfix for vector-tile-selection example ([@KaiVolland](https://github.com/KaiVolland))
 * [#10007](https://github.com/openlayers/openlayers/pull/10007) - Changes for #9395 CircleStyle inconsistency ([@mike-000](https://github.com/mike-000))
 * [#10027](https://github.com/openlayers/openlayers/pull/10027) - Confirm zoomByDelta calls view.animate() ([@tschaub](https://github.com/tschaub))
 * [#10016](https://github.com/openlayers/openlayers/pull/10016) - WebGL Points Layer: allow expressions in literal style ([@jahow](https://github.com/jahow))
 * [#10017](https://github.com/openlayers/openlayers/pull/10017) - updated jsdoc-plugin-typescript ([@KlausBenndorf](https://github.com/KlausBenndorf))
 * [#10012](https://github.com/openlayers/openlayers/pull/10012) - Use the user projection for the map event coordinate ([@tschaub](https://github.com/tschaub))
 * [#10018](https://github.com/openlayers/openlayers/pull/10018) - Recover from skip feature removal regressions ([@ahocevar](https://github.com/ahocevar))
 * [#10013](https://github.com/openlayers/openlayers/pull/10013) - Minor reworking of the modify interaction ([@tschaub](https://github.com/tschaub))
 * [#10015](https://github.com/openlayers/openlayers/pull/10015) - Fix hit detection test for wrapped geometries ([@jahow](https://github.com/jahow))
 * [#10011](https://github.com/openlayers/openlayers/pull/10011) - Fix a type checking error on the WebGL points renderer ([@jahow](https://github.com/jahow))
 * [#10010](https://github.com/openlayers/openlayers/pull/10010) - Require type and listener for addEventListener/removeEventListener ([@ahocevar](https://github.com/ahocevar))
 * [#9994](https://github.com/openlayers/openlayers/pull/9994) - Add a new layer type: WebGLPointsLayer ([@jahow](https://github.com/jahow))
 * [#10006](https://github.com/openlayers/openlayers/pull/10006) - Check hits for wrapped around geometries ([@KlausBenndorf](https://github.com/KlausBenndorf))
 * [#10004](https://github.com/openlayers/openlayers/pull/10004) - Return a new simplified geometry after modification ([@tschaub](https://github.com/tschaub))
 * [#10005](https://github.com/openlayers/openlayers/pull/10005) - Fix some cosmetics on Select interaction ([@tkohr](https://github.com/tkohr))
 * [#10003](https://github.com/openlayers/openlayers/pull/10003) - Add back Select interaction without overlay ([@tkohr](https://github.com/tkohr))
 * [#10000](https://github.com/openlayers/openlayers/pull/10000) - Adopt JSDoc annotations to allow '.d.ts' generation ([@KaiVolland](https://github.com/KaiVolland))
 * [#10001](https://github.com/openlayers/openlayers/pull/10001) - reduced typecasts in layerrenderer ([@KlausBenndorf](https://github.com/KlausBenndorf))
 * [#9986](https://github.com/openlayers/openlayers/pull/9986) - Make Circle geometry hit detection consistent with Polygon ([@mike-000](https://github.com/mike-000))
 * [#9999](https://github.com/openlayers/openlayers/pull/9999) - fixed typescript issues ([@KlausBenndorf](https://github.com/KlausBenndorf))
 * [#9997](https://github.com/openlayers/openlayers/pull/9997) - Avoid error from tsc ([@tschaub](https://github.com/tschaub))
 * [#9993](https://github.com/openlayers/openlayers/pull/9993) - Add geographic tests for hasFeatureAtPixel and getFeaturesAtPixel ([@tschaub](https://github.com/tschaub))
 * [#9992](https://github.com/openlayers/openlayers/pull/9992) - Rendering test instructions ([@tschaub](https://github.com/tschaub))
 * [#9982](https://github.com/openlayers/openlayers/pull/9982) - Don't use vendor prefixes for the transform property ([@fredj](https://github.com/fredj))
 * [#9989](https://github.com/openlayers/openlayers/pull/9989) - Correct getFeaturesAtPixel spelling and grammar ([@mike-000](https://github.com/mike-000))
 * [#9988](https://github.com/openlayers/openlayers/pull/9988) - Additional changes to work with user projection ([@tschaub](https://github.com/tschaub))
 * [#9973](https://github.com/openlayers/openlayers/pull/9973) - Make map work with user projected coordinates ([@tkohr](https://github.com/tkohr))
 * [#9981](https://github.com/openlayers/openlayers/pull/9981) - Remove simplified geometry cache ([@KlausBenndorf](https://github.com/KlausBenndorf))
 * [#9980](https://github.com/openlayers/openlayers/pull/9980) - Get simplified transformed geometry ([@tschaub](https://github.com/tschaub))
 * [#9984](https://github.com/openlayers/openlayers/pull/9984) - Don't attempt to render when there is no source ([@ahocevar](https://github.com/ahocevar))
 * [#9983](https://github.com/openlayers/openlayers/pull/9983) - getFeaturesAtPixel always returns array ([@KlausBenndorf](https://github.com/KlausBenndorf))
 * [#9960](https://github.com/openlayers/openlayers/pull/9960) - Always dispatch pointermove events, but calculate event pixel and coordinate lazily ([@ahocevar](https://github.com/ahocevar))
 * [#9978](https://github.com/openlayers/openlayers/pull/9978) - Handle empty source tiles and queue them properly ([@ahocevar](https://github.com/ahocevar))
 * [#9974](https://github.com/openlayers/openlayers/pull/9974) - Introduces the _withCredentials flag ([@KaiVolland](https://github.com/KaiVolland))
 * [#9966](https://github.com/openlayers/openlayers/pull/9966) - Document how to circumvent the canvas reuse optimization ([@jahow](https://github.com/jahow))
 * [#9961](https://github.com/openlayers/openlayers/pull/9961) - SelectInteraction removal ([@KlausBenndorf](https://github.com/KlausBenndorf))
 * [#9957](https://github.com/openlayers/openlayers/pull/9957) - Get hasOverlay from child element count ([@ahocevar](https://github.com/ahocevar))
 * [#9969](https://github.com/openlayers/openlayers/pull/9969) - Dev version based on time ([@tschaub](https://github.com/tschaub))
 * [#9965](https://github.com/openlayers/openlayers/pull/9965) - Transform the layer extent when a user projection is set ([@tschaub](https://github.com/tschaub))
 * [#9967](https://github.com/openlayers/openlayers/pull/9967) - Enable HTTPS on Mapbox tile layer in webgl sprite example ([@jahow](https://github.com/jahow))
 * [#9964](https://github.com/openlayers/openlayers/pull/9964) - Update various examples to use the Mapbox v4-API ([@marcjansen](https://github.com/marcjansen))
 * [#9963](https://github.com/openlayers/openlayers/pull/9963) - Update to work with globby@10 ([@tschaub](https://github.com/tschaub))
 * [#9962](https://github.com/openlayers/openlayers/pull/9962) - Improve the API description for "multiWorld" ([@mike-000](https://github.com/mike-000))
 * [#9710](https://github.com/openlayers/openlayers/pull/9710) - Additional Typescript compliance fixes ([@jahow](https://github.com/jahow))
 * [#9400](https://github.com/openlayers/openlayers/pull/9400) - Changes to parsing of KML displayName ([@KaiVolland](https://github.com/KaiVolland))
 * [#9959](https://github.com/openlayers/openlayers/pull/9959) - Set frame state extent when creating frame state ([@tschaub](https://github.com/tschaub))
 * [#9899](https://github.com/openlayers/openlayers/pull/9899) - Add hidpi option for ol.source.TileArcGISRest ([@LevN0](https://github.com/LevN0))
 * [#9723](https://github.com/openlayers/openlayers/pull/9723) - Pass the opt_direction value to the getConstrainedResolution function ([@fredj](https://github.com/fredj))
 * [#9903](https://github.com/openlayers/openlayers/pull/9903) - Respect multiWorld: false when an explicit extent constraint would be respected ([@mike-000](https://github.com/mike-000))
 * [#9846](https://github.com/openlayers/openlayers/pull/9846) - Make API work with user projected coordinates ([@tschaub](https://github.com/tschaub))
 * [#9935](https://github.com/openlayers/openlayers/pull/9935) - Add missing import for LinearRing ([@Abdullah0991](https://github.com/Abdullah0991))
 * [#9931](https://github.com/openlayers/openlayers/pull/9931) - Custom Overview Map CSS fix and rotateWithView option ([@mike-000](https://github.com/mike-000))
 * [#9951](https://github.com/openlayers/openlayers/pull/9951) - New test for Image layer with extent and rotation ([@mike-000](https://github.com/mike-000))
 * [#9831](https://github.com/openlayers/openlayers/pull/9831) - Support a LAYER param in getLegendUrl ([@KlausBenndorf](https://github.com/KlausBenndorf))
 * [#9942](https://github.com/openlayers/openlayers/pull/9942) - Renaming getGetFeatureInfoUrl ([@KlausBenndorf](https://github.com/KlausBenndorf))
 * [#9930](https://github.com/openlayers/openlayers/pull/9930) - Correct extent clipping in ImageLayer ([@mike-000](https://github.com/mike-000))
 * [#9923](https://github.com/openlayers/openlayers/pull/9923) - Cancel postrender before disposing renderer ([@ahocevar](https://github.com/ahocevar))
 * [#9925](https://github.com/openlayers/openlayers/pull/9925) - Workflow to publish a dev release ([@openlayers](https://github.com/openlayers))
 * [#9919](https://github.com/openlayers/openlayers/pull/9919) - Revise and correct OverviewMap rotation ([@mike-000](https://github.com/mike-000))
 * [#9908](https://github.com/openlayers/openlayers/pull/9908) - LineString.forEachSegment callback API description ([@mike-000](https://github.com/mike-000))
 * [#9909](https://github.com/openlayers/openlayers/pull/9909) - Clone the text's padding ([@oterral](https://github.com/oterral))
 * [#9907](https://github.com/openlayers/openlayers/pull/9907) - Prevent endless cycles observed in OverviewMap ([@mike-000](https://github.com/mike-000))
 * [#9897](https://github.com/openlayers/openlayers/pull/9897) - Use pointer events everywhere ([@ahocevar](https://github.com/ahocevar))
 * [#9888](https://github.com/openlayers/openlayers/pull/9888) - Use PointerEvent polyfill instead of our own abstraction ([@ahocevar](https://github.com/ahocevar))
 * [#9896](https://github.com/openlayers/openlayers/pull/9896) - Misc. WebGL fixes ([@jahow](https://github.com/jahow))
 * [#9889](https://github.com/openlayers/openlayers/pull/9889) - Event performance improvements ([@ahocevar](https://github.com/ahocevar))
 * [#9882](https://github.com/openlayers/openlayers/pull/9882) - Handle rotation in the Box Selection example ([@mike-000](https://github.com/mike-000))
 * [#9877](https://github.com/openlayers/openlayers/pull/9877) - Fix -1 pixel buffer for vector tile extent ([@ahocevar](https://github.com/ahocevar))
 * [#9873](https://github.com/openlayers/openlayers/pull/9873) - Only check extent when a url tile coordinate is available ([@ahocevar](https://github.com/ahocevar))
 * [#9871](https://github.com/openlayers/openlayers/pull/9871) - Properly handle tile source key change ([@ahocevar](https://github.com/ahocevar))
 * [#9870](https://github.com/openlayers/openlayers/pull/9870) - Declutter multi geometries per geometry instead of per feature ([@ahocevar](https://github.com/ahocevar))
 * [#9872](https://github.com/openlayers/openlayers/pull/9872) - Check extent for wrapped tile coordinate ([@ahocevar](https://github.com/ahocevar))
 * [#9869](https://github.com/openlayers/openlayers/pull/9869) - Only get squared tolerance once per render ([@MoonE](https://github.com/MoonE))
 * [#9389](https://github.com/openlayers/openlayers/pull/9389) - Replaces listener test in tile.tests.js and removes artifacts ([@KaiVolland](https://github.com/KaiVolland))
 * [#9855](https://github.com/openlayers/openlayers/pull/9855) - Make sure vector tile load handler is called ([@tschaub](https://github.com/tschaub))
 * [#9864](https://github.com/openlayers/openlayers/pull/9864) - Properly update frameState.animate and deal with non-numeric layer opacity ([@tschaub](https://github.com/tschaub))
 * [#9858](https://github.com/openlayers/openlayers/pull/9858) - Run npm audit fix ([@tschaub](https://github.com/tschaub))
 * [#9844](https://github.com/openlayers/openlayers/pull/9844) - Set initial tile state to EMPTY when outside source extent ([@ahocevar](https://github.com/ahocevar))
 * [#9839](https://github.com/openlayers/openlayers/pull/9839) - Enable correct display of side-by-side example when not using the examples template ([@mike-000](https://github.com/mike-000))
 * [#9838](https://github.com/openlayers/openlayers/pull/9838) - Make WMSServerType appear in API docs ([@ahocevar](https://github.com/ahocevar))
 * [#9754](https://github.com/openlayers/openlayers/pull/9754) - Export PDF example extent corrections ([@mike-000](https://github.com/mike-000))
 * [#9834](https://github.com/openlayers/openlayers/pull/9834) - Use nextzen for osm-vector-tiles example ([@ahocevar](https://github.com/ahocevar))
 * [#9833](https://github.com/openlayers/openlayers/pull/9833) - Remove accidentally added package-lock.json ([@ahocevar](https://github.com/ahocevar))
 * [#9826](https://github.com/openlayers/openlayers/pull/9826) - Accept additional args when publishing ([@tschaub](https://github.com/tschaub))
 * [#9812](https://github.com/openlayers/openlayers/pull/9812) - Make zDirection configurable on tile source ([@ahocevar](https://github.com/ahocevar))
 * [#9824](https://github.com/openlayers/openlayers/pull/9824) - Support zoom limits for layers ([@tschaub](https://github.com/tschaub))
 * [#9804](https://github.com/openlayers/openlayers/pull/9804) - Replacement for the Shared Views example ([@mike-000](https://github.com/mike-000))
 * [#9803](https://github.com/openlayers/openlayers/pull/9803) - Remove unused variable in MousePosition control ([@openlayers](https://github.com/openlayers))
 * [#9802](https://github.com/openlayers/openlayers/pull/9802) - Introduce EMPTY image state to deal with images outside the view extent ([@ahocevar](https://github.com/ahocevar))
 * [#9797](https://github.com/openlayers/openlayers/pull/9797) - Avoid false positives for line and polygon hit detection ([@ahocevar](https://github.com/ahocevar))
 * [#9794](https://github.com/openlayers/openlayers/pull/9794) - Fix linting error (import extension missing) ([@marcjansen](https://github.com/marcjansen))
 * [#9792](https://github.com/openlayers/openlayers/pull/9792) - Improve documentation of getGetLegendGraphicUrl ([@marcjansen](https://github.com/marcjansen))
 * [#9375](https://github.com/openlayers/openlayers/pull/9375) - Replaces reproj image.tests.js and tile.tests.js ([@KaiVolland](https://github.com/KaiVolland))
 * [#9762](https://github.com/openlayers/openlayers/pull/9762) - Get legend request ([@KlausBenndorf](https://github.com/KlausBenndorf))
 * [#9789](https://github.com/openlayers/openlayers/pull/9789) - Use Image.prototype.decode only when src is already set ([@ahocevar](https://github.com/ahocevar))
 * [#9778](https://github.com/openlayers/openlayers/pull/9778) - Return existing source tiles if at target resolution ([@ahocevar](https://github.com/ahocevar))
 * [#9622](https://github.com/openlayers/openlayers/pull/9622) - Avoid mutating input in EsriJSON format ([@kekel87](https://github.com/kekel87))
 * [#9755](https://github.com/openlayers/openlayers/pull/9755) - Font loading improvements ([@ahocevar](https://github.com/ahocevar))
 * [#9767](https://github.com/openlayers/openlayers/pull/9767) - Fix hit detection for webgl layers on retina devices ([@jahow](https://github.com/jahow))
 * [#9774](https://github.com/openlayers/openlayers/pull/9774) - Fix observable properties documentation ([@ahocevar](https://github.com/ahocevar))
 * [#9757](https://github.com/openlayers/openlayers/pull/9757) - Use CanvasLineJoin and CanvasLienCap types instead of string ([@fredj](https://github.com/fredj))
 * [#9745](https://github.com/openlayers/openlayers/pull/9745) - Simplify heatmap's shaders ([@fredj](https://github.com/fredj))
 * [#9748](https://github.com/openlayers/openlayers/pull/9748) - Remove hit detection transforms from ol/renderer/webgl/PointsLayer ([@fredj](https://github.com/fredj))
 * [#9752](https://github.com/openlayers/openlayers/pull/9752) - Custom Animation example and the multiWorld view constraint ([@mike-000](https://github.com/mike-000))
 * [#9751](https://github.com/openlayers/openlayers/pull/9751) - Add minArea typedef and ctor prop in DragZoom ([@logan-bounet](https://github.com/logan-bounet))
 * [#9747](https://github.com/openlayers/openlayers/pull/9747) - Set world projection only for tile-pixels units ([@ahocevar](https://github.com/ahocevar))
 * [#9743](https://github.com/openlayers/openlayers/pull/9743) - Finalize IIIF Image API version 3 ([@lutzhelm](https://github.com/lutzhelm))
 * [#9733](https://github.com/openlayers/openlayers/pull/9733) - Get rid of JSDoc warnings and fix fires arguments ([@ahocevar](https://github.com/ahocevar))
 * [#9732](https://github.com/openlayers/openlayers/pull/9732) - Fix EMPTY state and source key handling ([@ahocevar](https://github.com/ahocevar))
 * [#9724](https://github.com/openlayers/openlayers/pull/9724) - Fix wrong import in tutorial ([@fredj](https://github.com/fredj))
 * [#9722](https://github.com/openlayers/openlayers/pull/9722) - Remove unused param in getState function ([@fredj](https://github.com/fredj))
 * [#9655](https://github.com/openlayers/openlayers/pull/9655) - Add hit detection on the WebGL points renderer ([@jahow](https://github.com/jahow))
 * [#9728](https://github.com/openlayers/openlayers/pull/9728) - Remove accidently added package-lock.json ([@ahocevar](https://github.com/ahocevar))
 * [#9719](https://github.com/openlayers/openlayers/pull/9719) - Use special MapTiler API key dedicated for OpenLayers examples ([@petrsloup](https://github.com/petrsloup))
 * [#9714](https://github.com/openlayers/openlayers/pull/9714) - Update the circle style after setRadius calls ([@fredj](https://github.com/fredj))
 * [#9718](https://github.com/openlayers/openlayers/pull/9718) - Remove unused variable in ol/renderer/webgl/PointsLayer ([@fredj](https://github.com/fredj))
 * [#9711](https://github.com/openlayers/openlayers/pull/9711) - Remove extra space for the 'viewParams' attribute ([@fredj](https://github.com/fredj))
 * [#9712](https://github.com/openlayers/openlayers/pull/9712) - Allow an arbitrary tag to be used as feature id ([@tschaub](https://github.com/tschaub))
 * [#9709](https://github.com/openlayers/openlayers/pull/9709) - Try to make rendering tests run again in puppeteer ([@ahocevar](https://github.com/ahocevar))
 * [#9705](https://github.com/openlayers/openlayers/pull/9705) - Vector tile renderer optimizations and fixes ([@ahocevar](https://github.com/ahocevar))
 * [#9706](https://github.com/openlayers/openlayers/pull/9706) - Do not use self to check browser features ([@ahocevar](https://github.com/ahocevar))
 * [#9704](https://github.com/openlayers/openlayers/pull/9704) - Handle container reuse properly when layers are added/removed ([@ahocevar](https://github.com/ahocevar))
 * [#9701](https://github.com/openlayers/openlayers/pull/9701) - Remove will-change CSS rule for Overlay container ([@fredj](https://github.com/fredj))
 * [#9702](https://github.com/openlayers/openlayers/pull/9702) - Fix several TypeScript type check problems ([@lutzhelm](https://github.com/lutzhelm))
 * [#9700](https://github.com/openlayers/openlayers/pull/9700) - Solves typescript related issues ([@KaiVolland](https://github.com/KaiVolland))
 * [#9699](https://github.com/openlayers/openlayers/pull/9699) - Fix MapTiler API usage ([@petrsloup](https://github.com/petrsloup))
 * [#9636](https://github.com/openlayers/openlayers/pull/9636) - Remove and move code from ol/webgl ([@fredj](https://github.com/fredj))
 * [#9684](https://github.com/openlayers/openlayers/pull/9684) - List complete classes in doc navigation ([@ahocevar](https://github.com/ahocevar))
 * [#9685](https://github.com/openlayers/openlayers/pull/9685) - Remove glContext from RenderEvent ([@fredj](https://github.com/fredj))
 * [#9681](https://github.com/openlayers/openlayers/pull/9681) - Remove duplicates from api docs and make navigation more usable ([@ahocevar](https://github.com/ahocevar))
 * [#9677](https://github.com/openlayers/openlayers/pull/9677) - Add support for tile pixel projection in feature formats ([@ahocevar](https://github.com/ahocevar))
 * [#9679](https://github.com/openlayers/openlayers/pull/9679) - Set pixelTransform and inversePixelTransform as protected ([@fredj](https://github.com/fredj))
 * [#9678](https://github.com/openlayers/openlayers/pull/9678) - Update geography class urls ([@ahocevar](https://github.com/ahocevar))
 * [#9658](https://github.com/openlayers/openlayers/pull/9658) - Don't use HTMLImageElement.decode method on Safari ([@fredj](https://github.com/fredj))
 * [#9657](https://github.com/openlayers/openlayers/pull/9657) - Better documentation for getFeaturesInExtent function ([@fredj](https://github.com/fredj))
 * [#9562](https://github.com/openlayers/openlayers/pull/9562) - Optimize the WebGL points renderer using a worker ([@jahow](https://github.com/jahow))
 * [#9394](https://github.com/openlayers/openlayers/pull/9394) - Introduces import snippets for static functions ([@KaiVolland](https://github.com/KaiVolland))
 * [#9638](https://github.com/openlayers/openlayers/pull/9638) - #9625: Add filter function to translate interaction ([@agpixdev](https://github.com/agpixdev))
 * [#9644](https://github.com/openlayers/openlayers/pull/9644) - Use compose function from ol/transform ([@fredj](https://github.com/fredj))
 * [#9645](https://github.com/openlayers/openlayers/pull/9645) - Handle case of no used tiles ([@ahocevar](https://github.com/ahocevar))
 * [#9640](https://github.com/openlayers/openlayers/pull/9640) - Import options directly instead of importing a typedef ([@ahocevar](https://github.com/ahocevar))
 * [#9641](https://github.com/openlayers/openlayers/pull/9641) - Only import what's needed from projections ([@ahocevar](https://github.com/ahocevar))
 * [#9637](https://github.com/openlayers/openlayers/pull/9637) - Detach label cache on Map#setTarget() ([@ahocevar](https://github.com/ahocevar))
 * [#9633](https://github.com/openlayers/openlayers/pull/9633) -  Mark the `layers` property as optional in OverviewMap constructor ([@fredj](https://github.com/fredj))
 * [#9634](https://github.com/openlayers/openlayers/pull/9634) - Remove old Android workaround ([@ahocevar](https://github.com/ahocevar))
 * [#9629](https://github.com/openlayers/openlayers/pull/9629) - Clear overlay canvas when reusing containers ([@ahocevar](https://github.com/ahocevar))
 * [#9626](https://github.com/openlayers/openlayers/pull/9626) - Remove TOUCH, POINTER and MSPOINTER from ol/has ([@fredj](https://github.com/fredj))
 * [#9624](https://github.com/openlayers/openlayers/pull/9624) - Remove typecasts in ol/control/OverviewMap ([@fredj](https://github.com/fredj))
 * [#9615](https://github.com/openlayers/openlayers/pull/9615) - Include full filename in import specifier ([@tschaub](https://github.com/tschaub))
 * [#9592](https://github.com/openlayers/openlayers/pull/9592) - Remove `layerState` param from `prepareFrame` and `renderFrame` function ([@fredj](https://github.com/fredj))
 * [#9289](https://github.com/openlayers/openlayers/pull/9289) - Vector source geom ([@sbrunner](https://github.com/sbrunner))
 * [#9608](https://github.com/openlayers/openlayers/pull/9608) - Use markdown link syntax in jsdoc ([@fredj](https://github.com/fredj))
 * [#9596](https://github.com/openlayers/openlayers/pull/9596) - Vector source / prevent adding features with duplicate id in the collection ([@jahow](https://github.com/jahow))
 * [#9604](https://github.com/openlayers/openlayers/pull/9604) - Use window instead of global in addEventListener ([@bartvde](https://github.com/bartvde))
 * [#9599](https://github.com/openlayers/openlayers/pull/9599) - Create FUNDING.yml ([@openlayers](https://github.com/openlayers))
 * [#9601](https://github.com/openlayers/openlayers/pull/9601) - Use global addEventListener in PluggableMap ([@bartvde](https://github.com/bartvde))
 * [#9584](https://github.com/openlayers/openlayers/pull/9584) - Reuse render target ([@ahocevar](https://github.com/ahocevar))
 * [#6217](https://github.com/openlayers/openlayers/pull/6217) - Add primaryAction condition to DragPan ([@fredj](https://github.com/fredj))
 * [#9569](https://github.com/openlayers/openlayers/pull/9569) - Fix for change in Zoomify.js/CustomTile signature ([@engsterhold](https://github.com/engsterhold))
 * [#9582](https://github.com/openlayers/openlayers/pull/9582) - Add app to mark inactive issues as stale ([@tschaub](https://github.com/tschaub))
 * [#9581](https://github.com/openlayers/openlayers/pull/9581) - Update webpack and use mode in the loader ([@tschaub](https://github.com/tschaub))
 * [#9576](https://github.com/openlayers/openlayers/pull/9576) - Remove geolocation detection from ol/has ([@fredj](https://github.com/fredj))
 * [#9575](https://github.com/openlayers/openlayers/pull/9575) - Rework exports for getUid and control defaults ([@tschaub](https://github.com/tschaub))
 * [#9574](https://github.com/openlayers/openlayers/pull/9574) - Update OL MapGuide example to point to my demo MapGuide Server. ([@jumpinjackie](https://github.com/jumpinjackie))
 * [#9571](https://github.com/openlayers/openlayers/pull/9571) - Small examples improvements ([@fredj](https://github.com/fredj))
 * [#9572](https://github.com/openlayers/openlayers/pull/9572) - Add a note about CSS removal in upgrade-notes.md ([@fredj](https://github.com/fredj))
 * [#9570](https://github.com/openlayers/openlayers/pull/9570) - Remove CSS print rules in ol.css ([@fredj](https://github.com/fredj))
 * [#9563](https://github.com/openlayers/openlayers/pull/9563) - Fix @abstract and @module annotations ([@tschaub](https://github.com/tschaub))
 * [#9560](https://github.com/openlayers/openlayers/pull/9560) - Simplify loading detection loop ([@ahocevar](https://github.com/ahocevar))
 * [#9561](https://github.com/openlayers/openlayers/pull/9561) - Remove memory leak caused by label cache listeners ([@ahocevar](https://github.com/ahocevar))
 * [#9559](https://github.com/openlayers/openlayers/pull/9559) - Minify worker ([@tschaub](https://github.com/tschaub))
 * [#9558](https://github.com/openlayers/openlayers/pull/9558) - Stop listening for image decoding ([@tschaub](https://github.com/tschaub))
 * [#9550](https://github.com/openlayers/openlayers/pull/9550) - Setup for building workers ([@tschaub](https://github.com/tschaub))
 * [#9555](https://github.com/openlayers/openlayers/pull/9555) - Remove unused roundUpToPowerOfTwo function ([@fredj](https://github.com/fredj))
 * [#9551](https://github.com/openlayers/openlayers/pull/9551) - Use HTMLImageElement.decode if available ([@fredj](https://github.com/fredj))
 * [#9500](https://github.com/openlayers/openlayers/pull/9500) - KML string validation with extendedData ([@edellucien](https://github.com/edellucien))
 * [#9534](https://github.com/openlayers/openlayers/pull/9534) - Remove unnecessary parts from the Mapbox layer example ([@tschaub](https://github.com/tschaub))
 * [#9548](https://github.com/openlayers/openlayers/pull/9548) - Avoid cut off labels for italic fonts ([@ahocevar](https://github.com/ahocevar))
 * [#9549](https://github.com/openlayers/openlayers/pull/9549) - Remove unused getReplayTransform_ function in VectorTileLayer ([@fredj](https://github.com/fredj))
 * [#9545](https://github.com/openlayers/openlayers/pull/9545) - Avoid panning off the edge of the world ([@tschaub](https://github.com/tschaub))
 * [#9539](https://github.com/openlayers/openlayers/pull/9539) - Document existing error event type ([@tschaub](https://github.com/tschaub))
 * [#9541](https://github.com/openlayers/openlayers/pull/9541) - Upgrade to rbush@3 ([@tschaub](https://github.com/tschaub))
 * [#9543](https://github.com/openlayers/openlayers/pull/9543) - Update jsdoc-plugin-typescript to version 2.0.1 ([@tschaub](https://github.com/tschaub))
 * [#9536](https://github.com/openlayers/openlayers/pull/9536) - More font cache hits ([@ahocevar](https://github.com/ahocevar))
 * [#9537](https://github.com/openlayers/openlayers/pull/9537) - WebGL / Points renderer refactoring ([@jahow](https://github.com/jahow))
 * [#9546](https://github.com/openlayers/openlayers/pull/9546) - Lazily create the hit detection context ([@fredj](https://github.com/fredj))
 * [#9533](https://github.com/openlayers/openlayers/pull/9533) - Canvas optimizations ([@fredj](https://github.com/fredj))
 * [#9538](https://github.com/openlayers/openlayers/pull/9538) - Correct the module annotation for the vector image layer renderer ([@tschaub](https://github.com/tschaub))
 * [#9532](https://github.com/openlayers/openlayers/pull/9532) - Remove unused 'container' property in mapbox-layer example ([@fredj](https://github.com/fredj))
 * [#9530](https://github.com/openlayers/openlayers/pull/9530) - Fix spelling ([@fredj](https://github.com/fredj))
 * [#9489](https://github.com/openlayers/openlayers/pull/9489) - Fix Zoomify to display retina tiles ([@crubier](https://github.com/crubier))
 * [#9525](https://github.com/openlayers/openlayers/pull/9525) - Support a custom render function for the Layer class ([@jahow](https://github.com/jahow))
 * [#9522](https://github.com/openlayers/openlayers/pull/9522) - Use https urls for mapbox.com ([@fredj](https://github.com/fredj))
 * [#9520](https://github.com/openlayers/openlayers/pull/9520) - [WIP] Improve IIIF tile source and parser documentation ([@lutzhelm](https://github.com/lutzhelm))
 * [#9523](https://github.com/openlayers/openlayers/pull/9523) - Make the code simpler in the Mapbox example ([@jahow](https://github.com/jahow))
 * [#9519](https://github.com/openlayers/openlayers/pull/9519) - Use synchronous render in Mapbox example ([@jahow](https://github.com/jahow))
 * [#9518](https://github.com/openlayers/openlayers/pull/9518) - Fix hit detection for multiple layers when decluttering is off ([@ahocevar](https://github.com/ahocevar))
 * [#9516](https://github.com/openlayers/openlayers/pull/9516) - Upgrade ol-mapbox-style to v5 ([@ahocevar](https://github.com/ahocevar))
 * [#9505](https://github.com/openlayers/openlayers/pull/9505) - Avoid blurry vector tiles ([@ahocevar](https://github.com/ahocevar))
 * [#9430](https://github.com/openlayers/openlayers/pull/9430) - Adds IIIF Image API tile source ([@lutzhelm](https://github.com/lutzhelm))
 * [#9512](https://github.com/openlayers/openlayers/pull/9512) - Mapbox layer example improvement ([@fredj](https://github.com/fredj))
 * [#9511](https://github.com/openlayers/openlayers/pull/9511) - Update devDependencies ([@fredj](https://github.com/fredj))
 * [#9504](https://github.com/openlayers/openlayers/pull/9504) - Minor examples fixes ([@fredj](https://github.com/fredj))
 * [#9466](https://github.com/openlayers/openlayers/pull/9466) - Declutter in correct order and for all layers ([@ahocevar](https://github.com/ahocevar))
 * [#9497](https://github.com/openlayers/openlayers/pull/9497) - Fix earth radius in documentation ([@simonseyock](https://github.com/simonseyock))
 * [#9493](https://github.com/openlayers/openlayers/pull/9493) - Upgrade jsdoc to v3.6.1 ([@ahocevar](https://github.com/ahocevar))
 * [#9490](https://github.com/openlayers/openlayers/pull/9490) - Misc. API doc improvements ([@jahow](https://github.com/jahow))
 * [#9492](https://github.com/openlayers/openlayers/pull/9492) - Fix zIndex handling for unmanaged layers ([@ahocevar](https://github.com/ahocevar))
 * [#9388](https://github.com/openlayers/openlayers/pull/9388) - Restore code coverage report ([@jahow](https://github.com/jahow))
 * [#9487](https://github.com/openlayers/openlayers/pull/9487) - Avoid header expanding over examples ([@tschaub](https://github.com/tschaub))
 * [#9488](https://github.com/openlayers/openlayers/pull/9488) - Set the 'lang' attribute to the html tag in examples ([@openlayers](https://github.com/openlayers))
 * [#9484](https://github.com/openlayers/openlayers/pull/9484) - Build API docs in CI job ([@tschaub](https://github.com/tschaub))
 * [#9476](https://github.com/openlayers/openlayers/pull/9476) - Document events fired by interactions ([@tschaub](https://github.com/tschaub))
 * [#9475](https://github.com/openlayers/openlayers/pull/9475) - Call the color callback once per feature ([@tschaub](https://github.com/tschaub))
 * [#9477](https://github.com/openlayers/openlayers/pull/9477) - Tidy up the JSDoc events plugin ([@tschaub](https://github.com/tschaub))
 * [#9469](https://github.com/openlayers/openlayers/pull/9469) - Use nearest lower resolution of vector tiles ([@ahocevar](https://github.com/ahocevar))
 * [#9452](https://github.com/openlayers/openlayers/pull/9452) - Fewer calls to the WebGL color callback ([@tschaub](https://github.com/tschaub))
 * [#9453](https://github.com/openlayers/openlayers/pull/9453) - Remove unnecessary closure and fix uniform type ([@tschaub](https://github.com/tschaub))
 * [#9459](https://github.com/openlayers/openlayers/pull/9459) - Use html-to-image instead of dom-to-image-more ([@fredj](https://github.com/fredj))
 * [#9450](https://github.com/openlayers/openlayers/pull/9450) - Set the interacting flag on pointerdrag instead of pointerdown ([@ahocevar](https://github.com/ahocevar))
 * [#9439](https://github.com/openlayers/openlayers/pull/9439) - Add attributionsCollapsible option to source/VectorTile ([@ahocevar](https://github.com/ahocevar))
 * [#9440](https://github.com/openlayers/openlayers/pull/9440) - Skip the header and bad data in CSV parsing ([@tschaub](https://github.com/tschaub))
 * [#9442](https://github.com/openlayers/openlayers/pull/9442) - Disable opacity transition for raster source sources ([@ahocevar](https://github.com/ahocevar))
 * [#9441](https://github.com/openlayers/openlayers/pull/9441) - Do not round view center to pixels ([@ahocevar](https://github.com/ahocevar))
 * [#9435](https://github.com/openlayers/openlayers/pull/9435) - Set the default values after the property name ([@fredj](https://github.com/fredj))
 * [#9433](https://github.com/openlayers/openlayers/pull/9433) - Remove unused private variables, remove trailing whitespace ([@fredj](https://github.com/fredj))
 * [#9416](https://github.com/openlayers/openlayers/pull/9416) - Implement rotate and translate functions for circle geometry ([@fredj](https://github.com/fredj))
 * [#9429](https://github.com/openlayers/openlayers/pull/9429) - Update all devDependencies ([@fredj](https://github.com/fredj))
 * [#9425](https://github.com/openlayers/openlayers/pull/9425) - Remove unused ol/render/webgl module ([@fredj](https://github.com/fredj))
 * [#9418](https://github.com/openlayers/openlayers/pull/9418) - Re-export GeometryCollection in ol/geom ([@ahocevar](https://github.com/ahocevar))
 * [#9411](https://github.com/openlayers/openlayers/pull/9411) - Fix tile state condition in raster layer test ([@fredj](https://github.com/fredj))
 * [#9410](https://github.com/openlayers/openlayers/pull/9410) - Add new maxDelta property to MouseWheelZoom constructor ([@fredj](https://github.com/fredj))
 * [#9409](https://github.com/openlayers/openlayers/pull/9409) - Remove more opt_this parameters ([@fredj](https://github.com/fredj))
 * [#9286](https://github.com/openlayers/openlayers/pull/9286) - Disable transition when an interim tile is available ([@ahocevar](https://github.com/ahocevar))
 * [#9404](https://github.com/openlayers/openlayers/pull/9404) - View / apply constraints when an interaction starts ([@jahow](https://github.com/jahow))
 * [#9390](https://github.com/openlayers/openlayers/pull/9390) - Add a new WebGL example for filtering features ([@jahow](https://github.com/jahow))
 * [#9385](https://github.com/openlayers/openlayers/pull/9385) - PointsLayer added clear of the render Buffers on Source Change ([@Kai-W](https://github.com/Kai-W))
 * [#9379](https://github.com/openlayers/openlayers/pull/9379) - Fix typo in vector tile source docs ([@openlayers](https://github.com/openlayers))
 * [#9368](https://github.com/openlayers/openlayers/pull/9368) - Show only one world ([@ahocevar](https://github.com/ahocevar))
 * [#9362](https://github.com/openlayers/openlayers/pull/9362) - Use local font "Ubuntu Regular" for rendering tests ([@KaiVolland](https://github.com/KaiVolland))
 * [#9357](https://github.com/openlayers/openlayers/pull/9357) - Render vector tiles at the view resolution ([@ahocevar](https://github.com/ahocevar))
 * [#9374](https://github.com/openlayers/openlayers/pull/9374) - Fix view initialization with min/max resolution constraint ([@jahow](https://github.com/jahow))
 * [#9364](https://github.com/openlayers/openlayers/pull/9364) - Replace clip.test.js with new tests ([@KaiVolland](https://github.com/KaiVolland))
 * [#9360](https://github.com/openlayers/openlayers/pull/9360) - Enables attributions for the RasterSource ([@KaiVolland](https://github.com/KaiVolland))
 * [#9365](https://github.com/openlayers/openlayers/pull/9365) - Fix View method name in upgrade notes ([@jahow](https://github.com/jahow))
 * [#9361](https://github.com/openlayers/openlayers/pull/9361) -  Add a zDirection option for Zoomify - implements #9343 ([@lutzhelm](https://github.com/lutzhelm))
 * [#9333](https://github.com/openlayers/openlayers/pull/9333) - Unify rendering tests ([@KaiVolland](https://github.com/KaiVolland))
 * [#9350](https://github.com/openlayers/openlayers/pull/9350) - Remove unnecessary css in examples ([@fredj](https://github.com/fredj))
 * [#9351](https://github.com/openlayers/openlayers/pull/9351) - More efficient default styles ([@ahocevar](https://github.com/ahocevar))
 * [#9346](https://github.com/openlayers/openlayers/pull/9346) - Remove tilePixelRatio options from ol.source.VectorTile ([@fredj](https://github.com/fredj))
 * [#9345](https://github.com/openlayers/openlayers/pull/9345) - Update all dev dependencies ([@fredj](https://github.com/fredj))
 * [#9341](https://github.com/openlayers/openlayers/pull/9341) - Remove unused ExecutorGroup methods ([@ahocevar](https://github.com/ahocevar))
 * [#9337](https://github.com/openlayers/openlayers/pull/9337) - Set map div size in example send to codesandbox ([@fredj](https://github.com/fredj))
 * [#9335](https://github.com/openlayers/openlayers/pull/9335) - Create codesandbox using the 'parcel' template ([@openlayers](https://github.com/openlayers))
 * [#9329](https://github.com/openlayers/openlayers/pull/9329) - Don't refresh the layer after addFeatures call ([@fredj](https://github.com/fredj))
 * [#9328](https://github.com/openlayers/openlayers/pull/9328) - Mark layerFilter in AtPixelOptions as optional ([@fredj](https://github.com/fredj))
 * [#9325](https://github.com/openlayers/openlayers/pull/9325) - Create a more accurate origin for tile positioning ([@ahocevar](https://github.com/ahocevar))
 * [#9320](https://github.com/openlayers/openlayers/pull/9320) - enhance tile-debug readability ([@RobertOrthofer](https://github.com/RobertOrthofer))
 * [#9318](https://github.com/openlayers/openlayers/pull/9318) - Smart cache size ([@ahocevar](https://github.com/ahocevar))
 * [#9322](https://github.com/openlayers/openlayers/pull/9322) - Use closest lower source resolution for render tiles ([@ahocevar](https://github.com/ahocevar))
 * [#9321](https://github.com/openlayers/openlayers/pull/9321) - Fixes #9294 (missing documention for methods with `@inheritDoc`) ([@KaiVolland](https://github.com/KaiVolland))
 * [#9319](https://github.com/openlayers/openlayers/pull/9319) - Add title to license to clarify that it is BSD 2-Clause ([@tschaub](https://github.com/tschaub))
 * [#9300](https://github.com/openlayers/openlayers/pull/9300) - Fix documentation about zoomDelta for ol.interaction.default function ([@fredj](https://github.com/fredj))
 * [#9305](https://github.com/openlayers/openlayers/pull/9305) - Fixes failing tests for Chrome v74 ([@KaiVolland](https://github.com/KaiVolland))
 * [#9315](https://github.com/openlayers/openlayers/pull/9315) - Change CSS class for tooltips in measure example ([@fredj](https://github.com/fredj))
 * [#9137](https://github.com/openlayers/openlayers/pull/9137) - Refactor the way view constraints are handled & add a view extent constraint ([@jahow](https://github.com/jahow))
 * [#9313](https://github.com/openlayers/openlayers/pull/9313) - Re-enable and fix disabled tests ([@ahocevar](https://github.com/ahocevar))
 * [#9314](https://github.com/openlayers/openlayers/pull/9314) - Fix transpilation ([@ahocevar](https://github.com/ahocevar))
 * [#9308](https://github.com/openlayers/openlayers/pull/9308) - Simplify vector tile projection handling ([@ahocevar](https://github.com/ahocevar))
 * [#9312](https://github.com/openlayers/openlayers/pull/9312) - Update zoom levels for Stamen source ([@bartvde](https://github.com/bartvde))
 * [#9310](https://github.com/openlayers/openlayers/pull/9310) - Add transition options to Stamen source ([@fredj](https://github.com/fredj))
 * [#9307](https://github.com/openlayers/openlayers/pull/9307) - Take line-height into account when measuring text height ([@ahocevar](https://github.com/ahocevar))
 * [#9306](https://github.com/openlayers/openlayers/pull/9306) - Set the canvas size to 0 on dispose ([@fredj](https://github.com/fredj))
 * [#9295](https://github.com/openlayers/openlayers/pull/9295) - Update ol-mapbox-style to fix broken mapbox-style example ([@ahocevar](https://github.com/ahocevar))
 * [#9292](https://github.com/openlayers/openlayers/pull/9292) - Downgrades puppeteer to `~1.11.0` ([@KaiVolland](https://github.com/KaiVolland))
 * [#9266](https://github.com/openlayers/openlayers/pull/9266) - Full type definition for image vector layer options ([@tschaub](https://github.com/tschaub))
 * [#9278](https://github.com/openlayers/openlayers/pull/9278) - Update Bing's imagerySet used in examples ([@fredj](https://github.com/fredj))
 * [#9270](https://github.com/openlayers/openlayers/pull/9270) - Update faq.md ([@bvx89](https://github.com/bvx89))
 * [#9277](https://github.com/openlayers/openlayers/pull/9277) - Rotate API token ([@ahocevar](https://github.com/ahocevar))
 * [#9276](https://github.com/openlayers/openlayers/pull/9276) - Use the constructor options instead of changing the private variables ([@fredj](https://github.com/fredj))
 * [#9275](https://github.com/openlayers/openlayers/pull/9275) - Remove setDeclutter function ([@fredj](https://github.com/fredj))
 * [#9273](https://github.com/openlayers/openlayers/pull/9273) - Fix WMS GetFeatureInfo examples ([@chrismayer](https://github.com/chrismayer))
 * [#9246](https://github.com/openlayers/openlayers/pull/9246) - Add missing ol.css in mobile-full-screen example ([@openlayers](https://github.com/openlayers))
 * [#9264](https://github.com/openlayers/openlayers/pull/9264) - add question about resizing map element ([@tpluscode](https://github.com/tpluscode))
 * [#9260](https://github.com/openlayers/openlayers/pull/9260) - Remove unused 'geometry' param from ol/render/canvas/Builder ([@fredj](https://github.com/fredj))
 * [#9254](https://github.com/openlayers/openlayers/pull/9254) - Add tileSize option to ol/source/TileJSON ([@petrsloup](https://github.com/petrsloup))
 * [#9250](https://github.com/openlayers/openlayers/pull/9250) - Clearer behaviour of clear() and refresh() on sources ([@ahocevar](https://github.com/ahocevar))
 * [#9251](https://github.com/openlayers/openlayers/pull/9251) - Fix cache size calculation ([@ahocevar](https://github.com/ahocevar))
 * [#9110](https://github.com/openlayers/openlayers/pull/9110) - Add TilePixelRatio to Zoomify ([@crubier](https://github.com/crubier))
 * [#9244](https://github.com/openlayers/openlayers/pull/9244) - add stylus only and touch only mode to drawing a shape ([@huyngkh](https://github.com/huyngkh))
 * [#9240](https://github.com/openlayers/openlayers/pull/9240) - Add setRotateWithView function to ol/style/Text ([@fredj](https://github.com/fredj))
 * [#9230](https://github.com/openlayers/openlayers/pull/9230) - Consider all tiles for hit detection when decluttering ([@ahocevar](https://github.com/ahocevar))
 * [#9237](https://github.com/openlayers/openlayers/pull/9237) - Fix zoom after export to PDF is done ([@umbe1987](https://github.com/umbe1987))
 * [#9239](https://github.com/openlayers/openlayers/pull/9239) - Run tests in Puppeteer and non headless mode ([@ahocevar](https://github.com/ahocevar))
 * [#9236](https://github.com/openlayers/openlayers/pull/9236) - Move params list to the constructor function ([@fredj](https://github.com/fredj))
 * [#9233](https://github.com/openlayers/openlayers/pull/9233) - Remove deprecated {get,set}SnapToPixel functions ([@fredj](https://github.com/fredj))
 * [#9231](https://github.com/openlayers/openlayers/pull/9231) - Set vector tile extent earlier ([@ahocevar](https://github.com/ahocevar))
 * [#9224](https://github.com/openlayers/openlayers/pull/9224) - Remove vendor prefix for the 'transform' CSS property and fullscreen api ([@fredj](https://github.com/fredj))
 * [#9222](https://github.com/openlayers/openlayers/pull/9222) - Update all dev dependencies ([@fredj](https://github.com/fredj))
 * [#9221](https://github.com/openlayers/openlayers/pull/9221) - Remove unused sortByZIndex function ([@ahocevar](https://github.com/ahocevar))
 * [#9220](https://github.com/openlayers/openlayers/pull/9220) - Don't resize/clear the vector renderer canvas ([@fredj](https://github.com/fredj))
 * [#9217](https://github.com/openlayers/openlayers/pull/9217) - Don't use loadImage function to avoid infinite loading loop ([@fredj](https://github.com/fredj))
 * [#9212](https://github.com/openlayers/openlayers/pull/9212) - Remove unnecessary type cast ([@fredj](https://github.com/fredj))
 * [#9201](https://github.com/openlayers/openlayers/pull/9201) - Only consider child range with drawable tiles ([@ahocevar](https://github.com/ahocevar))
 * [#9204](https://github.com/openlayers/openlayers/pull/9204) - Add missing 'include' section ([@ahocevar](https://github.com/ahocevar))
 * [#9203](https://github.com/openlayers/openlayers/pull/9203) - Only promise what we can deliver regarding IntelliSense ([@ahocevar](https://github.com/ahocevar))
 * [#9200](https://github.com/openlayers/openlayers/pull/9200) - Add upgrade note about renderMode: 'image' for vector layers ([@ahocevar](https://github.com/ahocevar))
 * [#9197](https://github.com/openlayers/openlayers/pull/9197) - Remove unused opt_this param ([@fredj](https://github.com/fredj))
 * [#9196](https://github.com/openlayers/openlayers/pull/9196) - getPointResolution returns resolution in projection units ([@ahocevar](https://github.com/ahocevar))
 * [#9190](https://github.com/openlayers/openlayers/pull/9190) - Fix MultiPolygon area calculation ([@romanzoller](https://github.com/romanzoller))
 * [#9179](https://github.com/openlayers/openlayers/pull/9179) - Allow declutter with image render mode ([@gberaudo](https://github.com/gberaudo))
 * [#9187](https://github.com/openlayers/openlayers/pull/9187) -  Remove unnecessary type cast ([@fredj](https://github.com/fredj))
 * [#9186](https://github.com/openlayers/openlayers/pull/9186) - Simplify typing in EsriJSON format ([@fredj](https://github.com/fredj))
 * [#9161](https://github.com/openlayers/openlayers/pull/9161) - Use type template for the source type of layers ([@fredj](https://github.com/fredj))
 * [#9184](https://github.com/openlayers/openlayers/pull/9184) - Update all dev dependencies ([@fredj](https://github.com/fredj))
 * [#9178](https://github.com/openlayers/openlayers/pull/9178) - Sources in npm package for TypeScript support ([@ahocevar](https://github.com/ahocevar))
 * [#9181](https://github.com/openlayers/openlayers/pull/9181) - Add test to verify that removefeature is triggered ([@ahocevar](https://github.com/ahocevar))
 * [#9173](https://github.com/openlayers/openlayers/pull/9173) - Document the correct render events ([@ahocevar](https://github.com/ahocevar))
 * [#9167](https://github.com/openlayers/openlayers/pull/9167) - JSDoc fixes ([@ahocevar](https://github.com/ahocevar))
 * [#9164](https://github.com/openlayers/openlayers/pull/9164) - event chain documentation ([@KlausBenndorf](https://github.com/KlausBenndorf))
 * [#9157](https://github.com/openlayers/openlayers/pull/9157) - Remove deprecated inherits function ([@fredj](https://github.com/fredj))
 * [#9152](https://github.com/openlayers/openlayers/pull/9152) - Vector tile optimizations ([@ahocevar](https://github.com/ahocevar))
 * [#9154](https://github.com/openlayers/openlayers/pull/9154) - Safer check for window.screen ([@ahocevar](https://github.com/ahocevar))
 * [#9150](https://github.com/openlayers/openlayers/pull/9150) - Avoid clipping when rendering to tiles that don't exceed the clip extent ([@ahocevar](https://github.com/ahocevar))
 * [#9149](https://github.com/openlayers/openlayers/pull/9149) - Keep track of used labels ([@ahocevar](https://github.com/ahocevar))
 * [#9131](https://github.com/openlayers/openlayers/pull/9131) - Don't use strict comparison with style.opacity ([@fredj](https://github.com/fredj))
 * [#9013](https://github.com/openlayers/openlayers/pull/9013) - Added scalebar option to ol.control.scaleline ([@weskamm](https://github.com/weskamm))
 * [#9133](https://github.com/openlayers/openlayers/pull/9133) - Reduce memory footprint of tiles and labels ([@ahocevar](https://github.com/ahocevar))
 * [#9129](https://github.com/openlayers/openlayers/pull/9129) - Reduce garbage generation ([@fredj](https://github.com/fredj))
 * [#9128](https://github.com/openlayers/openlayers/pull/9128) - Use less render cycles for vector tile layers ([@ahocevar](https://github.com/ahocevar))
 * [#9120](https://github.com/openlayers/openlayers/pull/9120) - Update all dev dependencies ([@fredj](https://github.com/fredj))
 * [#9118](https://github.com/openlayers/openlayers/pull/9118) - Don't dispatch change events when reading features ([@fredj](https://github.com/fredj))
 * [#9114](https://github.com/openlayers/openlayers/pull/9114) - Faster extent calculation with less garbage ([@ahocevar](https://github.com/ahocevar))
 * [#9109](https://github.com/openlayers/openlayers/pull/9109) - Make package.json valid json object ([@JosephSamela](https://github.com/JosephSamela))
 * [#9112](https://github.com/openlayers/openlayers/pull/9112) - Properly unregister prepareTile listeners ([@ahocevar](https://github.com/ahocevar))
 * [#9103](https://github.com/openlayers/openlayers/pull/9103) - Make examples more user friendly ([@ahocevar](https://github.com/ahocevar))
 * [#9107](https://github.com/openlayers/openlayers/pull/9107) - Fix cgiar csi URL due to #9106 ([@webgeodatavore](https://github.com/webgeodatavore))
 * [#9058](https://github.com/openlayers/openlayers/pull/9058) - Move all tile loading from the VectorImageTile to the source ([@ahocevar](https://github.com/ahocevar))
 * [#9102](https://github.com/openlayers/openlayers/pull/9102) - Use dom-to-image library in export-pdf example ([@openlayers](https://github.com/openlayers))
 * [#9072](https://github.com/openlayers/openlayers/pull/9072) - Remove 'layerStates' property from the FrameState ([@fredj](https://github.com/fredj))
 * [#9101](https://github.com/openlayers/openlayers/pull/9101) - Always load tiles while animating and interacting ([@ahocevar](https://github.com/ahocevar))
 * [#9099](https://github.com/openlayers/openlayers/pull/9099) - Allow users to opt out of tracking ([@ahocevar](https://github.com/ahocevar))
 * [#9098](https://github.com/openlayers/openlayers/pull/9098) - External types bugfix for jsdoc-plugin-typescript ([@ahocevar](https://github.com/ahocevar))
 * [#9083](https://github.com/openlayers/openlayers/pull/9083) - Reset lastDragTime when condition is not met ([@ahocevar](https://github.com/ahocevar))
 * [#9090](https://github.com/openlayers/openlayers/pull/9090) - Add texture & color to the WebGL points renderer ([@jahow](https://github.com/jahow))
 * [#9091](https://github.com/openlayers/openlayers/pull/9091) - Fix heatmap example in IE ([@jahow](https://github.com/jahow))
 * [#9089](https://github.com/openlayers/openlayers/pull/9089) - Replace rawgit with jsdelivr due to #9082 comment ([@ThomasG77](https://github.com/ThomasG77))
 * [#9079](https://github.com/openlayers/openlayers/pull/9079) - Listen to all fullscreen event types ([@ahocevar](https://github.com/ahocevar))
 * [#9070](https://github.com/openlayers/openlayers/pull/9070) - Modify.removePoint returns true only when a vertex was removed ([@ludvigeriksson](https://github.com/ludvigeriksson))
 * [#9068](https://github.com/openlayers/openlayers/pull/9068) - Use 'PBF' type instead of 'Object' in ol/format/MVT ([@fredj](https://github.com/fredj))
 * [#9066](https://github.com/openlayers/openlayers/pull/9066) - Rework transformWithOptions ([@fredj](https://github.com/fredj))
 * [#9064](https://github.com/openlayers/openlayers/pull/9064) - Remove Atlas, AtlasManager and getChecksum functions ([@fredj](https://github.com/fredj))
 * [#9060](https://github.com/openlayers/openlayers/pull/9060) - Avoid unexpected behavior when passing string coordinates ([@ahocevar](https://github.com/ahocevar))
 * [#9063](https://github.com/openlayers/openlayers/pull/9063) - Fix module name ([@oterral](https://github.com/oterral))
 * [#9056](https://github.com/openlayers/openlayers/pull/9056) - Remove typecast for object literals ([@fredj](https://github.com/fredj))
 * [#9057](https://github.com/openlayers/openlayers/pull/9057) - Use FeatureLike typedef ([@fredj](https://github.com/fredj))
 * [#9055](https://github.com/openlayers/openlayers/pull/9055) - Remove type cast in ol.View ([@fredj](https://github.com/fredj))
 * [#9008](https://github.com/openlayers/openlayers/pull/9008) - Decouple render instruction creation from rendering ([@ahocevar](https://github.com/ahocevar))
 * [#9045](https://github.com/openlayers/openlayers/pull/9045) - Remove CANVAS_LINE_DASH from ol/has ([@openlayers](https://github.com/openlayers))
 * [#9044](https://github.com/openlayers/openlayers/pull/9044) - Fix comments indentation ([@openlayers](https://github.com/openlayers))
 * [#9043](https://github.com/openlayers/openlayers/pull/9043) -  Fix type notation in examples ([@openlayers](https://github.com/openlayers))
 * [#9041](https://github.com/openlayers/openlayers/pull/9041) - Reworked the Webgl Heatmap layer & associated utilities ([@jahow](https://github.com/jahow))
 * [#9042](https://github.com/openlayers/openlayers/pull/9042) - Change onBoxEnd property in DragBox options to optional ([@openlayers](https://github.com/openlayers))
 * [#9039](https://github.com/openlayers/openlayers/pull/9039) - Add ': void' to non returning functions (error TS7014) ([@OSHistory](https://github.com/OSHistory))
 * [#9024](https://github.com/openlayers/openlayers/pull/9024) - Add prerender and postrender events for Image layer ([@ahocevar](https://github.com/ahocevar))
 * [#9028](https://github.com/openlayers/openlayers/pull/9028) - Specify the return array as coordinates ([@OSHistory](https://github.com/OSHistory))
 * [#9036](https://github.com/openlayers/openlayers/pull/9036) -  Remove drag segments of removed features ([@ahocevar](https://github.com/ahocevar))
 * [#9031](https://github.com/openlayers/openlayers/pull/9031) - Call insertVertexCondition only when a vertex acually can be inserted ([@ludvigeriksson](https://github.com/ludvigeriksson))
 * [#9029](https://github.com/openlayers/openlayers/pull/9029) - Use camel-cased inheritDoc for consistency ([@OSHistory](https://github.com/OSHistory))
 * [#9026](https://github.com/openlayers/openlayers/pull/9026) - Update ol-mapbox-style and jsdoc-plugin-typescript ([@ahocevar](https://github.com/ahocevar))
 * [#9025](https://github.com/openlayers/openlayers/pull/9025) - Remove unused render event ([@ahocevar](https://github.com/ahocevar))
 * [#9023](https://github.com/openlayers/openlayers/pull/9023) - Fix webgl PointsLayer not rendering anything ([@jahow](https://github.com/jahow))
 * [#9022](https://github.com/openlayers/openlayers/pull/9022) - Use WebGL even with major performance caveat ([@ahocevar](https://github.com/ahocevar))
 * [#9020](https://github.com/openlayers/openlayers/pull/9020) - Remove superfluous setTileUrlFunction call ([@ahocevar](https://github.com/ahocevar))
 * [#9018](https://github.com/openlayers/openlayers/pull/9018) - Duplicate @property for style and renderOrder ([@OSHistory](https://github.com/OSHistory))
 * [#9012](https://github.com/openlayers/openlayers/pull/9012) - Change projection and urls properties in sources options to optional ([@fredj](https://github.com/fredj))
 * [#9010](https://github.com/openlayers/openlayers/pull/9010) - Fix ExecutorGroup.js file location in comments ([@fredj](https://github.com/fredj))
 * [#9009](https://github.com/openlayers/openlayers/pull/9009) -  Revert "Simplify import path in examples" ([@fredj](https://github.com/fredj))
 * [#9005](https://github.com/openlayers/openlayers/pull/9005) - Simplify import path in examples ([@fredj](https://github.com/fredj))
 * [#9003](https://github.com/openlayers/openlayers/pull/9003) - Remove unused Builder/Executor functions and members ([@ahocevar](https://github.com/ahocevar))
 * [#9002](https://github.com/openlayers/openlayers/pull/9002) - Fix module path ([@openlayers](https://github.com/openlayers))
 * [#8996](https://github.com/openlayers/openlayers/pull/8996) - Add imageRatio option for VectorImage layers ([@fredj](https://github.com/fredj))
 * [#8995](https://github.com/openlayers/openlayers/pull/8995) - Remove leftover comments and code for 'vector' render mode ([@fredj](https://github.com/fredj))
 * [#8992](https://github.com/openlayers/openlayers/pull/8992) - Use standard tile coords ([@tschaub](https://github.com/tschaub))
 * [#8994](https://github.com/openlayers/openlayers/pull/8994) - Set projection property in sources options to optional ([@fredj](https://github.com/fredj))
 * [#8977](https://github.com/openlayers/openlayers/pull/8977) - Add WebGL rendering tests & improve the WebGLHelper API ([@jahow](https://github.com/jahow))
 * [#8990](https://github.com/openlayers/openlayers/pull/8990) - [Client] Remove renderFrame ([@nicholas-l](https://github.com/nicholas-l))
 * [#8988](https://github.com/openlayers/openlayers/pull/8988) - Pass along the ability to measure and cache text width ([@tschaub](https://github.com/tschaub))
 * [#8987](https://github.com/openlayers/openlayers/pull/8987) - Rendering test updates ([@tschaub](https://github.com/tschaub))
 * [#8983](https://github.com/openlayers/openlayers/pull/8983) - Add issue templates ([@openlayers](https://github.com/openlayers))
 * [#8982](https://github.com/openlayers/openlayers/pull/8982) - Stacking context for layers, overlays, and controls ([@tschaub](https://github.com/tschaub))
 * [#8980](https://github.com/openlayers/openlayers/pull/8980) - Change travis references to circleci in doc ([@fredj](https://github.com/fredj))
 * [#8976](https://github.com/openlayers/openlayers/pull/8976) - Scale tiles instead of canvas ([@ahocevar](https://github.com/ahocevar))
 * [#8970](https://github.com/openlayers/openlayers/pull/8970) - Fix zIndex positioning ([@ahocevar](https://github.com/ahocevar))
 * [#8968](https://github.com/openlayers/openlayers/pull/8968) - Use Object.values if available ([@fredj](https://github.com/fredj))
 * [#8972](https://github.com/openlayers/openlayers/pull/8972) - Remove unused rollup dependency ([@ahocevar](https://github.com/ahocevar))
 * [#8967](https://github.com/openlayers/openlayers/pull/8967) - Fix webgl types in ol/webgl/PostProcessingPass ([@fredj](https://github.com/fredj))
 * [#8969](https://github.com/openlayers/openlayers/pull/8969) - Create and use inverse pixel transforms during render ([@tschaub](https://github.com/tschaub))
 * [#8964](https://github.com/openlayers/openlayers/pull/8964) - Add index to the Collection events ([@fredj](https://github.com/fredj))
 * [#8915](https://github.com/openlayers/openlayers/pull/8915) - Use CSS z-index to order layers ([@fredj](https://github.com/fredj))
 * [#8923](https://github.com/openlayers/openlayers/pull/8923) - Use the composite renderer ([@tschaub](https://github.com/tschaub))
 * [#8951](https://github.com/openlayers/openlayers/pull/8951) - Remove legacy WebGL code & implement a lightweight API for point rendering ([@jahow](https://github.com/jahow))
 * [#8926](https://github.com/openlayers/openlayers/pull/8926) - Uncouple replay creation and rendering ([@gberaudo](https://github.com/gberaudo))
 * [#8952](https://github.com/openlayers/openlayers/pull/8952) - Port polygon-style rendering test ([@fredj](https://github.com/fredj))
 * [#8939](https://github.com/openlayers/openlayers/pull/8939) - Use ol/layer/Layer instead of ol/source/ImageCanvas in d3 example ([@fredj](https://github.com/fredj))
 * [#8957](https://github.com/openlayers/openlayers/pull/8957) - Fix JSdoc type cast format ([@fredj](https://github.com/fredj))
 * [#8934](https://github.com/openlayers/openlayers/pull/8934) - Port layer tiles rendering tests ([@fgravin](https://github.com/fgravin))
 * [#8944](https://github.com/openlayers/openlayers/pull/8944) - Use a layer for the graticule instead of a control ([@jahow](https://github.com/jahow))
 * [#8948](https://github.com/openlayers/openlayers/pull/8948) - Add rotation in mapbox-gl example ([@fgravin](https://github.com/fgravin))
 * [#8953](https://github.com/openlayers/openlayers/pull/8953) - Store rendering artifacts immediately after run tests ([@fredj](https://github.com/fredj))
 * [#8950](https://github.com/openlayers/openlayers/pull/8950) - Use shx to run unix commands in package.json ([@fredj](https://github.com/fredj))
 * [#8946](https://github.com/openlayers/openlayers/pull/8946) - Make the map renderer tolerant of layers without renderers ([@tschaub](https://github.com/tschaub))
 * [#8943](https://github.com/openlayers/openlayers/pull/8943) - Port text style rendering tests ([@fredj](https://github.com/fredj))
 * [#8940](https://github.com/openlayers/openlayers/pull/8940) - Make layers mandatory in the OverviewMap control ([@jahow](https://github.com/jahow))
 * [#8938](https://github.com/openlayers/openlayers/pull/8938) - Port render-toContext rendering test ([@fredj](https://github.com/fredj))
 * [#8941](https://github.com/openlayers/openlayers/pull/8941) - Rendering tests render message ([@fredj](https://github.com/fredj))
 * [#8933](https://github.com/openlayers/openlayers/pull/8933) - Port icon-symbol-svg rendering test ([@fredj](https://github.com/fredj))
 * [#8931](https://github.com/openlayers/openlayers/pull/8931) - Add Mapbox-gl-js example ([@fgravin](https://github.com/fgravin))
 * [#8937](https://github.com/openlayers/openlayers/pull/8937) - Make the tile debug source useful for understanding tiles ([@tschaub](https://github.com/tschaub))
 * [#8930](https://github.com/openlayers/openlayers/pull/8930) - Give the layers container a CSS class name ([@fredj](https://github.com/fredj))
 * [#8914](https://github.com/openlayers/openlayers/pull/8914) - Add new className property to ol/layer/Base ([@fredj](https://github.com/fredj))
 * [#8910](https://github.com/openlayers/openlayers/pull/8910) - Implements containsXY for all geometries ([@fredj](https://github.com/fredj))
 * [#8922](https://github.com/openlayers/openlayers/pull/8922) - Layer is reponsible for its renderer ([@fgravin](https://github.com/fgravin))
 * [#8936](https://github.com/openlayers/openlayers/pull/8936) - Serve sourcemaps from webpack during rendering tests ([@tschaub](https://github.com/tschaub))
 * [#8932](https://github.com/openlayers/openlayers/pull/8932) - Add pbf TypeScript type definitions ([@fredj](https://github.com/fredj))
 * [#8924](https://github.com/openlayers/openlayers/pull/8924) - Reuse vector tile replays for interim tiles ([@ahocevar](https://github.com/ahocevar))
 * [#8918](https://github.com/openlayers/openlayers/pull/8918) - Use dom-to-image-more library in export-map ([@fredj](https://github.com/fredj))
 * [#8928](https://github.com/openlayers/openlayers/pull/8928) - Add vector tile example using ol-mapbox-style ([@ahocevar](https://github.com/ahocevar))
 * [#8925](https://github.com/openlayers/openlayers/pull/8925) - Don't compute value more that once, remove unneeded type cast ([@fredj](https://github.com/fredj))
 * [#8927](https://github.com/openlayers/openlayers/pull/8927) - Use local data for rendering tests ([@tschaub](https://github.com/tschaub))
 * [#8920](https://github.com/openlayers/openlayers/pull/8920) - Remove unneeded 'relative' positioning ([@fredj](https://github.com/fredj))
 * [#8913](https://github.com/openlayers/openlayers/pull/8913) - Implement renderFrame function for intermediate canvas renderer ([@fgravin](https://github.com/fgravin))
 * [#8916](https://github.com/openlayers/openlayers/pull/8916) - Move canvas creation to intermediate canvas renderer constructor ([@tschaub](https://github.com/tschaub))
 * [#8917](https://github.com/openlayers/openlayers/pull/8917) - Apply all transforms in the layer renderer ([@tschaub](https://github.com/tschaub))
 * [#8912](https://github.com/openlayers/openlayers/pull/8912) - Rotation support in the composite renderer ([@tschaub](https://github.com/tschaub))
 * [#8908](https://github.com/openlayers/openlayers/pull/8908) - Handle layer opacity in the composite renderer ([@tschaub](https://github.com/tschaub))
 * [#8848](https://github.com/openlayers/openlayers/pull/8848) - Make layer renderers explicit layer dependencies ([@tschaub](https://github.com/tschaub))
 * [#8892](https://github.com/openlayers/openlayers/pull/8892) - Use the right device orientation property in example ([@fredj](https://github.com/fredj))
 * [#8904](https://github.com/openlayers/openlayers/pull/8904) - Add support for a default index page in the rendering tests ([@tschaub](https://github.com/tschaub))
 * [#8903](https://github.com/openlayers/openlayers/pull/8903) - Additional render tests ([@tschaub](https://github.com/tschaub))
 * [#8895](https://github.com/openlayers/openlayers/pull/8895) - New rendering tests ([@tschaub](https://github.com/tschaub))
 * [#8893](https://github.com/openlayers/openlayers/pull/8893) - Add proj.js to the sideEffects list ([@fredj](https://github.com/fredj))
 * [#8887](https://github.com/openlayers/openlayers/pull/8887) - Changes for 5.3.0 ([@openlayers](https://github.com/openlayers))


<details>
  <summary>Dependency Updates</summary>

 * [#9990](https://github.com/openlayers/openlayers/pull/9990) - Update handlebars to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9987](https://github.com/openlayers/openlayers/pull/9987) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9972](https://github.com/openlayers/openlayers/pull/9972) - Update handlebars to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9952](https://github.com/openlayers/openlayers/pull/9952) - Update handlebars to the latest version ([@openlayers](https://github.com/openlayers))
 * [#9932](https://github.com/openlayers/openlayers/pull/9932) - Greenkeeper/webpack 4.40.2 ([@openlayers](https://github.com/openlayers))
 * [#9928](https://github.com/openlayers/openlayers/pull/9928) - Update puppeteer to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9926](https://github.com/openlayers/openlayers/pull/9926) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9914](https://github.com/openlayers/openlayers/pull/9914) - Greenkeeper/terser webpack plugin 2.0.1 ([@openlayers](https://github.com/openlayers))
 * [#9886](https://github.com/openlayers/openlayers/pull/9886) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9880](https://github.com/openlayers/openlayers/pull/9880) - Greenkeeper/karma coverage 2.0.1 ([@openlayers](https://github.com/openlayers))
 * [#9876](https://github.com/openlayers/openlayers/pull/9876) - Update yargs to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9856](https://github.com/openlayers/openlayers/pull/9856) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9857](https://github.com/openlayers/openlayers/pull/9857) - Update karma-chrome-launcher to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9817](https://github.com/openlayers/openlayers/pull/9817) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9827](https://github.com/openlayers/openlayers/pull/9827) - Update coveralls to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9816](https://github.com/openlayers/openlayers/pull/9816) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9801](https://github.com/openlayers/openlayers/pull/9801) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9795](https://github.com/openlayers/openlayers/pull/9795) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9793](https://github.com/openlayers/openlayers/pull/9793) - Update puppeteer to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9787](https://github.com/openlayers/openlayers/pull/9787) - Update mocha to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9786](https://github.com/openlayers/openlayers/pull/9786) - chore(package): update webpack to version 4.36.1 ([@openlayers](https://github.com/openlayers))
 * [#9775](https://github.com/openlayers/openlayers/pull/9775) - Update jsdoc to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9772](https://github.com/openlayers/openlayers/pull/9772) - Update karma-chrome-launcher to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9769](https://github.com/openlayers/openlayers/pull/9769) - Update coveralls to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9759](https://github.com/openlayers/openlayers/pull/9759) - Update marked to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9763](https://github.com/openlayers/openlayers/pull/9763) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9744](https://github.com/openlayers/openlayers/pull/9744) - chore(package): update webpack to version 4.35.2 ([@openlayers](https://github.com/openlayers))
 * [#9738](https://github.com/openlayers/openlayers/pull/9738) - Update marked to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9737](https://github.com/openlayers/openlayers/pull/9737) - Update globby to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9703](https://github.com/openlayers/openlayers/pull/9703) - Update eslint to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9698](https://github.com/openlayers/openlayers/pull/9698) - Update puppeteer to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9695](https://github.com/openlayers/openlayers/pull/9695) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9673](https://github.com/openlayers/openlayers/pull/9673) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9660](https://github.com/openlayers/openlayers/pull/9660) - Update pixelmatch to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9653](https://github.com/openlayers/openlayers/pull/9653) - Update coveralls to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9649](https://github.com/openlayers/openlayers/pull/9649) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9598](https://github.com/openlayers/openlayers/pull/9598) - Update puppeteer to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9594](https://github.com/openlayers/openlayers/pull/9594) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9589](https://github.com/openlayers/openlayers/pull/9589) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9586](https://github.com/openlayers/openlayers/pull/9586) - Update rollup-plugin-terser to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9553](https://github.com/openlayers/openlayers/pull/9553) - chore(package): update ol-mapbox-style to version 5.0.0-beta.2 ([@openlayers](https://github.com/openlayers))
 * [#9528](https://github.com/openlayers/openlayers/pull/9528) - Update puppeteer to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9517](https://github.com/openlayers/openlayers/pull/9517) - Update jsdoc to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9515](https://github.com/openlayers/openlayers/pull/9515) - Update fs-extra to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9508](https://github.com/openlayers/openlayers/pull/9508) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9486](https://github.com/openlayers/openlayers/pull/9486) - Update jquery to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9468](https://github.com/openlayers/openlayers/pull/9468) - Update puppeteer to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9444](https://github.com/openlayers/openlayers/pull/9444) - Update mocha to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9432](https://github.com/openlayers/openlayers/pull/9432) - Update handlebars to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9431](https://github.com/openlayers/openlayers/pull/9431) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9427](https://github.com/openlayers/openlayers/pull/9427) - Update mocha to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9420](https://github.com/openlayers/openlayers/pull/9420) - Update jquery to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9412](https://github.com/openlayers/openlayers/pull/9412) - Update mocha to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9408](https://github.com/openlayers/openlayers/pull/9408) - chore(package): update mocha to version 6.1.1 ([@openlayers](https://github.com/openlayers))
 * [#9406](https://github.com/openlayers/openlayers/pull/9406) - Update clean-css-cli to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9405](https://github.com/openlayers/openlayers/pull/9405) - Update marked to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9387](https://github.com/openlayers/openlayers/pull/9387) - Update puppeteer to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9342](https://github.com/openlayers/openlayers/pull/9342) - Update handlebars to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9311](https://github.com/openlayers/openlayers/pull/9311) - Update pbf to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9285](https://github.com/openlayers/openlayers/pull/9285) - Update globby to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9280](https://github.com/openlayers/openlayers/pull/9280) - Update ol-mapbox-style to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9279](https://github.com/openlayers/openlayers/pull/9279) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9268](https://github.com/openlayers/openlayers/pull/9268) - Update mocha to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9261](https://github.com/openlayers/openlayers/pull/9261) - Update coveralls to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9256](https://github.com/openlayers/openlayers/pull/9256) - Update mocha to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9247](https://github.com/openlayers/openlayers/pull/9247) - Update copy-webpack-plugin to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9242](https://github.com/openlayers/openlayers/pull/9242) - Update marked to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9238](https://github.com/openlayers/openlayers/pull/9238) - Update mocha to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9232](https://github.com/openlayers/openlayers/pull/9232) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9225](https://github.com/openlayers/openlayers/pull/9225) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9207](https://github.com/openlayers/openlayers/pull/9207) - Update yargs to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9195](https://github.com/openlayers/openlayers/pull/9195) - Update handlebars to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9194](https://github.com/openlayers/openlayers/pull/9194) - chore(package): update webpack to version 4.29.3 ([@openlayers](https://github.com/openlayers))
 * [#9185](https://github.com/openlayers/openlayers/pull/9185) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9148](https://github.com/openlayers/openlayers/pull/9148) - Update karma to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9124](https://github.com/openlayers/openlayers/pull/9124) - Update sinon to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9127](https://github.com/openlayers/openlayers/pull/9127) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9108](https://github.com/openlayers/openlayers/pull/9108) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9095](https://github.com/openlayers/openlayers/pull/9095) - Update marked to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9092](https://github.com/openlayers/openlayers/pull/9092) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9085](https://github.com/openlayers/openlayers/pull/9085) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9080](https://github.com/openlayers/openlayers/pull/9080) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9076](https://github.com/openlayers/openlayers/pull/9076) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9037](https://github.com/openlayers/openlayers/pull/9037) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9032](https://github.com/openlayers/openlayers/pull/9032) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#9004](https://github.com/openlayers/openlayers/pull/9004) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8989](https://github.com/openlayers/openlayers/pull/8989) - Update marked to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8978](https://github.com/openlayers/openlayers/pull/8978) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8966](https://github.com/openlayers/openlayers/pull/8966) - Update rollup to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8963](https://github.com/openlayers/openlayers/pull/8963) - Update rollup to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8905](https://github.com/openlayers/openlayers/pull/8905) - Update rollup to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8902](https://github.com/openlayers/openlayers/pull/8902) - Update rollup to the latest version 🚀 ([@openlayers](https://github.com/openlayers))


</details>
