# 6.1.0

With 47 pull requests, this release keeps up the momentum of the v6.x effort and brings several bug fixes, performance improvements and new features. In addition to that, we added some missing documentation to our API docs and gave them some usability improvements.

## New features

* A new, performance optimized hit detection API on the layer level, `Layer#getFeatures(pixel)` has been introduced. At this point it is implemented for vector, vector tile and image vector layers, and is recommended when performance is critical, e.g. for hit detection on mouseover.
* For the WebGLPoints layer, we made several additions to the style expressions system. This includes a `case` operator, support for array and string types, and type checking.

## List of all changes

 * [#10214](https://github.com/openlayers/openlayers/pull/10214) - WebGL / Add 'case' operator for style expressions ([@jahow](https://github.com/jahow))
 * [#10198](https://github.com/openlayers/openlayers/pull/10198) - WebGL renderer / use the specified loading strategy for the vector data ([@jahow](https://github.com/jahow))
 * [#10212](https://github.com/openlayers/openlayers/pull/10212) - Add config file for dependabot ([@fredj](https://github.com/fredj))
 * [#10187](https://github.com/openlayers/openlayers/pull/10187) - Set touch-action to allow native touch gestures ([@ahocevar](https://github.com/ahocevar))
 * [#10194](https://github.com/openlayers/openlayers/pull/10194) - Added check to make sure extent array has four objects. ([@MrSoUndso](https://github.com/MrSoUndso))
 * [#10204](https://github.com/openlayers/openlayers/pull/10204) - Avoid scrolling over navigation ([@tschaub](https://github.com/tschaub))
 * [#10205](https://github.com/openlayers/openlayers/pull/10205) - Add the default to the type column ([@tschaub](https://github.com/tschaub))
 * [#10178](https://github.com/openlayers/openlayers/pull/10178) - Make ol/interaction/Select#handleEvent return always true. ([@TieSKey](https://github.com/TieSKey))
 * [#10203](https://github.com/openlayers/openlayers/pull/10203) - Keep issues assigned to a milestone from going stale ([@tschaub](https://github.com/tschaub))
 * [#10200](https://github.com/openlayers/openlayers/pull/10200) - Carbon add on API docs ([@tschaub](https://github.com/tschaub))
 * [#10196](https://github.com/openlayers/openlayers/pull/10196) - Webgl / add support for string and arrays in style expressions ([@jahow](https://github.com/jahow))
 * [#10197](https://github.com/openlayers/openlayers/pull/10197) - Restore node v8 compatibility ([@ahocevar](https://github.com/ahocevar))
 * [#10195](https://github.com/openlayers/openlayers/pull/10195) - Treat hsl/hsla as named colors ([@mike-000](https://github.com/mike-000))
 * [#10188](https://github.com/openlayers/openlayers/pull/10188) - Document that map render events do not have a context set ([@ahocevar](https://github.com/ahocevar))
 * [#10184](https://github.com/openlayers/openlayers/pull/10184) - Clamp the weight value between 0 and 1 ([@fredj](https://github.com/fredj))
 * [#10175](https://github.com/openlayers/openlayers/pull/10175) - Remove description from type tag ([@tschaub](https://github.com/tschaub))
 * [#10176](https://github.com/openlayers/openlayers/pull/10176) - Avoid toggling when clicking the title ([@tschaub](https://github.com/tschaub))
 * [#10172](https://github.com/openlayers/openlayers/pull/10172) - Ensure inherited docs are shown ([@ahocevar](https://github.com/ahocevar))
 * [#10171](https://github.com/openlayers/openlayers/pull/10171) - Open default attributions links in a new tab or window ([@mike-000](https://github.com/mike-000))
 * [#10047](https://github.com/openlayers/openlayers/pull/10047) - Apidoc changes ([@KaiVolland](https://github.com/KaiVolland))
 * [#10161](https://github.com/openlayers/openlayers/pull/10161) - Implement getFeatures() for ol/layer/VectorImage ([@ahocevar](https://github.com/ahocevar))
 * [#10168](https://github.com/openlayers/openlayers/pull/10168) - Webgl / Add support for filtering and color interpolation in style expressions ([@jahow](https://github.com/jahow))
 * [#10170](https://github.com/openlayers/openlayers/pull/10170) - Add back html from select-features example ([@openlayers](https://github.com/openlayers))
 * [#10093](https://github.com/openlayers/openlayers/pull/10093) - Set label text for Graticule option styles ([@mike-000](https://github.com/mike-000))
 * [#10160](https://github.com/openlayers/openlayers/pull/10160) - Improve test in case of async call ([@ejn](https://github.com/ejn))
 * [#10159](https://github.com/openlayers/openlayers/pull/10159) - Fix target name collision in event.Target and Control ([@ejn](https://github.com/ejn))
 * [#10142](https://github.com/openlayers/openlayers/pull/10142) - Fix tilechange events ([@ahocevar](https://github.com/ahocevar))
 * [#10138](https://github.com/openlayers/openlayers/pull/10138) - Should be able to ovveride defaultvalue of style in selection. ([@wirdehall](https://github.com/wirdehall))
 * [#10135](https://github.com/openlayers/openlayers/pull/10135) - Revise the description of applyTransform for geometries ([@mike-000](https://github.com/mike-000))
 * [#10133](https://github.com/openlayers/openlayers/pull/10133) - Properly unregister source tile change listeners ([@ahocevar](https://github.com/ahocevar))
 * [#10094](https://github.com/openlayers/openlayers/pull/10094) - New Layer#getFeatures method with fast hit detection ([@ahocevar](https://github.com/ahocevar))
 * [#10104](https://github.com/openlayers/openlayers/pull/10104) - Remove font sizing from the attribution control ([@openlayers](https://github.com/openlayers))
 * [#10108](https://github.com/openlayers/openlayers/pull/10108) - Fix documentation for handleMoveEvent ([@notnotse](https://github.com/notnotse))
 * [#10118](https://github.com/openlayers/openlayers/pull/10118) - Document the OSM crossOrigin default ([@mike-000](https://github.com/mike-000))
 * [#10112](https://github.com/openlayers/openlayers/pull/10112) - No ERROR state for render tiles ([@ahocevar](https://github.com/ahocevar))
 * [#10115](https://github.com/openlayers/openlayers/pull/10115) - Improve Heatmap hit detection test ([@jahow](https://github.com/jahow))
 * [#10111](https://github.com/openlayers/openlayers/pull/10111) - Correct the defaulting of ol/source/VectorTile maxZoom ([@mike-000](https://github.com/mike-000))
 * [#10102](https://github.com/openlayers/openlayers/pull/10102) - Cosmetic type fixes ([@KlausBenndorf](https://github.com/KlausBenndorf))
 * [#10107](https://github.com/openlayers/openlayers/pull/10107) - Update Vector Tile Info example test for no features ([@mike-000](https://github.com/mike-000))
 * [#10097](https://github.com/openlayers/openlayers/pull/10097) - Align layer canvas to the left ([@fredj](https://github.com/fredj))
 * [#10101](https://github.com/openlayers/openlayers/pull/10101) - Add hit detection support on the Heatmap layer ([@jahow](https://github.com/jahow))
 * [#10087](https://github.com/openlayers/openlayers/pull/10087) - Add example showing vector tiles in EPSG:4326 ([@petrsloup](https://github.com/petrsloup))
 * [#10086](https://github.com/openlayers/openlayers/pull/10086) - Update mapbox-style example ([@petrsloup](https://github.com/petrsloup))
 * [#10083](https://github.com/openlayers/openlayers/pull/10083) - webgl points layer example fixes ([@MoonE](https://github.com/MoonE))
 * [#10076](https://github.com/openlayers/openlayers/pull/10076) - Remove unnecessary typecast ([@fredj](https://github.com/fredj))
 * [#10074](https://github.com/openlayers/openlayers/pull/10074) - Remove offsets from mouse position calculation ([@mike-000](https://github.com/mike-000))
 * [#10072](https://github.com/openlayers/openlayers/pull/10072) - Better typing ([@fredj](https://github.com/fredj))


<details>
  <summary>Dependency Updates</summary>
  
 * [#10208](https://github.com/openlayers/openlayers/pull/10208) - Bump pixelmatch from 5.0.2 to 5.1.0 ([@openlayers](https://github.com/openlayers))
 * [#10210](https://github.com/openlayers/openlayers/pull/10210) - Bump glob from 7.1.4 to 7.1.5 ([@openlayers](https://github.com/openlayers))
 * [#10209](https://github.com/openlayers/openlayers/pull/10209) - Bump karma from 4.1.0 to 4.4.1 ([@openlayers](https://github.com/openlayers))
 * [#10207](https://github.com/openlayers/openlayers/pull/10207) - Bump ol-mapbox-style from 5.0.0-beta.3 to 5.0.2 ([@openlayers](https://github.com/openlayers))
 * [#10157](https://github.com/openlayers/openlayers/pull/10157) - Bump karma-coverage-istanbul-reporter from 2.0.5 to 2.1.0 ([@openlayers](https://github.com/openlayers))
 * [#10155](https://github.com/openlayers/openlayers/pull/10155) - Bump @types/pbf from 3.0.1 to 3.0.2 ([@openlayers](https://github.com/openlayers))
 * [#10153](https://github.com/openlayers/openlayers/pull/10153) - Bump yargs from 14.0.0 to 14.2.0 ([@openlayers](https://github.com/openlayers))
 * [#10154](https://github.com/openlayers/openlayers/pull/10154) - Bump @babel/core from 7.4.4 to 7.6.4 ([@openlayers](https://github.com/openlayers))
 * [#10151](https://github.com/openlayers/openlayers/pull/10151) - Bump rollup-plugin-babel from 4.3.2 to 4.3.3 ([@openlayers](https://github.com/openlayers))
 * [#10148](https://github.com/openlayers/openlayers/pull/10148) - Bump rollup-plugin-node-resolve from 5.0.0 to 5.2.0 ([@openlayers](https://github.com/openlayers))
 * [#10150](https://github.com/openlayers/openlayers/pull/10150) - Bump copy-webpack-plugin from 5.0.3 to 5.0.4 ([@openlayers](https://github.com/openlayers))
 * [#10149](https://github.com/openlayers/openlayers/pull/10149) - Bump rbush from 3.0.0 to 3.0.1 ([@openlayers](https://github.com/openlayers))
 * [#10147](https://github.com/openlayers/openlayers/pull/10147) - Bump rollup from 1.12.0 to 1.25.1 ([@openlayers](https://github.com/openlayers))
 * [#10145](https://github.com/openlayers/openlayers/pull/10145) - Greenkeeper/handlebars 4.4.5 ([@openlayers](https://github.com/openlayers))
 * [#10132](https://github.com/openlayers/openlayers/pull/10132) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#10143](https://github.com/openlayers/openlayers/pull/10143) - Update mocha to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#10117](https://github.com/openlayers/openlayers/pull/10117) - Update pbf to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#10114](https://github.com/openlayers/openlayers/pull/10114) - Update coveralls to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#10116](https://github.com/openlayers/openlayers/pull/10116) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#10105](https://github.com/openlayers/openlayers/pull/10105) - Update jsdoc-plugin-typescript to the latest version 🚀 ([@openlayers](https://github.com/openlayers))


</details>
