/* ***** BEGIN LICENSE BLOCK *****
 * Distributed under the BSD license:
 *
 * Copyright (c) 2012, Ajax.org B.V.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Ajax.org B.V. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL AJAX.ORG B.V. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ***** END LICENSE BLOCK ***** */

/* This file was autogenerated from Pig.tmLanguage (uuid: ) */
/****************************************************************************************
 * IT MIGHT NOT BE PERFECT ...But it's a good start from an existing *.tmlanguage file. *
 * fileTypes                                                                            *
 ****************************************************************************************/

define(function(require, exports, module) {
"use strict";

var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;

var PigHighlightRules = function() {
    // regexp must not have capturing parentheses. Use (?:) instead.
    // regexps are ordered -> the first match is used

    this.$rules = {
        start: [{
            token: "comment.block.pig",
            regex: /\/\*/,
            push: [{
                token: "comment.block.pig",
                regex: /\*\//,
                next: "pop"
            }, {
                defaultToken: "comment.block.pig"
            }]
        }, {
            token: "comment.line.double-dash.asciidoc",
            regex: /--.*$/
        }, {
            token: "keyword.control.pig",
            regex: /\b(?:ASSERT|LOAD|STORE|DUMP|FILTER|DISTINCT|FOREACH|GENERATE|STREAM|JOIN|COGROUP|GROUP|CROSS|ORDER|LIMIT|UNION|SPLIT|DESCRIBE|EXPLAIN|ILLUSTRATE|AS|BY|INTO|USING|LIMIT|PARALLEL|OUTER|INNER|DEFAULT|LEFT|SAMPLE|RANK|CUBE|ALL|KILL|QUIT|MAPREDUCE|ASC|DESC|THROUGH|SHIP|CACHE|DECLARE|CASE|WHEN|THEN|END|IN|PARTITION|FULL|IMPORT|IF|ONSCHEMA|INPUT|OUTPUT)\b/,
            caseInsensitive: true
        }, {
            token: "storage.datatypes.pig",
            regex: /\b(?:int|long|float|double|chararray|bytearray|boolean|datetime|biginteger|bigdecimal|tuple|bag|map)\b/,
            caseInsensitive: true
        }, {
            token: "support.function.storage.pig",
            regex: /\b(?:PigStorage|BinStorage|BinaryStorage|PigDump|HBaseStorage|JsonLoader|JsonStorage|AvroStorage|TextLoader|PigStreaming|TrevniStorage|AccumuloStorage)\b/
        }, {
            token: "support.function.udf.pig",
            regex: /\b(?:DIFF|TOBAG|TOMAP|TOP|TOTUPLE|RANDOM|FLATTEN|flatten|CUBE|ROLLUP|IsEmpty|ARITY|PluckTuple|SUBTRACT|BagToString)\b/
        }, {
            token: "support.function.udf.math.pig",
            regex: /\b(?:ABS|ACOS|ASIN|ATAN|CBRT|CEIL|COS|COSH|EXP|FLOOR|LOG|LOG10|ROUND|ROUND_TO|SIN|SINH|SQRT|TAN|TANH|AVG|COUNT|COUNT_STAR|MAX|MIN|SUM|COR|COV)\b/
        }, {
            token: "support.function.udf.string.pig",
            regex: /\b(?:CONCAT|INDEXOF|LAST_INDEX_OF|LCFIRST|LOWER|REGEX_EXTRACT|REGEX_EXTRACT_ALL|REPLACE|SIZE|STRSPLIT|SUBSTRING|TOKENIZE|TRIM|UCFIRST|UPPER|LTRIM|RTRIM|ENDSWITH|STARTSWITH|TRIM)\b/
        }, {
            token: "support.function.udf.datetime.pig",
            regex: /\b(?:AddDuration|CurrentTime|DaysBetween|GetDay|GetHour|GetMilliSecond|GetMinute|GetMonth|GetSecond|GetWeek|GetWeekYear|GetYear|HoursBetween|MilliSecondsBetween|MinutesBetween|MonthsBetween|SecondsBetween|SubtractDuration|ToDate|WeeksBetween|YearsBetween|ToMilliSeconds|ToString|ToUnixTime)\b/
        }, {
            token: "support.function.command.pig",
            regex: /\b(?:cat|cd|copyFromLocal|copyToLocal|cp|ls|mkdir|mv|pwd|rm)\b/
        }, {
            token: "variable.pig",
            regex: /\$[a_zA-Z0-9_]+/
        }, {
            token: "constant.language.pig",
            regex: /\b(?:NULL|true|false|stdin|stdout|stderr)\b/,
            caseInsensitive: true
        }, {
            token: "constant.numeric.pig",
            regex: /\b\d+(?:\.\d+)?\b/
        }, {
            token: "keyword.operator.comparison.pig",
            regex: /!=|==|<|>|<=|>=|\b(?:MATCHES|IS|OR|AND|NOT)\b/,
            caseInsensitive: true
        }, {
            token: "keyword.operator.arithmetic.pig",
            regex: /\+|\-|\*|\/|\%|\?|:|::|\.\.|#/
        }, {
            token: "string.quoted.double.pig",
            regex: /"/,
            push: [{
                token: "string.quoted.double.pig",
                regex: /"/,
                next: "pop"
            }, {
                token: "constant.character.escape.pig",
                regex: /\\./
            }, {
                defaultToken: "string.quoted.double.pig"
            }]
        }, {
            token: "string.quoted.single.pig",
            regex: /'/,
            push: [{
                token: "string.quoted.single.pig",
                regex: /'/,
                next: "pop"
            }, {
                token: "constant.character.escape.pig",
                regex: /\\./
            }, {
                defaultToken: "string.quoted.single.pig"
            }]
        }, {
            todo: {
                token: [
                    "text",
                    "keyword.parameter.pig",
                    "text",
                    "storage.type.parameter.pig"
                ],
                regex: /^(\s*)(set)(\s+)(\S+)/,
                caseInsensitive: true,
                push: [{
                    token: "text",
                    regex: /$/,
                    next: "pop"
                }, {
                    include: "$self"
                }]
            }
        }, {
            token: [
                "text",
                "keyword.alias.pig",
                "text",
                "storage.type.alias.pig"
            ],
            regex: /(\s*)(DEFINE|DECLARE|REGISTER)(\s+)(\S+)/,
            caseInsensitive: true,
            push: [{
                token: "text",
                regex: /;?$/,
                next: "pop"
            }]
        }]
    }
    
    this.normalizeRules();
};

PigHighlightRules.metaData = {
    fileTypes: ["pig"],
    name: "Pig",
    scopeName: "source.pig"
}


oop.inherits(PigHighlightRules, TextHighlightRules);

exports.PigHighlightRules = PigHighlightRules;
});
