if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/aui-progressbar/aui-progressbar.js']) {
   __coverage__['build/aui-progressbar/aui-progressbar.js'] = {"path":"build/aui-progressbar/aui-progressbar.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0,"45":0,"46":0,"47":0,"48":0,"49":0,"50":0,"51":0,"52":0,"53":0,"54":0,"55":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0,0],"4":[0,0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":27},"end":{"line":1,"column":46}}},"2":{"name":"(anonymous_2)","line":17,"loc":{"start":{"line":17,"column":15},"end":{"line":17,"column":27}}},"3":{"name":"(anonymous_3)","line":89,"loc":{"start":{"line":89,"column":21},"end":{"line":89,"column":32}}},"4":{"name":"(anonymous_4)","line":144,"loc":{"start":{"line":144,"column":23},"end":{"line":144,"column":37}}},"5":{"name":"(anonymous_5)","line":194,"loc":{"start":{"line":194,"column":21},"end":{"line":194,"column":32}}},"6":{"name":"(anonymous_6)","line":209,"loc":{"start":{"line":209,"column":23},"end":{"line":209,"column":37}}},"7":{"name":"(anonymous_7)","line":225,"loc":{"start":{"line":225,"column":15},"end":{"line":225,"column":37}}},"8":{"name":"(anonymous_8)","line":253,"loc":{"start":{"line":253,"column":18},"end":{"line":253,"column":29}}},"9":{"name":"(anonymous_9)","line":267,"loc":{"start":{"line":267,"column":16},"end":{"line":267,"column":27}}},"10":{"name":"(anonymous_10)","line":293,"loc":{"start":{"line":293,"column":29},"end":{"line":293,"column":40}}},"11":{"name":"(anonymous_11)","line":311,"loc":{"start":{"line":311,"column":23},"end":{"line":311,"column":34}}},"12":{"name":"(anonymous_12)","line":324,"loc":{"start":{"line":324,"column":19},"end":{"line":324,"column":30}}},"13":{"name":"(anonymous_13)","line":339,"loc":{"start":{"line":339,"column":18},"end":{"line":339,"column":29}}},"14":{"name":"(anonymous_14)","line":349,"loc":{"start":{"line":349,"column":35},"end":{"line":349,"column":46}}},"15":{"name":"(anonymous_15)","line":365,"loc":{"start":{"line":365,"column":21},"end":{"line":365,"column":35}}},"16":{"name":"(anonymous_16)","line":384,"loc":{"start":{"line":384,"column":27},"end":{"line":384,"column":41}}},"17":{"name":"(anonymous_17)","line":404,"loc":{"start":{"line":404,"column":21},"end":{"line":404,"column":32}}},"18":{"name":"(anonymous_18)","line":438,"loc":{"start":{"line":438,"column":25},"end":{"line":438,"column":36}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":454,"column":101}},"2":{"start":{"line":12,"column":0},"end":{"line":27,"column":25}},"3":{"start":{"line":18,"column":8},"end":{"line":18,"column":34}},"4":{"start":{"line":49,"column":0},"end":{"line":449,"column":3}},"5":{"start":{"line":90,"column":16},"end":{"line":90,"column":73}},"6":{"start":{"line":145,"column":16},"end":{"line":145,"column":85}},"7":{"start":{"line":195,"column":16},"end":{"line":195,"column":47}},"8":{"start":{"line":210,"column":16},"end":{"line":210,"column":105}},"9":{"start":{"line":226,"column":12},"end":{"line":226,"column":48}},"10":{"start":{"line":228,"column":12},"end":{"line":230,"column":13}},"11":{"start":{"line":229,"column":16},"end":{"line":229,"column":39}},"12":{"start":{"line":254,"column":12},"end":{"line":254,"column":32}},"13":{"start":{"line":256,"column":12},"end":{"line":256,"column":57}},"14":{"start":{"line":258,"column":12},"end":{"line":258,"column":49}},"15":{"start":{"line":268,"column":12},"end":{"line":268,"column":32}},"16":{"start":{"line":270,"column":12},"end":{"line":280,"column":13}},"17":{"start":{"line":271,"column":16},"end":{"line":279,"column":19}},"18":{"start":{"line":294,"column":12},"end":{"line":294,"column":32}},"19":{"start":{"line":295,"column":12},"end":{"line":295,"column":58}},"20":{"start":{"line":297,"column":12},"end":{"line":301,"column":14}},"21":{"start":{"line":312,"column":12},"end":{"line":312,"column":32}},"22":{"start":{"line":314,"column":12},"end":{"line":314,"column":74}},"23":{"start":{"line":325,"column":12},"end":{"line":325,"column":32}},"24":{"start":{"line":326,"column":12},"end":{"line":326,"column":42}},"25":{"start":{"line":327,"column":12},"end":{"line":327,"column":84}},"26":{"start":{"line":329,"column":12},"end":{"line":329,"column":38}},"27":{"start":{"line":340,"column":12},"end":{"line":340,"column":43}},"28":{"start":{"line":350,"column":12},"end":{"line":350,"column":32}},"29":{"start":{"line":352,"column":12},"end":{"line":354,"column":13}},"30":{"start":{"line":353,"column":16},"end":{"line":353,"column":76}},"31":{"start":{"line":366,"column":12},"end":{"line":367,"column":52}},"32":{"start":{"line":369,"column":12},"end":{"line":371,"column":13}},"33":{"start":{"line":370,"column":16},"end":{"line":370,"column":53}},"34":{"start":{"line":373,"column":12},"end":{"line":373,"column":31}},"35":{"start":{"line":385,"column":12},"end":{"line":385,"column":32}},"36":{"start":{"line":386,"column":12},"end":{"line":386,"column":58}},"37":{"start":{"line":387,"column":12},"end":{"line":387,"column":52}},"38":{"start":{"line":389,"column":12},"end":{"line":389,"column":64}},"39":{"start":{"line":390,"column":12},"end":{"line":390,"column":63}},"40":{"start":{"line":392,"column":12},"end":{"line":392,"column":56}},"41":{"start":{"line":393,"column":12},"end":{"line":393,"column":39}},"42":{"start":{"line":405,"column":12},"end":{"line":405,"column":32}},"43":{"start":{"line":406,"column":12},"end":{"line":406,"column":53}},"44":{"start":{"line":408,"column":12},"end":{"line":408,"column":28}},"45":{"start":{"line":410,"column":12},"end":{"line":423,"column":13}},"46":{"start":{"line":411,"column":16},"end":{"line":415,"column":18}},"47":{"start":{"line":418,"column":16},"end":{"line":422,"column":18}},"48":{"start":{"line":425,"column":12},"end":{"line":427,"column":13}},"49":{"start":{"line":426,"column":16},"end":{"line":426,"column":42}},"50":{"start":{"line":429,"column":12},"end":{"line":429,"column":57}},"51":{"start":{"line":439,"column":12},"end":{"line":439,"column":32}},"52":{"start":{"line":440,"column":12},"end":{"line":440,"column":58}},"53":{"start":{"line":441,"column":12},"end":{"line":441,"column":52}},"54":{"start":{"line":443,"column":12},"end":{"line":446,"column":14}},"55":{"start":{"line":451,"column":0},"end":{"line":451,"column":28}}},"branchMap":{"1":{"line":18,"type":"binary-expr","locations":[{"start":{"line":18,"column":15},"end":{"line":18,"column":28}},{"start":{"line":18,"column":32},"end":{"line":18,"column":33}}]},"2":{"line":90,"type":"binary-expr","locations":[{"start":{"line":90,"column":23},"end":{"line":90,"column":66}},{"start":{"line":90,"column":70},"end":{"line":90,"column":72}}]},"3":{"line":145,"type":"binary-expr","locations":[{"start":{"line":145,"column":23},"end":{"line":145,"column":36}},{"start":{"line":145,"column":41},"end":{"line":145,"column":61}},{"start":{"line":145,"column":65},"end":{"line":145,"column":83}}]},"4":{"line":210,"type":"binary-expr","locations":[{"start":{"line":210,"column":23},"end":{"line":210,"column":46}},{"start":{"line":210,"column":52},"end":{"line":210,"column":74}},{"start":{"line":210,"column":80},"end":{"line":210,"column":102}}]},"5":{"line":228,"type":"if","locations":[{"start":{"line":228,"column":12},"end":{"line":228,"column":12}},{"start":{"line":228,"column":12},"end":{"line":228,"column":12}}]},"6":{"line":270,"type":"if","locations":[{"start":{"line":270,"column":12},"end":{"line":270,"column":12}},{"start":{"line":270,"column":12},"end":{"line":270,"column":12}}]},"7":{"line":299,"type":"cond-expr","locations":[{"start":{"line":299,"column":63},"end":{"line":299,"column":70}},{"start":{"line":299,"column":73},"end":{"line":299,"column":81}}]},"8":{"line":352,"type":"if","locations":[{"start":{"line":352,"column":12},"end":{"line":352,"column":12}},{"start":{"line":352,"column":12},"end":{"line":352,"column":12}}]},"9":{"line":369,"type":"if","locations":[{"start":{"line":369,"column":12},"end":{"line":369,"column":12}},{"start":{"line":369,"column":12},"end":{"line":369,"column":12}}]},"10":{"line":410,"type":"if","locations":[{"start":{"line":410,"column":12},"end":{"line":410,"column":12}},{"start":{"line":410,"column":12},"end":{"line":410,"column":12}}]},"11":{"line":425,"type":"if","locations":[{"start":{"line":425,"column":12},"end":{"line":425,"column":12}},{"start":{"line":425,"column":12},"end":{"line":425,"column":12}}]}},"code":["(function () { YUI.add('aui-progressbar', function (A, NAME) {","","/**"," * The ProgressBar Utility provides a visual means of showing progress of an"," * ongoing operation. The ProgressBar can be enhanced via CSS styles to provide"," * different colors, shapes and textures. The bar can move horizontally or"," * vertically. The movement can be enhanced by using the Animation utility."," *"," * @module aui-progressbar"," */","","var L = A.Lang,","    isNumber = L.isNumber,","    isString = L.isString,","    isUndefined = L.isUndefined,","","    toNumber = function(v) {","        return parseFloat(v) || 0;","    },","","    getCN = A.getClassName,","","    CSS_BAR = getCN('progress', 'bar'),","    CSS_HORIZONTAL = getCN('horizontal'),","    CSS_VERTICAL = getCN('vertical'),","","    TPL_TEXT = '<p></p>';","","/**"," * A base class for Progressbar, providing:"," *"," * - Widget Lifecycle (initializer, renderUI, bindUI, syncUI, destructor)"," * - A visual means of showing progress of an ongoing operation"," * - Can be enhanced via CSS styles to provide different colors, shapes and"," *   textures"," * - The bar can move horizontally or vertically"," * - The movement can be enhanced by using the Animation utility"," *"," * Check the [live demo](http://alloyui.com/examples/progress-bar/)."," *"," * @class A.ProgressBar"," * @extends A.Component"," * @param {Object} config Object literal specifying widget configuration"," *     properties."," * @constructor"," * @include http://alloyui.com/examples/progress-bar/basic-markup.html"," * @include http://alloyui.com/examples/progress-bar/basic.js"," */","var ProgressBar = A.Component.create({","    /**","     * Static property provides a string to identify the class.","     *","     * @property NAME","     * @type String","     * @static","     */","    NAME: 'progress',","","    /**","     * Static property used to define the default attribute","     * configuration for the ProgressBar.","     *","     * @property ATTRS","     * @type Object","     * @static","     */","    ATTRS: {","","        /**","         * Boolean indicating if use of the WAI-ARIA Roles and States","         * should be enabled.","         *","         * @attribute useARIA","         * @default true","         * @type Boolean","         */","        useARIA: {","            value: true","        },","","        /**","         * Display height of the progressbar.","         *","         * @attribute height","         * @default 25","         * @type int | String","         */","        height: {","            valueFn: function() {","                return this.get('boundingBox').get('offsetHeight') || 25;","            }","        },","","        /**","         * Display label of the progressbar. If not specified try to query","         * using HTML_PARSER an element inside boundingBox which matches","         * `aui-progressbar-text` and get its innerHTML to be","         * used as label.","         *","         * @attribute label","         * @default undefined","         * @type String","         */","        label: {},","","        /**","         * Represents the top value for the bar. The bar will be fully","         * extended when reaching this value. Values higher than this will","         * be ignored.","         *","         * @attribute max","         * @default 100","         * @type Number","         */","        max: {","            validator: isNumber,","            value: 100","        },","","        /**","         * Represents the lowest value for the bar. The bar will be","         * totally collapsed when reaching this value. Values lower than","         * this will be ignored.","         *","         * @attribute min","         * @default 0","         * @type Number","         */","        min: {","            validator: isNumber,","            value: 0","        },","","        /**","         * Display orientation of the progressbar (i.e. vertical or","         * horizontal).","         *","         * @attribute orientation","         * @default HORIZONTAL","         * @type String","         */","        orientation: {","            value: 'horizontal',","            validator: function(val) {","                return isString(val) && (val === 'horizontal' || val === 'vertical');","            }","        },","","        /**","         * Calculate the ratio based on `max` and `min` values.","         *","         * @attribute ratio","         * @readOnly","         * @type number","         */","        ratio: {","            getter: '_getRatio',","            readOnly: true","        },","","        /**","         * Calculate the progressbar step based on `ratio` value.","         *","         * @attribute step","         * @readOnly","         * @type number","         */","        step: {","            getter: '_getStep',","            readOnly: true","        },","","        /**","         * Specify the tab order of elements.","         *","         * @attribute tabIndex","         * @default 1","         * @type Number","         */","        tabIndex: {","            value: 1","        },","","        /**","         * DOM Node to display the text of the progressbar. If not","         * specified try to query using HTML_PARSER an element inside","         * contentBox which matches `aui-progressbar-text`.","         *","         * @attribute textNode","         * @default Generated div element.","         * @type String","         */","        textNode: {","            valueFn: function() {","                return A.Node.create(TPL_TEXT);","            }","        },","","        /**","         * The value for the bar. Valid values are in between the minValue","         * and maxValue attributes.","         *","         * @attribute value","         * @default 0","         * @type Number | String","         */","        value: {","            setter: toNumber,","            validator: function(val) {","                return isNumber(toNumber(val)) && ((val >= this.get('min')) && (val <= this.get('max')));","            },","            value: 0","        }","    },","","    /**","     * Object hash, defining how attribute values are to be parsed from","     * markup contained in the widget's bounding box.","     *","     * @property HTML_PARSER","     * @type Object","     * @static","     */","    HTML_PARSER: {","        label: function(boundingBox) {","            var textNode = boundingBox.one('p');","","            if (textNode) {","                return textNode.html();","            }","        },","","        textNode: 'p'","    },","","    /**","     * Static property used to define the UI attributes.","     *","     * @property UI_ATTRS","     * @type Array","     * @static","     */","    UI_ATTRS: ['label', 'orientation', 'value'],","","    prototype: {","","        /**","         * Create the DOM structure for the ProgressBar. Lifecycle.","         *","         * @method renderUI","         * @protected","         */","        renderUI: function() {","            var instance = this;","","            instance.get('contentBox').addClass(CSS_BAR);","","            instance._renderTextNodeIfLabelSet();","        },","","        /**","         * Sync the ProgressBar UI. Lifecycle.","         *","         * @method syncUI","         * @protected","         */","        syncUI: function() {","            var instance = this;","","            if (instance.get('useARIA')) {","                instance.plug(A.Plugin.Aria, {","                    attributes: {","                        value: 'valuenow',","                        max: 'valuemax',","                        min: 'valuemin',","                        orientation: 'orientation'","                    },","                    roleName: 'progressbar'","                });","            }","        },","","        /**","         * Calculate the boundingBox size based on the","         * `orientation` of the progressbar. If the orientation","         * is HORIZONTAL get the width, if the orientation is VERTICAL get","         * the height.","         *","         * @method _getBoundingBoxSize","         * @protected","         * @return {Number}","         */","        _getBoundingBoxSize: function() {","            var instance = this;","            var boundingBox = instance.get('boundingBox');","","            return toNumber(","                boundingBox.getStyle(","                    this.get('orientation') === 'horizontal' ? 'width' : 'height'","                )","            );","        },","","        /**","         * Calculate the number of pixels to set the `contentBox` bar.","         *","         * @method _getPixelStep","         * @protected","         * @return {Number}","         */","        _getPixelStep: function() {","            var instance = this;","","            return instance._getBoundingBoxSize() * instance.get('ratio');","        },","","        /**","         * Calculate the ratio based on `max` and `min` values.","         *","         * @method _getRatio","         * @protected","         * @return {Number}","         */","        _getRatio: function() {","            var instance = this;","            var min = instance.get('min');","            var ratio = (instance.get('value') - min) / (instance.get('max') - min);","","            return Math.max(ratio, 0);","        },","","        /**","         * Calculate the progressbar step based on `ratio` value.","         *","         * @method _getStep","         * @protected","         * @return {Number}","         */","        _getStep: function() {","            return this.get('ratio') * 100;","        },","","        /**","         * Render the `textNode` of the progressbar if label is set.","         *","         * @method _renderTextNodeIfLabelSet","         * @protected","         */","        _renderTextNodeIfLabelSet: function() {","            var instance = this;","","            if (!isUndefined(instance.get('label'))) {","                instance.get('contentBox').append(instance.get('textNode'));","            }","        },","","        /**","         * Invoked automatically by the UI_ATTRS Widget API when bind or sync","         * the `label` attribute.","         *","         * @method _uiSetLabel","         * @param {String} val Display label","         * @protected","         */","        _uiSetLabel: function(val) {","            var instance = this,","                textNode = instance.get('textNode');","","            if (!textNode.inDoc()) {","                instance._renderTextNodeIfLabelSet();","            }","","            textNode.html(val);","        },","","        /**","         * Invoked automatically by the UI_ATTRS Widget API when bind or sync","         * the `orientation` attribute.","         *","         * @method _uiSetOrientation","         * @param {String} val Orientation","         * @protected","         */","        _uiSetOrientation: function(val) {","            var instance = this;","            var boundingBox = instance.get('boundingBox');","            var horizontal = (val === 'horizontal');","","            boundingBox.toggleClass(CSS_HORIZONTAL, horizontal);","            boundingBox.toggleClass(CSS_VERTICAL, !horizontal);","","            instance._uiSetValue(instance.get('value'));","            instance._uiSizeTextNode();","        },","","        /**","         * Invoked automatically by the UI_ATTRS Widget API when bind or sync","         * the `value` attribute.","         *","         * @method _uiSetValue","         * @param {String} val Progress value","         * @protected","         */","        _uiSetValue: function() {","            var instance = this;","            var pixelStep = instance._getPixelStep();","","            var styles = {};","","            if (instance.get('orientation') === 'horizontal') {","                styles = {","                    height: '100%',","                    top: 'auto',","                    width: pixelStep + 'px'","                };","            }","            else {","                styles = {","                    height: pixelStep + 'px',","                    top: toNumber(instance._getBoundingBoxSize() - pixelStep) + 'px',","                    width: '100%'","                };","            }","","            if (instance.get('step') >= 100) {","                instance.fire('complete');","            }","","            instance.get('contentBox').setStyles(styles);","        },","","        /**","         * Sync the size of the ProgressBar when some UI attribute change.","         *","         * @method _uiSizeTextNode","         * @protected","         */","        _uiSizeTextNode: function() {","            var instance = this;","            var boundingBox = instance.get('boundingBox');","            var textNode = instance.get('textNode');","","            textNode.setStyle(","                'lineHeight',","                boundingBox.getStyle('height')","            );","        }","    }","});","","A.ProgressBar = ProgressBar;","","","}, '3.0.2-deprecated.1', {\"requires\": [\"aui-node\", \"aui-component\", \"aui-aria\"], \"skinnable\": true});","","}());"]};
}
var __cov_zh_sN2iWl$WvlxSUgxUAxA = __coverage__['build/aui-progressbar/aui-progressbar.js'];
__cov_zh_sN2iWl$WvlxSUgxUAxA.s['1']++;YUI.add('aui-progressbar',function(A,NAME){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['1']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['2']++;var L=A.Lang,isNumber=L.isNumber,isString=L.isString,isUndefined=L.isUndefined,toNumber=function(v){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['2']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['3']++;return(__cov_zh_sN2iWl$WvlxSUgxUAxA.b['1'][0]++,parseFloat(v))||(__cov_zh_sN2iWl$WvlxSUgxUAxA.b['1'][1]++,0);},getCN=A.getClassName,CSS_BAR=getCN('progress','bar'),CSS_HORIZONTAL=getCN('horizontal'),CSS_VERTICAL=getCN('vertical'),TPL_TEXT='<p></p>';__cov_zh_sN2iWl$WvlxSUgxUAxA.s['4']++;var ProgressBar=A.Component.create({NAME:'progress',ATTRS:{useARIA:{value:true},height:{valueFn:function(){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['3']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['5']++;return(__cov_zh_sN2iWl$WvlxSUgxUAxA.b['2'][0]++,this.get('boundingBox').get('offsetHeight'))||(__cov_zh_sN2iWl$WvlxSUgxUAxA.b['2'][1]++,25);}},label:{},max:{validator:isNumber,value:100},min:{validator:isNumber,value:0},orientation:{value:'horizontal',validator:function(val){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['4']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['6']++;return(__cov_zh_sN2iWl$WvlxSUgxUAxA.b['3'][0]++,isString(val))&&((__cov_zh_sN2iWl$WvlxSUgxUAxA.b['3'][1]++,val==='horizontal')||(__cov_zh_sN2iWl$WvlxSUgxUAxA.b['3'][2]++,val==='vertical'));}},ratio:{getter:'_getRatio',readOnly:true},step:{getter:'_getStep',readOnly:true},tabIndex:{value:1},textNode:{valueFn:function(){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['5']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['7']++;return A.Node.create(TPL_TEXT);}},value:{setter:toNumber,validator:function(val){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['6']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['8']++;return(__cov_zh_sN2iWl$WvlxSUgxUAxA.b['4'][0]++,isNumber(toNumber(val)))&&((__cov_zh_sN2iWl$WvlxSUgxUAxA.b['4'][1]++,val>=this.get('min'))&&(__cov_zh_sN2iWl$WvlxSUgxUAxA.b['4'][2]++,val<=this.get('max')));},value:0}},HTML_PARSER:{label:function(boundingBox){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['7']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['9']++;var textNode=boundingBox.one('p');__cov_zh_sN2iWl$WvlxSUgxUAxA.s['10']++;if(textNode){__cov_zh_sN2iWl$WvlxSUgxUAxA.b['5'][0]++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['11']++;return textNode.html();}else{__cov_zh_sN2iWl$WvlxSUgxUAxA.b['5'][1]++;}},textNode:'p'},UI_ATTRS:['label','orientation','value'],prototype:{renderUI:function(){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['8']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['12']++;var instance=this;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['13']++;instance.get('contentBox').addClass(CSS_BAR);__cov_zh_sN2iWl$WvlxSUgxUAxA.s['14']++;instance._renderTextNodeIfLabelSet();},syncUI:function(){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['9']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['15']++;var instance=this;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['16']++;if(instance.get('useARIA')){__cov_zh_sN2iWl$WvlxSUgxUAxA.b['6'][0]++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['17']++;instance.plug(A.Plugin.Aria,{attributes:{value:'valuenow',max:'valuemax',min:'valuemin',orientation:'orientation'},roleName:'progressbar'});}else{__cov_zh_sN2iWl$WvlxSUgxUAxA.b['6'][1]++;}},_getBoundingBoxSize:function(){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['10']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['18']++;var instance=this;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['19']++;var boundingBox=instance.get('boundingBox');__cov_zh_sN2iWl$WvlxSUgxUAxA.s['20']++;return toNumber(boundingBox.getStyle(this.get('orientation')==='horizontal'?(__cov_zh_sN2iWl$WvlxSUgxUAxA.b['7'][0]++,'width'):(__cov_zh_sN2iWl$WvlxSUgxUAxA.b['7'][1]++,'height')));},_getPixelStep:function(){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['11']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['21']++;var instance=this;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['22']++;return instance._getBoundingBoxSize()*instance.get('ratio');},_getRatio:function(){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['12']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['23']++;var instance=this;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['24']++;var min=instance.get('min');__cov_zh_sN2iWl$WvlxSUgxUAxA.s['25']++;var ratio=(instance.get('value')-min)/(instance.get('max')-min);__cov_zh_sN2iWl$WvlxSUgxUAxA.s['26']++;return Math.max(ratio,0);},_getStep:function(){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['13']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['27']++;return this.get('ratio')*100;},_renderTextNodeIfLabelSet:function(){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['14']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['28']++;var instance=this;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['29']++;if(!isUndefined(instance.get('label'))){__cov_zh_sN2iWl$WvlxSUgxUAxA.b['8'][0]++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['30']++;instance.get('contentBox').append(instance.get('textNode'));}else{__cov_zh_sN2iWl$WvlxSUgxUAxA.b['8'][1]++;}},_uiSetLabel:function(val){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['15']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['31']++;var instance=this,textNode=instance.get('textNode');__cov_zh_sN2iWl$WvlxSUgxUAxA.s['32']++;if(!textNode.inDoc()){__cov_zh_sN2iWl$WvlxSUgxUAxA.b['9'][0]++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['33']++;instance._renderTextNodeIfLabelSet();}else{__cov_zh_sN2iWl$WvlxSUgxUAxA.b['9'][1]++;}__cov_zh_sN2iWl$WvlxSUgxUAxA.s['34']++;textNode.html(val);},_uiSetOrientation:function(val){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['16']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['35']++;var instance=this;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['36']++;var boundingBox=instance.get('boundingBox');__cov_zh_sN2iWl$WvlxSUgxUAxA.s['37']++;var horizontal=val==='horizontal';__cov_zh_sN2iWl$WvlxSUgxUAxA.s['38']++;boundingBox.toggleClass(CSS_HORIZONTAL,horizontal);__cov_zh_sN2iWl$WvlxSUgxUAxA.s['39']++;boundingBox.toggleClass(CSS_VERTICAL,!horizontal);__cov_zh_sN2iWl$WvlxSUgxUAxA.s['40']++;instance._uiSetValue(instance.get('value'));__cov_zh_sN2iWl$WvlxSUgxUAxA.s['41']++;instance._uiSizeTextNode();},_uiSetValue:function(){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['17']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['42']++;var instance=this;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['43']++;var pixelStep=instance._getPixelStep();__cov_zh_sN2iWl$WvlxSUgxUAxA.s['44']++;var styles={};__cov_zh_sN2iWl$WvlxSUgxUAxA.s['45']++;if(instance.get('orientation')==='horizontal'){__cov_zh_sN2iWl$WvlxSUgxUAxA.b['10'][0]++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['46']++;styles={height:'100%',top:'auto',width:pixelStep+'px'};}else{__cov_zh_sN2iWl$WvlxSUgxUAxA.b['10'][1]++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['47']++;styles={height:pixelStep+'px',top:toNumber(instance._getBoundingBoxSize()-pixelStep)+'px',width:'100%'};}__cov_zh_sN2iWl$WvlxSUgxUAxA.s['48']++;if(instance.get('step')>=100){__cov_zh_sN2iWl$WvlxSUgxUAxA.b['11'][0]++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['49']++;instance.fire('complete');}else{__cov_zh_sN2iWl$WvlxSUgxUAxA.b['11'][1]++;}__cov_zh_sN2iWl$WvlxSUgxUAxA.s['50']++;instance.get('contentBox').setStyles(styles);},_uiSizeTextNode:function(){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['18']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['51']++;var instance=this;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['52']++;var boundingBox=instance.get('boundingBox');__cov_zh_sN2iWl$WvlxSUgxUAxA.s['53']++;var textNode=instance.get('textNode');__cov_zh_sN2iWl$WvlxSUgxUAxA.s['54']++;textNode.setStyle('lineHeight',boundingBox.getStyle('height'));}}});__cov_zh_sN2iWl$WvlxSUgxUAxA.s['55']++;A.ProgressBar=ProgressBar;},'3.0.2-deprecated.1',{'requires':['aui-node','aui-component','aui-aria'],'skinnable':true});
