if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/aui-datepicker-native/aui-datepicker-native.js']) {
   __coverage__['build/aui-datepicker-native/aui-datepicker-native.js'] = {"path":"build/aui-datepicker-native/aui-datepicker-native.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0,"45":0,"46":0,"47":0,"48":0,"49":0,"50":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0,0],"10":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":33},"end":{"line":1,"column":52}}},"2":{"name":"DatePickerNativeBase","line":21,"loc":{"start":{"line":21,"column":0},"end":{"line":21,"column":32}}},"3":{"name":"(anonymous_3)","line":67,"loc":{"start":{"line":67,"column":17},"end":{"line":67,"column":28}}},"4":{"name":"(anonymous_4)","line":78,"loc":{"start":{"line":78,"column":18},"end":{"line":78,"column":29}}},"5":{"name":"(anonymous_5)","line":99,"loc":{"start":{"line":99,"column":20},"end":{"line":99,"column":31}}},"6":{"name":"(anonymous_6)","line":111,"loc":{"start":{"line":111,"column":19},"end":{"line":111,"column":30}}},"7":{"name":"(anonymous_7)","line":122,"loc":{"start":{"line":122,"column":10},"end":{"line":122,"column":21}}},"8":{"name":"(anonymous_8)","line":134,"loc":{"start":{"line":134,"column":10},"end":{"line":134,"column":21}}},"9":{"name":"(anonymous_9)","line":147,"loc":{"start":{"line":147,"column":17},"end":{"line":147,"column":33}}},"10":{"name":"(anonymous_10)","line":166,"loc":{"start":{"line":166,"column":18},"end":{"line":166,"column":33}}},"11":{"name":"(anonymous_11)","line":196,"loc":{"start":{"line":196,"column":31},"end":{"line":196,"column":46}}},"12":{"name":"(anonymous_12)","line":207,"loc":{"start":{"line":207,"column":33},"end":{"line":207,"column":49}}},"13":{"name":"(anonymous_13)","line":222,"loc":{"start":{"line":222,"column":26},"end":{"line":222,"column":37}}},"14":{"name":"(anonymous_14)","line":241,"loc":{"start":{"line":241,"column":17},"end":{"line":241,"column":32}}},"15":{"name":"(anonymous_15)","line":264,"loc":{"start":{"line":264,"column":22},"end":{"line":264,"column":37}}},"16":{"name":"(anonymous_16)","line":282,"loc":{"start":{"line":282,"column":26},"end":{"line":282,"column":41}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":309,"column":108}},"2":{"start":{"line":10,"column":0},"end":{"line":10,"column":18}},"3":{"start":{"line":21,"column":0},"end":{"line":21,"column":34}},"4":{"start":{"line":31,"column":0},"end":{"line":56,"column":2}},"5":{"start":{"line":58,"column":0},"end":{"line":292,"column":2}},"6":{"start":{"line":68,"column":8},"end":{"line":68,"column":28}},"7":{"start":{"line":70,"column":8},"end":{"line":70,"column":32}},"8":{"start":{"line":79,"column":8},"end":{"line":81,"column":48}},"9":{"start":{"line":83,"column":8},"end":{"line":91,"column":10}},"10":{"start":{"line":100,"column":8},"end":{"line":101,"column":54}},"11":{"start":{"line":103,"column":8},"end":{"line":103,"column":28}},"12":{"start":{"line":112,"column":8},"end":{"line":112,"column":28}},"13":{"start":{"line":114,"column":8},"end":{"line":114,"column":34}},"14":{"start":{"line":123,"column":8},"end":{"line":124,"column":54}},"15":{"start":{"line":126,"column":8},"end":{"line":126,"column":27}},"16":{"start":{"line":135,"column":8},"end":{"line":136,"column":54}},"17":{"start":{"line":138,"column":8},"end":{"line":138,"column":28}},"18":{"start":{"line":148,"column":8},"end":{"line":149,"column":54}},"19":{"start":{"line":151,"column":8},"end":{"line":153,"column":9}},"20":{"start":{"line":152,"column":12},"end":{"line":152,"column":29}},"21":{"start":{"line":155,"column":8},"end":{"line":157,"column":9}},"22":{"start":{"line":156,"column":12},"end":{"line":156,"column":57}},"23":{"start":{"line":167,"column":8},"end":{"line":170,"column":19}},"24":{"start":{"line":172,"column":8},"end":{"line":172,"column":42}},"25":{"start":{"line":174,"column":8},"end":{"line":179,"column":9}},"26":{"start":{"line":175,"column":12},"end":{"line":175,"column":61}},"27":{"start":{"line":176,"column":12},"end":{"line":178,"column":13}},"28":{"start":{"line":177,"column":16},"end":{"line":177,"column":58}},"29":{"start":{"line":181,"column":8},"end":{"line":183,"column":9}},"30":{"start":{"line":182,"column":12},"end":{"line":182,"column":50}},"31":{"start":{"line":185,"column":8},"end":{"line":185,"column":40}},"32":{"start":{"line":197,"column":8},"end":{"line":197,"column":71}},"33":{"start":{"line":208,"column":8},"end":{"line":209,"column":52}},"34":{"start":{"line":211,"column":8},"end":{"line":213,"column":9}},"35":{"start":{"line":212,"column":12},"end":{"line":212,"column":44}},"36":{"start":{"line":223,"column":8},"end":{"line":225,"column":70}},"37":{"start":{"line":227,"column":8},"end":{"line":230,"column":15}},"38":{"start":{"line":242,"column":8},"end":{"line":247,"column":15}},"39":{"start":{"line":249,"column":8},"end":{"line":251,"column":9}},"40":{"start":{"line":250,"column":12},"end":{"line":250,"column":70}},"41":{"start":{"line":253,"column":8},"end":{"line":253,"column":25}},"42":{"start":{"line":265,"column":8},"end":{"line":271,"column":9}},"43":{"start":{"line":268,"column":16},"end":{"line":268,"column":28}},"44":{"start":{"line":270,"column":16},"end":{"line":270,"column":29}},"45":{"start":{"line":283,"column":8},"end":{"line":284,"column":52}},"46":{"start":{"line":286,"column":8},"end":{"line":288,"column":9}},"47":{"start":{"line":287,"column":12},"end":{"line":287,"column":25}},"48":{"start":{"line":290,"column":8},"end":{"line":290,"column":46}},"49":{"start":{"line":294,"column":0},"end":{"line":294,"column":46}},"50":{"start":{"line":306,"column":0},"end":{"line":306,"column":112}}},"branchMap":{"1":{"line":151,"type":"if","locations":[{"start":{"line":151,"column":8},"end":{"line":151,"column":8}},{"start":{"line":151,"column":8},"end":{"line":151,"column":8}}]},"2":{"line":155,"type":"if","locations":[{"start":{"line":155,"column":8},"end":{"line":155,"column":8}},{"start":{"line":155,"column":8},"end":{"line":155,"column":8}}]},"3":{"line":174,"type":"if","locations":[{"start":{"line":174,"column":8},"end":{"line":174,"column":8}},{"start":{"line":174,"column":8},"end":{"line":174,"column":8}}]},"4":{"line":176,"type":"if","locations":[{"start":{"line":176,"column":12},"end":{"line":176,"column":12}},{"start":{"line":176,"column":12},"end":{"line":176,"column":12}}]},"5":{"line":181,"type":"if","locations":[{"start":{"line":181,"column":8},"end":{"line":181,"column":8}},{"start":{"line":181,"column":8},"end":{"line":181,"column":8}}]},"6":{"line":211,"type":"if","locations":[{"start":{"line":211,"column":8},"end":{"line":211,"column":8}},{"start":{"line":211,"column":8},"end":{"line":211,"column":8}}]},"7":{"line":229,"type":"cond-expr","locations":[{"start":{"line":229,"column":39},"end":{"line":229,"column":47}},{"start":{"line":229,"column":50},"end":{"line":229,"column":52}}]},"8":{"line":249,"type":"if","locations":[{"start":{"line":249,"column":8},"end":{"line":249,"column":8}},{"start":{"line":249,"column":8},"end":{"line":249,"column":8}}]},"9":{"line":265,"type":"switch","locations":[{"start":{"line":266,"column":12},"end":{"line":266,"column":24}},{"start":{"line":267,"column":12},"end":{"line":268,"column":28}},{"start":{"line":269,"column":12},"end":{"line":270,"column":29}}]},"10":{"line":286,"type":"if","locations":[{"start":{"line":286,"column":8},"end":{"line":286,"column":8}},{"start":{"line":286,"column":8},"end":{"line":286,"column":8}}]}},"code":["(function () { YUI.add('aui-datepicker-native', function (A, NAME) {","","/**"," * The DatePicker Component"," *"," * @module aui-datepicker"," * @submodule aui-datepicker-native"," */","","var Lang = A.Lang;","","/**"," * A base class for `DatePickerNativeBase`."," *"," * @class A.DatePickerNativeBase"," * @param {Object} config Object literal specifying widget configuration"," *     properties."," * @constructor"," */","","function DatePickerNativeBase() {}","","/**"," * Static property used to define the default attribute configuration for the"," * `DatePickerNativeBase`."," *"," * @property ATTRS"," * @type {Object}"," * @static"," */","DatePickerNativeBase.ATTRS = {","","    /**","     * Defines the native date mask.","     *","     * @attribute nativeMask","     * @default '%Y-%m-%d'","     * @type {String}","     */","    nativeMask: {","        validator: Lang.isString,","        value: '%Y-%m-%d'","    },","","    /**","     * Defines the type attribute in an HTML element.","     *","     * @attribute nativeType","     * @default 'date'","     * @type {String}","     */","    nativeType: {","        validator: Lang.isString,","        value: 'date'","    }","};","","DatePickerNativeBase.prototype = {","","    /**","     * Construction logic executed during `DatePickerNativeBase` instantiation.","     * Lifecycle.","     *","     * @method initializer","     * @protected","     */","    initializer: function() {","        var instance = this;","","        instance.bindNativeUI();","    },","","    /**","     * Bind the events on the `DatePickerNativeBase` UI. Lifecycle.","     *","     * @method bindNativeUI","     */","    bindNativeUI: function() {","        var instance = this,","            container = instance.get('container'),","            selector = instance.get('selector');","","        instance._eventHandles.push(","            container.delegate(","                'touchstart',","                A.bind('_onceUserInteraction', instance), selector),","","            container.delegate(","                'change',","                A.bind('_afterNativeSelectionChange', instance), selector)","        );","    },","","    /**","     * Clears selected dates in the native calendar.","     *","     * @method clearSelection","     */","    clearSelection: function() {","        var instance = this,","            activeInput = instance.get('activeInput');","","        activeInput.val('');","    },","","    /**","     * Deselects dates in the native calendar.","     *","     * @method deselectDates","     */","    deselectDates: function() {","        var instance = this;","","        instance.clearSelection();","    },","","    /**","     * Blurs native calendar.","     *","     * @method hide","     */","    hide: function() {","        var instance = this,","            activeInput = instance.get('activeInput');","","        activeInput.blur();","    },","","    /**","     * Focus native calendar.","     *","     * @method show","     */","    show: function() {","        var instance = this,","            activeInput = instance.get('activeInput');","","        activeInput.focus();","    },","","    /**","     * Selects a date in the native calendar.","     *","     * @method selectDates","     * @param dates","     */","    selectDates: function(dates) {","        var instance = this,","            activeInput = instance.get('activeInput');","","        if (Lang.isArray(dates)) {","            dates = dates[0];","        }","","        if (Lang.isDate(dates)) {","            activeInput.val(instance._formatDate(dates));","        }","    },","","    /**","     * Renders the widget in an `<input>` node.","     *","     * @method useInputNode","     * @param node","     */","    useInputNode: function(node) {","        var instance = this,","            nativeType = instance.get('nativeType'),","            type = node.attr('type'),","            parsed;","","        instance.set('activeInput', node);","","        if (!instance._isTypeSupported(type)) {","            parsed = instance.getParsedDatesFromInputValue();","            if (parsed) {","                node.val(instance._formatDate(parsed[0]));","            }","        }","","        if (node.getAttribute('type') !== nativeType) {","            node.setAttribute('type', nativeType);","        }","","        instance._fireSelectionChange();","    },","","    /**","     * Adds four digits as a padding for the year value.","     *","     * @method _addFourDigitsYearPadding","     * @param text","     * @protected","     * @return {String} The result of the string manipulation.","     */","    _addFourDigitsYearPadding: function(text) {","        return A.Lang.String.repeat('0', 4 - text.indexOf('-')) + text;","    },","","    /**","     * Fires after a selection change in the native calendar.","     *","     * @method _afterNativeSelectionChange","     * @param event","     * @protected","     */","    _afterNativeSelectionChange: function(event) {","        var instance = this,","            type = event.currentTarget.attr('type');","","        if (instance._isTypeSupported(type)) {","            instance._fireSelectionChange();","        }","    },","","    /**","     * Fires a selection change.","     *","     * @method _fireSelectionChange","     * @protected","     */","    _fireSelectionChange: function() {","        var instance = this,","            activeInput = instance.get('activeInput'),","            parsed = instance._parseDateFromString(activeInput.val());","","        instance.fire(","            'selectionChange', {","                newSelection: parsed ? [parsed] : []","            });","    },","","    /**","     * Formats native date.","     *","     * @method _formatDate","     * @param date","     * @protected","     * @return {Date}","     */","    _formatDate: function(date) {","        var instance = this,","            nativeMask = instance.get('nativeMask'),","            nativeType = instance.get('nativeType'),","            formatted = A.Date.format(date, {","                format: nativeMask","            });","","        if (nativeType === 'date') {","            formatted = instance._addFourDigitsYearPadding(formatted);","        }","","        return formatted;","    },","","    /**","     * Checks if type attribute is supported.","     *","     * @method _isTypeSupported","     * @param type","     * @protected","     * @return {Boolean}","     */","    _isTypeSupported: function(type) {","        switch (type.toLowerCase()) {","            case 'date':","            case 'time':","                return true;","            default:","                return false;","        }","    },","","    /**","     * Parses a date from a string.","     *","     * @method _parseDateFromString","     * @param text","     * @protected","     * @return {Date}","     */","    _parseDateFromString: function(text) {","        var instance = this,","            nativeMask = instance.get('nativeMask');","","        if (!text) {","            return false;","        }","","        return A.Date.parse(nativeMask, text);","    }","};","","A.DatePickerNativeBase = DatePickerNativeBase;","","/**"," * A base class for `DatePickerNative`."," *"," * @class A.DatePickerNative"," * @extends Base"," * @uses A.DatePickerDelegate, A.DatePickerNativeBase"," * @param {Object} config Object literal specifying widget configuration"," *     properties."," * @constructor"," */","A.DatePickerNative = A.Base.create('datepicker-native', A.Base, [A.DatePickerDelegate, A.DatePickerNativeBase]);","","","}, '3.0.3-deprecated.10', {\"requires\": [\"base\", \"base-build\", \"aui-node-base\", \"aui-datepicker-delegate\"]});","","}());"]};
}
var __cov_QpVrMN51hZDGf7cSVIoSZA = __coverage__['build/aui-datepicker-native/aui-datepicker-native.js'];
__cov_QpVrMN51hZDGf7cSVIoSZA.s['1']++;YUI.add('aui-datepicker-native',function(A,NAME){__cov_QpVrMN51hZDGf7cSVIoSZA.f['1']++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['2']++;var Lang=A.Lang;__cov_QpVrMN51hZDGf7cSVIoSZA.s['3']++;function DatePickerNativeBase(){__cov_QpVrMN51hZDGf7cSVIoSZA.f['2']++;}__cov_QpVrMN51hZDGf7cSVIoSZA.s['4']++;DatePickerNativeBase.ATTRS={nativeMask:{validator:Lang.isString,value:'%Y-%m-%d'},nativeType:{validator:Lang.isString,value:'date'}};__cov_QpVrMN51hZDGf7cSVIoSZA.s['5']++;DatePickerNativeBase.prototype={initializer:function(){__cov_QpVrMN51hZDGf7cSVIoSZA.f['3']++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['6']++;var instance=this;__cov_QpVrMN51hZDGf7cSVIoSZA.s['7']++;instance.bindNativeUI();},bindNativeUI:function(){__cov_QpVrMN51hZDGf7cSVIoSZA.f['4']++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['8']++;var instance=this,container=instance.get('container'),selector=instance.get('selector');__cov_QpVrMN51hZDGf7cSVIoSZA.s['9']++;instance._eventHandles.push(container.delegate('touchstart',A.bind('_onceUserInteraction',instance),selector),container.delegate('change',A.bind('_afterNativeSelectionChange',instance),selector));},clearSelection:function(){__cov_QpVrMN51hZDGf7cSVIoSZA.f['5']++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['10']++;var instance=this,activeInput=instance.get('activeInput');__cov_QpVrMN51hZDGf7cSVIoSZA.s['11']++;activeInput.val('');},deselectDates:function(){__cov_QpVrMN51hZDGf7cSVIoSZA.f['6']++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['12']++;var instance=this;__cov_QpVrMN51hZDGf7cSVIoSZA.s['13']++;instance.clearSelection();},hide:function(){__cov_QpVrMN51hZDGf7cSVIoSZA.f['7']++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['14']++;var instance=this,activeInput=instance.get('activeInput');__cov_QpVrMN51hZDGf7cSVIoSZA.s['15']++;activeInput.blur();},show:function(){__cov_QpVrMN51hZDGf7cSVIoSZA.f['8']++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['16']++;var instance=this,activeInput=instance.get('activeInput');__cov_QpVrMN51hZDGf7cSVIoSZA.s['17']++;activeInput.focus();},selectDates:function(dates){__cov_QpVrMN51hZDGf7cSVIoSZA.f['9']++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['18']++;var instance=this,activeInput=instance.get('activeInput');__cov_QpVrMN51hZDGf7cSVIoSZA.s['19']++;if(Lang.isArray(dates)){__cov_QpVrMN51hZDGf7cSVIoSZA.b['1'][0]++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['20']++;dates=dates[0];}else{__cov_QpVrMN51hZDGf7cSVIoSZA.b['1'][1]++;}__cov_QpVrMN51hZDGf7cSVIoSZA.s['21']++;if(Lang.isDate(dates)){__cov_QpVrMN51hZDGf7cSVIoSZA.b['2'][0]++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['22']++;activeInput.val(instance._formatDate(dates));}else{__cov_QpVrMN51hZDGf7cSVIoSZA.b['2'][1]++;}},useInputNode:function(node){__cov_QpVrMN51hZDGf7cSVIoSZA.f['10']++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['23']++;var instance=this,nativeType=instance.get('nativeType'),type=node.attr('type'),parsed;__cov_QpVrMN51hZDGf7cSVIoSZA.s['24']++;instance.set('activeInput',node);__cov_QpVrMN51hZDGf7cSVIoSZA.s['25']++;if(!instance._isTypeSupported(type)){__cov_QpVrMN51hZDGf7cSVIoSZA.b['3'][0]++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['26']++;parsed=instance.getParsedDatesFromInputValue();__cov_QpVrMN51hZDGf7cSVIoSZA.s['27']++;if(parsed){__cov_QpVrMN51hZDGf7cSVIoSZA.b['4'][0]++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['28']++;node.val(instance._formatDate(parsed[0]));}else{__cov_QpVrMN51hZDGf7cSVIoSZA.b['4'][1]++;}}else{__cov_QpVrMN51hZDGf7cSVIoSZA.b['3'][1]++;}__cov_QpVrMN51hZDGf7cSVIoSZA.s['29']++;if(node.getAttribute('type')!==nativeType){__cov_QpVrMN51hZDGf7cSVIoSZA.b['5'][0]++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['30']++;node.setAttribute('type',nativeType);}else{__cov_QpVrMN51hZDGf7cSVIoSZA.b['5'][1]++;}__cov_QpVrMN51hZDGf7cSVIoSZA.s['31']++;instance._fireSelectionChange();},_addFourDigitsYearPadding:function(text){__cov_QpVrMN51hZDGf7cSVIoSZA.f['11']++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['32']++;return A.Lang.String.repeat('0',4-text.indexOf('-'))+text;},_afterNativeSelectionChange:function(event){__cov_QpVrMN51hZDGf7cSVIoSZA.f['12']++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['33']++;var instance=this,type=event.currentTarget.attr('type');__cov_QpVrMN51hZDGf7cSVIoSZA.s['34']++;if(instance._isTypeSupported(type)){__cov_QpVrMN51hZDGf7cSVIoSZA.b['6'][0]++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['35']++;instance._fireSelectionChange();}else{__cov_QpVrMN51hZDGf7cSVIoSZA.b['6'][1]++;}},_fireSelectionChange:function(){__cov_QpVrMN51hZDGf7cSVIoSZA.f['13']++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['36']++;var instance=this,activeInput=instance.get('activeInput'),parsed=instance._parseDateFromString(activeInput.val());__cov_QpVrMN51hZDGf7cSVIoSZA.s['37']++;instance.fire('selectionChange',{newSelection:parsed?(__cov_QpVrMN51hZDGf7cSVIoSZA.b['7'][0]++,[parsed]):(__cov_QpVrMN51hZDGf7cSVIoSZA.b['7'][1]++,[])});},_formatDate:function(date){__cov_QpVrMN51hZDGf7cSVIoSZA.f['14']++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['38']++;var instance=this,nativeMask=instance.get('nativeMask'),nativeType=instance.get('nativeType'),formatted=A.Date.format(date,{format:nativeMask});__cov_QpVrMN51hZDGf7cSVIoSZA.s['39']++;if(nativeType==='date'){__cov_QpVrMN51hZDGf7cSVIoSZA.b['8'][0]++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['40']++;formatted=instance._addFourDigitsYearPadding(formatted);}else{__cov_QpVrMN51hZDGf7cSVIoSZA.b['8'][1]++;}__cov_QpVrMN51hZDGf7cSVIoSZA.s['41']++;return formatted;},_isTypeSupported:function(type){__cov_QpVrMN51hZDGf7cSVIoSZA.f['15']++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['42']++;switch(type.toLowerCase()){case'date':__cov_QpVrMN51hZDGf7cSVIoSZA.b['9'][0]++;case'time':__cov_QpVrMN51hZDGf7cSVIoSZA.b['9'][1]++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['43']++;return true;default:__cov_QpVrMN51hZDGf7cSVIoSZA.b['9'][2]++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['44']++;return false;}},_parseDateFromString:function(text){__cov_QpVrMN51hZDGf7cSVIoSZA.f['16']++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['45']++;var instance=this,nativeMask=instance.get('nativeMask');__cov_QpVrMN51hZDGf7cSVIoSZA.s['46']++;if(!text){__cov_QpVrMN51hZDGf7cSVIoSZA.b['10'][0]++;__cov_QpVrMN51hZDGf7cSVIoSZA.s['47']++;return false;}else{__cov_QpVrMN51hZDGf7cSVIoSZA.b['10'][1]++;}__cov_QpVrMN51hZDGf7cSVIoSZA.s['48']++;return A.Date.parse(nativeMask,text);}};__cov_QpVrMN51hZDGf7cSVIoSZA.s['49']++;A.DatePickerNativeBase=DatePickerNativeBase;__cov_QpVrMN51hZDGf7cSVIoSZA.s['50']++;A.DatePickerNative=A.Base.create('datepicker-native',A.Base,[A.DatePickerDelegate,A.DatePickerNativeBase]);},'3.0.3-deprecated.10',{'requires':['base','base-build','aui-node-base','aui-datepicker-delegate']});
