if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/aui-char-counter/aui-char-counter.js']) {
   __coverage__['build/aui-char-counter/aui-char-counter.js'] = {"path":"build/aui-char-counter/aui-char-counter.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0,"45":0,"46":0,"47":0,"48":0,"49":0,"50":0,"51":0,"52":0,"53":0,"54":0,"55":0,"56":0,"57":0,"58":0,"59":0,"60":0,"61":0,"62":0,"63":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":28},"end":{"line":1,"column":47}}},"2":{"name":"(anonymous_2)","line":82,"loc":{"start":{"line":82,"column":20},"end":{"line":82,"column":32}}},"3":{"name":"(anonymous_3)","line":127,"loc":{"start":{"line":127,"column":21},"end":{"line":127,"column":32}}},"4":{"name":"(anonymous_4)","line":141,"loc":{"start":{"line":141,"column":16},"end":{"line":141,"column":27}}},"5":{"name":"(anonymous_5)","line":165,"loc":{"start":{"line":165,"column":16},"end":{"line":165,"column":27}}},"6":{"name":"(anonymous_6)","line":185,"loc":{"start":{"line":185,"column":17},"end":{"line":185,"column":28}}},"7":{"name":"(anonymous_7)","line":202,"loc":{"start":{"line":202,"column":21},"end":{"line":202,"column":32}}},"8":{"name":"(anonymous_8)","line":250,"loc":{"start":{"line":250,"column":30},"end":{"line":250,"column":46}}},"9":{"name":"(anonymous_9)","line":269,"loc":{"start":{"line":269,"column":24},"end":{"line":269,"column":35}}},"10":{"name":"(anonymous_10)","line":284,"loc":{"start":{"line":284,"column":32},"end":{"line":284,"column":43}}},"11":{"name":"(anonymous_11)","line":299,"loc":{"start":{"line":299,"column":34},"end":{"line":299,"column":45}}},"12":{"name":"(anonymous_12)","line":314,"loc":{"start":{"line":314,"column":23},"end":{"line":314,"column":35}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":330,"column":89}},"2":{"start":{"line":9,"column":0},"end":{"line":10,"column":26}},"3":{"start":{"line":12,"column":4},"end":{"line":12,"column":41}},"4":{"start":{"line":13,"column":4},"end":{"line":13,"column":43}},"5":{"start":{"line":31,"column":0},"end":{"line":325,"column":3}},"6":{"start":{"line":83,"column":16},"end":{"line":83,"column":45}},"7":{"start":{"line":128,"column":12},"end":{"line":128,"column":32}},"8":{"start":{"line":130,"column":12},"end":{"line":130,"column":30}},"9":{"start":{"line":132,"column":12},"end":{"line":132,"column":35}},"10":{"start":{"line":142,"column":12},"end":{"line":142,"column":32}},"11":{"start":{"line":143,"column":12},"end":{"line":143,"column":46}},"12":{"start":{"line":145,"column":12},"end":{"line":145,"column":42}},"13":{"start":{"line":147,"column":12},"end":{"line":147,"column":68}},"14":{"start":{"line":149,"column":12},"end":{"line":156,"column":13}},"15":{"start":{"line":150,"column":16},"end":{"line":155,"column":18}},"16":{"start":{"line":166,"column":12},"end":{"line":166,"column":32}},"17":{"start":{"line":167,"column":12},"end":{"line":167,"column":50}},"18":{"start":{"line":169,"column":12},"end":{"line":175,"column":13}},"19":{"start":{"line":170,"column":16},"end":{"line":170,"column":56}},"20":{"start":{"line":172,"column":16},"end":{"line":172,"column":100}},"21":{"start":{"line":174,"column":16},"end":{"line":174,"column":43}},"22":{"start":{"line":186,"column":12},"end":{"line":186,"column":32}},"23":{"start":{"line":188,"column":12},"end":{"line":188,"column":65}},"24":{"start":{"line":203,"column":12},"end":{"line":203,"column":32}},"25":{"start":{"line":204,"column":12},"end":{"line":204,"column":46}},"26":{"start":{"line":206,"column":12},"end":{"line":206,"column":36}},"27":{"start":{"line":208,"column":12},"end":{"line":237,"column":13}},"28":{"start":{"line":209,"column":16},"end":{"line":209,"column":58}},"29":{"start":{"line":210,"column":16},"end":{"line":210,"column":40}},"30":{"start":{"line":212,"column":16},"end":{"line":212,"column":76}},"31":{"start":{"line":214,"column":16},"end":{"line":214,"column":35}},"32":{"start":{"line":216,"column":16},"end":{"line":230,"column":17}},"33":{"start":{"line":217,"column":20},"end":{"line":217,"column":59}},"34":{"start":{"line":218,"column":20},"end":{"line":218,"column":61}},"35":{"start":{"line":220,"column":20},"end":{"line":220,"column":83}},"36":{"start":{"line":222,"column":20},"end":{"line":222,"column":59}},"37":{"start":{"line":224,"column":20},"end":{"line":224,"column":37}},"38":{"start":{"line":226,"column":20},"end":{"line":226,"column":54}},"39":{"start":{"line":227,"column":20},"end":{"line":227,"column":56}},"40":{"start":{"line":229,"column":20},"end":{"line":229,"column":40}},"41":{"start":{"line":232,"column":16},"end":{"line":232,"column":34}},"42":{"start":{"line":234,"column":16},"end":{"line":236,"column":17}},"43":{"start":{"line":235,"column":20},"end":{"line":235,"column":47}},"44":{"start":{"line":239,"column":12},"end":{"line":239,"column":31}},"45":{"start":{"line":251,"column":12},"end":{"line":251,"column":56}},"46":{"start":{"line":253,"column":12},"end":{"line":253,"column":39}},"47":{"start":{"line":255,"column":12},"end":{"line":257,"column":13}},"48":{"start":{"line":256,"column":16},"end":{"line":256,"column":53}},"49":{"start":{"line":259,"column":12},"end":{"line":259,"column":53}},"50":{"start":{"line":270,"column":12},"end":{"line":270,"column":32}},"51":{"start":{"line":272,"column":12},"end":{"line":274,"column":13}},"52":{"start":{"line":273,"column":16},"end":{"line":273,"column":39}},"53":{"start":{"line":285,"column":12},"end":{"line":285,"column":32}},"54":{"start":{"line":287,"column":12},"end":{"line":287,"column":47}},"55":{"start":{"line":289,"column":12},"end":{"line":289,"column":35}},"56":{"start":{"line":300,"column":12},"end":{"line":300,"column":32}},"57":{"start":{"line":302,"column":12},"end":{"line":302,"column":46}},"58":{"start":{"line":315,"column":12},"end":{"line":315,"column":32}},"59":{"start":{"line":316,"column":12},"end":{"line":316,"column":46}},"60":{"start":{"line":318,"column":12},"end":{"line":320,"column":13}},"61":{"start":{"line":319,"column":16},"end":{"line":319,"column":42}},"62":{"start":{"line":322,"column":12},"end":{"line":322,"column":21}},"63":{"start":{"line":327,"column":0},"end":{"line":327,"column":28}}},"branchMap":{"1":{"line":149,"type":"if","locations":[{"start":{"line":149,"column":12},"end":{"line":149,"column":12}},{"start":{"line":149,"column":12},"end":{"line":149,"column":12}}]},"2":{"line":169,"type":"if","locations":[{"start":{"line":169,"column":12},"end":{"line":169,"column":12}},{"start":{"line":169,"column":12},"end":{"line":169,"column":12}}]},"3":{"line":208,"type":"if","locations":[{"start":{"line":208,"column":12},"end":{"line":208,"column":12}},{"start":{"line":208,"column":12},"end":{"line":208,"column":12}}]},"4":{"line":216,"type":"if","locations":[{"start":{"line":216,"column":16},"end":{"line":216,"column":16}},{"start":{"line":216,"column":16},"end":{"line":216,"column":16}}]},"5":{"line":234,"type":"if","locations":[{"start":{"line":234,"column":16},"end":{"line":234,"column":16}},{"start":{"line":234,"column":16},"end":{"line":234,"column":16}}]},"6":{"line":255,"type":"if","locations":[{"start":{"line":255,"column":12},"end":{"line":255,"column":12}},{"start":{"line":255,"column":12},"end":{"line":255,"column":12}}]},"7":{"line":272,"type":"if","locations":[{"start":{"line":272,"column":12},"end":{"line":272,"column":12}},{"start":{"line":272,"column":12},"end":{"line":272,"column":12}}]},"8":{"line":318,"type":"if","locations":[{"start":{"line":318,"column":12},"end":{"line":318,"column":12}},{"start":{"line":318,"column":12},"end":{"line":318,"column":12}}]},"9":{"line":318,"type":"binary-expr","locations":[{"start":{"line":318,"column":16},"end":{"line":318,"column":21}},{"start":{"line":318,"column":26},"end":{"line":318,"column":38}}]}},"code":["(function () { YUI.add('aui-char-counter', function (A, NAME) {","","/**"," * The CharCounter Utility"," *"," * @module aui-char-counter"," */","","var L = A.Lang,","    isNumber = L.isNumber;","","    A.Node.DOM_EVENTS.compositionend = 1;","    A.Node.DOM_EVENTS.compositionstart = 1;","","/**"," * A base class for CharCounter, providing:"," *"," * - Limit the number of characters allowed in an input box"," * - Display the number of characters left"," *"," * Check the [live demo](http://alloyui.com/examples/char-counter/)."," *"," * @class A.CharCounter"," * @extends Base"," * @param {Object} config Object literal specifying widget configuration"," *     properties."," * @constructor"," * @include http://alloyui.com/examples/char-counter/basic-markup.html"," * @include http://alloyui.com/examples/char-counter/basic.js"," */","var CharCounter = A.Component.create({","    /**","     * Static property provides a string to identify the class.","     *","     * @property NAME","     * @type String","     * @static","     */","    NAME: 'char-counter',","","    /**","     * Static property used to define the default attribute","     * configuration for the CharCounter.","     *","     * @property ATTRS","     * @type Object","     * @static","     */","    ATTRS: {","        /**","         * Node or Selector to display the information of the counter.","         *","         * @attribute counter","         * @default null","         * @type {Node | String}","         */","        counter: {","            setter: A.one","        },","","        /**","         * Node or Selector for the input field. Required.","         *","         * @attribute input","         * @default null","         * @type {Node | String}","         */","        input: {","            setter: A.one","        },","","        /**","         * Max number of characters the [input](A.CharCounter.html#attr_input)","         * can have.","         *","         * @attribute maxLength","         * @default Infinity","         * @type Number","         */","        maxLength: {","            lazyAdd: false,","            setter: function(v) {","                return this._setMaxLength(v);","            },","            validator: isNumber,","            value: Infinity","        }","    },","","    /**","     * Static property used to define which component it extends.","     *","     * @property EXTENDS","     * @type Object","     * @static","     */","    EXTENDS: A.Base,","","    prototype: {","","        /**","         * Holds the event handles for any bind event from the internal","         * implementation.","         *","         * @property _eventHandles","         * @type {Array}","         * @protected","         */","        _eventHandles: null,","","        /**","         * Tracks whether input is being manipulated by an IME tool.","         *","         * @property _inputComposition","         * @type {Boolean}","         * @protected","         */","        _inputComposition: false,","","        /**","         * Construction logic executed during CharCounter instantiation.","         * Lifecycle.","         *","         * @method initializer","         * @protected","         */","        initializer: function() {","            var instance = this;","","            instance.bindUI();","","            instance.checkLength();","        },","","        /**","         * Bind the events on the CharCounter UI. Lifecycle.","         *","         * @method bindUI","         * @protected","         */","        bindUI: function() {","            var instance = this;","            var input = instance.get('input');","","            instance.publish('maxLength');","","            instance.after('maxLengthChange', instance.checkLength);","","            if (input) {","                instance._eventHandles = [","                    input.on('compositionend', A.bind(instance._onInputCompositionEnd, instance)),","                    input.on('compositionstart', A.bind(instance._onInputCompositionStart, instance)),","                    // use cross browser input-handler event","                    input.on('input', A.bind(instance._onInputChange, instance))","                ];","            }","        },","","        /**","         * Sync the CharCounter UI. Lifecycle.","         *","         * @method syncUI","         * @protected","         */","        syncUI: function() {","            var instance = this;","            var counter = instance.get('counter');","","            if (counter) {","                var value = instance.get('input').val();","","                var counterValue = instance.get('maxLength') - instance._getNormalizedLength(value);","","                counter.html(counterValue);","            }","        },","","        /**","         * Destructor lifecycle implementation for the `CharCounter` class.","         * Purges events attached to the node (and all child nodes).","         *","         * @method destroy","         * @protected","         */","        destroy: function() {","            var instance = this;","","            (new A.EventHandle(instance._eventHandles)).detach();","        },","","        /**","         * Check the current value of the","         * [input](A.CharCounter.html#attr_input), truncate the data if needed,","         * and re-sync the UI. Fired from","         * [_onInputChange](A.CharCounter.html#method__onInputChange).","         *","         * @method checkLength","         * @return {Boolean | String} Returns the final value if it was changed.","         *   Otherwise returns either true, when the input value was checked, or","         *   false if there was no input to check the value for.","         */","        checkLength: function() {","            var instance = this;","            var input = instance.get('input');","","            var returnValue = false;","","            if (input) {","                var maxLength = instance.get('maxLength');","                var value = input.val();","","                var normalizedLength = instance._getNormalizedLength(value);","","                returnValue = true;","","                if (normalizedLength > maxLength) {","                    var scrollTop = input.get('scrollTop');","                    var scrollLeft = input.get('scrollLeft');","","                    var trimLength = maxLength - (normalizedLength - value.length);","","                    value = value.substring(0, trimLength);","","                    input.val(value);","","                    input.set('scrollTop', scrollTop);","                    input.set('scrollLeft', scrollLeft);","","                    returnValue = value;","                }","","                instance.syncUI();","","                if (normalizedLength >= maxLength) {","                    instance.fire('maxLength');","                }","            }","","            return returnValue;","        },","","        /**","         * Normalize reported length between browsers.","         *","         * @method _getNormalizedLength","         * @param {String} value.","         * @protected","         * @return {Number}","         */","        _getNormalizedLength: function(value) {","            var newLines = value.match(/(\\r\\n|\\n|\\r)/g);","","            var newLinesCorrection = 0;","","            if (newLines !== null) {","                newLinesCorrection = newLines.length;","            }","","            return value.length + newLinesCorrection;","        },","","        /**","         * Fired on input value change.","         *","         * @method _onInputChange","         * @param {EventFacade} event","         * @protected","         */","        _onInputChange: function() {","            var instance = this;","","            if (!instance._inputComposition) {","                instance.checkLength();","            }","        },","","        /**","         * Fired on input when `compositionend` event occurs.","         *","         * @method _onInputCompositionEnd","         * @param {EventFacade} event","         * @protected","         */","        _onInputCompositionEnd: function() {","            var instance = this;","","            instance._inputComposition = false;","","            instance.checkLength();","        },","","        /**","         * Fired on input when `compositionstart` event occurs.","         *","         * @method _onInputCompositionStart","         * @param {EventFacade} event","         * @protected","         */","        _onInputCompositionStart: function() {","            var instance = this;","","            instance._inputComposition = true;","        },","","        /**","         * Setter for [maxLength](A.CharCounter.html#attr_maxLength).","         *","         * @method _setMaxLength","         * @param {Number} v Value of the new","         *     [maxLength](A.CharCounter.html#attr_maxLength).","         * @protected","         * @return {Number}","         */","        _setMaxLength: function(v) {","            var instance = this;","            var input = instance.get('input');","","            if (input && (v < Infinity)) {","                input.set('maxLength', v);","            }","","            return v;","        }","    }","});","","A.CharCounter = CharCounter;","","","}, '3.0.3-deprecated.4', {\"requires\": [\"aui-node\", \"aui-event-input\", \"aui-component\"]});","","}());"]};
}
var __cov_NELhfFunw1OpDtGWV8fO0g = __coverage__['build/aui-char-counter/aui-char-counter.js'];
__cov_NELhfFunw1OpDtGWV8fO0g.s['1']++;YUI.add('aui-char-counter',function(A,NAME){__cov_NELhfFunw1OpDtGWV8fO0g.f['1']++;__cov_NELhfFunw1OpDtGWV8fO0g.s['2']++;var L=A.Lang,isNumber=L.isNumber;__cov_NELhfFunw1OpDtGWV8fO0g.s['3']++;A.Node.DOM_EVENTS.compositionend=1;__cov_NELhfFunw1OpDtGWV8fO0g.s['4']++;A.Node.DOM_EVENTS.compositionstart=1;__cov_NELhfFunw1OpDtGWV8fO0g.s['5']++;var CharCounter=A.Component.create({NAME:'char-counter',ATTRS:{counter:{setter:A.one},input:{setter:A.one},maxLength:{lazyAdd:false,setter:function(v){__cov_NELhfFunw1OpDtGWV8fO0g.f['2']++;__cov_NELhfFunw1OpDtGWV8fO0g.s['6']++;return this._setMaxLength(v);},validator:isNumber,value:Infinity}},EXTENDS:A.Base,prototype:{_eventHandles:null,_inputComposition:false,initializer:function(){__cov_NELhfFunw1OpDtGWV8fO0g.f['3']++;__cov_NELhfFunw1OpDtGWV8fO0g.s['7']++;var instance=this;__cov_NELhfFunw1OpDtGWV8fO0g.s['8']++;instance.bindUI();__cov_NELhfFunw1OpDtGWV8fO0g.s['9']++;instance.checkLength();},bindUI:function(){__cov_NELhfFunw1OpDtGWV8fO0g.f['4']++;__cov_NELhfFunw1OpDtGWV8fO0g.s['10']++;var instance=this;__cov_NELhfFunw1OpDtGWV8fO0g.s['11']++;var input=instance.get('input');__cov_NELhfFunw1OpDtGWV8fO0g.s['12']++;instance.publish('maxLength');__cov_NELhfFunw1OpDtGWV8fO0g.s['13']++;instance.after('maxLengthChange',instance.checkLength);__cov_NELhfFunw1OpDtGWV8fO0g.s['14']++;if(input){__cov_NELhfFunw1OpDtGWV8fO0g.b['1'][0]++;__cov_NELhfFunw1OpDtGWV8fO0g.s['15']++;instance._eventHandles=[input.on('compositionend',A.bind(instance._onInputCompositionEnd,instance)),input.on('compositionstart',A.bind(instance._onInputCompositionStart,instance)),input.on('input',A.bind(instance._onInputChange,instance))];}else{__cov_NELhfFunw1OpDtGWV8fO0g.b['1'][1]++;}},syncUI:function(){__cov_NELhfFunw1OpDtGWV8fO0g.f['5']++;__cov_NELhfFunw1OpDtGWV8fO0g.s['16']++;var instance=this;__cov_NELhfFunw1OpDtGWV8fO0g.s['17']++;var counter=instance.get('counter');__cov_NELhfFunw1OpDtGWV8fO0g.s['18']++;if(counter){__cov_NELhfFunw1OpDtGWV8fO0g.b['2'][0]++;__cov_NELhfFunw1OpDtGWV8fO0g.s['19']++;var value=instance.get('input').val();__cov_NELhfFunw1OpDtGWV8fO0g.s['20']++;var counterValue=instance.get('maxLength')-instance._getNormalizedLength(value);__cov_NELhfFunw1OpDtGWV8fO0g.s['21']++;counter.html(counterValue);}else{__cov_NELhfFunw1OpDtGWV8fO0g.b['2'][1]++;}},destroy:function(){__cov_NELhfFunw1OpDtGWV8fO0g.f['6']++;__cov_NELhfFunw1OpDtGWV8fO0g.s['22']++;var instance=this;__cov_NELhfFunw1OpDtGWV8fO0g.s['23']++;new A.EventHandle(instance._eventHandles).detach();},checkLength:function(){__cov_NELhfFunw1OpDtGWV8fO0g.f['7']++;__cov_NELhfFunw1OpDtGWV8fO0g.s['24']++;var instance=this;__cov_NELhfFunw1OpDtGWV8fO0g.s['25']++;var input=instance.get('input');__cov_NELhfFunw1OpDtGWV8fO0g.s['26']++;var returnValue=false;__cov_NELhfFunw1OpDtGWV8fO0g.s['27']++;if(input){__cov_NELhfFunw1OpDtGWV8fO0g.b['3'][0]++;__cov_NELhfFunw1OpDtGWV8fO0g.s['28']++;var maxLength=instance.get('maxLength');__cov_NELhfFunw1OpDtGWV8fO0g.s['29']++;var value=input.val();__cov_NELhfFunw1OpDtGWV8fO0g.s['30']++;var normalizedLength=instance._getNormalizedLength(value);__cov_NELhfFunw1OpDtGWV8fO0g.s['31']++;returnValue=true;__cov_NELhfFunw1OpDtGWV8fO0g.s['32']++;if(normalizedLength>maxLength){__cov_NELhfFunw1OpDtGWV8fO0g.b['4'][0]++;__cov_NELhfFunw1OpDtGWV8fO0g.s['33']++;var scrollTop=input.get('scrollTop');__cov_NELhfFunw1OpDtGWV8fO0g.s['34']++;var scrollLeft=input.get('scrollLeft');__cov_NELhfFunw1OpDtGWV8fO0g.s['35']++;var trimLength=maxLength-(normalizedLength-value.length);__cov_NELhfFunw1OpDtGWV8fO0g.s['36']++;value=value.substring(0,trimLength);__cov_NELhfFunw1OpDtGWV8fO0g.s['37']++;input.val(value);__cov_NELhfFunw1OpDtGWV8fO0g.s['38']++;input.set('scrollTop',scrollTop);__cov_NELhfFunw1OpDtGWV8fO0g.s['39']++;input.set('scrollLeft',scrollLeft);__cov_NELhfFunw1OpDtGWV8fO0g.s['40']++;returnValue=value;}else{__cov_NELhfFunw1OpDtGWV8fO0g.b['4'][1]++;}__cov_NELhfFunw1OpDtGWV8fO0g.s['41']++;instance.syncUI();__cov_NELhfFunw1OpDtGWV8fO0g.s['42']++;if(normalizedLength>=maxLength){__cov_NELhfFunw1OpDtGWV8fO0g.b['5'][0]++;__cov_NELhfFunw1OpDtGWV8fO0g.s['43']++;instance.fire('maxLength');}else{__cov_NELhfFunw1OpDtGWV8fO0g.b['5'][1]++;}}else{__cov_NELhfFunw1OpDtGWV8fO0g.b['3'][1]++;}__cov_NELhfFunw1OpDtGWV8fO0g.s['44']++;return returnValue;},_getNormalizedLength:function(value){__cov_NELhfFunw1OpDtGWV8fO0g.f['8']++;__cov_NELhfFunw1OpDtGWV8fO0g.s['45']++;var newLines=value.match(/(\r\n|\n|\r)/g);__cov_NELhfFunw1OpDtGWV8fO0g.s['46']++;var newLinesCorrection=0;__cov_NELhfFunw1OpDtGWV8fO0g.s['47']++;if(newLines!==null){__cov_NELhfFunw1OpDtGWV8fO0g.b['6'][0]++;__cov_NELhfFunw1OpDtGWV8fO0g.s['48']++;newLinesCorrection=newLines.length;}else{__cov_NELhfFunw1OpDtGWV8fO0g.b['6'][1]++;}__cov_NELhfFunw1OpDtGWV8fO0g.s['49']++;return value.length+newLinesCorrection;},_onInputChange:function(){__cov_NELhfFunw1OpDtGWV8fO0g.f['9']++;__cov_NELhfFunw1OpDtGWV8fO0g.s['50']++;var instance=this;__cov_NELhfFunw1OpDtGWV8fO0g.s['51']++;if(!instance._inputComposition){__cov_NELhfFunw1OpDtGWV8fO0g.b['7'][0]++;__cov_NELhfFunw1OpDtGWV8fO0g.s['52']++;instance.checkLength();}else{__cov_NELhfFunw1OpDtGWV8fO0g.b['7'][1]++;}},_onInputCompositionEnd:function(){__cov_NELhfFunw1OpDtGWV8fO0g.f['10']++;__cov_NELhfFunw1OpDtGWV8fO0g.s['53']++;var instance=this;__cov_NELhfFunw1OpDtGWV8fO0g.s['54']++;instance._inputComposition=false;__cov_NELhfFunw1OpDtGWV8fO0g.s['55']++;instance.checkLength();},_onInputCompositionStart:function(){__cov_NELhfFunw1OpDtGWV8fO0g.f['11']++;__cov_NELhfFunw1OpDtGWV8fO0g.s['56']++;var instance=this;__cov_NELhfFunw1OpDtGWV8fO0g.s['57']++;instance._inputComposition=true;},_setMaxLength:function(v){__cov_NELhfFunw1OpDtGWV8fO0g.f['12']++;__cov_NELhfFunw1OpDtGWV8fO0g.s['58']++;var instance=this;__cov_NELhfFunw1OpDtGWV8fO0g.s['59']++;var input=instance.get('input');__cov_NELhfFunw1OpDtGWV8fO0g.s['60']++;if((__cov_NELhfFunw1OpDtGWV8fO0g.b['9'][0]++,input)&&(__cov_NELhfFunw1OpDtGWV8fO0g.b['9'][1]++,v<Infinity)){__cov_NELhfFunw1OpDtGWV8fO0g.b['8'][0]++;__cov_NELhfFunw1OpDtGWV8fO0g.s['61']++;input.set('maxLength',v);}else{__cov_NELhfFunw1OpDtGWV8fO0g.b['8'][1]++;}__cov_NELhfFunw1OpDtGWV8fO0g.s['62']++;return v;}}});__cov_NELhfFunw1OpDtGWV8fO0g.s['63']++;A.CharCounter=CharCounter;},'3.0.3-deprecated.4',{'requires':['aui-node','aui-event-input','aui-component']});
