if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/aui-button-search-cancel/aui-button-search-cancel.js']) {
   __coverage__['build/aui-button-search-cancel/aui-button-search-cancel.js'] = {"path":"build/aui-button-search-cancel/aui-button-search-cancel.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0,"45":0,"46":0,"47":0,"48":0,"49":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":36},"end":{"line":1,"column":55}}},"2":{"name":"(anonymous_2)","line":59,"loc":{"start":{"line":59,"column":17},"end":{"line":59,"column":28}}},"3":{"name":"(anonymous_3)","line":73,"loc":{"start":{"line":73,"column":13},"end":{"line":73,"column":24}}},"4":{"name":"(anonymous_4)","line":76,"loc":{"start":{"line":76,"column":39},"end":{"line":76,"column":56}}},"5":{"name":"(anonymous_5)","line":91,"loc":{"start":{"line":91,"column":12},"end":{"line":91,"column":23}}},"6":{"name":"(anonymous_6)","line":116,"loc":{"start":{"line":116,"column":25},"end":{"line":116,"column":43}}},"7":{"name":"(anonymous_7)","line":146,"loc":{"start":{"line":146,"column":13},"end":{"line":146,"column":29}}},"8":{"name":"(anonymous_8)","line":163,"loc":{"start":{"line":163,"column":20},"end":{"line":163,"column":45}}},"9":{"name":"(anonymous_9)","line":168,"loc":{"start":{"line":168,"column":15},"end":{"line":168,"column":26}}},"10":{"name":"(anonymous_10)","line":180,"loc":{"start":{"line":180,"column":24},"end":{"line":180,"column":40}}},"11":{"name":"(anonymous_11)","line":193,"loc":{"start":{"line":193,"column":21},"end":{"line":193,"column":32}}},"12":{"name":"(anonymous_12)","line":196,"loc":{"start":{"line":196,"column":39},"end":{"line":196,"column":56}}},"13":{"name":"(anonymous_13)","line":211,"loc":{"start":{"line":211,"column":19},"end":{"line":211,"column":37}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":362,"column":3}},"2":{"start":{"line":3,"column":0},"end":{"line":6,"column":36}},"3":{"start":{"line":21,"column":0},"end":{"line":343,"column":3}},"4":{"start":{"line":60,"column":8},"end":{"line":60,"column":28}},"5":{"start":{"line":62,"column":8},"end":{"line":62,"column":31}},"6":{"start":{"line":64,"column":8},"end":{"line":64,"column":26}},"7":{"start":{"line":74,"column":8},"end":{"line":74,"column":28}},"8":{"start":{"line":76,"column":8},"end":{"line":81,"column":11}},"9":{"start":{"line":79,"column":12},"end":{"line":79,"column":79}},"10":{"start":{"line":80,"column":12},"end":{"line":80,"column":28}},"11":{"start":{"line":83,"column":8},"end":{"line":83,"column":61}},"12":{"start":{"line":92,"column":8},"end":{"line":94,"column":46}},"13":{"start":{"line":96,"column":8},"end":{"line":106,"column":10}},"14":{"start":{"line":117,"column":8},"end":{"line":118,"column":58}},"15":{"start":{"line":120,"column":8},"end":{"line":134,"column":9}},"16":{"start":{"line":121,"column":12},"end":{"line":126,"column":24}},"17":{"start":{"line":128,"column":12},"end":{"line":128,"column":50}},"18":{"start":{"line":130,"column":12},"end":{"line":130,"column":57}},"19":{"start":{"line":131,"column":12},"end":{"line":131,"column":57}},"20":{"start":{"line":133,"column":12},"end":{"line":133,"column":88}},"21":{"start":{"line":136,"column":8},"end":{"line":136,"column":22}},"22":{"start":{"line":147,"column":8},"end":{"line":148,"column":64}},"23":{"start":{"line":150,"column":8},"end":{"line":152,"column":9}},"24":{"start":{"line":151,"column":12},"end":{"line":151,"column":26}},"25":{"start":{"line":164,"column":8},"end":{"line":164,"column":28}},"26":{"start":{"line":166,"column":8},"end":{"line":166,"column":48}},"27":{"start":{"line":168,"column":8},"end":{"line":170,"column":11}},"28":{"start":{"line":169,"column":12},"end":{"line":169,"column":28}},"29":{"start":{"line":181,"column":8},"end":{"line":181,"column":28}},"30":{"start":{"line":183,"column":8},"end":{"line":183,"column":45}},"31":{"start":{"line":194,"column":8},"end":{"line":194,"column":28}},"32":{"start":{"line":196,"column":8},"end":{"line":200,"column":11}},"33":{"start":{"line":197,"column":12},"end":{"line":199,"column":13}},"34":{"start":{"line":198,"column":16},"end":{"line":198,"column":76}},"35":{"start":{"line":212,"column":8},"end":{"line":217,"column":26}},"36":{"start":{"line":219,"column":8},"end":{"line":222,"column":9}},"37":{"start":{"line":220,"column":12},"end":{"line":220,"column":26}},"38":{"start":{"line":221,"column":12},"end":{"line":221,"column":19}},"39":{"start":{"line":224,"column":8},"end":{"line":224,"column":48}},"40":{"start":{"line":225,"column":8},"end":{"line":225,"column":40}},"41":{"start":{"line":226,"column":8},"end":{"line":226,"column":46}},"42":{"start":{"line":228,"column":8},"end":{"line":228,"column":46}},"43":{"start":{"line":229,"column":8},"end":{"line":231,"column":9}},"44":{"start":{"line":230,"column":12},"end":{"line":230,"column":54}},"45":{"start":{"line":233,"column":8},"end":{"line":233,"column":44}},"46":{"start":{"line":234,"column":8},"end":{"line":236,"column":9}},"47":{"start":{"line":235,"column":12},"end":{"line":235,"column":52}},"48":{"start":{"line":238,"column":8},"end":{"line":240,"column":94}},"49":{"start":{"line":345,"column":0},"end":{"line":345,"column":42}}},"branchMap":{"1":{"line":120,"type":"if","locations":[{"start":{"line":120,"column":8},"end":{"line":120,"column":8}},{"start":{"line":120,"column":8},"end":{"line":120,"column":8}}]},"2":{"line":150,"type":"if","locations":[{"start":{"line":150,"column":8},"end":{"line":150,"column":8}},{"start":{"line":150,"column":8},"end":{"line":150,"column":8}}]},"3":{"line":197,"type":"if","locations":[{"start":{"line":197,"column":12},"end":{"line":197,"column":12}},{"start":{"line":197,"column":12},"end":{"line":197,"column":12}}]},"4":{"line":219,"type":"if","locations":[{"start":{"line":219,"column":8},"end":{"line":219,"column":8}},{"start":{"line":219,"column":8},"end":{"line":219,"column":8}}]},"5":{"line":229,"type":"if","locations":[{"start":{"line":229,"column":8},"end":{"line":229,"column":8}},{"start":{"line":229,"column":8},"end":{"line":229,"column":8}}]},"6":{"line":234,"type":"if","locations":[{"start":{"line":234,"column":8},"end":{"line":234,"column":8}},{"start":{"line":234,"column":8},"end":{"line":234,"column":8}}]}},"code":["(function () { YUI.add('aui-button-search-cancel', function (A, NAME) {","","var Lang = A.Lang,","    AArray = A.Array,","","    _DOCUMENT = A.one(A.config.doc);","","/**"," * A base class for `ButtonSearchCancel`, providing:"," *"," * - Adds a button search cancel icon in order to clear the text on inputs and"," * textareas. Similar behavior of the HTML5 search input that contains a cancel"," * button to clear the current element value."," *"," * @class A.ButtonSearchCancel"," * @extends Base"," * @param {Object} config Object literal specifying widget configuration"," *     properties."," * @constructor"," */","var ButtonSearchCancel = A.Base.create('btn-search-cancel', A.Base, [], {","    /**","     * HTML template used on the button search cancel.","     *","     * @property TEMPLATE","     * @type {String}","     * @protected","     */","    TEMPLATE: '<div class=\"' + A.getClassName('btn-search-cancel') +","        '\" style=\"padding: 5px; position: absolute; z-index: {zIndex};\">' +","        '<i class=\"{iconClass}\"></i>' + '</div>',","","    /**","     * Holds the created buttons for each element match from the trigger","     * selector.","     *","     * @property _buttons","     * @type {Array}","     * @protected","     */","    _buttons: null,","","    /**","     * Holds the event handles for any bind event from the internal","     * implementation.","     *","     * @property _eventHandles","     * @type {Array}","     * @protected","     */","    _eventHandles: null,","","    /**","     * Construction logic executed during `ButtonSearchCancel` instantiation.","     * Lifecycle.","     *","     * @method initializer","     */","    initializer: function() {","        var instance = this;","","        instance._buttons = [];","","        instance.bindUI();","    },","","    /**","     * Destructor lifecycle implementation for the `ButtonSearchCancel` class.","     *","     * @method destroy","     * @protected","     */","    destroy: function() {","        var instance = this;","","        AArray.each(instance._buttons, function(button) {","            // To avoid memory leak caused by ghost button references, clear","            // its reference from the input element first","            button.getData('btn-search-cancel').clearData('btn-search-cancel');","            button.remove();","        });","","        (new A.EventHandle(instance._eventHandles)).detach();","    },","","    /**","     * Bind events on the UI. Lifecycle.","     *","     * @method bindUI","     */","    bindUI: function() {","        var instance = this,","            container = instance.get('container'),","            trigger = instance.get('trigger');","","        instance._eventHandles = [","            container.delegate(","                ['focus', 'input'],","                A.debounce(instance._onUserInteraction, 50, instance), trigger),","            container.delegate('blur',","                A.debounce(instance._onBlur, 25, instance), trigger),","            // YUI implementation for the windowresize synthetic event do not","            // support Y.on('windowresize', fn, context) binding, therefore","            // should be wrapped using Y.bind.","            A.on('windowresize', A.bind(instance._onWindowResize, instance))","        ];","    },","","    /**","     * Delegates events on the UI. Lifecycle.","     *","     * @method getButtonForElement","     * @param {Node} element Input or textarea element align the created button.","     * @return {Node} The `Button` node for the element.","     */","    getButtonForElement: function(element) {","        var instance = this,","            button = element.getData('btn-search-cancel');","","        if (!button) {","            button = A.Node.create(","                A.Lang.sub(","                    instance.TEMPLATE, {","                        iconClass: instance.get('iconClass'),","                        zIndex: instance.get('zIndex')","                    }));","","            instance._buttons.push(button.hide());","","            button.setData('btn-search-cancel', element);","            element.setData('btn-search-cancel', button);","","            button.on('gesturemovestart', A.rbind('_onButtonClick', instance, element));","        }","","        return button;","    },","","    /**","     * Fires when the input loses focus.","     *","     * @method _onBlur","     * @param {EventFacade} event","     * @protected","     */","    _onBlur: function(event) {","        var instance = this,","            button = instance.getButtonForElement(event.target);","","        if (button) {","            button.hide();","        }","    },","","    /**","     * Fires when the user clicks on the cancel search button.","     *","     * @method _onButtonClick","     * @param {EventFacade} event","     * @param {Node} element Input or textarea element.","     * @protected","     */","    _onButtonClick: function(event, element) {","        var instance = this;","","        instance._syncButtonUI(element.val(''));","","        A.soon(function() {","            element.focus();","        });","    },","","    /**","     * Fires when the user focus or input value on the host element.","     *","     * @method _onUserInteraction","     * @param {EventFacade} event","     * @protected","     */","    _onUserInteraction: function(event) {","        var instance = this;","","        instance._syncButtonUI(event.target);","    },","","    /**","     * Fires when the user resizes the browser window.","     *","     * @method _onWindowResize","     * @param event","     * @Protected","     */","    _onWindowResize: function() {","        var instance = this;","","        AArray.each(instance._buttons, function(button) {","            if (!button.hasClass('hide')) {","                instance._syncButtonUI(button.getData('btn-search-cancel'));","            }","        });","    },","","    /**","     * Positions the cancel search button and aligns it with the passed","     * `element`.","     *","     * @method _syncButtonUI","     * @param {Node} element The input or textarea element align the button.","     * @protected","     */","    _syncButtonUI: function(element) {","        var instance = this,","            button = instance.getButtonForElement(element),","            gutter,","            buttonHeight,","            buttonWidth,","            elementRegion;","","        if (!element.val()) {","            button.hide();","            return;","        }","","        element.insert(button.show(), 'before');","        gutter = instance.get('gutter');","        elementRegion = element.get('region');","","        buttonHeight = this.get('iconHeight');","        if (!Lang.isNumber(buttonHeight)) {","            buttonHeight = button.get('offsetHeight');","        }","","        buttonWidth = this.get('iconWidth');","        if (!Lang.isNumber(buttonWidth)) {","            buttonWidth = button.get('offsetWidth');","        }","","        button.setXY([","                elementRegion.right - buttonWidth + gutter[0],","                elementRegion.top + elementRegion.height / 2 - buttonHeight / 2 + gutter[1]]);","    }","}, {","    /**","     * Static property used to define the default attribute configuration for","     * the `ButtonSearchCancel`.","     *","     * @property ATTRS","     * @type {Object}","     * @static","     */","    ATTRS: {","        /**","         * Defines the event delegation container of `ButtonSearchCancel`","         * instance.","         *","         * @attribute container","         * @type {Node}","         * @writeOnce","         */","        container: {","            setter: A.one,","            value: _DOCUMENT,","            writeOnce: true","        },","","        /**","         * Defines the space surrounding the cancel icon rendered on the input.","         * Useful when the user needs a different alignment. Gutter values are","         * added to the X and Y alignment values of the button search cancel.","         *","         * @attribute gutter","         * @default [-5, 0]","         * @type {Array}","         */","        gutter: {","            value: [-5, 0]","        },","","        /**","         * Icon CSS class to be used on the search cancel button.","         *","         * @attribute iconClass","         * @default 'glyphicon glyphicon-remove'","         * @type {String}","         */","        iconClass: {","            validator: Lang.isString,","            value: 'glyphicon glyphicon-remove'","        },","","        /**","         * Defines the width of the button. Useful when an async request","         * for resource file (image or font for example) may be necessary","         * before calculating the button's width.","         *","         * @attribute iconWidth","         * @default 24","         * @type {Number}","         */","        iconWidth: {","            value: 24","        },","","        /**","         * Defines the height of the button. Useful when an async request","         * for resource file (image or font for example) may be necessary","         * before calculating the button's height.","         *","         * @attribute iconHeight","         * @default 30","         * @type {Number}","         */","        iconHeight: {","            value: 30","        },","","        /**","         * Defines the CSS selector for the input elements the button search","         * cancel renders. Supports single or multiple node selector.","         *","         * @attribute trigger","         * @type {String}","         * @writeOnce","         */","        trigger: {","            validator: Lang.isString,","            writeOnce: true","        },","","        /**","         * Defines the z-index of the button search cancel.","         *","         * @attribute zIndex","         * @default 2","         * @type Number","         * @writeOnce","         */","        zIndex: {","            value: 2,","            writeOnce: true","        }","    }","});","","A.ButtonSearchCancel = ButtonSearchCancel;","","","}, '3.0.3-deprecated.5', {","    \"requires\": [","        \"array-invoke\",","        \"base\",","        \"base-build\",","        \"event-focus\",","        \"event-move\",","        \"event-resize\",","        \"node-screen\",","        \"node-event-delegate\",","        \"aui-node-base\",","        \"aui-classnamemanager\",","        \"aui-event-input\"","    ]","});","","}());"]};
}
var __cov_ZTgCZiw4v4agKaBivFIBPg = __coverage__['build/aui-button-search-cancel/aui-button-search-cancel.js'];
__cov_ZTgCZiw4v4agKaBivFIBPg.s['1']++;YUI.add('aui-button-search-cancel',function(A,NAME){__cov_ZTgCZiw4v4agKaBivFIBPg.f['1']++;__cov_ZTgCZiw4v4agKaBivFIBPg.s['2']++;var Lang=A.Lang,AArray=A.Array,_DOCUMENT=A.one(A.config.doc);__cov_ZTgCZiw4v4agKaBivFIBPg.s['3']++;var ButtonSearchCancel=A.Base.create('btn-search-cancel',A.Base,[],{TEMPLATE:'<div class="'+A.getClassName('btn-search-cancel')+'" style="padding: 5px; position: absolute; z-index: {zIndex};">'+'<i class="{iconClass}"></i>'+'</div>',_buttons:null,_eventHandles:null,initializer:function(){__cov_ZTgCZiw4v4agKaBivFIBPg.f['2']++;__cov_ZTgCZiw4v4agKaBivFIBPg.s['4']++;var instance=this;__cov_ZTgCZiw4v4agKaBivFIBPg.s['5']++;instance._buttons=[];__cov_ZTgCZiw4v4agKaBivFIBPg.s['6']++;instance.bindUI();},destroy:function(){__cov_ZTgCZiw4v4agKaBivFIBPg.f['3']++;__cov_ZTgCZiw4v4agKaBivFIBPg.s['7']++;var instance=this;__cov_ZTgCZiw4v4agKaBivFIBPg.s['8']++;AArray.each(instance._buttons,function(button){__cov_ZTgCZiw4v4agKaBivFIBPg.f['4']++;__cov_ZTgCZiw4v4agKaBivFIBPg.s['9']++;button.getData('btn-search-cancel').clearData('btn-search-cancel');__cov_ZTgCZiw4v4agKaBivFIBPg.s['10']++;button.remove();});__cov_ZTgCZiw4v4agKaBivFIBPg.s['11']++;new A.EventHandle(instance._eventHandles).detach();},bindUI:function(){__cov_ZTgCZiw4v4agKaBivFIBPg.f['5']++;__cov_ZTgCZiw4v4agKaBivFIBPg.s['12']++;var instance=this,container=instance.get('container'),trigger=instance.get('trigger');__cov_ZTgCZiw4v4agKaBivFIBPg.s['13']++;instance._eventHandles=[container.delegate(['focus','input'],A.debounce(instance._onUserInteraction,50,instance),trigger),container.delegate('blur',A.debounce(instance._onBlur,25,instance),trigger),A.on('windowresize',A.bind(instance._onWindowResize,instance))];},getButtonForElement:function(element){__cov_ZTgCZiw4v4agKaBivFIBPg.f['6']++;__cov_ZTgCZiw4v4agKaBivFIBPg.s['14']++;var instance=this,button=element.getData('btn-search-cancel');__cov_ZTgCZiw4v4agKaBivFIBPg.s['15']++;if(!button){__cov_ZTgCZiw4v4agKaBivFIBPg.b['1'][0]++;__cov_ZTgCZiw4v4agKaBivFIBPg.s['16']++;button=A.Node.create(A.Lang.sub(instance.TEMPLATE,{iconClass:instance.get('iconClass'),zIndex:instance.get('zIndex')}));__cov_ZTgCZiw4v4agKaBivFIBPg.s['17']++;instance._buttons.push(button.hide());__cov_ZTgCZiw4v4agKaBivFIBPg.s['18']++;button.setData('btn-search-cancel',element);__cov_ZTgCZiw4v4agKaBivFIBPg.s['19']++;element.setData('btn-search-cancel',button);__cov_ZTgCZiw4v4agKaBivFIBPg.s['20']++;button.on('gesturemovestart',A.rbind('_onButtonClick',instance,element));}else{__cov_ZTgCZiw4v4agKaBivFIBPg.b['1'][1]++;}__cov_ZTgCZiw4v4agKaBivFIBPg.s['21']++;return button;},_onBlur:function(event){__cov_ZTgCZiw4v4agKaBivFIBPg.f['7']++;__cov_ZTgCZiw4v4agKaBivFIBPg.s['22']++;var instance=this,button=instance.getButtonForElement(event.target);__cov_ZTgCZiw4v4agKaBivFIBPg.s['23']++;if(button){__cov_ZTgCZiw4v4agKaBivFIBPg.b['2'][0]++;__cov_ZTgCZiw4v4agKaBivFIBPg.s['24']++;button.hide();}else{__cov_ZTgCZiw4v4agKaBivFIBPg.b['2'][1]++;}},_onButtonClick:function(event,element){__cov_ZTgCZiw4v4agKaBivFIBPg.f['8']++;__cov_ZTgCZiw4v4agKaBivFIBPg.s['25']++;var instance=this;__cov_ZTgCZiw4v4agKaBivFIBPg.s['26']++;instance._syncButtonUI(element.val(''));__cov_ZTgCZiw4v4agKaBivFIBPg.s['27']++;A.soon(function(){__cov_ZTgCZiw4v4agKaBivFIBPg.f['9']++;__cov_ZTgCZiw4v4agKaBivFIBPg.s['28']++;element.focus();});},_onUserInteraction:function(event){__cov_ZTgCZiw4v4agKaBivFIBPg.f['10']++;__cov_ZTgCZiw4v4agKaBivFIBPg.s['29']++;var instance=this;__cov_ZTgCZiw4v4agKaBivFIBPg.s['30']++;instance._syncButtonUI(event.target);},_onWindowResize:function(){__cov_ZTgCZiw4v4agKaBivFIBPg.f['11']++;__cov_ZTgCZiw4v4agKaBivFIBPg.s['31']++;var instance=this;__cov_ZTgCZiw4v4agKaBivFIBPg.s['32']++;AArray.each(instance._buttons,function(button){__cov_ZTgCZiw4v4agKaBivFIBPg.f['12']++;__cov_ZTgCZiw4v4agKaBivFIBPg.s['33']++;if(!button.hasClass('hide')){__cov_ZTgCZiw4v4agKaBivFIBPg.b['3'][0]++;__cov_ZTgCZiw4v4agKaBivFIBPg.s['34']++;instance._syncButtonUI(button.getData('btn-search-cancel'));}else{__cov_ZTgCZiw4v4agKaBivFIBPg.b['3'][1]++;}});},_syncButtonUI:function(element){__cov_ZTgCZiw4v4agKaBivFIBPg.f['13']++;__cov_ZTgCZiw4v4agKaBivFIBPg.s['35']++;var instance=this,button=instance.getButtonForElement(element),gutter,buttonHeight,buttonWidth,elementRegion;__cov_ZTgCZiw4v4agKaBivFIBPg.s['36']++;if(!element.val()){__cov_ZTgCZiw4v4agKaBivFIBPg.b['4'][0]++;__cov_ZTgCZiw4v4agKaBivFIBPg.s['37']++;button.hide();__cov_ZTgCZiw4v4agKaBivFIBPg.s['38']++;return;}else{__cov_ZTgCZiw4v4agKaBivFIBPg.b['4'][1]++;}__cov_ZTgCZiw4v4agKaBivFIBPg.s['39']++;element.insert(button.show(),'before');__cov_ZTgCZiw4v4agKaBivFIBPg.s['40']++;gutter=instance.get('gutter');__cov_ZTgCZiw4v4agKaBivFIBPg.s['41']++;elementRegion=element.get('region');__cov_ZTgCZiw4v4agKaBivFIBPg.s['42']++;buttonHeight=this.get('iconHeight');__cov_ZTgCZiw4v4agKaBivFIBPg.s['43']++;if(!Lang.isNumber(buttonHeight)){__cov_ZTgCZiw4v4agKaBivFIBPg.b['5'][0]++;__cov_ZTgCZiw4v4agKaBivFIBPg.s['44']++;buttonHeight=button.get('offsetHeight');}else{__cov_ZTgCZiw4v4agKaBivFIBPg.b['5'][1]++;}__cov_ZTgCZiw4v4agKaBivFIBPg.s['45']++;buttonWidth=this.get('iconWidth');__cov_ZTgCZiw4v4agKaBivFIBPg.s['46']++;if(!Lang.isNumber(buttonWidth)){__cov_ZTgCZiw4v4agKaBivFIBPg.b['6'][0]++;__cov_ZTgCZiw4v4agKaBivFIBPg.s['47']++;buttonWidth=button.get('offsetWidth');}else{__cov_ZTgCZiw4v4agKaBivFIBPg.b['6'][1]++;}__cov_ZTgCZiw4v4agKaBivFIBPg.s['48']++;button.setXY([elementRegion.right-buttonWidth+gutter[0],elementRegion.top+elementRegion.height/2-buttonHeight/2+gutter[1]]);}},{ATTRS:{container:{setter:A.one,value:_DOCUMENT,writeOnce:true},gutter:{value:[-5,0]},iconClass:{validator:Lang.isString,value:'glyphicon glyphicon-remove'},iconWidth:{value:24},iconHeight:{value:30},trigger:{validator:Lang.isString,writeOnce:true},zIndex:{value:2,writeOnce:true}}});__cov_ZTgCZiw4v4agKaBivFIBPg.s['49']++;A.ButtonSearchCancel=ButtonSearchCancel;},'3.0.3-deprecated.5',{'requires':['array-invoke','base','base-build','event-focus','event-move','event-resize','node-screen','node-event-delegate','aui-node-base','aui-classnamemanager','aui-event-input']});
