﻿// (c) ammap.com | SVG (in JSON format) map of Zimbabwe - Low
// areas: {id:"ZW-BU"},{id:"ZW-HA"},{id:"ZW-MA"},{id:"ZW-MC"},{id:"ZW-ME"},{id:"ZW-MI"},{id:"ZW-MN"},{id:"ZW-MS"},{id:"ZW-MV"},{id:"ZW-MW"}
AmCharts.maps.zimbabweLow={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"25.236468",
				"topLatitude":"-15.610101",
				"rightLongitude":"33.056935",
				"bottomLatitude":"-22.420971"
			}
		},
		"g":{
			"path":[
				{
					"id":"ZW-BU",
					"title":"Bulawayo",
					"d":"M282.643,404.8L281.918,403.872L277.547,403.515L276.53,406.89L273.083,404.795L273.083,404.795L274.521,401.47L273.034,400.4L272.644,398.403L269.564,399.64L267.914,398.975L264.962,399.274L263.957,398.696L264.209,397.397L266.115,396.479L266.728,395.548L266.128,394.689L267.081,391.444L265.897,387.654L266.351,386.479L267.319,386.487L273.109,389.625L275.624,387.938L279.827,387.035L279.483,390.285L279.923,390.938L281.375,391.071L283.869,392.595L286.259,391.31L286.489,393.386L288.502,394.294L287.228,398.067L289.962,400.202L290.12,400.976L288.652,403.122z"
				},
				{
					"id":"ZW-HA",
					"title":"Harare",
					"d":"M489.891,178.68L492.159,178.907L492.654,181.307L498.982,181.827L499.438,184.108L498.746,187.157L499.753,188.794L499.856,191.879L501.114,194.837L500.842,195.681L499.375,196.492L498.803,199.664L496.851,199.557L494.792,201.174L495.215,204.46L494.637,207.032L492.028,207.434L492.41,208.71L493.903,209.646L491.522,211.506L489.729,211.598L487.545,212.655L482.369,207.869L474.328,203.018L474.328,203.018L477.43,201.999L478.1,201.032L476.853,199.034L474.055,197.444L475.631,194.829L474.067,193.113L474.489,190.465L477.152,189.77L478.096,188.001L480.313,186.227L480.973,183.539L480.973,183.539L482.773,185.171L484.685,185.28L485.593,184.313L486.711,184.828L488.42,184.617L489.763,183.087z"
				},
				{
					"id":"ZW-MA",
					"title":"Manicaland",
					"d":"M647.911,168.686L648.366,169.65L650.689,170.167L652.785,172.144L653.541,173.19L653.449,175.214L651.419,179.111L650.922,181.815L651.614,183.404L650.199,183.336L650.086,183.81L650.499,185.612L652.137,186.697L651.067,187.693L650.77,190.5L647.354,190.538L646.582,191.897L646.051,199.723L647.617,200.298L647.976,201.138L647.331,203.789L646.783,204.608L645.536,204.62L645.08,206.887L646.522,214.131L647.75,217.336L647.571,220.311L649.721,222.638L649.598,224.668L650.66,228.9L649.716,231.731L650.096,234.542L653.271,237.088L653.166,237.934L654.527,239.553L653.832,241.1L651.912,242.115L651.285,245.636L651.837,247.936L651.122,249.362L648.168,250.753L646.602,249.735L643.219,251.828L641.889,251.617L640.855,252.255L640.251,253.622L641.183,256.741L640.368,258.605L641.451,259.658L642.322,262.327L646.08,268.365L643.876,275.05L640.914,277.688L639.674,277.766L636.189,276.044L634.327,276.374L625.802,280.971L625.2,283.006L626.814,286.029L627.378,289.044L624.839,290.377L625.608,295.765L626.704,297.792L629.576,298.159L633.288,297.097L635.975,297.049L636.968,297.792L637.469,301.314L638.029,302.37L639.134,302.84L639.656,304.223L637.265,316.188L637.35,321.474L631.202,327.443L631.135,328.253L631.977,329.679L631.205,335.247L631.701,336.751L633.455,337.677L636.934,337.603L636.542,341.352L637.462,343.326L637.156,349.351L637.594,350.612L636.118,355.332L637.374,355.991L640.688,355.994L647.31,353.36L648.31,356.027L646.344,358.39L646.459,359.386L649.293,361.537L653.167,363.269L654.34,364.475L654.635,366.122L650.837,385.559L647.364,387.203L643.264,388.111L642.566,389.475L643.101,390.408L643.208,394.099L642.368,394.542L641.063,394.143L640.5,392.998L638.885,393.78L637.839,397.723L639.144,400.686L637.098,401.648L636.434,403.335L638.746,405.165L638.534,409.342L633.767,413.974L633.235,416.824L627.651,423.675L622.183,433.141L621.319,433.726L613.676,433.658L607.395,438.787L606.858,443.767L607.614,446.104L607.876,455.592L609.613,462.85L609.471,465.119L605.416,473.802L598.679,481.538L596.902,484.942L600.177,487.906L599.274,489.947L599.633,491.181L601.544,493.004L602.305,495.124L606.053,500.535L606.388,502.036L604.102,500.495L601.55,500.72L601.55,500.72L596.028,495.139L592.386,493.561L590.362,489.217L590.158,486.685L588.446,481.479L586.757,479.952L582.429,478.26L582.534,474.745L579.655,472.296L579.539,470.011L578.39,466.557L578.758,464.224L584.453,452.798L585.751,445.316L588.222,442.957L588.857,437.162L590.451,433.146L590.294,425.982L591.529,414.857L593.08,408.37L593.762,400.558L595.079,394.689L595.221,385.918L594.569,383.048L590.316,381.567L586.209,379.193L582.613,375.756L576.814,375.876L574.868,375.05L571.688,372.253L568.184,372.258L566.724,371.507L564.473,368.899L563.471,366.277L560.052,363.441L557.776,358.728L555.87,357.616L552.647,354.13L550.863,349.816L545.478,346.759L543.753,343.742L541.639,341.782L540.187,341.312L538.605,336.634L533.084,335.153L530.877,335.458L528.999,332.726L524.904,329.246L521.117,328.148L516.657,327.906L513.734,324.737L500.489,316.355L500.489,316.355L506.223,315.786L507.301,315.211L507.625,311.168L509.606,308.566L510.082,303.595L514.053,303.724L515.992,305.241L520.242,305.163L521.795,308.017L526.144,309.632L527.547,309.539L532.153,301.702L531.828,297.508L532.383,296.938L537.904,299.708L541.304,299.067L543.492,297.672L545.059,298.019L548.487,299.92L551.692,303.154L555.325,305.172L558.909,306.463L561.663,305.461L564.838,306.15L563.623,302.129L564.312,299.539L564.471,293.324L561.875,287.628L559.327,285.562L558.615,283.071L558.744,277.307L556.742,273.985L551.846,272.629L552.144,270.773L551.36,268.769L549.137,266.779L545.768,262.305L546.673,257.627L542.901,252.716L545.439,250.961L546.994,247.165L553.556,244.885L552.842,241.837L554.48,238.564L553.989,223.867L554.867,220.487L555.693,219.595L557.444,219.255L559.728,220.314L566.306,220.402L564.284,214.767L565.379,213.07L568.347,211.432L571.614,208.387L578.41,201.091L577.726,197.412L579.55,193.905L586.536,189.736L591.548,183.948L593.684,183.121L598.007,179.583L603.357,178.554L605.834,176.72L607.821,174.013L611.634,174.002L614.479,172.963L617.01,169.609L619.587,169.373L620.021,163.97L626.763,161.037L627.889,156.945L630.578,151.315L636.163,148.478L639.193,144.56L645.16,143.472L649.394,141.929L649.394,141.929L649.704,147.476L653.71,150.823L650.537,155.505L649.765,160.081L648.544,160.317L646.766,162.548L646.587,165.531z"
				},
				{
					"id":"ZW-MC",
					"title":"Mashonaland Central",
					"d":"M434.373,3.363L434.307,33.824L475.99,33.824L478.283,35.236L478.896,37.172L480.981,38.93L484.179,37.681L485.039,35.455L486.972,34.954L487.864,33.824L488.54,35.229L491.122,33.824L491.004,33.438L494.241,32.294L497.403,32.996L498.379,34.188L500.512,34.479L502.962,33.824L503.149,34.558L504.896,34.67L508.21,36.175L510.426,38.019L511.674,40.758L516.348,45.699L518.192,45.527L518.529,47.363L522.783,47.41L524.277,48.605L528.118,49.777L540.389,51.29L543.858,53.605L547.012,54.325L548.263,56.031L549.275,56.164L549.72,57.224L550.806,57.855L550.706,59.365L551.583,59.317L552.024,60.536L553.516,60.635L553.806,61.355L557.309,62.973L558.762,66.154L558.436,68.278L558.957,69.598L569.343,72.157L590.088,71.481L600.695,74.517L625.571,85.834L625.099,92.764L629.385,94.813L629.385,94.813L623.989,97.905L620.492,96.639L615.966,98.052L610.116,95.221L604.142,94.817L599.021,96.194L594.226,98.479L590.393,98.644L586.116,101.4L582.385,100.326L575.532,102.91L574.121,104.001L570.399,103.84L568.807,106.367L566.836,107.064L566.448,107.826L567.022,113.082L564.979,114.497L562.84,114.439L561.22,118.283L557.966,121.346L558.431,124.054L554.545,127.403L552.571,131.892L553.666,134.197L543.56,138.523L543.328,139.084L545.026,142.264L545.181,145.738L544.6,147.103L537.357,153.162L535.984,154.852L535.798,156.014L534.223,157.426L533.432,159.691L526.842,162.288L524.975,164.793L523.915,167.912L522.377,169.246L521.347,171.835L520.396,169.901L519.801,170.026L514.748,174.067L513.44,174.637L510.296,174.22L507.768,176.12L505.979,176.332L505.351,172.293L508.693,163.065L505.946,162.245L499.824,161.965L494.604,160.587L493.27,161.927L492.095,164.495L492.154,167.215L489.217,167.633L489.669,169.833L490.228,170.229L492.015,169.898L490.559,177.595L489.891,178.68L489.891,178.68L489.763,183.087L488.42,184.617L486.711,184.828L485.593,184.313L484.685,185.28L482.773,185.171L480.973,183.539L480.973,183.539L480.313,180.216L479.272,179.06L477.045,179.032L475.069,181.245L469.041,177.629L463.181,175.373L464.42,169.241L449.592,169.538L450.146,160.33L451.05,158.046L450.073,152.81L454.585,140.88L458.403,134.353L459.873,126.6L456.379,125.574L454.834,125.979L453.556,123.987L449.84,126.434L448.327,125.282L444.799,125.252L444.241,124.614L444.021,119.106L442.303,115.439L442.688,112.685L441.235,105.348L441.784,103.632L444.081,103.746L444.748,102.109L443.99,100.795L441.532,100.044L442.553,97.53L441.864,93.028L432.989,89.821L429.851,85.483L430.316,82.734L432.832,77.354L433.133,72.098L434.86,68.155L434.175,63.699L432.038,62.669L426.784,63.116L424.569,61.766L423.732,58.625L422.584,57.473L418.79,56.602L416.581,58.155L415.563,62.691L414.46,64.323L411.3,64.762L409.957,65.758L407.311,66.236L404.823,68.147L402.647,67.113L403.315,63.492L406.155,59.871L406.028,53.468L409.656,49.888L410.206,48.258L409.969,47.661L407.994,47.265L406.49,44.522L405.461,41.94L405.219,37.45L402.929,35.503L402.138,33.835L402.136,31.651L410.134,26.488L416.197,21.602L417.259,19.895L421.038,17.708L422.255,15.961L425.088,13.697L425.715,12.705L425.633,11.157L424.842,9.85L422.396,7.988L422.194,2.88L422.194,2.88L428.825,3.546L433.776,0.754L0,NaNz"
				},
				{
					"id":"ZW-ME",
					"title":"Mashonaland East",
					"d":"M638.927,95.263L640.994,96.274L643.499,94.639L648.125,95.148L647.132,100.823L642.571,111.403L636.163,113.711L644.737,126.584L648.792,136.211L649.394,141.929L649.394,141.929L645.16,143.472L639.193,144.56L636.163,148.478L630.578,151.315L627.889,156.945L626.763,161.037L620.021,163.97L619.587,169.373L617.01,169.609L614.479,172.963L611.634,174.002L607.821,174.013L605.834,176.72L603.357,178.554L598.007,179.583L593.684,183.121L591.548,183.948L586.536,189.736L579.55,193.905L577.726,197.412L578.41,201.091L571.614,208.387L568.347,211.432L565.379,213.07L564.284,214.767L566.306,220.402L559.728,220.314L557.444,219.255L555.693,219.595L554.867,220.487L553.989,223.867L554.48,238.564L552.842,241.837L553.556,244.885L546.994,247.165L545.439,250.961L542.901,252.716L546.673,257.627L545.768,262.305L549.137,266.779L551.36,268.769L552.144,270.773L551.846,272.629L556.742,273.985L558.744,277.307L558.615,283.071L559.327,285.562L561.875,287.628L564.471,293.324L564.312,299.539L563.623,302.129L564.838,306.15L561.663,305.461L558.909,306.463L555.325,305.172L551.692,303.154L548.487,299.92L545.059,298.019L543.492,297.672L541.304,299.067L537.904,299.708L532.383,296.938L531.828,297.508L532.153,301.702L527.547,309.539L526.144,309.632L521.795,308.017L520.242,305.163L515.992,305.241L514.053,303.724L510.082,303.595L509.606,308.566L507.625,311.168L507.301,315.211L506.223,315.786L500.489,316.355L500.489,316.355L490.74,316.993L482.641,318.22L481.949,317.012L482.177,309.817L475.226,308.324L474.772,312.448L473.489,312.536L473.411,312.981L474.563,316.976L472.281,318.04L471.047,319.381L471.047,319.381L463.827,314.246L461.559,310.903L458.905,310.067L459.046,306.511L460.289,306.506L460.078,304.931L455.14,296.796L457.524,293.112L456.076,292.11L456.016,288.519L448.648,289.72L440.614,285.554L440.614,285.554L442.964,282.479L445.048,282.794L445.475,279.929L449.065,277.053L449.498,275.479L449.146,269.031L451.032,270.272L452.348,269.301L453.196,270.788L456.089,265.538L457.878,263.475L458.151,262.225L461.926,257.779L462.888,244.372L464.714,242.512L464.868,241.547L458.232,233.213L457.337,229.961L457.445,227.871L462.25,223.59L462.443,222.425L461.797,220.82L462.578,218.087L465.269,214.139L463.803,208.846L466.379,206.306L466.399,202.976L467.108,201.569L470.612,201.191L474.328,203.018L474.328,203.018L482.369,207.869L487.545,212.655L489.729,211.598L491.522,211.506L493.903,209.646L492.41,208.71L492.028,207.434L494.637,207.032L495.215,204.46L494.792,201.174L496.851,199.557L498.803,199.664L499.375,196.492L500.842,195.681L501.114,194.837L499.856,191.879L499.753,188.794L498.746,187.157L499.438,184.108L498.982,181.827L492.654,181.307L492.159,178.907L489.891,178.68L489.891,178.68L490.559,177.595L492.015,169.898L490.228,170.229L489.669,169.833L489.217,167.633L492.154,167.215L492.095,164.495L493.27,161.927L494.604,160.587L499.824,161.965L505.946,162.245L508.693,163.065L505.351,172.293L505.979,176.332L507.768,176.12L510.296,174.22L513.44,174.637L514.748,174.067L519.801,170.026L520.396,169.901L521.347,171.835L522.377,169.246L523.915,167.912L524.975,164.793L526.842,162.288L533.432,159.691L534.223,157.426L535.798,156.014L535.984,154.852L537.357,153.162L544.6,147.103L545.181,145.738L545.026,142.264L543.328,139.084L543.56,138.523L553.666,134.197L552.571,131.892L554.545,127.403L558.431,124.054L557.966,121.346L561.22,118.283L562.84,114.439L564.979,114.497L567.022,113.082L566.448,107.826L566.836,107.064L568.807,106.367L570.399,103.84L574.121,104.001L575.532,102.91L582.385,100.326L586.116,101.4L590.393,98.644L594.226,98.479L599.021,96.194L604.142,94.817L610.116,95.221L615.966,98.052L620.492,96.639L623.989,97.905L629.385,94.813L629.385,94.813L630.645,95.34L635.314,95.316L636.757,94.43L637.649,95.214z"
				},
				{
					"id":"ZW-MI",
					"title":"Midlands",
					"d":"M252.632,155.293L255.377,154.877L257.954,155.581L260.749,153.883L265.043,153.559L269.978,152.358L275.912,156.366L276.549,156.29L278.042,152.62L279.638,151.551L282.401,147.771L284.073,147.264L284.847,143.989L288.134,138.614L290.794,138.512L294.306,135.137L297.805,133.68L305.069,133.483L308.013,131.901L309.165,131.788L309.717,132.47L312.077,137.719L313.538,139.365L320.594,142.479L321.66,144.163L324.161,144.494L330.031,146.8L335.313,147.061L335.548,148.421L337.333,149.628L337.957,153.912L341.568,156.085L344.897,160.218L348.75,161.871L347.712,164.35L345.88,165.786L343.645,169.383L341.812,171.059L341.81,171.981L343.634,174.431L343.142,181.201L340.525,183.813L340.425,185.361L342.015,186.609L342.093,187.291L339.657,190.13L339.293,192.615L337.335,194.935L337.13,197.421L333.286,203.748L332.194,209.283L334.091,215.476L335.444,216.967L338.937,224.092L344.121,226.602L346.708,230.831L350.101,231.605L357.841,236.732L360.557,237.583L363.312,240.123L362.508,245.433L361.027,247.523L361.423,251.791L360.46,255.171L361.138,257.59L362.337,258.357L365.658,258.203L367.656,260.865L368.936,261.471L375.738,261.197L377.579,264.02L380.139,263.014L383.262,266.683L384.504,267.168L386.064,266.845L389.309,268.942L391.79,269.225L395.311,268.217L399.315,268.617L400.998,269.786L403.078,269.018L405.843,270.668L410.606,270.461L414.492,271.584L416.176,272.307L417.186,275.37L419.63,276.01L421.598,277.821L425.08,277.249L429.459,281.149L434.395,283.193L437.287,285.081L440.614,285.554L440.614,285.554L448.648,289.72L456.016,288.519L456.076,292.11L457.524,293.112L455.14,296.796L460.078,304.931L460.289,306.506L459.046,306.511L458.905,310.067L461.559,310.903L463.827,314.246L471.047,319.381L471.047,319.381L457.098,330.537L461.644,331.283L463.14,332.813L462.266,334.315L458.895,335.223L459.166,340.242L457.2,347.866L458.282,353.816L455.866,367.21L456.618,371.63L450.978,371.858L442.261,369.745L437.347,370.372L436.716,373.419L437.896,375.892L437.3,377.558L434.888,379.149L434.695,381.099L435.952,382.517L435.39,383.128L422.322,383.696L416.682,386.065L411.235,386.238L413.906,389.119L414.315,390.5L414.12,392.736L412.796,395.544L412.767,399.244L412.049,402.093L414.748,399.809L416.081,399.766L420.736,402.683L422.318,404.47L419.153,411.884L419.077,413.309L420.092,414.487L425.032,416.346L426.871,420.861L428.731,420.774L432.921,425.893L434.271,428.903L436.877,432.195L436.824,437.985L438.55,442.75L442.208,444.979L442.052,446L440.191,446.824L439.791,447.642L437.446,456.836L436.817,468.81L432.985,473.853L429.181,476.605L422.514,475.278L419.066,476.27L416.951,475.743L415.207,476.034L412.157,475.223L410.895,473.876L407.277,473.147L404.263,469.595L401.215,468.21L397.635,465.148L396.093,465.109L392.118,466.87L382.305,475.704L378.527,475.908L376.861,474.967L376.861,474.967L369.387,475.043L365.284,476.225L359.476,476.011L355.048,474.98L354.481,473.998L359.926,469.183L368.047,463.227L369.872,451.955L372.789,441.549L368.939,442.524L366.468,442.521L365.415,441.663L364.443,439.54L364.525,437.338L367.685,435.547L366.712,433.997L373.393,429.967L374.85,427.93L376.426,423.896L377.596,416.483L381.549,404.681L381.466,402.238L384.329,395.895L388.318,389.105L388.233,385.488L387.182,384.474L382.381,384.352L381.895,383.132L382.135,379.923L381.207,379.435L374.592,381.624L373.261,381.501L371.969,375.611L365.759,378.243L364.388,377.47L362.05,373.933L356.167,370.714L353.909,370.79L351.567,373.545L350.438,373.339L349.475,371.144L349.848,364.408L350.939,361.733L350.62,359.582L346.276,356.002L344.874,352.267L341.177,348.932L339.372,346.008L336.853,339.639L335.608,338.257L334.001,337.926L334.001,337.926L331.352,336.053L330.512,334.188L326.945,330.569L322.692,328.162L325.559,324.088L325.081,322.912L316.959,313.732L315.197,312.714L314.721,311.054L315.158,302.245L314.04,300.907L313.525,299.086L312.844,298.961L312.971,297.347L310.926,297.336L309.845,296.724L305.116,278.897L304.576,274.336L303.584,272.314L304.552,270.869L317.259,267.107L324.753,264.241L325.918,262.715L324.533,258.196L314.492,258.47L297.893,257.893L288.861,256.143L282.856,256.986L277.979,256.467L271.852,257.547L264.696,257.005L258.57,257.798L255.134,257.244L251.332,257.531L249.539,256.668L247.977,256.977L247.183,256.243L244.943,256.302L240.514,255.05L236.505,256.057L231.353,255.318L231.375,227.677L233.552,225.369L234.914,224.82L239.181,225.346L240.189,224.19L239.479,223.179L236.926,223.033L235.579,222.014L235.35,220.846L236.739,217.285L236.415,213.465L235.665,212.615L233.149,212.99L232.024,209.485L230.96,208.149L232.017,206.033L234.788,203.813L235.198,202.573L236.563,201.424L236.434,198.052L238.264,193.938L236.865,190.034L237.115,188.793L240.416,184.736L244.003,184.21L247.271,179.031L247.59,174.145L248.805,171.393L248.65,166.145L250.143,163.315L251.991,155.927z"
				},
				{
					"id":"ZW-MN",
					"title":"Matabeleland North",
					"d":"M232.597,110.062L233.75,111.677L234.069,115.951L233.089,119.175L233.668,120.938L235.122,122.509L236.177,125.551L235.336,125.667L235.728,127.669L233.759,129.783L234.838,129.946L237.762,128.956L239.122,132.295L242.374,132.565L242.462,136.124L243.914,138.255L243.5,140.05L245.093,144.343L245.151,146.984L246.769,148.239L247.706,150.247L249.925,150.908L252.632,155.293L252.632,155.293L251.991,155.927L250.143,163.315L248.65,166.145L248.805,171.393L247.59,174.145L247.271,179.031L244.003,184.21L240.416,184.736L237.115,188.793L236.865,190.034L238.264,193.938L236.434,198.052L236.563,201.424L235.198,202.573L234.788,203.813L232.017,206.033L230.96,208.149L232.024,209.485L233.149,212.99L235.665,212.615L236.415,213.465L236.739,217.285L235.35,220.846L235.579,222.014L236.926,223.033L239.479,223.179L240.189,224.19L239.181,225.346L234.914,224.82L233.552,225.369L231.375,227.677L231.353,255.318L236.505,256.057L240.514,255.05L244.943,256.302L247.183,256.243L247.977,256.977L249.539,256.668L251.332,257.531L255.134,257.244L258.57,257.798L264.696,257.005L271.852,257.547L277.979,256.467L282.856,256.986L288.861,256.143L297.893,257.893L314.492,258.47L324.533,258.196L325.918,262.715L324.753,264.241L317.259,267.107L304.552,270.869L303.584,272.314L304.576,274.336L305.116,278.897L309.845,296.724L310.926,297.336L312.971,297.347L312.844,298.961L313.525,299.086L314.04,300.907L315.158,302.245L314.721,311.054L315.197,312.714L316.959,313.732L325.081,322.912L325.559,324.088L322.692,328.162L326.945,330.569L330.512,334.188L331.352,336.053L334.001,337.926L334.001,337.926L332.948,340.636L331.618,341.481L330.451,341.314L328.726,339.93L324.625,339.063L322.369,340.065L322.485,341.483L324.731,343.519L325.69,345.549L324.106,350L319.545,353.385L319.943,354.44L323.678,357.541L323.622,362.245L322.157,366.297L322.927,367.472L318.644,370.916L311.123,368.151L314.087,379.008L306.259,387.489L299.604,387.977L303.289,390.695L296.631,396.652L294.185,403.018L291.065,406.346L291.805,407.403L287.291,410.509L282.643,404.8L282.643,404.8L288.652,403.122L290.12,400.976L289.962,400.202L287.228,398.067L288.502,394.294L286.489,393.386L286.259,391.31L283.869,392.595L281.375,391.071L279.923,390.938L279.483,390.285L279.827,387.035L275.624,387.938L273.109,389.625L267.319,386.487L266.351,386.479L265.897,387.654L267.081,391.444L266.128,394.689L266.728,395.548L266.115,396.479L264.209,397.397L263.957,398.696L264.962,399.274L267.914,398.975L269.564,399.64L272.644,398.403L273.034,400.4L274.521,401.47L273.083,404.795L273.083,404.795L270.415,405.058L267.592,409.593L266.619,410.154L263.426,409.923L260.766,414.133L257.987,407.675L256.613,407.622L251.491,401.592L249.725,400.313L248.146,396.109L246.787,394.509L241.845,391.817L239.698,392.566L233.802,392.707L230.597,394.258L226.25,389.086L224.443,395.732L222.175,400.302L217.298,399.268L215.34,397.291L212.568,396.036L207.51,390.037L204.024,387.92L201.958,385.131L200.555,384.502L196.771,380.512L195.541,375.662L191.813,370.699L187.064,370.187L180.836,365.796L174.838,365.424L169.978,367.297L160.131,365.561L157.298,366.407L152.219,366.608L148.299,367.476L145.693,366.62L141.377,366.951L128.379,370.857L125.268,373.641L122.168,374.687L122.168,374.687L117.776,373.463L115.468,373.939L111.481,366.252L105.061,362.753L99.939,361.823L98.231,359.889L96.058,355.119L92.917,355.468L90.648,353.849L92.825,350.027L89.286,346.811L84.326,347.579L81.076,345.491L79.303,345.16L77.773,343.749L76.046,339.522L75.363,334.646L73.523,333.037L73.413,330.325L69.607,321.01L69.78,319.471L67.067,316.442L67.506,314.976L66.1,312.39L61.88,307.649L60.739,305.06L60.503,302.109L63.348,298.336L62.812,295.529L60.78,290.739L58.925,287.721L57.056,287.249L52.687,283.708L48.776,281.859L48.865,279.478L47.192,276.956L46.297,274.245L46.011,270.596L46.901,268.36L45.851,265.977L45.767,263.476L42.855,260.822L39.617,260.25L38.364,259L34.026,251.631L31.166,250.608L23.886,241.635L21.185,233.782L15.363,221.755L13.324,218.648L10.875,217.698L9.982,215.761L7.13,214.675L4.606,210.44L2.59,204.055L0.013,200.654L0.045,197.1L2.183,190.326L8.765,194.037L10.865,193.879L12.006,195.119L16.056,194.535L17.187,195.065L18.506,194.509L20.296,194.811L23.268,196.565L24.45,196.312L26.353,194.163L29.147,194.452L29.978,195.045L31.114,194.37L34.042,194.035L36.377,191.976L38.843,191.736L39.319,193.836L40.36,193.679L44.46,195.058L47.144,197.91L50.668,198.608L52.177,201.782L51.127,202.98L52.404,203.748L52.196,204.754L52.773,205.832L56.366,206.97L56.86,207.868L58.825,207.54L61.731,208.384L65.074,205.947L66.908,206.343L67.688,205.646L71.523,206.521L72.699,203.847L71.798,202.919L72.581,201.8L77.93,200.305L82.78,198.097L82.617,199.304L84.996,201.095L88.105,200.806L89.939,202.425L93.085,201.913L95.652,202.816L97.878,202.539L102.141,205.1L103.898,205.249L106.925,206.774L110.91,207.012L112.169,209.498L113.815,210.333L114.276,212.471L115.806,213.22L118.363,213.205L121.667,214.81L126.342,210.336L128.701,209.721L130.521,210.203L132.907,208.983L133.579,206.737L136.105,207.302L137.335,206.631L138.607,206.863L144.289,204.842L145.762,205.109L148.545,203.797L150.759,204.769L154.86,199.064L160.115,194.619L159.912,190.508L165.861,183.557L173.633,172.851L193.112,157.571L198.529,151.336L199.277,150.135L200.434,142.019L217.05,117.346z"
				},
				{
					"id":"ZW-MS",
					"title":"Matabeleland South",
					"d":"M334.001,337.926L335.608,338.257L336.853,339.639L339.372,346.008L341.177,348.932L344.874,352.267L346.276,356.002L350.62,359.582L350.939,361.733L349.848,364.408L349.475,371.144L350.438,373.339L351.567,373.545L353.909,370.79L356.167,370.714L362.05,373.933L364.388,377.47L365.759,378.243L371.969,375.611L373.261,381.501L374.592,381.624L381.207,379.435L382.135,379.923L381.895,383.132L382.381,384.352L387.182,384.474L388.233,385.488L388.318,389.105L384.329,395.895L381.466,402.238L381.549,404.681L377.596,416.483L376.426,423.896L374.85,427.93L373.393,429.967L366.712,433.997L367.685,435.547L364.525,437.338L364.443,439.54L365.415,441.663L366.468,442.521L368.939,442.524L372.789,441.549L369.872,451.955L368.047,463.227L359.926,469.183L354.481,473.998L355.048,474.98L359.476,476.011L365.284,476.225L369.387,475.043L376.861,474.967L376.861,474.967L378.936,480.081L384.834,485.074L385.898,489.454L389.071,490.805L389.158,493.957L391.52,495.677L392.015,499.036L393.434,500.317L394.262,503.583L394.874,504.36L398.704,505.996L403.036,512.263L407.119,515.537L407.816,517.136L411.891,517.004L416.592,521.096L419.119,521.252L419.612,522.154L418.971,524.905L419.911,525.519L428.68,526.106L434.275,528.301L437.754,530.586L441.062,531.229L441.678,532.047L441.083,535.089L443.129,536.106L444.485,537.784L445.988,536.668L449.553,539.155L452.32,537.907L453.465,538.23L452.217,540.866L454.39,542.251L455.19,545.824L457.977,547.328L458.976,549.872L460.079,550.152L460.868,551.874L463.621,554.079L462.614,555.937L462.826,557.005L466.394,558.545L466.163,560.479L470.44,563.743L470.698,565.307L472.015,566.203L472.983,569.613L476.74,568.967L476.683,571.769L477.793,572.377L478.645,576.161L481.312,577.006L481.563,577.498L480.551,578.824L482.477,579.14L483.156,581.73L485.293,582.619L483.959,584.403L484.583,585.387L490.312,589.215L491.932,592.432L489.637,593.185L488.117,592.943L488.117,592.943L482.453,590.651L481.649,591.567L480.659,591.605L479.857,590.517L477.999,590.538L476.625,589.286L474.12,588.847L472.63,589.602L468.695,588.451L458.086,590.714L454.287,590.16L451.644,592.439L448.552,590.949L446.233,591.119L445.041,592.021L439.731,590.646L430.761,593.753L425.244,593.466L423.058,594.236L421.674,593.393L420.327,591.037L418.11,588.802L411.933,589.158L409.322,590.168L403.62,585.317L400.905,585.003L400.232,582.782L396.238,582.354L392.54,579.275L389.092,579.691L387.032,577.951L384.616,577.93L382.453,577.079L379.804,574.915L371.352,574.681L370.019,573.449L367.632,574.394L366.128,576.197L363.615,574.868L360.185,575.925L359.239,578.202L353.895,577.135L350.174,577.856L347.318,579.472L345.243,579.877L343.002,576.572L339.071,573.138L337.188,568.917L335.84,567.661L330.63,569.365L327.312,569.145L323.965,567.808L319.632,564.234L317.558,560.44L316.881,556.133L318.346,549.853L321.469,546.055L319.322,544.074L316.482,543.228L315.039,542.082L310.245,542.127L304.196,540.549L301.539,538.767L297.839,538.482L295.788,536.692L287.979,533.718L286.223,531.426L281.771,530.508L279.941,529.163L278.813,529.258L278.145,530.347L277.033,530.296L275.488,531.657L273,532.484L269.036,530.227L265.207,529.507L262.003,527.003L261.033,527.605L258.784,526.641L254.492,526.162L248.086,527.324L240.562,525.14L233.352,524.529L230.76,520.412L231.293,519.657L230.97,519.173L229.337,519.57L228.521,518.635L230.056,516.535L228.017,515.561L227.91,514.617L229.217,513.495L227.471,511.137L227.804,509.691L224.339,505.139L224.037,501.328L220.061,496.916L219.028,494.511L215.796,490.624L215.648,489.008L213.831,488.608L212.123,486.917L210.284,486.347L208.119,483.345L206.658,482.294L205.032,478.623L206.412,476.357L205.407,473.801L206.73,472.581L206.298,471.648L207.237,469.865L205.317,467.556L206.423,464.991L205.372,462.048L207.322,459.313L208.044,455.159L208.843,454.482L208.491,453.252L209.075,451.199L208.396,448.476L208.855,447.217L206.726,442.914L206.634,437.44L208.083,435.648L208.704,432.246L208.049,429.963L204.85,427.391L201.65,428.378L199.83,426.795L195.467,427.833L187.429,425.884L183.58,427.027L180.002,426.896L177.586,425.896L172.34,428.318L171.455,428.055L172.419,421.069L172.534,410.479L171.145,403.907L169.525,402.557L167.907,396.52L167.083,396.109L165.607,392.801L163.6,391.295L158.465,391.717L156.765,391.31L154.836,387.447L152.31,385.889L144.913,385.669L140.047,383.607L138.341,383.781L135.123,382.643L131.575,382.322L131.057,381.844L131.448,380.941L130.278,379.336L127.292,378.537L123.919,378.923L122.168,374.687L122.168,374.687L125.268,373.641L128.379,370.857L141.377,366.951L145.693,366.62L148.299,367.476L152.219,366.608L157.298,366.407L160.131,365.561L169.978,367.297L174.838,365.424L180.836,365.796L187.064,370.187L191.813,370.699L195.541,375.662L196.771,380.512L200.555,384.502L201.958,385.131L204.024,387.92L207.51,390.037L212.568,396.036L215.34,397.291L217.298,399.268L222.175,400.302L224.443,395.732L226.25,389.086L230.597,394.258L233.802,392.707L239.698,392.566L241.845,391.817L246.787,394.509L248.146,396.109L249.725,400.313L251.491,401.592L256.613,407.622L257.987,407.675L260.766,414.133L263.426,409.923L266.619,410.154L267.592,409.593L270.415,405.058L273.083,404.795L273.083,404.795L276.53,406.89L277.547,403.515L281.918,403.872L282.643,404.8L282.643,404.8L287.291,410.509L291.805,407.403L291.065,406.346L294.185,403.018L296.631,396.652L303.289,390.695L299.604,387.977L306.259,387.489L314.087,379.008L311.123,368.151L318.644,370.916L322.927,367.472L322.157,366.297L323.622,362.245L323.678,357.541L319.943,354.44L319.545,353.385L324.106,350L325.69,345.549L324.731,343.519L322.485,341.483L322.369,340.065L324.625,339.063L328.726,339.93L330.451,341.314L331.618,341.481L332.948,340.636z"
				},
				{
					"id":"ZW-MV",
					"title":"Masvingo",
					"d":"M471.047,319.381L472.281,318.04L474.563,316.976L473.411,312.981L473.489,312.536L474.772,312.448L475.226,308.324L482.177,309.817L481.949,317.012L482.641,318.22L490.74,316.993L500.489,316.355L500.489,316.355L513.734,324.737L516.657,327.906L521.117,328.148L524.904,329.246L528.999,332.726L530.877,335.458L533.084,335.153L538.605,336.634L540.187,341.312L541.639,341.782L543.753,343.742L545.478,346.759L550.863,349.816L552.647,354.13L555.87,357.616L557.776,358.728L560.052,363.441L563.471,366.277L564.473,368.899L566.724,371.507L568.184,372.258L571.688,372.253L574.868,375.05L576.814,375.876L582.613,375.756L586.209,379.193L590.316,381.567L594.569,383.048L595.221,385.918L595.079,394.689L593.762,400.558L593.08,408.37L591.529,414.857L590.294,425.982L590.451,433.146L588.857,437.162L588.222,442.957L585.751,445.316L584.453,452.798L578.758,464.224L578.39,466.557L579.539,470.011L579.655,472.296L582.534,474.745L582.429,478.26L586.757,479.952L588.446,481.479L590.158,486.685L590.362,489.217L592.386,493.561L596.028,495.139L601.55,500.72L601.55,500.72L599.672,501.99L514.419,595.634L508.205,600L506.515,598.566L504.959,595.253L503.363,594.832L500.32,595.355L497.055,592.006L495.525,591.758L490.024,593.597L488.117,592.943L488.117,592.943L489.637,593.185L491.932,592.432L490.312,589.215L484.583,585.387L483.959,584.403L485.293,582.619L483.156,581.73L482.477,579.14L480.551,578.824L481.563,577.498L481.312,577.006L478.645,576.161L477.793,572.377L476.683,571.769L476.74,568.967L472.983,569.613L472.015,566.203L470.698,565.307L470.44,563.743L466.163,560.479L466.394,558.545L462.826,557.005L462.614,555.937L463.621,554.079L460.868,551.874L460.079,550.152L458.976,549.872L457.977,547.328L455.19,545.824L454.39,542.251L452.217,540.866L453.465,538.23L452.32,537.907L449.553,539.155L445.988,536.668L444.485,537.784L443.129,536.106L441.083,535.089L441.678,532.047L441.062,531.229L437.754,530.586L434.275,528.301L428.68,526.106L419.911,525.519L418.971,524.905L419.612,522.154L419.119,521.252L416.592,521.096L411.891,517.004L407.816,517.136L407.119,515.537L403.036,512.263L398.704,505.996L394.874,504.36L394.262,503.583L393.434,500.317L392.015,499.036L391.52,495.677L389.158,493.957L389.071,490.805L385.898,489.454L384.834,485.074L378.936,480.081L376.861,474.967L376.861,474.967L378.527,475.908L382.305,475.704L392.118,466.87L396.093,465.109L397.635,465.148L401.215,468.21L404.263,469.595L407.277,473.147L410.895,473.876L412.157,475.223L415.207,476.034L416.951,475.743L419.066,476.27L422.514,475.278L429.181,476.605L432.985,473.853L436.817,468.81L437.446,456.836L439.791,447.642L440.191,446.824L442.052,446L442.208,444.979L438.55,442.75L436.824,437.985L436.877,432.195L434.271,428.903L432.921,425.893L428.731,420.774L426.871,420.861L425.032,416.346L420.092,414.487L419.077,413.309L419.153,411.884L422.318,404.47L420.736,402.683L416.081,399.766L414.748,399.809L412.049,402.093L412.767,399.244L412.796,395.544L414.12,392.736L414.315,390.5L413.906,389.119L411.235,386.238L416.682,386.065L422.322,383.696L435.39,383.128L435.952,382.517L434.695,381.099L434.888,379.149L437.3,377.558L437.896,375.892L436.716,373.419L437.347,370.372L442.261,369.745L450.978,371.858L456.618,371.63L455.866,367.21L458.282,353.816L457.2,347.866L459.166,340.242L458.895,335.223L462.266,334.315L463.14,332.813L461.644,331.283L457.098,330.537z"
				},
				{
					"id":"ZW-MW",
					"title":"Mashonaland West",
					"d":"M390.534,1.156L393.292,1.239L396.003,2.91L409.251,0.954L412.722,0.998L416.884,4.563L420.529,1.476L422.194,2.88L422.194,2.88L422.396,7.988L424.842,9.85L425.633,11.157L425.715,12.705L425.088,13.697L422.255,15.961L421.038,17.708L417.259,19.895L416.197,21.602L410.134,26.488L402.136,31.651L402.138,33.835L402.929,35.503L405.219,37.45L405.461,41.94L406.49,44.522L407.994,47.265L409.969,47.661L410.206,48.258L409.656,49.888L406.028,53.468L406.155,59.871L403.315,63.492L402.647,67.113L404.823,68.147L407.311,66.236L409.957,65.758L411.3,64.762L414.46,64.323L415.563,62.691L416.581,58.155L418.79,56.602L422.584,57.473L423.732,58.625L424.569,61.766L426.784,63.116L432.038,62.669L434.175,63.699L434.86,68.155L433.133,72.098L432.832,77.354L430.316,82.734L429.851,85.483L432.989,89.821L441.864,93.028L442.553,97.53L441.532,100.044L443.99,100.795L444.748,102.109L444.081,103.746L441.784,103.632L441.235,105.348L442.688,112.685L442.303,115.439L444.021,119.106L444.241,124.614L444.799,125.252L448.327,125.282L449.84,126.434L453.556,123.987L454.834,125.979L456.379,125.574L459.873,126.6L458.403,134.353L454.585,140.88L450.073,152.81L451.05,158.046L450.146,160.33L449.592,169.538L464.42,169.241L463.181,175.373L469.041,177.629L475.069,181.245L477.045,179.032L479.272,179.06L480.313,180.216L480.973,183.539L480.973,183.539L480.313,186.227L478.096,188.001L477.152,189.77L474.489,190.465L474.067,193.113L475.631,194.829L474.055,197.444L476.853,199.034L478.1,201.032L477.43,201.999L474.328,203.018L474.328,203.018L470.612,201.191L467.108,201.569L466.399,202.976L466.379,206.306L463.803,208.846L465.269,214.139L462.578,218.087L461.797,220.82L462.443,222.425L462.25,223.59L457.445,227.871L457.337,229.961L458.232,233.213L464.868,241.547L464.714,242.512L462.888,244.372L461.926,257.779L458.151,262.225L457.878,263.475L456.089,265.538L453.196,270.788L452.348,269.301L451.032,270.272L449.146,269.031L449.498,275.479L449.065,277.053L445.475,279.929L445.048,282.794L442.964,282.479L440.614,285.554L440.614,285.554L437.287,285.081L434.395,283.193L429.459,281.149L425.08,277.249L421.598,277.821L419.63,276.01L417.186,275.37L416.176,272.307L414.492,271.584L410.606,270.461L405.843,270.668L403.078,269.018L400.998,269.786L399.315,268.617L395.311,268.217L391.79,269.225L389.309,268.942L386.064,266.845L384.504,267.168L383.262,266.683L380.139,263.014L377.579,264.02L375.738,261.197L368.936,261.471L367.656,260.865L365.658,258.203L362.337,258.357L361.138,257.59L360.46,255.171L361.423,251.791L361.027,247.523L362.508,245.433L363.312,240.123L360.557,237.583L357.841,236.732L350.101,231.605L346.708,230.831L344.121,226.602L338.937,224.092L335.444,216.967L334.091,215.476L332.194,209.283L333.286,203.748L337.13,197.421L337.335,194.935L339.293,192.615L339.657,190.13L342.093,187.291L342.015,186.609L340.425,185.361L340.525,183.813L343.142,181.201L343.634,174.431L341.81,171.981L341.812,171.059L343.645,169.383L345.88,165.786L347.712,164.35L348.75,161.871L344.897,160.218L341.568,156.085L337.957,153.912L337.333,149.628L335.548,148.421L335.313,147.061L330.031,146.8L324.161,144.494L321.66,144.163L320.594,142.479L313.538,139.365L312.077,137.719L309.717,132.47L309.165,131.788L308.013,131.901L305.069,133.483L297.805,133.68L294.306,135.137L290.794,138.512L288.134,138.614L284.847,143.989L284.073,147.264L282.401,147.771L279.638,151.551L278.042,152.62L276.549,156.29L275.912,156.366L269.978,152.358L265.043,153.559L260.749,153.883L257.954,155.581L255.377,154.877L252.632,155.293L252.632,155.293L249.925,150.908L247.706,150.247L246.769,148.239L245.151,146.984L245.093,144.343L243.5,140.05L243.914,138.255L242.462,136.124L242.374,132.565L239.122,132.295L237.762,128.956L234.838,129.946L233.759,129.783L235.728,127.669L235.336,125.667L236.177,125.551L235.122,122.509L233.668,120.938L233.089,119.175L234.069,115.951L233.75,111.677L232.597,110.062L232.597,110.062L242.692,105.328L253.898,96.064L285.087,83.332L292.911,81.872L293.923,80.496L298.469,77.492L299.938,75.376L299.897,72.151L301.555,69.712L302.393,66.581L301.668,65.032L301.925,63.054L300.111,61.677L300.708,59.113L303.207,55.655L303.086,54.982L301.596,54.373L301.219,53.112L301.775,47.986L303.575,44.493L302.248,42.07L303.196,39.975L301.986,38.761L305.441,33.824L307.672,29.223L309.623,28.573L316.34,28.781L317.227,28.35L320.479,23.432L331.423,15.723L332.921,13.991L337.328,12.922L345.369,8.732L348.507,8.914L351.387,6.917L356.936,6.598L360.662,3.197L363.353,2.849L366.121,4.503L367.709,4.553L374.957,2.868L381.727,0.139L388.473,0.284z"
				}
			]
		}
	}
};