/**
* @author Jason Dobry <jason.dobry@gmail.com>
* @file angular-cache.min.js
* @version 2.3.7 - Homepage <http://jmdobry.github.io/angular-cache/>
* @copyright (c) 2013-2014 Jason Dobry <http://jmdobry.github.io/angular-cache>
* @license MIT <https://github.com/jmdobry/angular-cache/blob/master/LICENSE>
*
* @overview angular-cache is a very useful replacement for Angular's $cacheFactory.
*/
!function(a,b,c){"use strict";function d(){this.$get=function(){function a(a,b,c){for(var d=a[c],e=b(d);c>0;){var f=Math.floor((c+1)/2)-1,g=a[f];if(e>=b(g))break;a[f]=d,a[c]=g,c=f}}function c(a,b,c){for(var d=a.length,e=a[c],f=b(e);;){var g=2*(c+1),h=g-1,i=null;if(d>h){var j=a[h],k=b(j);f>k&&(i=h)}if(d>g){var l=a[g],m=b(l);m<(null===i?f:b(a[h]))&&(i=g)}if(null===i)break;a[c]=a[i],a[i]=e,c=i}}function d(a){if(a&&!b.isFunction(a))throw new Error("BinaryHeap(weightFunc): weightFunc: must be a function!");a=a||function(a){return a},this.weightFunc=a,this.heap=[]}return d.prototype.push=function(b){this.heap.push(b),a(this.heap,this.weightFunc,this.heap.length-1)},d.prototype.peek=function(){return this.heap[0]},d.prototype.pop=function(){var a=this.heap[0],b=this.heap.pop();return this.heap.length>0&&(this.heap[0]=b,c(this.heap,this.weightFunc,0)),a},d.prototype.remove=function(d){for(var e=this.heap.length,f=0;e>f;f++)if(b.equals(this.heap[f],d)){var g=this.heap[f],h=this.heap.pop();return f!==e-1&&(this.heap[f]=h,a(this.heap,this.weightFunc,f),c(this.heap,this.weightFunc,f)),g}return null},d.prototype.removeAll=function(){this.heap=[]},d.prototype.size=function(){return this.heap.length},d}}function e(){function a(a,c){c(b.isNumber(a)?0>a?"must be greater than zero!":null:"must be a number!")}var d,e=function(){return{capacity:Number.MAX_VALUE,maxAge:null,deleteOnExpire:"none",onExpire:null,cacheFlushInterval:null,recycleFreq:1e3,storageMode:"none",storageImpl:null,verifyIntegrity:!0,disabled:!1}};this.setCacheDefaults=function(c){var f="$angularCacheFactoryProvider.setCacheDefaults(options): ";if(c=c||{},!b.isObject(c))throw new Error(f+"options: must be an object!");if("disabled"in c&&(c.disabled=c.disabled===!0),"capacity"in c&&a(c.capacity,function(a){if(a)throw new Error(f+"capacity: "+a)}),"deleteOnExpire"in c){if(!b.isString(c.deleteOnExpire))throw new Error(f+"deleteOnExpire: must be a string!");if("none"!==c.deleteOnExpire&&"passive"!==c.deleteOnExpire&&"aggressive"!==c.deleteOnExpire)throw new Error(f+'deleteOnExpire: accepted values are "none", "passive" or "aggressive"!')}if("maxAge"in c&&a(c.maxAge,function(a){if(a)throw new Error(f+"maxAge: "+a)}),"recycleFreq"in c&&a(c.recycleFreq,function(a){if(a)throw new Error(f+"recycleFreq: "+a)}),"cacheFlushInterval"in c&&a(c.cacheFlushInterval,function(a){if(a)throw new Error(f+"cacheFlushInterval: "+a)}),"storageMode"in c){if(!b.isString(c.storageMode))throw new Error(f+"storageMode: must be a string!");if("none"!==c.storageMode&&"localStorage"!==c.storageMode&&"sessionStorage"!==c.storageMode)throw new Error(f+'storageMode: accepted values are "none", "localStorage" or "sessionStorage"!');if("storageImpl"in c){if(!b.isObject(c.storageImpl))throw new Error(f+"storageImpl: must be an object!");if(!("setItem"in c.storageImpl&&"function"==typeof c.storageImpl.setItem))throw new Error(f+'storageImpl: must implement "setItem(key, value)"!');if(!("getItem"in c.storageImpl&&"function"==typeof c.storageImpl.getItem))throw new Error(f+'storageImpl: must implement "getItem(key)"!');if(!("removeItem"in c.storageImpl)||"function"!=typeof c.storageImpl.removeItem)throw new Error(f+'storageImpl: must implement "removeItem(key)"!')}}if("onExpire"in c&&"function"!=typeof c.onExpire)throw new Error(f+"onExpire: must be a function!");d=b.extend({},e(),c)},this.setCacheDefaults({}),this.$get=["$window","BinaryHeap",function(e,f){function g(a){return a&&b.isNumber(a)?a.toString():a}function h(a){var b,c={};for(b in a)a.hasOwnProperty(b)&&(c[b]=b);return c}function i(a){var b,c=[];for(b in a)a.hasOwnProperty(b)&&c.push(b);return c}function j(j,k){function m(b){a(b,function(a){if(a)throw new Error("capacity: "+a);for(B.capacity=b;E.size()>B.capacity;)H.remove(E.peek().key,{verifyIntegrity:!1})})}function n(a){if(!b.isString(a))throw new Error("deleteOnExpire: must be a string!");if("none"!==a&&"passive"!==a&&"aggressive"!==a)throw new Error('deleteOnExpire: accepted values are "none", "passive" or "aggressive"!');B.deleteOnExpire=a}function o(b){var c=i(C);if(null===b){if(B.maxAge)for(var d=0;d<c.length;d++){var e=c[d];"maxAge"in C[e]||(delete C[e].expires,D.remove(C[e]))}B.maxAge=b}else a(b,function(a){if(a)throw new Error("maxAge: "+a);if(b!==B.maxAge){B.maxAge=b;for(var d=(new Date).getTime(),e=0;e<c.length;e++){var f=c[e];"maxAge"in C[f]||(D.remove(C[f]),C[f].expires=C[f].created+B.maxAge,D.push(C[f]),C[f].expires<d&&H.remove(f,{verifyIntegrity:!1}))}}})}function p(){for(var a=(new Date).getTime(),b=D.peek();b&&b.expires&&b.expires<a;)H.remove(b.key,{verifyIntegrity:!1}),B.onExpire&&B.onExpire(b.key,b.value),b=D.peek()}function q(b){null===b?(B.recycleFreqId&&(clearInterval(B.recycleFreqId),delete B.recycleFreqId),B.recycleFreq=d.recycleFreq,B.recycleFreqId=setInterval(p,B.recycleFreq)):a(b,function(a){if(a)throw new Error("recycleFreq: "+a);B.recycleFreq=b,B.recycleFreqId&&clearInterval(B.recycleFreqId),B.recycleFreqId=setInterval(p,B.recycleFreq)})}function r(b){null===b?(B.cacheFlushIntervalId&&(clearInterval(B.cacheFlushIntervalId),delete B.cacheFlushIntervalId),B.cacheFlushInterval=b):a(b,function(a){if(a)throw new Error("cacheFlushInterval: "+a);b!==B.cacheFlushInterval&&(B.cacheFlushIntervalId&&clearInterval(B.cacheFlushIntervalId),B.cacheFlushInterval=b,B.cacheFlushIntervalId=setInterval(H.removeAll,B.cacheFlushInterval))})}function s(a,c){var d,f;if(!b.isString(a))throw new Error("storageMode: must be a string!");if("none"!==a&&"localStorage"!==a&&"sessionStorage"!==a)throw new Error('storageMode: accepted values are "none", "localStorage" or "sessionStorage"!');if(("localStorage"===B.storageMode||"sessionStorage"===B.storageMode)&&a!==B.storageMode){for(d=i(C),f=0;f<d.length;f++)I.removeItem(F+".data."+d[f]);I.removeItem(F+".keys")}if(B.storageMode=a,c){if(!b.isObject(c))throw new Error("storageImpl: must be an object!");if(!("setItem"in c&&"function"==typeof c.setItem))throw new Error('storageImpl: must implement "setItem(key, value)"!');if(!("getItem"in c&&"function"==typeof c.getItem))throw new Error('storageImpl: must implement "getItem(key)"!');if(!("removeItem"in c)||"function"!=typeof c.removeItem)throw new Error('storageImpl: must implement "removeItem(key)"!');I=c}else"localStorage"===B.storageMode?I=e.localStorage:"sessionStorage"===B.storageMode&&(I=e.sessionStorage);if("none"!==B.storageMode&&I)if(G)for(d=i(C),f=0;f<d.length;f++)v(d[f]);else u()}function t(a,c,e){if(a=a||{},e=e||{},c=!!c,!b.isObject(a))throw new Error("AngularCache.setOptions(cacheOptions, strict, options): cacheOptions: must be an object!");if(w(e.verifyIntegrity),c&&(a=b.extend({},d,a)),"disabled"in a&&(B.disabled=a.disabled===!0),"verifyIntegrity"in a&&(B.verifyIntegrity=a.verifyIntegrity===!0),"capacity"in a&&m(a.capacity),"deleteOnExpire"in a&&n(a.deleteOnExpire),"maxAge"in a&&o(a.maxAge),"recycleFreq"in a&&q(a.recycleFreq),"cacheFlushInterval"in a&&r(a.cacheFlushInterval),"storageMode"in a&&s(a.storageMode,a.storageImpl),"onExpire"in a){if(null!==a.onExpire&&"function"!=typeof a.onExpire)throw new Error("onExpire: must be a function!");B.onExpire=a.onExpire}G=!0}function u(){var a=b.fromJson(I.getItem(F+".keys"));if(I.removeItem(F+".keys"),a&&a.length){for(var c=0;c<a.length;c++){var d=b.fromJson(I.getItem(F+".data."+a[c]))||{},e=d.maxAge||B.maxAge,f=d.deleteOnExpire||B.deleteOnExpire;if(e&&(new Date).getTime()-d.created>e&&"aggressive"===f)I.removeItem(F+".data."+a[c]);else{var g={created:d.created};d.expires&&(g.expires=d.expires),d.accessed&&(g.accessed=d.accessed),d.maxAge&&(g.maxAge=d.maxAge),d.deleteOnExpire&&(g.deleteOnExpire=d.deleteOnExpire),H.put(a[c],d.value,g)}}v(null)}}function v(a){"none"!==B.storageMode&&I&&(I.setItem(F+".keys",b.toJson(i(C))),a&&I.setItem(F+".data."+a,b.toJson(C[a])))}function w(a){if((a||a!==!1&&B.verifyIntegrity)&&"none"!==B.storageMode&&I){var c=i(C);I.setItem(F+".keys",b.toJson(c));for(var d=0;d<c.length;d++)I.setItem(F+".data."+c[d],b.toJson(C[c[d]]))}}function x(a,c){if((c||c!==!1&&B.verifyIntegrity)&&"none"!==B.storageMode&&I){var d=I.getItem(F+".data."+a);if(!d&&a in C)H.remove(a);else if(d){var e=b.fromJson(d),f=e?e.value:null,g={};e&&e.created&&(g.created=e.created),e&&e.expires&&(g.expires=e.expires),e&&e.accessed&&(g.accessed=e.accessed),e&&e.maxAge&&(g.maxAge=e.maxAge),e&&e.deleteOnExpire&&(g.deleteOnExpire=e.deleteOnExpire),f&&H.put(a,f,g)}}}function y(a){if("none"!==B.storageMode&&I){var c=a||i(C);I.setItem(F+".keys",b.toJson(c))}}function z(a){"none"!==B.storageMode&&I&&a in C&&I.setItem(F+".data."+a,b.toJson(C[a]))}function A(){if("none"!==B.storageMode&&I){for(var a=i(C),c=0;c<a.length;c++)I.removeItem(F+".data."+a[c]);I.setItem(F+".keys",b.toJson([]))}}var B=b.extend({},{id:j}),C={},D=new f(function(a){return a.expires}),E=new f(function(a){return a.accessed}),F="angular-cache.caches."+j,G=!1,H=this,I=null;k=k||{},this.put=function(c,d,e){if(!B.disabled){if(d&&d.then)return void d.then(function(a){b.isObject(a)&&"status"in a&&"data"in a?H.put(c,[a.status,a.data,a.headers(),a.statusText]):H.put(c,a,e)});if(e=e||{},c=g(c),!b.isString(c))throw new Error("AngularCache.put(key, value, options): key: must be a string!");if(e&&!b.isObject(e))throw new Error("AngularCache.put(key, value, options): options: must be an object!");if(e.maxAge&&null!==e.maxAge)a(e.maxAge,function(a){if(a)throw new Error("AngularCache.put(key, value, options): maxAge: "+a)});else{if(e.deleteOnExpire&&!b.isString(e.deleteOnExpire))throw new Error("AngularCache.put(key, value, options): deleteOnExpire: must be a string!");if(e.deleteOnExpire&&"none"!==e.deleteOnExpire&&"passive"!==e.deleteOnExpire&&"aggressive"!==e.deleteOnExpire)throw new Error('AngularCache.put(key, value, options): deleteOnExpire: accepted values are "none", "passive" or "aggressive"!');if(b.isUndefined(d))return}var f,h,i=(new Date).getTime();return w(e.verifyIntegrity),C[c]?(D.remove(C[c]),E.remove(C[c])):C[c]={key:c},h=C[c],h.value=d,h.created=parseInt(e.created,10)||h.created||i,h.accessed=parseInt(e.accessed,10)||i,e.deleteOnExpire&&(h.deleteOnExpire=e.deleteOnExpire),e.maxAge&&(h.maxAge=e.maxAge),(h.maxAge||B.maxAge)&&("expires"in e?h.expires=parseInt(e.expires,10):b.isNumber(h.expires)||(h.expires=h.created+(h.maxAge||B.maxAge))),f=h.deleteOnExpire||B.deleteOnExpire,h.expires&&"aggressive"===f&&D.push(h),y(),z(c),E.push(h),E.size()>B.capacity&&this.remove(E.peek().key,{verifyIntegrity:!1}),d}},this.get=function(a,d){if(!B.disabled){if(b.isArray(a)){var e=a,f=[];return b.forEach(e,function(a){var c=H.get(a,d);b.isDefined(c)&&f.push(c)}),f}if(a=g(a),d=d||{},!b.isString(a))throw new Error("AngularCache.get(key, options): key: must be a string!");if(d&&!b.isObject(d))throw new Error("AngularCache.get(key, options): options: must be an object!");if(d.onExpire&&!b.isFunction(d.onExpire))throw new Error("AngularCache.get(key, options): onExpire: must be a function!");if(x(a,d.verifyIntegrity),a in C){var h=C[a],i=h.value,j=(new Date).getTime(),k=h.deleteOnExpire||B.deleteOnExpire;return E.remove(h),h.accessed=j,E.push(h),"passive"===k&&"expires"in h&&h.expires<j&&(this.remove(a,{verifyIntegrity:!1}),B.onExpire?B.onExpire(a,h.value,d.onExpire):d.onExpire&&d.onExpire(a,h.value),i=c),z(a),i}}},this.remove=function(a,b){b=b||{},w(b.verifyIntegrity),E.remove(C[a]),D.remove(C[a]),"none"!==B.storageMode&&I&&I.removeItem(F+".data."+a),delete C[a],y()},this.removeAll=function(){A(),E.removeAll(),D.removeAll(),C={}},this.removeExpired=function(a){a=a||{};for(var b=(new Date).getTime(),c=i(C),d={},e=0;e<c.length;e++)C[c[e]]&&C[c[e]].expires&&C[c[e]].expires<b&&(d[c[e]]=C[c[e]].value);for(var f in d)H.remove(f);if(w(a.verifyIntegrity),a.asArray){var g=[];for(f in d)g.push(d[f]);return g}return d},this.destroy=function(){B.cacheFlushIntervalId&&clearInterval(B.cacheFlushIntervalId),B.recycleFreqId&&clearInterval(B.recycleFreqId),this.removeAll(),"none"!==B.storageMode&&I&&(I.removeItem(F+".keys"),I.removeItem(F)),I=null,C=null,E=null,D=null,B=null,F=null,H=null;for(var a=i(this),b=0;b<a.length;b++)this.hasOwnProperty(a[b])&&delete this[a[b]];l[j]=null,delete l[j]},this.info=function(a){if(a){if(C[a]){var c={created:C[a].created,accessed:C[a].accessed,expires:C[a].expires,maxAge:C[a].maxAge||B.maxAge,deleteOnExpire:C[a].deleteOnExpire||B.deleteOnExpire,isExpired:!1};return c.maxAge&&(c.isExpired=(new Date).getTime()-c.created>c.maxAge),c}return C[a]}return b.extend({},B,{size:E&&E.size()||0})},this.keySet=function(){return h(C)},this.keys=function(){return i(C)},this.setOptions=t,t(k,!0,{verifyIntegrity:!1})}function k(a,c){if(a in l)throw new Error("cacheId "+a+" taken!");if(!b.isString(a))throw new Error("cacheId must be a string!");return l[a]=new j(a,c),l[a]}var l={};return k.info=function(){for(var a=i(l),c={size:a.length,caches:{}},e=0;e<a.length;e++){var f=a[e];c.caches[f]=l[f].info()}return c.cacheDefaults=b.extend({},d),c},k.get=function(a){if(!b.isString(a))throw new Error("$angularCacheFactory.get(cacheId): cacheId: must be a string!");return l[a]},k.keySet=function(){return h(l)},k.keys=function(){return i(l)},k.removeAll=function(){for(var a=i(l),b=0;b<a.length;b++)l[a[b]].destroy()},k.clearAll=function(){for(var a=i(l),b=0;b<a.length;b++)l[a[b]].removeAll()},k.enableAll=function(){for(var a=i(l),b=0;b<a.length;b++)l[a[b]].setOptions({disabled:!1})},k.disableAll=function(){for(var a=i(l),b=0;b<a.length;b++)l[a[b]].setOptions({disabled:!0})},k}]}b.module("jmdobry.binary-heap",[]).provider("BinaryHeap",d),b.module("jmdobry.angular-cache",["ng","jmdobry.binary-heap"]).provider("$angularCacheFactory",e)}(window,window.angular);