Country select for AngularJS with i18n
======================================

A simple AngularJS directive to create country select, based on select2. Country data is from [mledoze/countries](https://github.com/mledoze/countries).

### Usage

Install via bower

```
bower install angular-country-select-i18n
```

Add module as dependency.

```javascript
angular.module('app', ['angular-country-select-i18n']);
```

Then use directive `country-select`.

```html
<input country-select data-ng-model="country">
```

or

```html
<input country-select language="rus" options="options" data-ng-model="country">
```

**ng-model is required**

### Supported options

- placeholder

### Supported languages

- "eng" - default
- "cym"
- "deu"
- "fra"
- "hrv"
- "ita"
- "jpn"
- "nld"
- "por"
- "rus"
- "spa"

Check [https://en.wikipedia.org/wiki/ISO_639-3](https://en.wikipedia.org/wiki/ISO_639-3) for more details

Value of selected country is the [ISO 3166-1 alpha-2](http://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) code, e.g. `CN`, `US`.

See `example/index.html` for a simple example.