var data = [];
var optionsDefaults = {
  placeholder: ''
};

angular.module('angular-country-select-i18n', [])
  .constant('COUNTRIES', data)
  .directive('countrySelect', ['COUNTRIES', function(COUNTRIES) {
    return {
      restrict: 'A',
      require:'ngModel',
      scope: {
        language: '=',
        options: '='
      },
      link: function(scope, elem, attrs) {
        var data = COUNTRIES;
        var options = angular.extend(
          optionsDefaults,
          scope.options
        );

        elem.select2({
          data: data[scope.language] || data['eng'],
          placeholder: options.placeholder
        });
      }
    };
  }]);