var gulp = require('gulp');
var replace = require('gulp-replace');
var concat = require('gulp-concat');
var fs = require('fs');

var countriesPath = './bower_components/world-countries/dist/countries.json';

function replaceString() {
  var string = 'var data = ',
      fileData = JSON.parse(fs.readFileSync(countriesPath, 'utf-8')),
      data = {},
      languages = Object.keys(fileData[0].translations);

  data['eng'] = [];
  languages.forEach(function (language) {
    data[language] = [];
  });

  fileData.forEach(function (country, key) {
    data['eng'].push({
      id: country.cca2,
      text: country.name.common
    });

    languages.forEach(function (language) {
      if (!country['translations'][language]) return;
      data[language].push({
        id: country.cca2,
        text: country['translations'][language].common
      })
    })
  });

  return string + JSON.stringify(data);
}

gulp.task('build', function() {
  return gulp.src('./angular-country-select.js')
    .pipe(replace('var data = []', replaceString))
    .pipe(concat('angular-country-select.js'))
    .pipe(gulp.dest('./dist/'));
});