angular.module('angular-cron-gen').run(['$templateCache', function($templateCache) {$templateCache.put('angular-cron-gen/cron-gen-time-select.html','<div class="inline-block">\n    <select class="hours"\n            name="{{namePrefix}}Hours"\n            ng-disabled="$ctrl.isDisabled"\n            ng-change="$ctrl.onChange()"\n            ng-required="$ctrl.isRequired"\n            ng-model="$ctrl.model.hours"\n            ng-options="hour as $ctrl.cronGenService.padNumber(hour) for hour in $ctrl.selectOptions.hours"\n            ng-class="$ctrl.selectClass">\n    </select>\n    <select class="minutes"\n            name="{{namePrefix}}Minutes"\n            ng-disabled="$ctrl.isDisabled"\n            ng-change="$ctrl.onChange()"\n            ng-required="$ctrl.isRequired"\n            ng-model="$ctrl.model.minutes"\n            ng-options="minute as $ctrl.cronGenService.padNumber(minute) for minute in $ctrl.selectOptions.minutes"\n            ng-class="$ctrl.selectClass">\n    </select>\n    <select class="seconds"\n            name="{{namePrefix}}Seconds"\n            ng-show="!$ctrl.hideSeconds"\n            ng-disabled="$ctrl.isDisabled"\n            ng-change="$ctrl.onChange()"\n            ng-required="$ctrl.isRequired"\n            ng-model="$ctrl.model.seconds"\n            ng-options="second as $ctrl.cronGenService.padNumber(second) for second in $ctrl.selectOptions.seconds"\n            ng-class="$ctrl.selectClass">\n    </select>\n    <select class="hour-types"\n            name="{{namePrefix}}HourType"\n            ng-show="!$ctrl.use24HourTime"\n            ng-disabled="$ctrl.isDisabled"\n            ng-change="$ctrl.onChange()"\n            ng-model="$ctrl.model.hourType"\n            ng-options="hourType as hourType for hourType in $ctrl.selectOptions.hourTypes"\n            ng-required="$ctrl.isRequired"\n            ng-class="$ctrl.selectClass">\n    </select>\n</div>');
$templateCache.put('angular-cron-gen/cron-gen.html','<!doctype html>\n<div class="cron-gen-main" ng-cloak>\n    <ul class="nav nav-tabs tab-nav" role="tablist">\n        <li ng-class="{\'active\': $ctrl.activeTab === \'minutes\'}"\n            ng-show="!$ctrl.parsedOptions.hideMinutesTab"\n            role="presentation">\n            <a href="#"\n               aria-controls="minutes"\n               role="tab"\n               data-toggle="tab"\n               ng-click="$ctrl.setActiveTab($event, \'minutes\')">\n                Minutes\n            </a>\n        </li>\n        <li role="presentation"\n            ng-show="!$ctrl.parsedOptions.hideHourlyTab"\n            ng-class="{\'active\': $ctrl.activeTab === \'hourly\'}">\n            <a href="#"\n               aria-controls="hourly"\n               role="tab"\n               data-toggle="tab"\n               ng-click="$ctrl.setActiveTab($event, \'hourly\')">\n                Hourly\n            </a>\n        </li>\n        <li role="presentation"\n            ng-show="!$ctrl.parsedOptions.hideDailyTab"\n            ng-class="{\'active\': $ctrl.activeTab === \'daily\'}">\n            <a href="#"\n               aria-controls="daily"\n               role="tab"\n               data-toggle="tab"\n               ng-click="$ctrl.setActiveTab($event, \'daily\')">\n                Daily\n            </a>\n        </li>\n        <li role="presentation"\n            ng-show="!$ctrl.parsedOptions.hideWeeklyTab"\n            ng-class="{\'active\': $ctrl.activeTab === \'weekly\'}">\n            <a href="#" aria-controls="weekly"\n               role="tab"\n               data-toggle="tab"\n               ng-click="$ctrl.setActiveTab($event, \'weekly\')">\n                Weekly\n            </a>\n        </li>\n        <li role="presentation"\n            ng-show="!$ctrl.parsedOptions.hideMonthlyTab"\n            ng-class="{\'active\': $ctrl.activeTab === \'monthly\'}">\n            <a href="#"\n               aria-controls="monthly"\n               role="tab"\n               data-toggle="tab"\n               ng-click="$ctrl.setActiveTab($event, \'monthly\')">\n                Monthly\n            </a>\n        </li>\n        <li role="presentation"\n            ng-show="!$ctrl.parsedOptions.hideYearlyTab"\n            ng-class="{\'active\': $ctrl.activeTab === \'yearly\'}">\n            <a href="#"\n               aria-controls="yearly"\n               role="tab"\n               data-toggle="tab"\n               ng-click="$ctrl.setActiveTab($event, \'yearly\')">\n                Yearly\n            </a>\n        </li>\n        <li role="presentation"\n            ng-show="!$ctrl.parsedOptions.hideAdvancedTab"\n            ng-class="{\'active\': $ctrl.activeTab === \'advanced\'}">\n            <a href="#"\n               aria-controls="advanced"\n               role="tab"\n               data-toggle="tab"\n               ng-click="$ctrl.setActiveTab($event, \'advanced\')">\n                Advanced\n            </a>\n        </li>\n    </ul>\n    <div class="cron-gen-container">\n        <div class="row">\n            <div class="col-xs-12">\n                <div class="tab-content">\n                    <div class="tab-pane"\n                         ng-show="!$ctrl.parsedOptions.hideMinutesTab"\n                         ng-class="{\'active\': $ctrl.activeTab === \'minutes\'}">\n                        <div class="well well-small">\n                            Every\n                            <select class="minutes"\n                                    name="minutesMinutes"\n                                    ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'minutes\'"\n                                    ng-change="$ctrl.regenerateCron()"\n                                    ng-model="$ctrl.state.minutes.minutes"\n                                    ng-required="$ctrl.activeTab === \'minutes\'"\n                                    ng-options="minute as minute for minute in $ctrl.selectOptions.minutes"\n                                    ng-class="$ctrl.parsedOptions.formSelectClass">\n                            </select>\n                            minute(s)\n                            <span ng-show="!$ctrl.parsedOptions.hideSeconds">on second</span>\n                            <select class="seconds"\n                                    name="minutesSeconds"\n                                    ng-show="!$ctrl.parsedOptions.hideSeconds"\n                                    ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'minutes\'"\n                                    ng-change="$ctrl.regenerateCron()"\n                                    ng-model="$ctrl.state.minutes.seconds"\n                                    ng-required="$ctrl.activeTab === \'minutes\'"\n                                    ng-options="second as $ctrl.cronGenService.padNumber(second) for second in $ctrl.selectOptions.seconds"\n                                    ng-class="$ctrl.parsedOptions.formSelectClass">\n                            </select>\n                        </div>\n                    </div>\n                    <div class="tab-pane"\n                         ng-show="!$ctrl.parsedOptions.hideHourlyTab"\n                         ng-class="{\'active\': $ctrl.activeTab === \'hourly\'}">\n                        <div class="well well-small">\n                            Every\n                            <select class="hours"\n                                    name="hourlyHours"\n                                    ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'hourly\'"\n                                    ng-change="$ctrl.regenerateCron()"\n                                    ng-model="$ctrl.state.hourly.hours"\n                                    ng-required="$ctrl.activeTab === \'hourly\'"\n                                    ng-options="hour as hour for hour in $ctrl.selectOptions.hours"\n                                    ng-class="$ctrl.parsedOptions.formSelectClass">\n                            </select>\n                            hour(s) on minute\n                            <select class="minutes"\n                                    name="hourlyMinutes"\n                                    ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'hourly\'"\n                                    ng-change="$ctrl.regenerateCron()"\n                                    ng-model="$ctrl.state.hourly.minutes"\n                                    ng-required="$ctrl.activeTab === \'hourly\'"\n                                    ng-options="minute as $ctrl.cronGenService.padNumber(minute) for minute in $ctrl.selectOptions.fullMinutes"\n                                    ng-class="$ctrl.parsedOptions.formSelectClass">\n                            </select>\n                            <span ng-show="!$ctrl.parsedOptions.hideSeconds">and second</span>\n                            <select class="seconds"\n                                    name="hourlySeconds"\n                                    ng-show="!$ctrl.parsedOptions.hideSeconds"\n                                    ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'hourly\'"\n                                    ng-change="$ctrl.regenerateCron()"\n                                    ng-model="$ctrl.state.hourly.seconds"\n                                    ng-required="$ctrl.activeTab === \'hourly\'"\n                                    ng-options="second as $ctrl.cronGenService.padNumber(second) for second in $ctrl.selectOptions.seconds"\n                                    ng-class="$ctrl.parsedOptions.formSelectClass">\n                            </select>\n                        </div>\n                    </div>\n                    <div class="tab-pane"\n                         ng-show="!$ctrl.parsedOptions.hideDailyTab"\n                         ng-class="{\'active\': $ctrl.activeTab === \'daily\'}">\n                        <div class="well well-small">\n                            <input type="radio"\n                                   value="everyDays"\n                                   name="daily-radio"\n                                   ng-disabled="$ctrl.ngDisabled"\n                                   ng-change="$ctrl.regenerateCron()"\n                                   ng-model="$ctrl.state.daily.subTab"\n                                   ng-class="$ctrl.state.formRadioClass"\n                                   checked="checked">\n                            Every\n                            <select class="days"\n                                    name="dailyEveryDaysDays"\n                                    ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'daily\' || $ctrl.state.daily.subTab !== \'everyDays\'"\n                                    ng-change="$ctrl.regenerateCron()"\n                                    ng-model="$ctrl.state.daily.everyDays.days"\n                                    ng-required="$ctrl.activeTab === \'daily\' && $ctrl.state.daily.subTab === \'everyDays\'"\n                                    ng-options="monthDay as monthDay for monthDay in $ctrl.selectOptions.monthDays"\n                                    ng-class="$ctrl.parsedOptions.formSelectClass">\n                            </select>\n                            day(s) at\n                            <cron-gen-time-select\n                                    is-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'daily\' || $ctrl.state.daily.subTab !== \'everyDays\'"\n                                    on-change="$ctrl.regenerateCron()"\n                                    name-prefix="dailyEveryDays"\n                                    is-required="$ctrl.activeTab === \'daily\' && $ctrl.state.daily.subTab === \'everyDays\'"\n                                    model="$ctrl.state.daily.everyDays"\n                                    select-class="$ctrl.parsedOptions.formSelectClass"\n                                    use-24-hour-time="$ctrl.parsedOptions.use24HourTime"\n                                    hide-seconds="$ctrl.parsedOptions.hideSeconds">\n                            </cron-gen-time-select>\n                        </div>\n                        <div class="well well-small">\n                            <input type="radio"\n                                   value="everyWeekDay"\n                                   ng-disabled="$ctrl.ngDisabled"\n                                   ng-change="$ctrl.regenerateCron()"\n                                   ng-model="$ctrl.state.daily.subTab"\n                                   ng-class="$ctrl.state.formRadioClass"\n                                   name="daily-radio">\n                            Every week day (Monday through Friday) at\n                            <cron-gen-time-select\n                                    is-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'daily\' || $ctrl.state.daily.subTab !== \'everyWeekDay\'"\n                                    on-change="$ctrl.regenerateCron()"\n                                    name-prefix="dailyEveryWeekDay"\n                                    is-required="$ctrl.activeTab === \'daily\' && $ctrl.state.daily.subTab === \'everyWeekDay\'"\n                                    model="$ctrl.state.daily.everyWeekDay"\n                                    select-class="$ctrl.parsedOptions.formSelectClass"\n                                    use-24-hour-time="$ctrl.parsedOptions.use24HourTime"\n                                    hide-seconds="$ctrl.parsedOptions.hideSeconds">\n                            </cron-gen-time-select>\n                        </div>\n                    </div>\n                    <div class="tab-pane"\n                         ng-show="!$ctrl.parsedOptions.hideWeeklyTab"\n                         ng-class="{\'active\': $ctrl.activeTab === \'weekly\'}">\n                        <div class="well well-small row">\n                            <div class="col-sm-6">\n                                <input type="checkbox"\n                                       name="weeklyMON"\n                                       ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'weekly\'"\n                                       ng-change="$ctrl.regenerateCron()"\n                                       ng-model="$ctrl.state.weekly.MON"\n                                       ng-class="$ctrl.parsedOptions.formCheckboxClass">\n                                Monday\n                            </div>\n                            <div class="col-sm-6">\n                                <input type="checkbox"\n                                       name="weeklyTUE"\n                                       ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'weekly\'"\n                                       ng-change="$ctrl.regenerateCron()"\n                                       ng-model="$ctrl.state.weekly.TUE"\n                                       ng-class="$ctrl.parsedOptions.formCheckboxClass">\n                                Tuesday\n                            </div>\n                            <div class="col-sm-6">\n                                <input type="checkbox"\n                                       name="weeklyWED"\n                                       ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'weekly\'"\n                                       ng-change="$ctrl.regenerateCron()"\n                                       ng-model="$ctrl.state.weekly.WED"\n                                       ng-class="$ctrl.parsedOptions.formCheckboxClass">\n                                Wednesday\n                            </div>\n                            <div class="col-sm-6">\n                                <input type="checkbox"\n                                       name="weeklyTHU"\n                                       ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'weekly\'"\n                                       ng-change="$ctrl.regenerateCron()"\n                                       ng-model="$ctrl.state.weekly.THU"\n                                       ng-class="$ctrl.parsedOptions.formCheckboxClass">\n                                Thursday\n                            </div>\n                            <div class="col-sm-6">\n                                <input type="checkbox"\n                                       name="weeklyFRI"\n                                       ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'weekly\'"\n                                       ng-change="$ctrl.regenerateCron()"\n                                       ng-model="$ctrl.state.weekly.FRI"\n                                       ng-class="$ctrl.parsedOptions.formCheckboxClass">\n                                Friday\n                            </div>\n                            <div class="col-sm-6">\n                                <input type="checkbox"\n                                       name="weeklySAT"\n                                       ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'weekly\'"\n                                       ng-change="$ctrl.regenerateCron()"\n                                       ng-model="$ctrl.state.weekly.SAT"\n                                       ng-class="$ctrl.parsedOptions.formCheckboxClass">\n                                Saturday\n                            </div>\n                            <div class="col-sm-6">\n                                <input type="checkbox"\n                                       name="weeklySUN"\n                                       ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'weekly\'"\n                                       ng-change="$ctrl.regenerateCron()"\n                                       ng-model="$ctrl.state.weekly.SUN"\n                                       ng-class="$ctrl.parsedOptions.formCheckboxClass">\n                                Sunday\n                            </div>\n                        </div>\n                        Start time\n                        <cron-gen-time-select\n                                is-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'weekly\'"\n                                on-change="$ctrl.regenerateCron()"\n                                name-prefix="weekly"\n                                is-required="$ctrl.activeTab === \'weekly\'"\n                                model="$ctrl.state.weekly"\n                                select-class="$ctrl.parsedOptions.formSelectClass"\n                                use-24-hour-time="$ctrl.parsedOptions.use24HourTime"\n                                hide-seconds="$ctrl.parsedOptions.hideSeconds">\n                        </cron-gen-time-select>\n                    </div>\n                    <div class="tab-pane"\n                         ng-show="!$ctrl.parsedOptions.hideMonthlyTab"\n                         ng-class="{\'active\': $ctrl.activeTab === \'monthly\'}">\n                        <div class="well well-small">\n                            <input type="radio"\n                                   value="specificDay"\n                                   ng-disabled="$ctrl.ngDisabled"\n                                   ng-change="$ctrl.regenerateCron()"\n                                   ng-model="$ctrl.state.monthly.subTab"\n                                   ng-class="$ctrl.state.formRadioClass"\n                                   name="monthly-radio"\n                                   checked="checked">\n                            On the\n                            <select class="month-days"\n                                    name="monthlySpecificDayDay"\n                                    ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'monthly\' || $ctrl.state.monthly.subTab !== \'specificDay\'"\n                                    ng-change="$ctrl.regenerateCron()"\n                                    ng-model="$ctrl.state.monthly.specificDay.day"\n                                    ng-required="$ctrl.activeTab === \'monthly\' && $ctrl.state.monthly.subTab === \'specificDay\'"\n                                    ng-options="monthDaysWithLast as $ctrl.monthDayDisplay(monthDaysWithLast) for monthDaysWithLast in $ctrl.selectOptions.monthDaysWithLasts"\n                                    ng-class="$ctrl.parsedOptions.formSelectClass">\n                            </select>\n                            of every\n                            <select class="months-small"\n                                    name="monthlySpecificDayMonths"\n                                    ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'monthly\' || $ctrl.state.monthly.subTab !== \'specificDay\'"\n                                    ng-change="$ctrl.regenerateCron()"\n                                    ng-model="$ctrl.state.monthly.specificDay.months"\n                                    ng-required="$ctrl.activeTab === \'monthly\' && $ctrl.state.monthly.subTab === \'specificDay\'"\n                                    ng-options="month as month for month in $ctrl.selectOptions.months"\n                                    ng-class="$ctrl.parsedOptions.formSelectClass">\n                            </select>\n                            month(s) at\n                            <cron-gen-time-select\n                                    is-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'monthly\' || $ctrl.state.monthly.subTab !== \'specificDay\'"\n                                    on-change="$ctrl.regenerateCron()"\n                                    name-prefix="monthlySpecificDay"\n                                    is-required="$ctrl.activeTab === \'monthly\' && $ctrl.state.monthly.subTab === \'specificDay\'"\n                                    model="$ctrl.state.monthly.specificDay"\n                                    select-class="$ctrl.parsedOptions.formSelectClass"\n                                    use-24-hour-time="$ctrl.parsedOptions.use24HourTime"\n                                    hide-seconds="$ctrl.parsedOptions.hideSeconds">\n                            </cron-gen-time-select>\n                        </div>\n                        <div class="well well-small">\n                            <input type="radio"\n                                   value="specificWeekDay"\n                                   ng-disabled="$ctrl.ngDisabled"\n                                   ng-change="$ctrl.regenerateCron()"\n                                   ng-model="$ctrl.state.monthly.subTab"\n                                   ng-class="$ctrl.state.formRadioClass"\n                                   name="monthly-radio">\n                            On the\n                            <select class="day-order-in-month"\n                                    name="monthlySpecificWeekDayMonthWeek"\n                                    ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'monthly\' || $ctrl.state.monthly.subTab !== \'specificWeekDay\'"\n                                    ng-change="$ctrl.regenerateCron()"\n                                    ng-model="$ctrl.state.monthly.specificWeekDay.monthWeek"\n                                    ng-required="$ctrl.activeTab === \'monthly\' && $ctrl.state.monthly.subTab === \'specificWeekDay\'"\n                                    ng-options="monthWeek as $ctrl.monthWeekDisplay(monthWeek) for monthWeek in $ctrl.selectOptions.monthWeeks"\n                                    ng-class="$ctrl.parsedOptions.formSelectClass">\n                            </select>\n                            <select class="week-days"\n                                    name="monthlySpecificWeekDayDay"\n                                    ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'monthly\' || $ctrl.state.monthly.subTab !== \'specificWeekDay\'"\n                                    ng-change="$ctrl.regenerateCron()"\n                                    ng-model="$ctrl.state.monthly.specificWeekDay.day"\n                                    ng-required="$ctrl.activeTab === \'monthly\' && $ctrl.state.monthly.subTab === \'specificWeekDay\'"\n                                    ng-options="day as $ctrl.dayDisplay(day) for day in $ctrl.selectOptions.days"\n                                    ng-class="$ctrl.parsedOptions.formSelectClass">\n                            </select>\n                            of every\n                            <select class="months-small"\n                                    name="monthlySpecificWeekDayMonths"\n                                    ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'monthly\' || $ctrl.state.monthly.subTab !== \'specificWeekDay\'"\n                                    ng-change="$ctrl.regenerateCron()"\n                                    ng-model="$ctrl.state.monthly.specificWeekDay.months"\n                                    ng-required="$ctrl.activeTab === \'monthly\' && $ctrl.state.monthly.subTab === \'specificWeekDay\'"\n                                    ng-options="month as month for month in $ctrl.selectOptions.months"\n                                    ng-class="$ctrl.parsedOptions.formSelectClass">\n                            </select>\n                            month(s) at\n                            <cron-gen-time-select\n                                    is-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'monthly\' || $ctrl.state.monthly.subTab !== \'specificWeekDay\'"\n                                    on-change="$ctrl.regenerateCron()"\n                                    name-prefix="monthlySpecificWeekDay"\n                                    is-required="$ctrl.activeTab === \'monthly\' && $ctrl.state.monthly.subTab === \'specificWeekDay\'"\n                                    model="$ctrl.state.monthly.specificWeekDay"\n                                    select-class="$ctrl.parsedOptions.formSelectClass"\n                                    use-24-hour-time="$ctrl.parsedOptions.use24HourTime"\n                                    hide-seconds="$ctrl.parsedOptions.hideSeconds">\n                            </cron-gen-time-select>\n                        </div>\n\n                    </div>\n                    <div class="tab-pane"\n                         ng-show="!$ctrl.parsedOptions.hideYearlyTab"\n                         ng-class="{\'active\': $ctrl.activeTab === \'yearly\'}">\n                        <div class="well well-small">\n                            <input type="radio"\n                                   value="specificMonthDay"\n                                   ng-disabled="$ctrl.ngDisabled"\n                                   ng-change="$ctrl.regenerateCron()"\n                                   ng-model="$ctrl.state.yearly.subTab"\n                                   ng-class="$ctrl.state.formRadioClass"\n                                   name="yearly-radio">\n                            Every\n                            <select class="months"\n                                    name="yearlySpecificMonthDayMonth"\n                                    ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'yearly\' || $ctrl.state.yearly.subTab !== \'specificMonthDay\'"\n                                    ng-change="$ctrl.regenerateCron()"\n                                    ng-model="$ctrl.state.yearly.specificMonthDay.month"\n                                    ng-required="$ctrl.activeTab === \'yearly\' && $ctrl.state.yearly.subTab === \'specificMonthDay\'"\n                                    ng-options="month as $ctrl.monthDisplay(month) for month in $ctrl.selectOptions.months"\n                                    ng-class="$ctrl.parsedOptions.formSelectClass">\n                            </select>\n                            on the\n                            <select class="month-days"\n                                    name="yearlySpecificMonthDayDay"\n                                    ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'yearly\' || $ctrl.state.yearly.subTab !== \'specificMonthDay\'"\n                                    ng-change="$ctrl.regenerateCron()"\n                                    ng-model="$ctrl.state.yearly.specificMonthDay.day"\n                                    ng-required="$ctrl.activeTab === \'yearly\' && $ctrl.state.yearly.subTab === \'specificMonthDay\'"\n                                    ng-options="monthDaysWithLast as $ctrl.monthDayDisplay(monthDaysWithLast) for monthDaysWithLast in $ctrl.selectOptions.monthDaysWithLasts"\n                                    ng-class="$ctrl.parsedOptions.formSelectClass">\n                            </select>\n                            at\n                            <cron-gen-time-select\n                                    is-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'yearly\' || $ctrl.state.yearly.subTab !== \'specificMonthDay\'"\n                                    on-change="$ctrl.regenerateCron()"\n                                    is-required="$ctrl.activeTab === \'yearly\' && $ctrl.state.yearly.subTab === \'specificMonthDay\'"\n                                    name-prefix="yearlySpecificMonthDay"\n                                    model="$ctrl.state.yearly.specificMonthDay"\n                                    select-class="$ctrl.parsedOptions.formSelectClass"\n                                    use-24-hour-time="$ctrl.parsedOptions.use24HourTime"\n                                    hide-seconds="$ctrl.parsedOptions.hideSeconds">\n                            </cron-gen-time-select>\n                        </div>\n                        <div class="well well-small">\n                            <input type="radio"\n                                   value="specificMonthWeek"\n                                   ng-disabled="$ctrl.ngDisabled"\n                                   ng-change="$ctrl.regenerateCron()"\n                                   ng-model="$ctrl.state.yearly.subTab"\n                                   ng-class="$ctrl.state.formRadioClass"\n                                   name="yearly-radio">\n                            On the\n                            <select class="day-order-in-month"\n                                    name="yearlySpecificMonthWeekMonthWeek"\n                                    ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'yearly\' || $ctrl.state.yearly.subTab !== \'specificMonthWeek\'"\n                                    ng-change="$ctrl.regenerateCron()"\n                                    ng-model="$ctrl.state.yearly.specificMonthWeek.monthWeek"\n                                    ng-required="$ctrl.activeTab === \'yearly\' && $ctrl.state.yearly.subTab === \'specificMonthWeek\'"\n                                    ng-options="monthWeek as $ctrl.monthWeekDisplay(monthWeek) for monthWeek in $ctrl.selectOptions.monthWeeks"\n                                    ng-class="$ctrl.parsedOptions.formSelectClass">\n                            </select>\n                            <select class="week-days"\n                                    name="yearlySpecificMonthWeekMonthDay"\n                                    ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'yearly\' || $ctrl.state.yearly.subTab !== \'specificMonthWeek\'"\n                                    ng-change="$ctrl.regenerateCron()"\n                                    ng-model="$ctrl.state.yearly.specificMonthWeek.day"\n                                    ng-required="$ctrl.activeTab === \'yearly\' && $ctrl.state.yearly.subTab === \'specificMonthWeek\'"\n                                    ng-options="day as $ctrl.dayDisplay(day) for day in $ctrl.selectOptions.days"\n                                    ng-class="$ctrl.parsedOptions.formSelectClass">\n                            </select>\n                            of\n                            <select class="months"\n                                    name="yearlySpecificMonthWeekMontMonth"\n                                    ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'yearly\' || $ctrl.state.yearly.subTab !== \'specificMonthWeek\'"\n                                    ng-change="$ctrl.regenerateCron()"\n                                    ng-model="$ctrl.state.yearly.specificMonthWeek.month"\n                                    ng-required="$ctrl.activeTab === \'yearly\' && $ctrl.state.yearly.subTab === \'specificMonthWeek\'"\n                                    ng-options="month as $ctrl.monthDisplay(month) for month in $ctrl.selectOptions.months"\n                                    ng-class="$ctrl.parsedOptions.formSelectClass">\n                            </select>\n                            at\n                            <cron-gen-time-select\n                                    is-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'yearly\' || $ctrl.state.yearly.subTab !== \'specificMonthWeek\'"\n                                    on-change="$ctrl.regenerateCron()"\n                                    name-prefix="yearlySpecificMonthWeek"\n                                    is-required="$ctrl.activeTab === \'yearly\' && $ctrl.state.yearly.subTab === \'specificMonthWeek\'"\n                                    model="$ctrl.state.yearly.specificMonthWeek"\n                                    select-class="$ctrl.parsedOptions.formSelectClass"\n                                    use-24-hour-time="$ctrl.parsedOptions.use24HourTime"\n                                    hide-seconds="$ctrl.parsedOptions.hideSeconds">\n                            </cron-gen-time-select>\n                        </div>\n                    </div>\n                    <div class="tab-pane"\n                         ng-show="!$ctrl.parsedOptions.hideAdvancedTab"\n                         ng-class="{\'active\': $ctrl.activeTab === \'advanced\'}">\n                        Cron Expression\n                        <input type="text"\n                               class="advanced-cron-gen-input"\n                               name="advancedExpression"\n                               ng-disabled="$ctrl.ngDisabled || $ctrl.activeTab !== \'advanced\'"\n                               ng-change="$ctrl.regenerateCron()"\n                               ng-model="$ctrl.state.advanced.expression"\n                               ng-required="$ctrl.activeTab === \'advanced\'"\n                               ng-class="$ctrl.parsedOptions.formInputClass">\n\n                        <p>More details about how to create these expressions can be found <a\n                                href="http://www.quartz-scheduler.org/documentation/quartz-2.x/tutorials/crontrigger.html"\n                                target="_blank">here</a>.</p>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n');}]);