/**
 * angular-data-table - A feature-rich but lightweight ES6 AngularJS Data Table crafted for large data sets!
 * @version v0.7.0
 * @link http://swimlane.com/
 * @license 
 */
!function(e,t){if("function"==typeof define&&define.amd)define("DataTable",["exports"],t);else if("undefined"!=typeof exports)t(exports);else{var n={exports:{}};t(n.exports),e.DataTable=n.exports}}(this,function(e){"use strict";function t(e){if(Array.isArray(e)){for(var t=0,n=Array(e.length);t<e.length;t++)n[t]=e[t];return n}return Array.from(e)}function n(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function o(){return{restrict:"E",controller:A,controllerAs:"pager",scope:!0,bindToController:{page:"=",size:"=",count:"=",onPage:"&"},template:'<div class="dt-pager">\n        <ul class="pager">\n          <li ng-class="{ disabled: !pager.canPrevious() }">\n            <a href ng-click="pager.selectPage(1)" class="icon-prev"></a>\n          </li>\n          <li ng-class="{ disabled: !pager.canPrevious() }">\n            <a href ng-click="pager.prevPage()" class="icon-left"></a>\n          </li>\n          <li ng-repeat="pg in pager.pages track by $index" ng-class="{ active: pg.active }">\n            <a href ng-click="pager.selectPage(pg.number)">{{pg.text}}</a>\n          </li>\n          <li ng-class="{ disabled: !pager.canNext() }">\n            <a href ng-click="pager.nextPage()" class="icon-right"></a>\n          </li>\n          <li ng-class="{ disabled: !pager.canNext() }">\n            <a href ng-click="pager.selectPage(pager.totalPages)" class="icon-skip"></a>\n          </li>\n        </ul>\n      </div>',replace:!0}}function i(){return{restrict:"E",controller:B,controllerAs:"footer",scope:!0,bindToController:{paging:"=",onPage:"&"},template:'<div class="dt-footer">\n        <div class="page-count">{{footer.paging.count}} total</div>\n        <dt-pager page="footer.page"\n               size="footer.paging.size"\n               count="footer.paging.count"\n               on-page="footer.onPaged(page)"\n               ng-show="footer.paging.count / footer.paging.size > 1">\n         </dt-pager>\n      </div>',replace:!0}}function r(e,t,n,o){return{restrict:"E",controller:G,scope:!0,controllerAs:"cell",bindToController:{options:"=",value:"=",selected:"=",column:"=",row:"=",expanded:"=",hasChildren:"=",onTreeToggle:"&",onCheckboxChange:"&"},template:'<div class="dt-cell"\n            data-title="{{::cell.column.name}}"\n            ng-style="cell.styles()"\n            ng-class="cell.cellClass()">\n        <label ng-if="cell.column.isCheckboxColumn" class="dt-checkbox">\n          <input type="checkbox"\n                 ng-checked="cell.selected"\n                 ng-click="cell.onCheckboxChanged($event)" />\n        </label>\n        <span ng-if="cell.column.isTreeColumn && cell.hasChildren"\n              ng-class="cell.treeClass()"\n              ng-click="cell.onTreeToggled($event)"></span>\n        <span class="dt-cell-content"></span>\n      </div>',replace:!0,compile:function(){return{pre:function(e,n,o,i){function r(){s=i.options.$outer.$new(!1),s.getValue=i.getValue}var s,l=angular.element(n[0].querySelector(".dt-cell-content"));(i.column.template||i.column.cellRenderer)&&r(),e.$watch("cell.row",function(){if(s&&(s.$destroy(),r(),s.$cell=i.value,s.$row=i.row,s.$column=i.column,s.$$watchers=null),i.column.template){l.empty();var e=angular.element("<span>"+i.column.template.trim()+"</span>");l.append(t(e)(s))}else if(i.column.cellRenderer){l.empty();var e=angular.element(i.column.cellRenderer(s,l));l.append(t(e)(s))}else l[0].innerHTML=i.getValue()},!0)}}}}}function s(e){return e=e.replace(/[^a-zA-Z0-9 ]/g," "),e=e.replace(/([a-z](?=[A-Z]))/g,"$1 "),e=e.replace(/([^a-zA-Z0-9 ])|^[0-9]+/g,"").trim().toLowerCase(),e=e.replace(/([ 0-9]+)([a-zA-Z])/g,function(e,t,n){return t.trim()+n.toUpperCase()})}function l(e){var t=s(e);return D[t]||(void 0!==H[M.css+e]?D[t]=M.css+e:void 0!==H[e]&&(D[t]=e)),D[t]}function a(e,t,n){V?!I&&j?(e[N]="translate3d("+t+"px, "+n+"px, 0)",e[O]="hidden"):e[s(N)]="translate("+t+"px, "+n+"px)":(e.top=n+"px",e.left=t+"px")}function c(){return{restrict:"E",controller:F,controllerAs:"group",bindToController:{row:"=",onGroupToggle:"&",expanded:"=",options:"="},scope:!0,replace:!0,template:'\n      <div class="dt-group-row">\n        <span ng-class="group.treeClass()"\n              ng-click="group.onGroupToggled($event)">\n        </span>\n        <span class="dt-group-row-label" ng-bind="group.row.name">\n        </span>\n      </div>',link:function(e,t,n,o){a(t[0].style,0,o.row.$$index*o.options.rowHeight),o.options.internal.styleTranslator.register(e.$index,t)}}}function d(e,t){if(!e||!t)return e;var n=e,o=t.split(".");if(o.length)for(var i=0,r=o.length;r>i;i++)n=n[o[i]];return n}function u(){return{restrict:"E",controller:U,controllerAs:"rowCtrl",scope:!0,bindToController:{row:"=",columns:"=",columnWidths:"=",expanded:"=",selected:"=",hasChildren:"=",options:"=",onCheckboxChange:"&",onTreeToggle:"&"},link:function(e,t,n,o){o.row&&a(t[0].style,0,o.row.$$index*o.options.rowHeight),o.options.internal.styleTranslator.register(e.$index,t)},template:'\n      <div class="dt-row">\n        <div class="dt-row-left dt-row-block"\n             ng-if="rowCtrl.columns[\'left\'].length"\n             ng-style="rowCtrl.stylesByGroup(\'left\')">\n          <dt-cell ng-repeat="column in rowCtrl.columns[\'left\'] track by column.$id"\n                   on-tree-toggle="rowCtrl.onTreeToggled(cell)"\n                   column="column"\n                   options="rowCtrl.options"\n                   has-children="rowCtrl.hasChildren"\n                   on-checkbox-change="rowCtrl.onCheckboxChanged($event)"\n                   selected="rowCtrl.selected"\n                   expanded="rowCtrl.expanded"\n                   row="rowCtrl.row"\n                   value="rowCtrl.getValue(column)">\n          </dt-cell>\n        </div>\n        <div class="dt-row-center dt-row-block"\n             ng-style="rowCtrl.stylesByGroup(\'center\')">\n          <dt-cell ng-repeat="column in rowCtrl.columns[\'center\'] track by column.$id"\n                   on-tree-toggle="rowCtrl.onTreeToggled(cell)"\n                   column="column"\n                   options="rowCtrl.options"\n                   has-children="rowCtrl.hasChildren"\n                   expanded="rowCtrl.expanded"\n                   selected="rowCtrl.selected"\n                   row="rowCtrl.row"\n                   on-checkbox-change="rowCtrl.onCheckboxChanged($event)"\n                   value="rowCtrl.getValue(column)">\n          </dt-cell>\n        </div>\n        <div class="dt-row-right dt-row-block"\n             ng-if="rowCtrl.columns[\'right\'].length"\n             ng-style="rowCtrl.stylesByGroup(\'right\')">\n          <dt-cell ng-repeat="column in rowCtrl.columns[\'right\'] track by column.$id"\n                   on-tree-toggle="rowCtrl.onTreeToggled(cell)"\n                   column="column"\n                   options="rowCtrl.options"\n                   has-children="rowCtrl.hasChildren"\n                   selected="rowCtrl.selected"\n                   on-checkbox-change="rowCtrl.onCheckboxChanged($event)"\n                   row="rowCtrl.row"\n                   expanded="rowCtrl.expanded"\n                   value="rowCtrl.getValue(column)">\n          </dt-cell>\n        </div>\n      </div>',replace:!0}}function h(){return{controller:q,restrict:"A",require:"^dtBody",controllerAs:"selCtrl"}}function p(e,t){return{restrict:"E",require:"^dtBody",transclude:!0,replace:!0,template:'<div ng-style="scrollerStyles()" ng-transclude></div>',link:function(e,t,n,o){function i(){o.options.internal.offsetY=l,o.options.internal.offsetX=a,o.updatePage(),o.options.scrollbarV&&o.getRows(),o.options.$outer.$digest(),s=!1}function r(){s||(Y(i),s=!0)}var s=!1,l=0,a=0,c=t.parent();o.options.internal.styleTranslator=new Z(o.options.rowHeight),o.options.internal.setYOffset=function(e){c[0].scrollTop=e},c.on("scroll",function(e){l=this.scrollTop,a=this.scrollLeft,r()}),e.$on("$destroy",function(){c.off("scroll")}),e.scrollerStyles=function(){return o.options.scrollbarV?{height:o.count*o.options.rowHeight+"px"}:void 0}}}}function g(e){return{restrict:"E",controller:_,controllerAs:"body",bindToController:{columns:"=",columnWidths:"=",rows:"=",options:"=",selected:"=?",expanded:"=?",onPage:"&",onTreeToggle:"&",onSelect:"&",onRowClick:"&",onRowDblClick:"&"},scope:!0,template:'\n      <div \n        class="progress-linear" \n        role="progressbar" \n        ng-show="body.options.paging.loadingIndicator">\n        <div class="container">\n          <div class="bar"></div>\n        </div>\n      </div>\n      <div class="dt-body" ng-style="body.styles()" dt-seletion>\n        <dt-scroller class="dt-body-scroller">\n          <dt-group-row ng-repeat-start="r in body.tempRows track by $index"\n                        ng-if="r.group"\n                        ng-style="body.groupRowStyles(r)" \n                        options="body.options"\n                        on-group-toggle="body.onGroupToggle(group)"\n                        expanded="body.getRowExpanded(r)"\n                        tabindex="{{$index}}"\n                        row="r">\n          </dt-group-row>\n          <dt-row ng-repeat-end\n                  ng-if="!r.group"\n                  row="body.getRowValue($index)"\n                  tabindex="{{$index}}"\n                  columns="body.columns"\n                  column-widths="body.columnWidths"\n                  ng-keydown="selCtrl.keyDown($event, $index, r)"\n                  ng-click="selCtrl.rowClicked($event, r.$$index, r)"\n                  ng-dblclick="selCtrl.rowDblClicked($event, r.$$index, r)"\n                  on-tree-toggle="body.onTreeToggled(row, cell)"\n                  ng-class="body.rowClasses(r)"\n                  options="body.options"\n                  selected="body.isSelected(r)"\n                  on-checkbox-change="selCtrl.onCheckboxChange($event, $index, row)"\n                  columns="body.columnsByPin"\n                  has-children="body.getRowHasChildren(r)"\n                  expanded="body.getRowExpanded(r)"\n                  ng-style="body.rowStyles(r)">\n          </dt-row>\n        </dt-scroller>\n        <div ng-if="body.rows && !body.rows.length" \n             class="empty-row" \n             ng-bind="::body.options.emptyMessage">\n       </div>\n       <div ng-if="body.rows === undefined" \n             class="loading-row"\n             ng-bind="::body.options.loadingMessage">\n        </div>\n      </div>'}}function f(e,t){return"single"===e?"asc"===t?"desc":"asc":t?"asc"===t?"desc":void 0:"asc"}function m(e){return{restrict:"E",controller:K,controllerAs:"hcell",scope:!0,bindToController:{options:"=",column:"=",onCheckboxChange:"&",onSort:"&",sortType:"=",onResize:"&",selected:"="},replace:!0,template:'<div ng-class="hcell.cellClass()"\n            class="dt-header-cell"\n            draggable="true"\n            data-id="{{column.$id}}"\n            ng-style="hcell.styles()"\n            title="{{::hcell.column.name}}">\n        <div resizable="hcell.column.resizable"\n             on-resize="hcell.onResized(width, hcell.column)"\n             min-width="hcell.column.minWidth"\n             max-width="hcell.column.maxWidth">\n          <label ng-if="hcell.column.isCheckboxColumn && hcell.column.headerCheckbox" class="dt-checkbox">\n            <input type="checkbox"\n                   ng-checked="hcell.selected"\n                   ng-click="hcell.onCheckboxChange()" />\n          </label>\n          <span class="dt-header-cell-label"\n                ng-click="hcell.onSorted()">\n          </span>\n          <span ng-class="hcell.sortClass()"></span>\n        </div>\n      </div>',compile:function(){return{pre:function(t,n,o,i){var r=n[0].querySelector(".dt-header-cell-label"),s=void 0;if((i.column.headerTemplate||i.column.headerRenderer)&&(s=i.options.$outer.$new(!1),s.$header=i.column.name,s.$index=t.$index),i.column.headerTemplate){var l=angular.element("<span>"+i.column.headerTemplate.trim()+"</span>");angular.element(r).append(e(l)(s))}else if(i.column.headerRenderer){var a=angular.element(i.column.headerRenderer(n));angular.element(r).append(e(a)(s)[0])}else{var c=i.column.name;void 0!==c&&null!==c||(c=""),r.textContent=c}}}}}}function v(e){return{restrict:"E",controller:J,controllerAs:"header",scope:!0,bindToController:{options:"=",columns:"=",columnWidths:"=",onSort:"&",onResize:"&",onCheckboxChange:"&"},template:'\n      <div class="dt-header" ng-style="header.styles()">\n\n        <div class="dt-header-inner" ng-style="header.innerStyles()">\n          <div class="dt-row-left"\n               ng-style="header.stylesByGroup(\'left\')"\n               ng-if="header.columns[\'left\'].length"\n               sortable="header.options.reorderable"\n               on-sortable-sort="columnsResorted(event, columnId)">\n            <dt-header-cell\n              ng-repeat="column in header.columns[\'left\'] track by column.$id"\n              on-checkbox-change="header.onCheckboxChanged()"\n              on-sort="header.onSorted(column)"\n              options="header.options"\n              sort-type="header.options.sortType"\n              on-resize="header.onResized(column, width)"\n              selected="header.isSelected()"\n              column="column">\n            </dt-header-cell>\n          </div>\n          <div class="dt-row-center"\n               sortable="header.options.reorderable"\n               ng-style="header.stylesByGroup(\'center\')"\n               on-sortable-sort="columnsResorted(event, columnId)">\n            <dt-header-cell\n              ng-repeat="column in header.columns[\'center\'] track by column.$id"\n              on-checkbox-change="header.onCheckboxChanged()"\n              on-sort="header.onSorted(column)"\n              sort-type="header.options.sortType"\n              selected="header.isSelected()"\n              on-resize="header.onResized(column, width)"\n              options="header.options"\n              column="column">\n            </dt-header-cell>\n          </div>\n          <div class="dt-row-right"\n               ng-if="header.columns[\'right\'].length"\n               sortable="header.options.reorderable"\n               ng-style="header.stylesByGroup(\'right\')"\n               on-sortable-sort="columnsResorted(event, columnId)">\n            <dt-header-cell\n              ng-repeat="column in header.columns[\'right\'] track by column.$id"\n              on-checkbox-change="header.onCheckboxChanged()"\n              on-sort="header.onSorted(column)"\n              sort-type="header.options.sortType"\n              selected="header.isSelected()"\n              on-resize="header.onResized(column, width)"\n              options="header.options"\n              column="column">\n            </dt-header-cell>\n          </div>\n        </div>\n      </div>',replace:!0,link:function(t,n,o,i){t.columnsResorted=function(t,n){var o=r(n),s=angular.element(t.currentTarget),l=-1;angular.forEach(s.children(),function(e,t){n===angular.element(e).attr("data-id")&&(l=t)}),e(function(){angular.forEach(i.columns,function(e){var t=e.indexOf(o);if(t>-1){var n=e[l],r=i.options.columns.indexOf(n),s=i.options.columns.indexOf(o);return i.options.columns.splice(s,1),i.options.columns.splice(r,0,o),!1}})})};var r=function(e){var t=i.columns.left.concat(i.columns.center).concat(i.columns.right);return t.find(function(t){return t.$id===e})}}}}function w(e){return{restrict:"A",scope:{isSortable:"=sortable",onSortableSort:"&"},link:function(e,t,n){function o(e,t){if(e.parentNode==t.parentNode)for(var n=e;n;n=n.previousSibling)if(n===t)return!0;return!1}function i(e){var t=e.target;o(l,t)?t.parentNode.insertBefore(l,t):t.nextSibling&&t.hasAttribute("draggable")&&t.parentNode.insertBefore(l,t.nextSibling.nextSibling)}function r(n){n.preventDefault(),l.classList.remove("dt-clone"),t.off("dragend",r),t.off("dragenter",i),a!==l.nextSibling&&e.onSortableSort({event:n,columnId:angular.element(l).attr("data-id")})}function s(n){return e.isSortable?(n=n.originalEvent||n,l=n.target,a=l.nextSibling,l.classList.add("dt-clone"),n.dataTransfer.effectAllowed="move",n.dataTransfer.setData("Text",l.textContent),t.on("dragenter",i),void t.on("dragend",r)):!1}var l,a;t[0];t.on("dragstart",s),e.$on("$destroy",function(){t.off("dragstart",s)})}}}function y(e,t){return{restrict:"A",scope:{isResizable:"=resizable",minWidth:"=",maxWidth:"=",onResize:"&"},link:function(n,o,i){function r(e){e=e.originalEvent||e;var t=c[0].clientWidth,o=e.movementX||e.mozMovementX||e.screenX-l,i=t+(o||0);l=e.screenX,(!n.minWidth||i>=n.minWidth)&&(!n.maxWidth||i<=n.maxWidth)&&c.css({width:i+"px"})}function s(){n.onResize&&t(function(){var e=c[0].clientWidth;e<n.minWidth&&(e=n.minWidth),n.onResize({width:e})}),e.unbind("mousemove",r),e.unbind("mouseup",s)}n.isResizable&&o.addClass("resizable");var l,a=angular.element('<span class="dt-resize-handle" title="Resize"></span>'),c=o.parent();a.on("mousedown",function(t){return o[0].classList.contains("resizable")?(t.stopPropagation(),t.preventDefault(),e.on("mousemove",r),void e.on("mouseup",s)):!1}),o.append(a)}}}function b(e,t,n){var o,i,r,s=null,l=0;n||(n={});var a=function(){l=n.leading===!1?0:new Date,s=null,r=e.apply(o,i)};return function(){var c=new Date;l||n.leading!==!1||(l=c);var d=t-(c-l);return o=this,i=arguments,0>=d?(clearTimeout(s),s=null,l=c,r=e.apply(o,i)):s||n.trailing===!1||(s=setTimeout(a,d)),r}}function C(){var e=document.createElement("div");e.style.visibility="hidden",e.style.width="100px",e.style.msOverflowStyle="scrollbar",document.body.appendChild(e);var t=e.offsetWidth;e.style.overflow="scroll";var n=document.createElement("div");n.style.width="100%",e.appendChild(n);var o=n.offsetWidth;return e.parentNode.removeChild(e),t-o}function x(){var e=((new Date).getTime()/1e3|0).toString(16);return e+"xxxxxxxxxxxxxxxx".replace(/[x]/g,function(){return(16*Math.random()|0).toString(16)}).toLowerCase()}function k(e,t,n){angular.forEach(e,function(e){e.forEach(function(e){e.canAutoResize?e.width=0:(t-=e.width,n-=e.flexGrow)})});var o={},i=t,r=function(){var t=i/n;i=0,angular.forEach(e,function(e){e.forEach(function(e,n){if(e.canAutoResize&&!o[n]){var r=e.width+e.flexGrow*t;void 0!==e.minWidth&&r<e.minWidth?(i+=r-e.minWidth,e.width=e.minWidth,o[n]=!0):e.width=r}})})};do r();while(0!==i)}function $(e){for(var t={left:[],center:[],right:[]},n=0,o=e.length;o>n;n++){var i=e[n];i.frozenLeft?t.left.push(i):i.frozenRight?t.right.push(i):t.center.push(i)}return t}function R(e){var t=0,n=!0,o=!1,i=void 0;try{for(var r,s=e[Symbol.iterator]();!(n=(r=s.next()).done);n=!0){var l=r.value;t+=l.flexGrow||0}}catch(a){o=!0,i=a}finally{try{!n&&s["return"]&&s["return"]()}finally{if(o)throw i}}return t}function T(e,t){var n=0;return e.forEach(function(e){var o=t&&e[t];n+=o?e[t]:e.width}),n}function P(e,t){var n=T(e),o=R(e),i=$(e);n!==t&&k(i,t,o)}function S(e,t,n){var o=0,i=n>-1?e.slice(n,e.length).filter(function(e){return e.canAutoResize}):e.filter(function(e){return e.canAutoResize});e.forEach(function(e){o+=e.canAutoResize?e.$$oldWidth||e.width:e.width});var r=t-o,s=r/i.length,l=o>t;i.forEach(function(e){if(l)e.width=e.$$oldWidth||e.width;else{e.$$oldWidth||(e.$$oldWidth=e.width);var t=e.$$oldWidth+s;e.minWith&&t<e.minWidth?e.width=e.minWidth:e.maxWidth&&t>e.maxWidth?e.width=e.maxWidth:e.width=t}})}function z(e,t){return{left:T(e.left),center:T(e.center),right:T(e.right),total:T(t)}}function W(e,t,n){return{restrict:"E",replace:!0,controller:ne,scope:!0,bindToController:{options:"=",rows:"=",selected:"=?",expanded:"=?",onSelect:"&",onSort:"&",onTreeToggle:"&",onPage:"&",onRowClick:"&",onRowDblClick:"&",onColumnResize:"&"},controllerAs:"dt",template:function(e){var t=e[0].getElementsByTagName("column"),n=x();return Q.saveColumns(n,t),'<div class="dt" ng-class="dt.tableCss()" data-column-id="'+n+'">\n          <dt-header options="dt.options"\n                     on-checkbox-change="dt.onHeaderCheckboxChange()"\n                     columns="dt.columnsByPin"\n                     column-widths="dt.columnWidths"\n                     ng-if="dt.options.headerHeight"\n                     on-resize="dt.onResized(column, width)"\n                     selected="dt.isAllRowsSelected()"\n                     on-sort="dt.onSorted()">\n          </dt-header>\n          <dt-body rows="dt.rows"\n                   selected="dt.selected"\n                   expanded="dt.expanded"\n                   columns="dt.columnsByPin"\n                   on-select="dt.onSelected(rows)"\n                   on-row-click="dt.onRowClicked(row)"\n                   on-row-dbl-click="dt.onRowDblClicked(row)"\n                   column-widths="dt.columnWidths"\n                   options="dt.options"\n                   on-page="dt.onBodyPage(offset, size)"\n                   on-tree-toggle="dt.onTreeToggled(row, cell)">\n           </dt-body>\n          <dt-footer ng-if="dt.options.footerHeight"\n                     ng-style="{ height: dt.options.footerHeight + \'px\' }"\n                     on-page="dt.onFooterPage(offset, size)"\n                     paging="dt.options.paging">\n           </dt-footer>\n        </div>'},compile:function(o,i){return{pre:function(o,i,r,s){function l(){var e=i[0].getBoundingClientRect();if(s.options.internal.innerWidth=Math.floor(e.width),s.options.scrollbarV){var t=e.height;s.options.headerHeight&&(t-=s.options.headerHeight),s.options.footerHeight&&(t-=s.options.footerHeight),s.options.internal.bodyHeight=t,s.calculatePageSize()}s.adjustColumns()}Q.buildColumns(o,n);var a=i.attr("data-column-id"),c=Q.columns[a];c&&(s.options.columns=c),s.transposeColumnDefaults(),s.options.internal.scrollBarWidth=C(),e.addEventListener("resize",b(function(){t(l)}));var d=function u(){var e=i[0].getBoundingClientRect(),n=e.width&&e.height;n?l():t(u,100)};d(),i.addClass("dt-loaded"),o.$on("$destroy",function(){angular.element(e).off("resize")})}}}}}W.$inject=["$window","$timeout","$parse"],y.$inject=["$document","$timeout"],w.$inject=["$timeout"],v.$inject=["$timeout"],m.$inject=["$compile"],g.$inject=["$timeout"],p.$inject=["$timeout","$rootScope"],r.$inject=["$rootScope","$compile","$log","$timeout"],Object.defineProperty(e,"__esModule",{value:!0});var E=function(){function e(e,t){for(var n=0;n<t.length;n++){var o=t[n];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,o.key,o)}}return function(t,n,o){return n&&e(t.prototype,n),o&&e(t,o),t}}();!function(){function e(e){Array.prototype[e]||(Array.prototype[e]=function(t){var n,o,i,r=arguments[1];if("function"!=typeof t)throw new TypeError;for(i=r?function(){return t.apply(r,arguments)}:t,n=0,o=this.length;o>n;n++)if(i(this[n],n,this)===!0)return"find"===e?this[n]:n;return"find"!==e?-1:void 0})}for(var t in{find:1,findIndex:1})e(t)}();var A=function(){function e(t){var o=this;n(this,e),t.$watch("pager.count",function(e){o.calcTotalPages(o.size,o.count),o.getPages(o.page||1)}),t.$watch("pager.size",function(e){o.calcTotalPages(o.size,o.count),o.getPages(o.page||1)}),t.$watch("pager.page",function(e){0!==e&&e<=o.totalPages&&o.getPages(e)}),this.getPages(this.page||1)}return e.$inject=["$scope"],E(e,[{key:"calcTotalPages",value:function(e,t){var t=1>e?1:Math.ceil(t/e);this.totalPages=Math.max(t||0,1)}},{key:"selectPage",value:function(e){e>0&&e<=this.totalPages&&(this.page=e,this.onPage({page:e}))}},{key:"prevPage",value:function(){this.page>1&&this.selectPage(--this.page)}},{key:"nextPage",value:function(){this.selectPage(++this.page)}},{key:"canPrevious",value:function(){return this.page>1}},{key:"canNext",value:function(){return this.page<this.totalPages}},{key:"getPages",value:function(e){var t=[],n=1,o=this.totalPages,i=5,r=i<this.totalPages;r&&(n=(Math.ceil(e/i)-1)*i+1,o=Math.min(n+i-1,this.totalPages));for(var s=n;o>=s;s++)t.push({number:s,text:s,active:s===e});this.pages=t}}]),e}(),B=function(){function e(t){var o=this;n(this,e),this.page=this.paging.offset+1,t.$watch("footer.paging.offset",function(e){o.offsetChanged(e)})}return e.$inject=["$scope"],E(e,[{key:"offsetChanged",value:function(e){this.page=e+1}},{key:"onPaged",value:function(e){this.paging.offset=e-1,this.onPage({offset:this.paging.offset,size:this.paging.size})}}]),e}(),G=function(){function e(){n(this,e)}return E(e,[{key:"styles",value:function(){return{width:this.column.width+"px","min-width":this.column.width+"px"}}},{key:"cellClass",value:function(){var e={"dt-tree-col":this.column.isTreeColumn};return this.column.className&&(e[this.column.className]=!0),e}},{key:"treeClass",value:function(){return{"dt-tree-toggle":!0,"icon-right":!this.expanded,"icon-down":this.expanded}}},{key:"onTreeToggled",value:function(e){e.stopPropagation(),this.expanded=!this.expanded,this.onTreeToggle({cell:{value:this.value,column:this.column,expanded:this.expanded}})}},{key:"onCheckboxChanged",value:function(e){e.stopPropagation(),this.onCheckboxChange({$event:e})}},{key:"getValue",value:function(){var e=this.column.cellDataGetter?this.column.cellDataGetter(this.value):this.value;return void 0!==e&&null!==e||(e=""),e}}]),e}(),D={},H=document.createElement("div").style,M=function(){var e=window.getComputedStyle(document.documentElement,""),t=(Array.prototype.slice.call(e).join("").match(/-(moz|webkit|ms)-/)||""===e.OLink&&["","o"])[1],n="WebKit|Moz|MS|O".match(new RegExp("("+t+")","i"))[1];return{dom:n,lowercase:t,css:"-"+t+"-",js:t[0].toUpperCase()+t.substr(1)}}(),N=l("transform"),O=l("backfaceVisibility"),V=!!l("transform"),j=!!l("perspective"),L=window.navigator.userAgent,I=/Safari\//.test(L)&&!/Chrome\//.test(L),F=function(){function e(){n(this,e)}return E(e,[{key:"onGroupToggled",value:function(e){e.stopPropagation(),this.onGroupToggle({group:this.row})}},{key:"treeClass",value:function(){return{"dt-tree-toggle":!0,"icon-right":!this.expanded,"icon-down":this.expanded}}}]),e}(),U=function(){function e(){n(this,e)}return E(e,[{key:"getValue",value:function(e){return e.prop?d(this.row,e.prop):""}},{key:"onTreeToggled",value:function(e){this.onTreeToggle({cell:e,row:this.row})}},{key:"stylesByGroup",value:function(e){var t={width:this.columnWidths[e]+"px"};if("left"===e)a(t,this.options.internal.offsetX,0);else if("right"===e){var n=-1*(this.columnWidths.total-this.options.internal.innerWidth-this.options.internal.offsetX+this.options.internal.scrollBarWidth);a(t,n,0)}return t}},{key:"onCheckboxChanged",value:function(e){this.onCheckboxChange({$event:e,row:this.row})}}]),e}(),X={BACKSPACE:8,TAB:9,RETURN:13,ALT:18,ESC:27,SPACE:32,PAGE_UP:33,PAGE_DOWN:34,END:35,HOME:36,LEFT:37,UP:38,RIGHT:39,DOWN:40,DELETE:46,COMMA:188,PERIOD:190,A:65,Z:90,ZERO:48,NUMPAD_0:96,NUMPAD_9:105},q=function(){function e(t){n(this,e),this.body=t.body,this.options=t.body.options,this.selected=t.body.selected}return e.$inject=["$scope"],E(e,[{key:"keyDown",value:function(e,t,n){if(X[e.keyCode]&&e.preventDefault(),e.keyCode===X.DOWN){var o=e.target.nextElementSibling;o&&o.focus()}else if(e.keyCode===X.UP){var i=e.target.previousElementSibling;i&&i.focus()}else e.keyCode===X.RETURN&&this.selectRow(t,n)}},{key:"rowClicked",value:function(e,t,n){this.options.checkboxSelection||this.selectRow(e,t,n),this.body.onRowClick({row:n})}},{key:"rowDblClicked",value:function(e,t,n){this.options.checkboxSelection||(e.preventDefault(),this.selectRow(e,t,n)),this.body.onRowDblClick({row:n})}},{key:"onCheckboxChange",value:function(e,t,n){this.selectRow(e,t,n)}},{key:"selectRow",value:function(e,t,n){if(this.options.selectable)if(this.options.multiSelect){var o=(e.ctrlKey||e.metaKey,e.shiftKey);if(o)this.selectRowsBetween(t,n);else{var i=this.selected.indexOf(n);i>-1?this.selected.splice(i,1):(this.options.multiSelectOnShift&&1===this.selected.length&&this.selected.splice(0,1),this.selected.push(n),this.body.onSelect({rows:[n]}))}this.prevIndex=t}else this.selected=n,this.body.onSelect({rows:[n]})}},{key:"selectRowsBetween",value:function(e){for(var t=e<this.prevIndex,n=[],o=0,i=this.body.rows.length;i>o;o++){var r=this.body.rows[o],s=o>=this.prevIndex&&e>=o,l=o<=this.prevIndex&&o>=e,a={};if(a=t?{start:e,end:this.prevIndex-e}:{start:this.prevIndex,end:e+1},t&&l||!t&&s){var c=this.selected.indexOf(r);if(t&&c>-1){this.selected.splice(c,1);continue}o>=a.start&&o<a.end&&-1===c&&(this.selected.push(r),n.push(r))}}this.body.onSelect({rows:n})}}]),e}(),Y=function(){return window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(e){window.setTimeout(e,1e3/60)}}(),Z=function(){function e(t){n(this,e),this.height=t,this.map=new Map}return E(e,[{key:"update",value:function(e){for(var t=0;t<=this.map.size;){var n=this.map.get(t),o=e[t];n&&o&&a(n[0].style,0,o.$$index*this.height),t++}}},{key:"register",value:function(e,t){this.map.set(e,t)}}]),e}(),_=function(){function e(t,o){var i=this;if(n(this,e),this.$scope=t,this.tempRows=[],this.treeColumn=this.options.columns.find(function(e){return e.isTreeColumn}),this.groupColumn=this.options.columns.find(function(e){return e.group}),t.$watchCollection("body.rows",this.rowsUpdated.bind(this)),this.options.scrollbarV||!this.options.scrollbarV&&this.options.paging.externalPaging){var r=!1;t.$watch("body.options.paging.size",function(e,t){(!r||e>t)&&(i.getRows(),r=!0)}),t.$watch("body.options.paging.count",function(e){i.count=e,i.updatePage()}),t.$watch("body.options.paging.offset",function(e){i.options.paging.size&&i.onPage({offset:e,size:i.options.paging.size})})}}return e.$inject=["$scope","$timeout"],E(e,[{key:"rowsUpdated",value:function(e,n){if(e)if(this.options.paging.externalPaging||(this.options.paging.count=e.length),this.count=this.options.paging.count,(this.treeColumn||this.groupColumn)&&this.buildRowsByGroup(),this.options.scrollbarV){var o=e&&n&&(e.length===n.length||e.length<n.length);this.getRows(o)}else{var i=this.rows;if(this.treeColumn?i=this.buildTree():this.groupColumn&&(i=this.buildGroups()),this.options.paging.externalPaging){var r=this.getFirstLastIndexes(),s=r.first;for(this.tempRows.splice(0,this.tempRows.length);s<r.last;)this.tempRows.push(i[s++])}else{var l;this.tempRows.splice(0,this.tempRows.length),(l=this.tempRows).push.apply(l,t(i))}}}},{key:"getFirstLastIndexes",value:function(){var e,t;return this.options.scrollbarV?(e=Math.max(Math.floor((this.options.internal.offsetY||0)/this.options.rowHeight,0),0),t=Math.min(e+this.options.paging.size,this.count)):this.options.paging.externalPaging?(e=Math.max(this.options.paging.offset*this.options.paging.size,0),t=Math.min(e+this.options.paging.size,this.count)):t=this.count,{first:e,last:t}}},{key:"updatePage",value:function(){var e=this.options.paging.offset,t=this.getFirstLastIndexes();void 0===this.options.internal.oldScrollPosition&&(this.options.internal.oldScrollPosition=0);var n=this.options.internal.oldScrollPosition,o=t.first/this.options.paging.size;this.options.internal.oldScrollPosition=o,o=n>o?Math.floor(o):o>n?Math.ceil(o):e,isNaN(o)||(this.options.paging.offset=o)}},{key:"calculateDepth",value:function(e){var t=arguments.length<=1||void 0===arguments[1]?0:arguments[1],n=this.treeColumn?this.treeColumn.relationProp:this.groupColumn.prop,o=this.treeColumn.prop;if(!e[n])return t;if(e.$$depth)return e.$$depth+t;var i=this.index[e[n]];if(i)return t+=1,this.calculateDepth(i,t);for(var r=0,s=this.rows.length;s>r;r++){var l=this.rows[r];if(l[o]==e[n])return t+=1,this.calculateDepth(l,t)}return t}},{key:"buildRowsByGroup",value:function(){this.index={},this.rowsByGroup={};for(var e=this.treeColumn?this.treeColumn.relationProp:this.groupColumn.prop,t=0,n=this.rows.length;n>t;t++){var o=this.rows[t],i=o[e];if(i&&(this.rowsByGroup[i]?this.rowsByGroup[i].push(o):this.rowsByGroup[i]=[o]),this.treeColumn){var r=this.treeColumn.prop;if(this.index[o[r]]=o,void 0===o[e])o.$$depth=0;else{var s=this.index[o[e]];if(void 0===s)for(var l=0;n>l;l++)if(this.rows[l][r]==i){s=this.rows[l];
break}void 0===s.$$depth&&(s.$$depth=this.calculateDepth(s)),o.$$depth=s.$$depth+1,s.$$children?s.$$children.push(o[r]):s.$$children=[o[r]]}}}}},{key:"buildGroups",value:function(){var e=this,n=[];return angular.forEach(this.rowsByGroup,function(o,i){n.push({name:i,group:!0}),e.expanded[i]&&n.push.apply(n,t(o))}),n}},{key:"isSelected",value:function(e){var t=!1;return this.options.selectable&&(t=this.options.multiSelect?this.selected.indexOf(e)>-1:this.selected===e),t}},{key:"buildTree",value:function(){function e(t,o,i){t.forEach(function(t){var r=t[n.treeColumn.relationProp],s=t[n.treeColumn.prop],l=n.rowsByGroup[s],a=n.expanded[s];(i>0||!r)&&(o.push(t),l&&l.length>0&&a&&e(l,o,i+1))})}var t=[],n=this;return e(this.rows,t,0),t}},{key:"getRows",value:function(e){if((this.treeColumn||this.groupColumn)&&!this.rowsByGroup)return!1;var t;this.treeColumn?(t=this.treeTemp||[],!e&&this.treeTemp||(this.treeTemp=t=this.buildTree(),this.count=t.length,this.tempRows.splice(0,this.tempRows.length))):this.groupColumn?(t=this.groupsTemp||[],!e&&this.groupsTemp||(this.groupsTemp=t=this.buildGroups(),this.count=t.length)):(t=this.rows,e===!0&&this.tempRows.splice(0,this.tempRows.length));var n=0,o=this.getFirstLastIndexes(),i=o.first;for(this.tempRows.splice(0,o.last-o.first);i<o.last&&i<this.count;){var r=t[i];r&&(r.$$index=i,this.tempRows[n]=r),n++,i++}return this.options.internal.styleTranslator.update(this.tempRows),this.tempRows}},{key:"styles",value:function o(){var o={width:this.options.internal.innerWidth+"px"};return this.options.scrollbarV?this.options.scrollbarH===!1&&(o.overflowX="hidden"):o.overflowY="hidden",this.options.scrollbarV&&(o.height=this.options.internal.bodyHeight+"px"),o}},{key:"rowStyles",value:function(e){var t={};return"auto"===this.options.rowHeight&&(t.height=this.options.rowHeight+"px"),t}},{key:"groupRowStyles",value:function(e){var t=this.rowStyles(e);return t.width=this.columnWidths.total+"px",t}},{key:"rowClasses",value:function(e){var t={selected:this.isSelected(e),"dt-row-even":e&&e.$$index%2===0,"dt-row-odd":e&&e.$$index%2!==0};return this.treeColumn&&(t["dt-leaf"]=this.rowsByGroup[e[this.treeColumn.relationProp]],t["dt-has-leafs"]=this.rowsByGroup[e[this.treeColumn.prop]],t["dt-depth-"+e.$$depth]=!0),t}},{key:"getRowValue",value:function(e){return this.tempRows[e]}},{key:"getRowExpanded",value:function(e){return this.treeColumn?this.expanded[e[this.treeColumn.prop]]:this.groupColumn?this.expanded[e.name]:void 0}},{key:"getRowHasChildren",value:function(e){if(this.treeColumn){var t=this.rowsByGroup[e[this.treeColumn.prop]];return void 0!==t||t&&!t.length}}},{key:"onTreeToggled",value:function(e,n){var o=e[this.treeColumn.prop];if(this.expanded[o]=!this.expanded[o],this.options.scrollbarV)this.getRows(!0);else{var i,r=this.buildTree();this.tempRows.splice(0,this.tempRows.length),(i=this.tempRows).push.apply(i,t(r))}this.onTreeToggle({row:e,cell:n})}},{key:"onGroupToggle",value:function(e){if(this.expanded[e.name]=!this.expanded[e.name],this.options.scrollbarV)this.getRows(!0);else{var n,o=this.buildGroups();this.tempRows.splice(0,this.tempRows.length),(n=this.tempRows).push.apply(n,t(o))}}}]),e}(),K=function(){function e(){n(this,e)}return E(e,[{key:"styles",value:function(){return{width:this.column.width+"px",minWidth:this.column.minWidth+"px",maxWidth:this.column.maxWidth+"px",height:this.column.height+"px"}}},{key:"cellClass",value:function(){var e={sortable:this.column.sortable,resizable:this.column.resizable};return this.column.headerClassName&&(e[this.column.headerClassName]=!0),e}},{key:"onSorted",value:function(){this.column.sortable&&(this.column.sort=f(this.sortType,this.column.sort),void 0===this.column.sort&&(this.column.sortPriority=void 0),this.onSort({column:this.column}))}},{key:"sortClass",value:function(){return{"sort-btn":!0,"sort-asc icon-down":"asc"===this.column.sort,"sort-desc icon-up":"desc"===this.column.sort}}},{key:"onResized",value:function(e,t){this.onResize({column:t,width:e})}},{key:"onCheckboxChange",value:function(){this.onCheckboxChanged()}}]),e}(),J=function(){function e(){n(this,e)}return E(e,[{key:"styles",value:function(){return{width:this.options.internal.innerWidth+"px",height:this.options.headerHeight+"px"}}},{key:"innerStyles",value:function(){return{width:this.columnWidths.total+"px"}}},{key:"onSorted",value:function(e){if("single"===this.options.sortType){var t=function(t){t!==e&&(t.sort=void 0)};this.columns.left.forEach(t),this.columns.center.forEach(t),this.columns.right.forEach(t)}this.onSort({column:e})}},{key:"stylesByGroup",value:function(e){var t={width:this.columnWidths[e]+"px"};if("center"===e)a(t,-1*this.options.internal.offsetX,0);else if("right"===e){var n=-1*(this.columnWidths.total-this.options.internal.innerWidth);a(t,n,0)}return t}},{key:"onCheckboxChanged",value:function(){this.onCheckboxChange()}},{key:"onResized",value:function(e,t){this.onResize({column:e,width:t})}}]),e}(),Q={columns:{},dTables:{},saveColumns:function(e,t){if(t&&t.length){var n=[].slice.call(t);this.dTables[e]=n}},buildColumns:function(e,t){var n=this;angular.forEach(this.dTables,function(o,i){n.columns[i]=[],angular.forEach(o,function(o){var r={},l=!0;angular.forEach(o.attributes,function(n){var o=s(n.name);switch(o){case"class":r.className=n.value;break;case"name":case"prop":r[o]=n.value;break;case"headerRenderer":case"cellRenderer":case"cellDataGetter":r[o]=t(n.value);break;case"visible":l=t(n.value)(e);break;default:r[o]=t(n.value)(e)}});var a=o.getElementsByTagName("column-header");a.length&&(r.headerTemplate=a[0].innerHTML,o.removeChild(a[0])),""!==o.innerHTML&&(r.template=o.innerHTML),l&&n.columns[i].push(r)})}),this.dTables={}}},ee={frozenLeft:!1,frozenRight:!1,className:void 0,headerClassName:void 0,flexGrow:0,minWidth:100,maxWidth:void 0,width:150,resizable:!0,comparator:void 0,sortable:!0,sort:void 0,sortBy:void 0,headerRenderer:void 0,cellRenderer:void 0,cellDataGetter:void 0,isTreeColumn:!1,isCheckboxColumn:!1,headerCheckbox:!1,canAutoResize:!0},te={scrollbarV:!0,rowHeight:30,columnMode:"standard",loadingMessage:"Loading...",emptyMessage:"No data to display",headerHeight:30,footerHeight:0,paging:{externalPaging:!1,size:void 0,count:0,offset:0,loadingIndicator:!1},selectable:!1,multiSelect:!1,checkboxSelection:!1,reorderable:!0,internal:{offsetX:0,offsetY:0,innerWidth:0,bodyHeight:300}},ne=function(){function e(t,o,i,r){var s=this;n(this,e),Object.assign(this,{$scope:t,$filter:o,$log:i}),this.defaults(),this.options.$outer=t.$parent,t.$watch("dt.options.columns",function(e,t){s.transposeColumnDefaults(),e.length!==t.length&&s.adjustColumns(),s.calculateColumns()},!0);var l=t.$watch("dt.rows",function(e){e&&(l(),s.onSorted())})}return e.$inject=["$scope","$filter","$log","$transclude"],E(e,[{key:"defaults",value:function(){var e=this;this.expanded=this.expanded||{},this.options=angular.extend(angular.copy(te),this.options),angular.forEach(te.paging,function(t,n){e.options.paging[n]||(e.options.paging[n]=t)}),this.options.selectable&&this.options.multiSelect&&(this.selected=this.selected||[])}},{key:"transposeColumnDefaults",value:function(){for(var e=0,t=this.options.columns.length;t>e;e++){var n=this.options.columns[e];n.$id=x(),angular.forEach(ee,function(e,t){n.hasOwnProperty(t)||(n[t]=e)}),n.name&&!n.prop&&(n.prop=s(n.name)),this.options.columns[e]=n}}},{key:"calculateColumns",value:function(){var e=this.options.columns;this.columnsByPin=$(e),this.columnWidths=z(this.columnsByPin,e)}},{key:"tableCss",value:function(){return{fixed:this.options.scrollbarV,selectable:this.options.selectable,checkboxable:this.options.checkboxSelection}}},{key:"adjustColumns",value:function(e){var t=this.options.internal.innerWidth-this.options.internal.scrollBarWidth;"force"===this.options.columnMode?S(this.options.columns,t,e):"flex"===this.options.columnMode&&P(this.options.columns,t)}},{key:"calculatePageSize",value:function(){this.options.paging.size=Math.ceil(this.options.internal.bodyHeight/this.options.rowHeight)+1}},{key:"onSorted",value:function(){if(this.rows){var e=this.options.columns.filter(function(e){return e.sort}).sort(function(e,t){if(e.sortPriority&&t.sortPriority){if(e.sortPriority>t.sortPriority)return 1;if(e.sortPriority<t.sortPriority)return-1}else{if(e.sortPriority)return-1;if(t.sortPriority)return 1}return 0}).map(function(e,t){return e.sortPriority=t+1,e});if(e.length){this.onSort({sorts:e}),this.options.onSort&&this.options.onSort(e);for(var n=[],o=0,i=e.length;i>o;o++){var r=e[o];if(r.comparator!==!1){var s="asc"===r.sort?"":"-";void 0!==r.sortBy?n.push(s+r.sortBy):n.push(s+r.prop)}}if(n.length){var l,a=this.$filter("orderBy")(this.rows,n);this.rows.splice(0,this.rows.length),(l=this.rows).push.apply(l,t(a))}}this.options.internal.setYOffset(0)}}},{key:"onTreeToggled",value:function(e,t){this.onTreeToggle({row:e,cell:t})}},{key:"onBodyPage",value:function(e,t){this.onPage({offset:e,size:t})}},{key:"onFooterPage",value:function(e,t){var n=this.options.rowHeight*t,o=n*e;this.options.internal.setYOffset(o)}},{key:"onHeaderCheckboxChange",value:function(){if(this.rows){var e=this.selected.length===this.rows.length;if(this.selected.splice(0,this.selected.length),!e){var n;(n=this.selected).push.apply(n,t(this.rows))}}}},{key:"isAllRowsSelected",value:function(){return this.rows?!1:this.selected.length===this.rows.length}},{key:"onResized",value:function(e,t){var n=this.options.columns.indexOf(e);if(n>-1){var e=this.options.columns[n];e.width=t,e.canAutoResize=!1,this.adjustColumns(n),this.calculateColumns()}this.onColumnResize&&this.onColumnResize({column:e,width:t})}},{key:"onSelected",value:function(e){this.onSelect({rows:e})}},{key:"onRowClicked",value:function(e){this.onRowClick({row:e})}},{key:"onRowDblClicked",value:function(e){this.onRowDblClick({row:e})}}]),e}(),oe=angular.module("data-table",[]).directive("dtable",W).directive("resizable",y).directive("sortable",w).directive("dtHeader",v).directive("dtHeaderCell",m).directive("dtBody",g).directive("dtScroller",p).directive("dtSeletion",h).directive("dtRow",u).directive("dtGroupRow",c).directive("dtCell",r).directive("dtFooter",i).directive("dtPager",o);e["default"]=oe});