/*!
 * Angular FileManager v0.9 (https://github.com/joni2back/angular-filemanager)
 * Jonas Sciangula Street <joni2back@gmail.com>
 * Licensed under MIT (https://github.com/joni2back/angular-filemanager/blob/master/LICENSE)
 */
(function(b,a,c){var e=a.module("FileManagerApp",["pascalprecht.translate","ngCookies"]);e.directive("ngFile",["$parse",function(f){return{restrict:"A",link:function(k,j,i){var h=f(i.ngFile);var g=h.assign;j.bind("change",function(){k.$apply(function(){g(k,j[0].files)})})}}}]);e.directive("ngRightClick",["$parse",function(f){return function(j,h,g){var i=f(g.ngRightClick);h.bind("contextmenu",function(k){j.$apply(function(){k.preventDefault();i(j,{$event:k})})})}}]);e.filter("strLimit",["$filter",function(f){return function(h,g){if(h.length<=g){return h}return f("limitTo")(h,g)+"..."}}]);var d=".main-navigation .table-files td a, .iconset a.thumbnail";c(b.document).on("shown.bs.modal",".modal",function(){var f=this;var g=setTimeout(function(){c("[autofocus]",f).focus();g&&clearTimeout(g)},100)});c(b.document).on("click",function(){c("#context-menu").hide()});c(b.document).on("contextmenu",d,function(f){c("#context-menu").hide().css({left:f.pageX,top:f.pageY}).show();f.preventDefault()})})(window,angular,jQuery);(function(a){a.module("FileManagerApp").service("chmod",function(){var b=function(d){this.owner=this.getRwxObj();this.group=this.getRwxObj();this.others=this.getRwxObj();if(d){var c=isNaN(d)?this.convertfromCode(d):this.convertfromOctal(d);if(!c){throw new Error("Invalid input data")}this.owner=c.owner;this.group=c.group;this.others=c.others}};b.prototype.toOctal=function(e,d){var h=["owner","group","others"];var c=[];for(var g in h){var f=h[g];c[g]=this[f].read&&this.octalValues.read||0;c[g]+=this[f].write&&this.octalValues.write||0;c[g]+=this[f].exec&&this.octalValues.exec||0}return(e||"")+c.join("")+(d||"")};b.prototype.toCode=function(e,d){var h=["owner","group","others"];var c=[];for(var g in h){var f=h[g];c[g]=this[f].read&&this.codeValues.read||"-";c[g]+=this[f].write&&this.codeValues.write||"-";c[g]+=this[f].exec&&this.codeValues.exec||"-"}return(e||"")+c.join("")+(d||"")};b.prototype.getRwxObj=function(){return{read:false,write:false,exec:false}};b.prototype.octalValues={read:4,write:2,exec:1};b.prototype.codeValues={read:"r",write:"w",exec:"x"};b.prototype.convertfromCode=function(g){g=(""+g).replace(RegExp("\\s","g"),"");g=g.length===10?g.substr(1):g;if(!RegExp("^[-rwx]{9}$").test(g)){return}var c=[],f=g.match(RegExp(".{1,3}","g"));for(var e in f){var d=this.getRwxObj();d.read=/r/.test(f[e]);d.write=/w/.test(f[e]);d.exec=/x/.test(f[e]);c.push(d)}return{owner:c[0],group:c[1],others:c[2]}};b.prototype.convertfromOctal=function(g){g=(""+g).replace(/\s/g,"");g=g.length===4?g.substr(1):g;if(!RegExp("^[0-7]{3}$").test(g)){return}var c=[],f=g.match(RegExp(".{1}","g"));for(var e in f){var d=this.getRwxObj();d.read=/[4567]/.test(f[e]);d.write=/[2367]/.test(f[e]);d.exec=/[1357]/.test(f[e]);c.push(d)}return{owner:c[0],group:c[1],others:c[2]}};return b})})(angular);(function(a){a.module("FileManagerApp").constant("$config",{appName:"https://github.com/joni2back/angular-filemanager",defaultLang:"en",listUrl:"bridges/php/handler.php",uploadUrl:"bridges/php/handler.php",renameUrl:"bridges/php/handler.php",copyUrl:"bridges/php/handler.php",removeUrl:"bridges/php/handler.php",editUrl:"bridges/php/handler.php",getContentUrl:"bridges/php/handler.php",createFolderUrl:"bridges/php/handler.php",downloadFileUrl:"bridges/php/handler.php",compressUrl:"bridges/php/handler.php",extractUrl:"bridges/php/handler.php",permissionsUrl:"bridges/php/handler.php",enablePermissionsModule:true,enablePermissionsRecursive:true,enableCompressChooseName:false,isEditableFilePattern:"\\.(txt|html|htm|aspx|asp|ini|pl|py|md|php|css|js|log|htaccess|htpasswd|json|sql|xml|xslt|sh|rb|as|bat|cmd|coffee|php[3-6]|java|c|cbl|go|h|scala|vb)$",isImageFilePattern:"\\.(jpg|jpeg|gif|bmp|png|svg|tiff)$",isExtractableFilePattern:"\\.(zip|gz|tar|rar|gzip)$"})})(angular);(function(b,a,c){a.module("FileManagerApp").controller("FileManagerCtrl",["$scope","$translate","$cookies","$config","item","fileNavigator","fileUploader",function(d,i,f,h,e,g,j){d.config=h;d.appName=h.appName;d.orderProp=["model.type","model.name"];d.query="";d.temp=new e();d.fileNavigator=new g();d.fileUploader=j;d.uploadFileList=[];d.viewTemplate=f.viewTemplate||"main-table.html";d.setTemplate=function(k){d.viewTemplate=f.viewTemplate=k};d.changeLanguage=function(k){if(k){return i.use(f.language=k)}i.use(f.language||h.defaultLang)};d.touch=function(k){k=(k&&k.revert&&k)||new e();k.revert&&k.revert();d.temp=k};d.smartRightClick=function(k){d.touch(k)};d.smartClick=function(k){if(k.isFolder()){return d.fileNavigator.folderClick(k)}if(k.isImage()){return k.preview()}if(k.isEditable()){k.getContent();d.touch(k);c("#edit").modal("show");return}};d.edit=function(k){k.edit(function(){c("#edit").modal("hide")})};d.changePermissions=function(k){k.changePermissions(function(){c("#changepermissions").modal("hide")})};d.copy=function(k){var l=k.tempModel.path.join()===k.model.path.join();if(l&&d.fileNavigator.fileNameExists(k.tempModel.name)){k.error=i.instant("error_invalid_filename");return false}k.copy(function(){d.fileNavigator.refresh();c("#copy").modal("hide")})};d.compress=function(k){k.compress(function(){k.success=true;d.fileNavigator.refresh()},function(){k.success=false})};d.extract=function(k){k.extract(function(){k.success=true;d.fileNavigator.refresh()},function(){k.success=false})};d.remove=function(k){k.remove(function(){d.fileNavigator.refresh();c("#delete").modal("hide")})};d.rename=function(k){var l=k.tempModel.path.join()===k.model.path.join();if(l&&d.fileNavigator.fileNameExists(k.tempModel.name)){k.error=i.instant("error_invalid_filename");return false}k.rename(function(){d.fileNavigator.refresh();c("#rename").modal("hide")})};d.createFolder=function(l){var k=l.tempModel.name&&l.tempModel.name.trim();l.tempModel.type="dir";l.tempModel.path=d.fileNavigator.currentPath;if(k&&!d.fileNavigator.fileNameExists(k)){l.createFolder(function(){d.fileNavigator.refresh();c("#newfolder").modal("hide")})}else{d.temp.error=i.instant("error_invalid_filename");return false}};d.uploadFiles=function(){d.fileUploader.upload(d.uploadFileList,d.fileNavigator.currentPath).success(function(){d.fileNavigator.refresh();c("#uploadfile").modal("hide")}).error(function(l){var k=l.result&&l.result.error||i.instant("error_uploading_files");d.temp.error=k})};d.getQueryParam=function(l){var k;b.location.search.substr(1).split("&").forEach(function(m){if(l===m.split("=")[0]){k=m.split("=")[1]}});return k};d.changeLanguage(d.getQueryParam("lang"));d.isWindows=d.getQueryParam("server")==="Windows";d.fileNavigator.refresh()}])})(window,angular,jQuery);(function(a){a.module("FileManagerApp").service("fileNavigator",["$http","$config","item",function(e,d,b){e.defaults.headers.common["X-Requested-With"]="XMLHttpRequest";var c=function(){this.requesting=false;this.fileList=[];this.currentPath=[];this.history=[];this.error=""};c.prototype.refresh=function(j,g){var f=this;var i=f.currentPath.join("/");var h={params:{mode:"list",onlyFolders:false,path:"/"+i}};f.requesting=true;f.fileList=[];f.error="";e.post(d.listUrl,h).success(function(k){f.fileList=[];a.forEach(k.result,function(l){f.fileList.push(new b(l,f.currentPath))});f.requesting=false;f.buildTree(i);if(k.error){f.error=k.error;return typeof g==="function"&&g(k)}typeof j==="function"&&j(k)}).error(function(k){f.requesting=false;typeof g==="function"&&g(k)})};c.prototype.buildTree=function(i){var f=this;var g=function(m,l,o){var p=o?(o+"/"+l.name):l.name;if(m.name.trim()&&o.trim().indexOf(m.name)!==0){m.nodes=[]}if(m.name!==o){for(var k in m.nodes){g(m.nodes[k],l,o)}}else{for(var n in m.nodes){if(m.nodes[n].name===p){return}}m.nodes.push({name:p,nodes:[]})}};!f.history.length&&f.history.push({name:i,nodes:[]});for(var j in f.fileList){var h=f.fileList[j].model;h.type==="dir"&&g(f.history[0],h,i)}};c.prototype.folderClickByName=function(g){var f=this;g=g.replace(RegExp("^/*","g"),"").split("/");f.currentPath=g&&g[0]===""?[]:g;f.refresh()};c.prototype.folderClick=function(g){var f=this;if(g&&g.model.type==="dir"){f.currentPath.push(g.model.name);f.refresh()}};c.prototype.upDir=function(){var f=this;if(f.currentPath[0]){f.currentPath=f.currentPath.slice(0,-1);f.refresh()}};c.prototype.goTo=function(g){var f=this;f.currentPath=f.currentPath.slice(0,g+1);f.refresh()};c.prototype.fileNameExists=function(h){var f=this;for(var g in f.fileList){g=f.fileList[g];if(h.trim&&g.model.name.trim()===h.trim()){return true}}};c.prototype.listHasFolders=function(){var f=this;for(var g in f.fileList){if(f.fileList[g].model.type==="dir"){return true}}};return c}])})(angular);(function(b,a){a.module("FileManagerApp").service("fileUploader",["$http","$config",function(e,d){var c=this;c.requesting=false;c.upload=function(g,k,l,f){var j=new b.FormData();j.append("destination","/"+k.join("/"));for(var h in g){var i=g[h];typeof i==="object"&&j.append("file-"+(1+parseInt(h,null)),i)}c.requesting=true;return e.post(d.uploadUrl,j,{transformRequest:a.identity,headers:{"Content-Type":undefined}}).success(function(m){c.requesting=false;typeof l==="function"&&l(m)}).error(function(m){c.requesting=false;typeof f==="function"&&f(m)})}}])})(window,angular);(function(b,a,c){a.module("FileManagerApp").factory("item",["$http","$translate","$config","chmod",function(h,g,f,e){var d=function(j,l){var i={name:j&&j.name||"",path:l||[],type:j&&j.type||"file",size:j&&j.size||0,date:k(j&&j.date),perms:new e(j&&j.rights),content:j&&j.content||"",recursive:false,sizeKb:function(){return Math.round(this.size/1024,1)},fullPath:function(){return("/"+this.path.join("/")+"/"+this.name).replace(RegExp("//"),"/")}};this.error="";this.inprocess=false;this.model=a.copy(i);this.tempModel=a.copy(i);function k(m){var n=(m||"").toString().split(/[- :]/);return new Date(n[0],n[1]-1,n[2],n[3],n[4],n[5])}};d.prototype.update=function(){a.extend(this.model,a.copy(this.tempModel));return this};d.prototype.revert=function(){a.extend(this.tempModel,a.copy(this.model));this.error="";return this};d.prototype.defineCallback=function(k,l,j){var i=this;if(k.result&&k.result.error){i.error=k.result.error;return typeof j==="function"&&j(k)}if(k.error){i.error=k.error.message;return typeof j==="function"&&j(k)}i.update();return typeof l==="function"&&l(k)};d.prototype.createFolder=function(l,j){var i=this;var k={params:{mode:"addfolder",path:i.tempModel.path.join("/"),name:i.tempModel.name}};if(i.tempModel.name.trim()){i.inprocess=true;i.error="";return h.post(f.createFolderUrl,k).success(function(m){i.defineCallback(m,l,j)}).error(function(m){i.error=m.result&&m.result.error?m.result.error:g.instant("error_creating_folder");typeof j==="function"&&j(m)})["finally"](function(){i.inprocess=false})}};d.prototype.rename=function(l,j){var i=this;var k={params:{mode:"rename",path:i.model.fullPath(),newPath:i.tempModel.fullPath()}};if(i.tempModel.name.trim()){i.inprocess=true;i.error="";return h.post(f.renameUrl,k).success(function(m){i.defineCallback(m,l,j)}).error(function(m){i.error=m.result&&m.result.error?m.result.error:g.instant("error_renaming");typeof j==="function"&&j(m)})["finally"](function(){i.inprocess=false})}};d.prototype.copy=function(l,j){var i=this;var k={params:{mode:"copy",path:i.model.fullPath(),newPath:i.tempModel.fullPath()}};if(i.tempModel.name.trim()){i.inprocess=true;i.error="";return h.post(f.copyUrl,k).success(function(m){i.defineCallback(m,l,j)}).error(function(m){i.error=m.result&&m.result.error?m.result.error:g.instant("error_copying");typeof j==="function"&&j(m)})["finally"](function(){i.inprocess=false})}};d.prototype.compress=function(l,j){var i=this;var k={params:{mode:"compress",path:i.model.fullPath(),destination:i.tempModel.fullPath()}};if(i.tempModel.name.trim()){i.inprocess=true;i.error="";return h.post(f.compressUrl,k).success(function(m){i.defineCallback(m,l,j)}).error(function(m){i.error=m.result&&m.result.error?m.result.error:g.instant("error_compressing");typeof j==="function"&&j(m)})["finally"](function(){i.inprocess=false})}};d.prototype.extract=function(l,j){var i=this;var k={params:{mode:"extract",path:i.model.fullPath(),sourceFile:i.model.fullPath(),destination:i.tempModel.fullPath()}};i.inprocess=true;i.error="";return h.post(f.extractUrl,k).success(function(m){i.defineCallback(m,l,j)}).error(function(m){i.error=m.result&&m.result.error?m.result.error:g.instant("error_extracting");typeof j==="function"&&j(m)})["finally"](function(){i.inprocess=false})};d.prototype.download=function(l){var i=this;var k={mode:"download",preview:l,path:i.model.fullPath()};var j=[f.downloadFileUrl,c.param(k)].join("?");if(i.model.type!=="dir"){b.open(j,"_blank","")}};d.prototype.preview=function(){var i=this;return i.download(true)};d.prototype.getContent=function(l,j){var i=this;var k={params:{mode:"editfile",path:i.tempModel.fullPath()}};i.inprocess=true;i.error="";return h.post(f.getContentUrl,k).success(function(m){i.tempModel.content=i.model.content=m.result;i.defineCallback(m,l,j)}).error(function(m){i.error=m.result&&m.result.error?m.result.error:g.instant("error_getting_content");typeof j==="function"&&j(m)})["finally"](function(){i.inprocess=false})};d.prototype.remove=function(l,j){var i=this;var k={params:{mode:"delete",path:i.tempModel.fullPath()}};i.inprocess=true;i.error="";return h.post(f.removeUrl,k).success(function(m){i.defineCallback(m,l,j)}).error(function(m){i.error=m.result&&m.result.error?m.result.error:g.instant("error_deleting");typeof j==="function"&&j(m)})["finally"](function(){i.inprocess=false})};d.prototype.edit=function(l,j){var i=this;var k={params:{mode:"savefile",content:i.tempModel.content,path:i.tempModel.fullPath()}};i.inprocess=true;i.error="";return h.post(f.editUrl,k).success(function(m){i.defineCallback(m,l,j)}).error(function(m){i.error=m.result&&m.result.error?m.result.error:g.instant("error_modifying");typeof j==="function"&&j(m)})["finally"](function(){i.inprocess=false})};d.prototype.changePermissions=function(l,j){var i=this;var k={params:{mode:"changepermissions",path:i.tempModel.fullPath(),perms:i.tempModel.perms.toOctal(),permsCode:i.tempModel.perms.toCode(),recursive:i.tempModel.recursive}};i.inprocess=true;i.error="";return h.post(f.permissionsUrl,k).success(function(m){i.defineCallback(m,l,j)}).error(function(m){i.error=m.result&&m.result.error?m.result.error:g.instant("error_changing_perms");typeof j==="function"&&j(m)})["finally"](function(){i.inprocess=false})};d.prototype.isFolder=function(){return this.model.type==="dir"};d.prototype.isEditable=function(){return !this.isFolder()&&RegExp(f.isEditableFilePattern).test(this.model.name.toLowerCase())};d.prototype.isImage=function(){return RegExp(f.isImageFilePattern).test(this.model.name.toLowerCase())};d.prototype.isCompressible=function(){return this.isFolder()};d.prototype.isExtractable=function(){return !this.isFolder()&&RegExp(f.isExtractableFilePattern).test(this.model.name)};return d}])})(window,angular,jQuery);(function(a,b){a.module("FileManagerApp").controller("ModalFileManagerCtrl",["$scope","$rootScope","$config","fileNavigator",function(d,c,f,e){d.appName=f.appName;d.orderProp=["model.type","model.name"];d.fileNavigator=new e();c.select=function(h,g){g.tempModel.path=h.model.fullPath().split("/");b("#selector").modal("hide")};c.openNavigator=function(g){d.fileNavigator.currentPath=g.model.path.slice();d.fileNavigator.refresh();b("#selector").modal("show")}}])})(angular,jQuery);(function(a){a.module("FileManagerApp").config(["$translateProvider",function(b){b.translations("en",{filemanager:"File Manager",language:"Language",english:"English",spanish:"Spanish",portuguese:"Portuguese",confirm:"Confirm",cancel:"Cancel",close:"Close",upload_file:"Upload file",files_will_uploaded_to:"Files will be uploaded to",uploading:"Uploading",permissions:"Permissions",select_destination_folder:"Select the destination folder",source:"Source",destination:"Destination",copy_file:"Copy file",sure_to_delete:"Are you sure to delete",change_name_move:"Change name / move",enter_new_name_for:"Enter new name for",extract_item:"Extract item",extraction_started:"Extraction started in a background process",compression_started:"Compression started in a background process",enter_folder_name_for_extraction:"Enter the folder name for the extraction of",enter_folder_name_for_compression:"Enter the folder name for the compression of",toggle_fullscreen:"Toggle fullscreen",edit_file:"Edit file",file_content:"File content",loading:"Loading",search:"Search",create_folder:"Create folder",create:"Create",folder_name:"Folder name",upload:"Upload",change_permissions:"Change permissions",change:"Change",details:"Details",icons:"Icons",list:"List",name:"Name",size:"Size",actions:"Actions",date:"Date",no_files_in_folder:"No files in this folder",no_folders_in_folder:"This folder not contains children folders",select_this:"Select this",go_back:"Go back",wait:"Wait",move:"Move",download:"Download",view_item:"View item",remove:"Delete",edit:"Edit",copy:"Copy",rename:"Rename",extract:"Extract",compress:"Compress",error_invalid_filename:"Invalid filename or already exists, specify another name",error_modifying:"An error occurred modifying the file",error_deleting:"An error occurred deleting the file or folder",error_renaming:"An error occurred renaming the file",error_copying:"An error occurred copying the file",error_compressing:"An error occurred compressing the file or folder",error_extracting:"An error occurred extracting the file",error_creating_folder:"An error occurred creating the folder",error_getting_content:"An error occurred getting the content of the file",error_changing_perms:"An error occurred changing the permissions of the file",error_uploading_files:"An error occurred uploading files",sure_to_start_compression_with:"Are you sure to compress",owner:"Owner",group:"Group",others:"Others",read:"Read",write:"Write",exec:"Exec",original:"Original",changes:"Changes",recursive:"Recursive"});b.translations("pt",{filemanager:"Gerenciador de arquivos",language:"Língua",english:"Inglês",spanish:"Espanhol",portuguese:"Portugues",confirm:"Confirmar",cancel:"Cancelar",close:"Desligar",upload_file:"Carregar arquivo",files_will_uploaded_to:"Os arquivos serão enviados para",uploading:"Carregar",permissions:"Autorizações",select_destination_folder:"Selecione a pasta de destino",source:"Origem",destination:"Destino",copy_file:"Copiar arquivo",sure_to_delete:"Tem certeza de que deseja apagar",change_name_move:"Rebatizar / mudança",enter_new_name_for:"Digite o novo nome para",extract_item:"Extrair arquivo",extraction_started:"A extração começou em um processo em segundo plano",compression_started:"A compressão começou em um processo em segundo plano",enter_folder_name_for_extraction:"Digite o nome da pasta para a extração de",enter_folder_name_for_compression:"Digite o nome da pasta para Compressão",toggle_fullscreen:"Ativar/desativar tela cheia",edit_file:"Editar arquivo",file_content:"Conteúdo do arquivo",loading:"Carregando",search:"Localizar",create_folder:"Criar Pasta",create:"Criar",folder_name:"Nome da pasta",upload:"Fazer",change_permissions:"Alterar permissões",change:"Alterar",details:"Detalhes",icons:"Icones",list:"Lista",name:"Nome",size:"Tamanho",actions:"Ações",date:"Data",no_files_in_folder:"Não há arquivos nesta pasta",no_folders_in_folder:"Esta pasta no contém subpastas",select_this:"Selecione esta",go_back:"Voltar",wait:"Aguente",move:"Mudar",download:"Baixar",view_item:"Veja o arquivo",remove:"Tirar",edit:"Editar",copy:"Copiar",rename:"Rebatizar",extract:"Extrair",compress:"Comprimir",error_invalid_filename:"Invalid ou nome de arquivo já existe, especifique outro nome",error_modifying:"Ocorreu um erro ao modificar o arquivo",error_deleting:"Ocorreu um erro ao excluir o arquivo ou pasta",error_renaming:"Ocorreu um erro ao mudar o nome do arquivo",error_copying:"Ocorreu um erro ao copiar o arquivo",error_compressing:"Ocorreu um erro ao comprimir o arquivo ou pasta",error_extracting:"Ocorreu um erro ao extrair o arquivo",error_creating_folder:"Ocorreu um erro ao criar a pasta",error_getting_content:"Ocorreu um erro ao obter o conteúdo do arquivo",error_changing_perms:"Ocorreu um erro ao alterar as permissões do arquivo",error_uploading_files:"Ocorreu um erro upload de arquivos",sure_to_start_compression_with:"Tem certeza que deseja comprimir",owner:"Proprietário",group:"Grupo",others:"Outros",read:"Leitura",write:"Gravável",exec:"Execução",original:"Original",changes:"Mudanças",recursive:"Recursiva"});b.translations("es",{filemanager:"Administrador de archivos",language:"Idioma",english:"Ingles",spanish:"Español",portuguese:"Portugues",confirm:"Confirmar",cancel:"Cancelar",close:"Cerrar",upload_file:"Subir archivo",files_will_uploaded_to:"Los archivos seran subidos a",uploading:"Subiendo",permissions:"Permisos",select_destination_folder:"Seleccione la carpeta de destino",source:"Origen",destination:"Destino",copy_file:"Copiar archivo",sure_to_delete:"Esta seguro que desea eliminar",change_name_move:"Renombrar / mover",enter_new_name_for:"Ingrese el nuevo nombre para",extract_item:"Extraer archivo",extraction_started:"La extraccion ha comenzado en un proceso de segundo plano",compression_started:"La compresion ha comenzado en un proceso de segundo plano",enter_folder_name_for_extraction:"Ingrese el nombre de la carpeta para la extraccion de",enter_folder_name_for_compression:"Ingrese el nombre de la carpeta para la compresion de",toggle_fullscreen:"Activar/Desactivar pantalla completa",edit_file:"Editar archivo",file_content:"Contenido del archivo",loading:"Cargando",search:"Buscar",create_folder:"Crear carpeta",create:"Crear",folder_name:"Nombre de la carpeta",upload:"Subir",change_permissions:"Cambiar permisos",change:"Cambiar",details:"Detalles",icons:"Iconos",list:"Lista",name:"Nombre",size:"Tamaño",actions:"Acciones",date:"Fecha",no_files_in_folder:"No hay archivos en esta carpeta",no_folders_in_folder:"Esta carpeta no contiene sub-carpetas",select_this:"Seleccionar esta",go_back:"Volver",wait:"Espere",move:"Mover",download:"Descargar",view_item:"Ver archivo",remove:"Eliminar",edit:"Editar",copy:"Copiar",rename:"Renombrar",extract:"Extraer",compress:"Comprimir",error_invalid_filename:"El nombre del archivo es invalido o ya existe",error_modifying:"Ocurrio un error al intentar modificar el archivo",error_deleting:"Ocurrio un error al intentar eliminar el archivo",error_renaming:"Ocurrio un error al intentar renombrar el archivo",error_copying:"Ocurrio un error al intentar copiar el archivo",error_compressing:"Ocurrio un error al intentar comprimir el archivo",error_extracting:"Ocurrio un error al intentar extraer el archivo",error_creating_folder:"Ocurrio un error al intentar crear la carpeta",error_getting_content:"Ocurrio un error al obtener el contenido del archivo",error_changing_perms:"Ocurrio un error al cambiar los permisos del archivo",error_uploading_files:"Ocurrio un error al subir archivos",sure_to_start_compression_with:"Esta seguro que desea comprimir",owner:"Propietario",group:"Grupo",others:"Otros",read:"Lectura",write:"Escritura",exec:"Ejecucion",original:"Original",changes:"Cambios",recursive:"Recursivo"})}])})(angular);