(function(angular) {
    "use strict";
    angular.module('FileManagerApp').config(['$translateProvider', function($translateProvider) {
        $translateProvider.translations('en', {
            filemanager: "File Manager",
            language: "Language",
            english: "English",
            spanish: "Spanish",
            portuguese: "Portuguese",
            confirm: "Confirm",
            cancel: "Cancel",
            close: "Close",
            upload_file: "Upload file",
            files_will_uploaded_to: "Files will be uploaded to",
            uploading: "Uploading",
            permissions: "Permissions",
            select_destination_folder: "Select the destination folder",
            source: "Source",
            destination: "Destination",
            copy_file: "Copy file",
            sure_to_delete: "Are you sure to delete",
            change_name_move: "Change name / move",
            enter_new_name_for: "Enter new name for",
            extract_item: "Extract item",
            extraction_started: "Extraction started in a background process",
            compression_started: "Compression started in a background process",
            enter_folder_name_for_extraction: "Enter the folder name for the extraction of",
            enter_folder_name_for_compression: "Enter the folder name for the compression of",
            toggle_fullscreen: "Toggle fullscreen",
            edit_file: "Edit file",
            file_content: "File content",
            loading: "Loading",
            search: "Search",
            create_folder: "Create folder",
            create: "Create",
            folder_name: "Folder name",
            upload: "Upload",
            change_permissions: "Change permissions",
            change: "Change",
            details: "Details",
            icons: "Icons",
            list: "List",
            name: "Name",
            size: "Size",
            actions: "Actions",
            date: "Date",
            no_files_in_folder: "No files in this folder",
            no_folders_in_folder: "This folder not contains children folders",
            select_this: "Select this",
            go_back: "Go back",
            wait: "Wait",
            move: "Move",
            download: "Download",
            view_item: "View item",
            remove: "Delete",
            edit: "Edit",
            copy: "Copy",
            rename: "Rename",
            extract: "Extract",
            compress: "Compress",
            error_invalid_filename: "Invalid filename or already exists, specify another name",
            error_modifying: "An error occurred modifying the file",
            error_deleting: "An error occurred deleting the file or folder",
            error_renaming: "An error occurred renaming the file",
            error_copying: "An error occurred copying the file",
            error_compressing: "An error occurred compressing the file or folder",
            error_extracting: "An error occurred extracting the file",
            error_creating_folder: "An error occurred creating the folder",
            error_getting_content: "An error occurred getting the content of the file",
            error_changing_perms: "An error occurred changing the permissions of the file",
            error_uploading_files: "An error occurred uploading files",
            sure_to_start_compression_with: "Are you sure to compress",
            owner: "Owner",
            group: "Group",
            others: "Others",
            read: "Read",
            write: "Write",
            exec: "Exec",
            original: "Original",
            changes: "Changes",
            recursive: "Recursive"
        });

        $translateProvider.translations('pt', {
            filemanager: "Gerenciador de arquivos",
            language: "Língua",
            english: "Inglês",
            spanish: "Espanhol",
            portuguese: "Portugues",
            confirm: "Confirmar",
            cancel: "Cancelar",
            close: "Desligar",
            upload_file: "Carregar arquivo",
            files_will_uploaded_to: "Os arquivos serão enviados para",
            uploading: "Carregar",
            permissions: "Autorizações",
            select_destination_folder: "Selecione a pasta de destino",
            source: "Origem",
            destination: "Destino",
            copy_file: "Copiar arquivo",
            sure_to_delete: "Tem certeza de que deseja apagar",
            change_name_move: "Rebatizar / mudança",
            enter_new_name_for: "Digite o novo nome para",
            extract_item: "Extrair arquivo",
            extraction_started: "A extração começou em um processo em segundo plano",
            compression_started: "A compressão começou em um processo em segundo plano",
            enter_folder_name_for_extraction: "Digite o nome da pasta para a extração de",
            enter_folder_name_for_compression: "Digite o nome da pasta para Compressão",
            toggle_fullscreen: "Ativar/desativar tela cheia",
            edit_file: "Editar arquivo",
            file_content: "Conteúdo do arquivo",
            loading: "Carregando",
            search: "Localizar",
            create_folder: "Criar Pasta",
            create: "Criar",
            folder_name: "Nome da pasta",
            upload: "Fazer",
            change_permissions: "Alterar permissões",
            change: "Alterar",
            details: "Detalhes",
            icons: "Icones",
            list: "Lista",
            name: "Nome",
            size: "Tamanho",
            actions: "Ações",
            date: "Data",
            no_files_in_folder: "Não há arquivos nesta pasta",
            no_folders_in_folder: "Esta pasta no contém subpastas",
            select_this: "Selecione esta",
            go_back: "Voltar",
            wait: "Aguente",
            move: "Mudar",
            download: "Baixar",
            view_item: "Veja o arquivo",
            remove: "Tirar",
            edit: "Editar",
            copy: "Copiar",
            rename: "Rebatizar",
            extract: "Extrair",
            compress: "Comprimir",
            error_invalid_filename: "Invalid ou nome de arquivo já existe, especifique outro nome",
            error_modifying: "Ocorreu um erro ao modificar o arquivo",
            error_deleting: "Ocorreu um erro ao excluir o arquivo ou pasta",
            error_renaming: "Ocorreu um erro ao mudar o nome do arquivo",
            error_copying: "Ocorreu um erro ao copiar o arquivo",
            error_compressing: "Ocorreu um erro ao comprimir o arquivo ou pasta",
            error_extracting: "Ocorreu um erro ao extrair o arquivo",
            error_creating_folder: "Ocorreu um erro ao criar a pasta",
            error_getting_content: "Ocorreu um erro ao obter o conteúdo do arquivo",
            error_changing_perms: "Ocorreu um erro ao alterar as permissões do arquivo",
            error_uploading_files: "Ocorreu um erro upload de arquivos",
            sure_to_start_compression_with: "Tem certeza que deseja comprimir",
            owner: "Proprietário",
            group: "Grupo",
            others: "Outros",
            read: "Leitura",
            write: "Gravável",
            exec: "Execução",
            original: "Original",
            changes: "Mudanças",
            recursive: "Recursiva"
        });

        $translateProvider.translations('es', {
            filemanager: "Administrador de archivos",
            language: "Idioma",
            english: "Ingles",
            spanish: "Español",
            portuguese: "Portugues",
            confirm: "Confirmar",
            cancel: "Cancelar",
            close: "Cerrar",
            upload_file: "Subir archivo",
            files_will_uploaded_to: "Los archivos seran subidos a",
            uploading: "Subiendo",
            permissions: "Permisos",
            select_destination_folder: "Seleccione la carpeta de destino",
            source: "Origen",
            destination: "Destino",
            copy_file: "Copiar archivo",
            sure_to_delete: "Esta seguro que desea eliminar",
            change_name_move: "Renombrar / mover",
            enter_new_name_for: "Ingrese el nuevo nombre para",
            extract_item: "Extraer archivo",
            extraction_started: "La extraccion ha comenzado en un proceso de segundo plano",
            compression_started: "La compresion ha comenzado en un proceso de segundo plano",
            enter_folder_name_for_extraction: "Ingrese el nombre de la carpeta para la extraccion de",
            enter_folder_name_for_compression: "Ingrese el nombre de la carpeta para la compresion de",
            toggle_fullscreen: "Activar/Desactivar pantalla completa",
            edit_file: "Editar archivo",
            file_content: "Contenido del archivo",
            loading: "Cargando",
            search: "Buscar",
            create_folder: "Crear carpeta",
            create: "Crear",
            folder_name: "Nombre de la carpeta",
            upload: "Subir",
            change_permissions: "Cambiar permisos",
            change: "Cambiar",
            details: "Detalles",
            icons: "Iconos",
            list: "Lista",
            name: "Nombre",
            size: "Tamaño",
            actions: "Acciones",
            date: "Fecha",
            no_files_in_folder: "No hay archivos en esta carpeta",
            no_folders_in_folder: "Esta carpeta no contiene sub-carpetas",
            select_this: "Seleccionar esta",
            go_back: "Volver",
            wait: "Espere",
            move: "Mover",
            download: "Descargar",
            view_item: "Ver archivo",
            remove: "Eliminar",
            edit: "Editar",
            copy: "Copiar",
            rename: "Renombrar",
            extract: "Extraer",
            compress: "Comprimir",
            error_invalid_filename: "El nombre del archivo es invalido o ya existe",
            error_modifying: "Ocurrio un error al intentar modificar el archivo",
            error_deleting: "Ocurrio un error al intentar eliminar el archivo",
            error_renaming: "Ocurrio un error al intentar renombrar el archivo",
            error_copying: "Ocurrio un error al intentar copiar el archivo",
            error_compressing: "Ocurrio un error al intentar comprimir el archivo",
            error_extracting: "Ocurrio un error al intentar extraer el archivo",
            error_creating_folder: "Ocurrio un error al intentar crear la carpeta",
            error_getting_content: "Ocurrio un error al obtener el contenido del archivo",
            error_changing_perms: "Ocurrio un error al cambiar los permisos del archivo",
            error_uploading_files: "Ocurrio un error al subir archivos",
            sure_to_start_compression_with: "Esta seguro que desea comprimir",
            owner: "Propietario",
            group: "Grupo",
            others: "Otros",
            read: "Lectura",
            write: "Escritura",
            exec: "Ejecucion",
            original: "Original",
            changes: "Cambios",
            recursive: "Recursivo"
        });
    }]);
})(angular);