!function(e,r,o){"use strict";var t=r.module("FileManagerApp",["pascalprecht.translate","ngCookies"]);t.directive("angularFileManager",["$parse",function(e){return{restrict:"EA",templateUrl:"assets/templates/index.html"}}]),t.directive("ngFile",["$parse",function(e){return{restrict:"A",link:function(r,o,t){var n=e(t.ngFile),i=n.assign;o.bind("change",function(){r.$apply(function(){i(r,o[0].files)})})}}}]),t.directive("ngRightClick",["$parse",function(e){return function(r,o,t){var n=e(t.ngRightClick);o.bind("contextmenu",function(e){r.$apply(function(){e.preventDefault(),n(r,{$event:e})})})}}]),t.filter("strLimit",["$filter",function(e){return function(r,o){return r.length<=o?r:e("limitTo")(r,o)+"..."}}]);var n=".main-navigation .table-files td a, .iconset a.thumbnail";o(e.document).on("shown.bs.modal",".modal",function(){var e=this,r=setTimeout(function(){o("[autofocus]",e).focus(),r&&clearTimeout(r)},100)}),o(e.document).on("click",function(){o("#context-menu").hide()}),o(e.document).on("contextmenu",n,function(e){o("#context-menu").hide().css({left:e.pageX,top:e.pageY}).show(),e.preventDefault()})}(window,angular,jQuery),function(e){"use strict";e.module("FileManagerApp").constant("fileManagerConfig",{appName:"https://github.com/joni2back/angular-filemanager",defaultLang:"en",listUrl:"bridges/php/handler.php",uploadUrl:"bridges/php/handler.php",renameUrl:"bridges/php/handler.php",copyUrl:"bridges/php/handler.php",removeUrl:"bridges/php/handler.php",editUrl:"bridges/php/handler.php",getContentUrl:"bridges/php/handler.php",createFolderUrl:"bridges/php/handler.php",downloadFileUrl:"bridges/php/handler.php",compressUrl:"bridges/php/handler.php",extractUrl:"bridges/php/handler.php",permissionsUrl:"bridges/php/handler.php",allowedActions:{rename:!0,copy:!0,edit:!0,changePermissions:!0,compress:!0,compressChooseName:!0,extract:!0,download:!0,preview:!0,remove:!0},enablePermissionsRecursive:!0,isEditableFilePattern:"\\.(txt|html|htm|aspx|asp|ini|pl|py|md|php|css|js|log|htaccess|htpasswd|json|sql|xml|xslt|sh|rb|as|bat|cmd|coffee|php[3-6]|java|c|cbl|go|h|scala|vb)$",isImageFilePattern:"\\.(jpg|jpeg|gif|bmp|png|svg|tiff)$",isExtractableFilePattern:"\\.(zip|gz|tar|rar|gzip)$"})}(angular),function(e){"use strict";e.module("FileManagerApp").service("chmod",function(){var e=function(e){if(this.owner=this.getRwxObj(),this.group=this.getRwxObj(),this.others=this.getRwxObj(),e){var r=isNaN(e)?this.convertfromCode(e):this.convertfromOctal(e);if(!r)throw new Error("Invalid input data");this.owner=r.owner,this.group=r.group,this.others=r.others}};return e.prototype.toOctal=function(e,r){var o=["owner","group","others"],t=[];for(var n in o){var i=o[n];t[n]=this[i].read&&this.octalValues.read||0,t[n]+=this[i].write&&this.octalValues.write||0,t[n]+=this[i].exec&&this.octalValues.exec||0}return(e||"")+t.join("")+(r||"")},e.prototype.toCode=function(e,r){var o=["owner","group","others"],t=[];for(var n in o){var i=o[n];t[n]=this[i].read&&this.codeValues.read||"-",t[n]+=this[i].write&&this.codeValues.write||"-",t[n]+=this[i].exec&&this.codeValues.exec||"-"}return(e||"")+t.join("")+(r||"")},e.prototype.getRwxObj=function(){return{read:!1,write:!1,exec:!1}},e.prototype.octalValues={read:4,write:2,exec:1},e.prototype.codeValues={read:"r",write:"w",exec:"x"},e.prototype.convertfromCode=function(e){if(e=(""+e).replace(RegExp("\\s","g"),""),e=10===e.length?e.substr(1):e,RegExp("^[-rwx]{9}$").test(e)){var r=[],o=e.match(RegExp(".{1,3}","g"));for(var t in o){var n=this.getRwxObj();n.read=/r/.test(o[t]),n.write=/w/.test(o[t]),n.exec=/x/.test(o[t]),r.push(n)}return{owner:r[0],group:r[1],others:r[2]}}},e.prototype.convertfromOctal=function(e){if(e=(""+e).replace(/\s/g,""),e=4===e.length?e.substr(1):e,RegExp("^[0-7]{3}$").test(e)){var r=[],o=e.match(RegExp(".{1}","g"));for(var t in o){var n=this.getRwxObj();n.read=/[4567]/.test(o[t]),n.write=/[2367]/.test(o[t]),n.exec=/[1357]/.test(o[t]),r.push(n)}return{owner:r[0],group:r[1],others:r[2]}}},e})}(angular),function(e,r,o){"use strict";r.module("FileManagerApp").controller("FileManagerCtrl",["$scope","$translate","$cookies","fileManagerConfig","item","fileNavigator","fileUploader",function(r,t,n,i,a,s,l){r.config=i,r.appName=i.appName,r.orderProp=["model.type","model.name"],r.query="",r.temp=new a,r.fileNavigator=new s,r.fileUploader=l,r.uploadFileList=[],r.viewTemplate=n.viewTemplate||"main-table.html",r.setTemplate=function(e){r.viewTemplate=n.viewTemplate=e},r.changeLanguage=function(e){return e?t.use(n.language=e):void t.use(n.language||i.defaultLang)},r.touch=function(e){e=e&&e.revert&&e||new a,e.revert&&e.revert(),r.temp=e},r.smartRightClick=function(e){r.touch(e)},r.smartClick=function(e){return e.isFolder()?r.fileNavigator.folderClick(e):e.isImage()?e.preview():e.isEditable()?(e.getContent(),r.touch(e),void o("#edit").modal("show")):void 0},r.edit=function(e){e.edit(function(){o("#edit").modal("hide")})},r.changePermissions=function(e){e.changePermissions(function(){o("#changepermissions").modal("hide")})},r.copy=function(e){var n=e.tempModel.path.join()===e.model.path.join();return n&&r.fileNavigator.fileNameExists(e.tempModel.name)?(e.error=t.instant("error_invalid_filename"),!1):void e.copy(function(){r.fileNavigator.refresh(),o("#copy").modal("hide")})},r.compress=function(e){e.compress(function(){e.success=!0,r.fileNavigator.refresh()},function(){e.success=!1})},r.extract=function(e){e.extract(function(){e.success=!0,r.fileNavigator.refresh()},function(){e.success=!1})},r.remove=function(e){e.remove(function(){r.fileNavigator.refresh(),o("#delete").modal("hide")})},r.rename=function(e){var n=e.tempModel.path.join()===e.model.path.join();return n&&r.fileNavigator.fileNameExists(e.tempModel.name)?(e.error=t.instant("error_invalid_filename"),!1):void e.rename(function(){r.fileNavigator.refresh(),o("#rename").modal("hide")})},r.createFolder=function(e){var n=e.tempModel.name&&e.tempModel.name.trim();return e.tempModel.type="dir",e.tempModel.path=r.fileNavigator.currentPath,!n||r.fileNavigator.fileNameExists(n)?(r.temp.error=t.instant("error_invalid_filename"),!1):void e.createFolder(function(){r.fileNavigator.refresh(),o("#newfolder").modal("hide")})},r.uploadFiles=function(){r.fileUploader.upload(r.uploadFileList,r.fileNavigator.currentPath).success(function(){r.fileNavigator.refresh(),o("#uploadfile").modal("hide")}).error(function(e){var o=e.result&&e.result.error||t.instant("error_uploading_files");r.temp.error=o})},r.getQueryParam=function(r){var o;return e.location.search.substr(1).split("&").forEach(function(e){r===e.split("=")[0]&&(o=e.split("=")[1])}),o},r.changeLanguage(r.getQueryParam("lang")),r.isWindows="Windows"===r.getQueryParam("server"),r.fileNavigator.refresh()}])}(window,angular,jQuery),function(e){"use strict";e.module("FileManagerApp").service("fileNavigator",["$http","fileManagerConfig","item",function(r,o,t){r.defaults.headers.common["X-Requested-With"]="XMLHttpRequest";var n=function(){this.requesting=!1,this.fileList=[],this.currentPath=[],this.history=[],this.error=""};return n.prototype.refresh=function(n,i){var a=this,s=a.currentPath.join("/"),l={params:{mode:"list",onlyFolders:!1,path:"/"+s}};a.requesting=!0,a.fileList=[],a.error="",r.post(o.listUrl,l).success(function(r){return a.fileList=[],e.forEach(r.result,function(e){a.fileList.push(new t(e,a.currentPath))}),a.requesting=!1,a.buildTree(s),r.error?(a.error=r.error,"function"==typeof i&&i(r)):void("function"==typeof n&&n(r))}).error(function(e){a.requesting=!1,"function"==typeof i&&i(e)})},n.prototype.buildTree=function(e){function r(e,o,t){var n=t?t+"/"+o.name:o.name;if(e.name.trim()&&0!==t.trim().indexOf(e.name)&&(e.nodes=[]),e.name!==t)for(var i in e.nodes)r(e.nodes[i],o,t);else{for(var a in e.nodes)if(e.nodes[a].name===n)return;e.nodes.push({name:n,nodes:[]})}e.nodes=e.nodes.sort(function(e,r){return e.name<r.name?-1:e.name===r.name?0:1})}var o=this;!o.history.length&&o.history.push({name:e,nodes:[]});for(var t in o.fileList){var n=o.fileList[t];n.isFolder()&&r(o.history[0],n.model,e)}},n.prototype.folderClickByName=function(e){var r=this;e=e.replace(RegExp("^/*","g"),"").split("/"),r.currentPath=e&&""===e[0]?[]:e,r.refresh()},n.prototype.folderClick=function(e){var r=this;e&&"dir"===e.model.type&&(r.currentPath.push(e.model.name),r.refresh())},n.prototype.upDir=function(){var e=this;e.currentPath[0]&&(e.currentPath=e.currentPath.slice(0,-1),e.refresh())},n.prototype.goTo=function(e){var r=this;r.currentPath=r.currentPath.slice(0,e+1),r.refresh()},n.prototype.fileNameExists=function(e){var r=this;for(var o in r.fileList)if(o=r.fileList[o],e.trim&&o.model.name.trim()===e.trim())return!0},n.prototype.listHasFolders=function(){var e=this;for(var r in e.fileList)if("dir"===e.fileList[r].model.type)return!0},n}])}(angular),function(e,r){"use strict";r.module("FileManagerApp").service("fileUploader",["$http","fileManagerConfig",function(o,t){var n=this;n.requesting=!1,n.upload=function(i,a,s,l){var c=new e.FormData;c.append("destination","/"+a.join("/"));for(var u in i){var p=i[u];"object"==typeof p&&c.append("file-"+(1+parseInt(u,null)),p)}return n.requesting=!0,o.post(t.uploadUrl,c,{transformRequest:r.identity,headers:{"Content-Type":void 0}}).success(function(e){n.requesting=!1,"function"==typeof s&&s(e)}).error(function(e){n.requesting=!1,"function"==typeof l&&l(e)})}}])}(window,angular),function(e,r,o){"use strict";r.module("FileManagerApp").factory("item",["$http","$translate","fileManagerConfig","chmod",function(t,n,i,a){var s=function(e,o){function t(e){var r=(e||"").toString().split(/[- :]/);return new Date(r[0],r[1]-1,r[2],r[3],r[4],r[5])}var n={name:e&&e.name||"",path:o||[],type:e&&e.type||"file",size:e&&e.size||0,date:t(e&&e.date),perms:new a(e&&e.rights),content:e&&e.content||"",recursive:!1,sizeKb:function(){return Math.round(this.size/1024,1)},fullPath:function(){return("/"+this.path.join("/")+"/"+this.name).replace(RegExp("//"),"/")}};this.error="",this.inprocess=!1,this.model=r.copy(n),this.tempModel=r.copy(n)};return s.prototype.update=function(){return r.extend(this.model,r.copy(this.tempModel)),this},s.prototype.revert=function(){return r.extend(this.tempModel,r.copy(this.model)),this.error="",this},s.prototype.defineCallback=function(e,r,o){var t=this;return e.result&&e.result.error?(t.error=e.result.error,"function"==typeof o&&o(e)):e.error?(t.error=e.error.message,"function"==typeof o&&o(e)):(t.update(),"function"==typeof r&&r(e))},s.prototype.createFolder=function(e,r){var o=this,a={params:{mode:"addfolder",path:o.tempModel.path.join("/"),name:o.tempModel.name}};return o.tempModel.name.trim()?(o.inprocess=!0,o.error="",t.post(i.createFolderUrl,a).success(function(t){o.defineCallback(t,e,r)}).error(function(e){o.error=e.result&&e.result.error?e.result.error:n.instant("error_creating_folder"),"function"==typeof r&&r(e)})["finally"](function(){o.inprocess=!1})):void 0},s.prototype.rename=function(e,r){var o=this,a={params:{mode:"rename",path:o.model.fullPath(),newPath:o.tempModel.fullPath()}};return o.tempModel.name.trim()?(o.inprocess=!0,o.error="",t.post(i.renameUrl,a).success(function(t){o.defineCallback(t,e,r)}).error(function(e){o.error=e.result&&e.result.error?e.result.error:n.instant("error_renaming"),"function"==typeof r&&r(e)})["finally"](function(){o.inprocess=!1})):void 0},s.prototype.copy=function(e,r){var o=this,a={params:{mode:"copy",path:o.model.fullPath(),newPath:o.tempModel.fullPath()}};return o.tempModel.name.trim()?(o.inprocess=!0,o.error="",t.post(i.copyUrl,a).success(function(t){o.defineCallback(t,e,r)}).error(function(e){o.error=e.result&&e.result.error?e.result.error:n.instant("error_copying"),"function"==typeof r&&r(e)})["finally"](function(){o.inprocess=!1})):void 0},s.prototype.compress=function(e,r){var o=this,a={params:{mode:"compress",path:o.model.fullPath(),destination:o.tempModel.fullPath()}};return o.tempModel.name.trim()?(o.inprocess=!0,o.error="",t.post(i.compressUrl,a).success(function(t){o.defineCallback(t,e,r)}).error(function(e){o.error=e.result&&e.result.error?e.result.error:n.instant("error_compressing"),"function"==typeof r&&r(e)})["finally"](function(){o.inprocess=!1})):void 0},s.prototype.extract=function(e,r){var o=this,a={params:{mode:"extract",path:o.model.fullPath(),sourceFile:o.model.fullPath(),destination:o.tempModel.fullPath()}};return o.inprocess=!0,o.error="",t.post(i.extractUrl,a).success(function(t){o.defineCallback(t,e,r)}).error(function(e){o.error=e.result&&e.result.error?e.result.error:n.instant("error_extracting"),"function"==typeof r&&r(e)})["finally"](function(){o.inprocess=!1})},s.prototype.download=function(r){var t=this,n={mode:"download",preview:r,path:t.model.fullPath()},a=[i.downloadFileUrl,o.param(n)].join("?");"dir"!==t.model.type&&e.open(a,"_blank","")},s.prototype.preview=function(){var e=this;return e.download(!0)},s.prototype.getContent=function(e,r){var o=this,a={params:{mode:"editfile",path:o.tempModel.fullPath()}};return o.inprocess=!0,o.error="",t.post(i.getContentUrl,a).success(function(t){o.tempModel.content=o.model.content=t.result,o.defineCallback(t,e,r)}).error(function(e){o.error=e.result&&e.result.error?e.result.error:n.instant("error_getting_content"),"function"==typeof r&&r(e)})["finally"](function(){o.inprocess=!1})},s.prototype.remove=function(e,r){var o=this,a={params:{mode:"delete",path:o.tempModel.fullPath()}};return o.inprocess=!0,o.error="",t.post(i.removeUrl,a).success(function(t){o.defineCallback(t,e,r)}).error(function(e){o.error=e.result&&e.result.error?e.result.error:n.instant("error_deleting"),"function"==typeof r&&r(e)})["finally"](function(){o.inprocess=!1})},s.prototype.edit=function(e,r){var o=this,a={params:{mode:"savefile",content:o.tempModel.content,path:o.tempModel.fullPath()}};return o.inprocess=!0,o.error="",t.post(i.editUrl,a).success(function(t){o.defineCallback(t,e,r)}).error(function(e){o.error=e.result&&e.result.error?e.result.error:n.instant("error_modifying"),"function"==typeof r&&r(e)})["finally"](function(){o.inprocess=!1})},s.prototype.changePermissions=function(e,r){var o=this,a={params:{mode:"changepermissions",path:o.tempModel.fullPath(),perms:o.tempModel.perms.toOctal(),permsCode:o.tempModel.perms.toCode(),recursive:o.tempModel.recursive}};return o.inprocess=!0,o.error="",t.post(i.permissionsUrl,a).success(function(t){o.defineCallback(t,e,r)}).error(function(e){o.error=e.result&&e.result.error?e.result.error:n.instant("error_changing_perms"),"function"==typeof r&&r(e)})["finally"](function(){o.inprocess=!1})},s.prototype.isFolder=function(){return"dir"===this.model.type},s.prototype.isEditable=function(){return!this.isFolder()&&RegExp(i.isEditableFilePattern).test(this.model.name.toLowerCase())},s.prototype.isImage=function(){return RegExp(i.isImageFilePattern).test(this.model.name.toLowerCase())},s.prototype.isCompressible=function(){return this.isFolder()},s.prototype.isExtractable=function(){return!this.isFolder()&&RegExp(i.isExtractableFilePattern).test(this.model.name)},s}])}(window,angular,jQuery),function(e,r){"use strict";e.module("FileManagerApp").controller("ModalFileManagerCtrl",["$scope","$rootScope","fileManagerConfig","fileNavigator",function(e,o,t,n){e.appName=t.appName,e.orderProp=["model.type","model.name"],e.fileNavigator=new n,o.select=function(e,o){o.tempModel.path=e.model.fullPath().split("/"),r("#selector").modal("hide")},o.openNavigator=function(o){e.fileNavigator.currentPath=o.model.path.slice(),e.fileNavigator.refresh(),r("#selector").modal("show")}}])}(angular,jQuery),function(e){"use strict";e.module("FileManagerApp").config(["$translateProvider",function(e){e.translations("en",{filemanager:"File Manager",language:"Language",english:"English",spanish:"Spanish",portuguese:"Portuguese",confirm:"Confirm",cancel:"Cancel",close:"Close",upload_file:"Upload file",files_will_uploaded_to:"Files will be uploaded to",uploading:"Uploading",permissions:"Permissions",select_destination_folder:"Select the destination folder",source:"Source",destination:"Destination",copy_file:"Copy file",sure_to_delete:"Are you sure to delete",change_name_move:"Change name / move",enter_new_name_for:"Enter new name for",extract_item:"Extract item",extraction_started:"Extraction started in a background process",compression_started:"Compression started in a background process",enter_folder_name_for_extraction:"Enter the folder name for the extraction of",enter_folder_name_for_compression:"Enter the folder name for the compression of",toggle_fullscreen:"Toggle fullscreen",edit_file:"Edit file",file_content:"File content",loading:"Loading",search:"Search",create_folder:"Create folder",create:"Create",folder_name:"Folder name",upload:"Upload",change_permissions:"Change permissions",change:"Change",details:"Details",icons:"Icons",list:"List",name:"Name",size:"Size",actions:"Actions",date:"Date",no_files_in_folder:"No files in this folder",no_folders_in_folder:"This folder not contains children folders",select_this:"Select this",go_back:"Go back",wait:"Wait",move:"Move",download:"Download",view_item:"View item",remove:"Delete",edit:"Edit",copy:"Copy",rename:"Rename",extract:"Extract",compress:"Compress",error_invalid_filename:"Invalid filename or already exists, specify another name",error_modifying:"An error occurred modifying the file",error_deleting:"An error occurred deleting the file or folder",error_renaming:"An error occurred renaming the file",error_copying:"An error occurred copying the file",error_compressing:"An error occurred compressing the file or folder",error_extracting:"An error occurred extracting the file",error_creating_folder:"An error occurred creating the folder",error_getting_content:"An error occurred getting the content of the file",error_changing_perms:"An error occurred changing the permissions of the file",error_uploading_files:"An error occurred uploading files",sure_to_start_compression_with:"Are you sure to compress",owner:"Owner",group:"Group",others:"Others",read:"Read",write:"Write",exec:"Exec",original:"Original",changes:"Changes",recursive:"Recursive"}),e.translations("pt",{filemanager:"Gerenciador de arquivos",language:"Língua",english:"Inglês",spanish:"Espanhol",portuguese:"Portugues",confirm:"Confirmar",cancel:"Cancelar",close:"Desligar",upload_file:"Carregar arquivo",files_will_uploaded_to:"Os arquivos serão enviados para",uploading:"Carregar",permissions:"Autorizações",select_destination_folder:"Selecione a pasta de destino",source:"Origem",destination:"Destino",copy_file:"Copiar arquivo",sure_to_delete:"Tem certeza de que deseja apagar",change_name_move:"Rebatizar / mudança",enter_new_name_for:"Digite o novo nome para",extract_item:"Extrair arquivo",extraction_started:"A extração começou em um processo em segundo plano",compression_started:"A compressão começou em um processo em segundo plano",enter_folder_name_for_extraction:"Digite o nome da pasta para a extração de",enter_folder_name_for_compression:"Digite o nome da pasta para Compressão",toggle_fullscreen:"Ativar/desativar tela cheia",edit_file:"Editar arquivo",file_content:"Conteúdo do arquivo",loading:"Carregando",search:"Localizar",create_folder:"Criar Pasta",create:"Criar",folder_name:"Nome da pasta",upload:"Fazer",change_permissions:"Alterar permissões",change:"Alterar",details:"Detalhes",icons:"Icones",list:"Lista",name:"Nome",size:"Tamanho",actions:"Ações",date:"Data",no_files_in_folder:"Não há arquivos nesta pasta",no_folders_in_folder:"Esta pasta no contém subpastas",select_this:"Selecione esta",go_back:"Voltar",wait:"Aguente",move:"Mudar",download:"Baixar",view_item:"Veja o arquivo",remove:"Tirar",edit:"Editar",copy:"Copiar",rename:"Rebatizar",extract:"Extrair",compress:"Comprimir",error_invalid_filename:"Invalid ou nome de arquivo já existe, especifique outro nome",error_modifying:"Ocorreu um erro ao modificar o arquivo",error_deleting:"Ocorreu um erro ao excluir o arquivo ou pasta",error_renaming:"Ocorreu um erro ao mudar o nome do arquivo",error_copying:"Ocorreu um erro ao copiar o arquivo",error_compressing:"Ocorreu um erro ao comprimir o arquivo ou pasta",error_extracting:"Ocorreu um erro ao extrair o arquivo",error_creating_folder:"Ocorreu um erro ao criar a pasta",error_getting_content:"Ocorreu um erro ao obter o conteúdo do arquivo",error_changing_perms:"Ocorreu um erro ao alterar as permissões do arquivo",error_uploading_files:"Ocorreu um erro upload de arquivos",sure_to_start_compression_with:"Tem certeza que deseja comprimir",owner:"Proprietário",group:"Grupo",others:"Outros",read:"Leitura",write:"Gravável",exec:"Execução",original:"Original",changes:"Mudanças",recursive:"Recursiva"}),e.translations("es",{filemanager:"Administrador de archivos",language:"Idioma",english:"Ingles",spanish:"Español",portuguese:"Portugues",confirm:"Confirmar",cancel:"Cancelar",close:"Cerrar",upload_file:"Subir archivo",files_will_uploaded_to:"Los archivos seran subidos a",uploading:"Subiendo",permissions:"Permisos",select_destination_folder:"Seleccione la carpeta de destino",source:"Origen",destination:"Destino",copy_file:"Copiar archivo",sure_to_delete:"Esta seguro que desea eliminar",change_name_move:"Renombrar / mover",enter_new_name_for:"Ingrese el nuevo nombre para",extract_item:"Extraer archivo",extraction_started:"La extraccion ha comenzado en un proceso de segundo plano",compression_started:"La compresion ha comenzado en un proceso de segundo plano",enter_folder_name_for_extraction:"Ingrese el nombre de la carpeta para la extraccion de",enter_folder_name_for_compression:"Ingrese el nombre de la carpeta para la compresion de",toggle_fullscreen:"Activar/Desactivar pantalla completa",edit_file:"Editar archivo",file_content:"Contenido del archivo",loading:"Cargando",search:"Buscar",create_folder:"Crear carpeta",create:"Crear",folder_name:"Nombre de la carpeta",upload:"Subir",change_permissions:"Cambiar permisos",change:"Cambiar",details:"Detalles",icons:"Iconos",list:"Lista",name:"Nombre",size:"Tamaño",actions:"Acciones",date:"Fecha",no_files_in_folder:"No hay archivos en esta carpeta",no_folders_in_folder:"Esta carpeta no contiene sub-carpetas",select_this:"Seleccionar esta",go_back:"Volver",wait:"Espere",move:"Mover",download:"Descargar",view_item:"Ver archivo",remove:"Eliminar",edit:"Editar",copy:"Copiar",rename:"Renombrar",extract:"Extraer",compress:"Comprimir",error_invalid_filename:"El nombre del archivo es invalido o ya existe",error_modifying:"Ocurrio un error al intentar modificar el archivo",error_deleting:"Ocurrio un error al intentar eliminar el archivo",error_renaming:"Ocurrio un error al intentar renombrar el archivo",error_copying:"Ocurrio un error al intentar copiar el archivo",error_compressing:"Ocurrio un error al intentar comprimir el archivo",error_extracting:"Ocurrio un error al intentar extraer el archivo",error_creating_folder:"Ocurrio un error al intentar crear la carpeta",error_getting_content:"Ocurrio un error al obtener el contenido del archivo",error_changing_perms:"Ocurrio un error al cambiar los permisos del archivo",error_uploading_files:"Ocurrio un error al subir archivos",sure_to_start_compression_with:"Esta seguro que desea comprimir",owner:"Propietario",group:"Grupo",others:"Otros",read:"Lectura",write:"Escritura",exec:"Ejecucion",original:"Original",changes:"Cambios",recursive:"Recursivo"})}])}(angular);