/*
Project: angular-gantt v1.2.14 - Gantt chart component for AngularJS
Authors: Marco Schweighauser, Rémi Alvergnat
License: MIT
Homepage: https://www.angular-gantt.com
Github: https://github.com/angular-gantt/angular-gantt.git
*/

!function(){"use strict";angular.module("gantt.dependencies",["gantt","gantt.dependencies.templates"]).directive("ganttDependencies",["$timeout","$document","ganttDebounce","GanttDependenciesManager","GanttDependenciesChecker",function(a,b,c,d,e){return{restrict:"E",require:"^gantt",scope:{enabled:"=?",readOnly:"=?",jsPlumbDefaults:"=?",endpoints:"=?",fallbackEndpoints:"=?",conflictChecker:"=?"},link:function(a,b,f,g){function h(){return angular.element('<span><span class="gantt-endpoint-overlay start-endpoint arrow-right"></span></span>')}function i(){return angular.element('<span><span class="gantt-endpoint-overlay end-endpoint arrow-right"></span></span>')}function j(){return angular.element('<span><span class="gantt-endpoint-overlay start-endpoint fallback-endpoint"></span></span>')}function k(){return angular.element('<span><span class="gantt-endpoint-overlay end-endpoint fallback-endpoint"></span></span>')}var l=g.gantt.api;if(a.options&&"object"==typeof a.options.dependencies)for(var m in a.options.dependencies)a[m]=a.options[m];void 0===a.enabled&&(a.enabled=!0),void 0===a.readOnly&&(a.readOnly=!1),void 0===a.jsPlumbDefaults&&(a.jsPlumbDefaults={Endpoint:["Dot",{radius:4}],EndpointStyle:{fillStyle:"#456",strokeStyle:"#456",lineWidth:1},Connector:"Flowchart",ConnectionOverlays:[["Arrow",{location:1,length:12,width:12}]]}),void 0===a.endpoints&&(a.endpoints=[{anchor:"Left",isSource:!1,isTarget:!0,maxConnections:-1,cssClass:"gantt-endpoint start-endpoint target-endpoint",overlays:[["Custom",{create:h}]]},{anchor:"Right",isSource:!0,isTarget:!1,maxConnections:-1,cssClass:"gantt-endpoint end-endpoint source-endpoint",overlays:[["Custom",{create:i}]]}]),void 0===a.fallbackEndpoints&&(a.fallbackEndpoints=[{endpoint:"Blank",anchor:"Left",isSource:!1,isTarget:!0,maxConnections:0,cssClass:"gantt-endpoint start-endpoint fallback-endpoint",overlays:[["Custom",{create:j}]]},{endpoint:"Blank",anchor:"Right",isSource:!0,isTarget:!1,maxConnections:0,cssClass:"gantt-endpoint end-endpoint fallback-endpoint",overlays:[["Custom",{create:k}]]}]),void 0===a.conflictChecker&&(a.conflictChecker=!1);var n=new d(g.gantt,a,l),o=new e(n,a,l);a.$watchGroup(["conflictChecker","enabled"],function(b,c){if(b!==c){for(var d=g.gantt.rowsManager.rows,e=[],f=0;f<d.length;f++)e.push.apply(e,d[f].tasks);a.conflictChecker&&a.enabled?o.refresh(e):o.clear(e)}}),l.directives.on["new"](a,function(a,b,c){"ganttBody"===a&&n.plumb.setContainer(c)}),l.tasks.on.add(a,function(a){n.addDependenciesFromTask(a)}),l.tasks.on.remove(a,function(a){n.removeDependenciesFromTask(a)}),l.tasks.on.displayed(a,c(function(b){n.setTasks(b),n.refresh(),a.conflictChecker&&a.enabled&&o.refresh(b)})),l.rows.on.displayed(a,function(){n.refresh()}),l.tasks.on.viewChange(a,function(b){b.$element&&n.plumb.revalidate(b.$element[0]),a.conflictChecker&&a.enabled&&o.refresh([b])}),l.tasks.on.viewRowChange(a,function(b){n.setTask(b),a.conflictChecker&&a.enabled&&o.refresh([b])}),l.dependencies.on.add(a,function(b){a.conflictChecker&&a.enabled&&o.refresh([b.getFromTask(),b.getToTask()])}),l.dependencies.on.change(a,function(b){a.conflictChecker&&a.enabled&&o.refresh([b.getFromTask(),b.getToTask()])}),l.dependencies.on.remove(a,function(b){a.conflictChecker&&a.enabled&&o.refresh([b.getFromTask(),b.getToTask()])})}}}])}(),function(){"use strict";angular.module("gantt.dependencies").factory("GanttDependenciesChecker",[function(){var a=function(a){function b(a,b){b.model.id in a||!b.$element||(b.$element.addClass("gantt-task-conflict"),a[b.model.id]=b)}function c(a,b){for(var c=0,d=b.length;c<d;c++){var e=b[c];e.model.id in a||!e.$element||e.$element.removeClass("gantt-task-conflict")}}this.refresh=function(d){for(var e=d.slice(0),f=[],g=0;g<d.length;g++)for(var h=a.getTaskDependencies(d[g]),i=0;i<h.length;i++){var j=h[i],k=j.getFromTask(),l=j.getToTask();k in e||e.push(k),l in e||e.push(l),k.model.to>l.model.from&&(b(f,k),b(f,l))}c(f,e)},this.clear=function(a){var b=a.slice(0);c([],b)}};return a}])}(),function(){"use strict";angular.module("gantt.dependencies").factory("GanttDependenciesEvents",[function(){var a=function(a){var b=this;this.manager=a;var c=function(){return!b.manager.pluginScope.readOnly};this.manager.plumb.bind("beforeDrag",c),this.manager.plumb.bind("beforeStartDetach",c);var d=function(a){return a.sourceId!==a.targetId};this.manager.plumb.bind("beforeDrop",d),this.manager.plumb.bind("connectionDrag",function(a){b.manager.setDraggingConnection(a)}),this.manager.plumb.bind("connectionDragStop",function(){b.manager.setDraggingConnection(void 0)}),this.manager.plumb.bind("beforeDrop",function(){return b.manager.setDraggingConnection(void 0),!0});var e=function(a,c){if(c){var d;a.connection.$dependency&&(d=a.connection.$dependency);var e=a.sourceEndpoint,f=a.targetEndpoint,g=e.$task.model,h=g.dependencies;void 0===h&&(h=[],g.dependencies=h);var i={to:f.$task.model.id};h.push(i),d&&(d.removeFromTaskModel(),b.manager.removeDependency(d,!0));var j=b.manager.addDependency(e.$task,i);a.connection.$dependency=j,j.connection=a.connection,b.manager.api.dependencies.raise.add(j)}},f=function(a,c){if(c){var d;a.connection.$dependency&&(d=a.connection.$dependency);var e=a.newSourceEndpoint,f=a.newTargetEndpoint,g=e.$task.model,h=g.dependencies;void 0===h&&(h=[],g.dependencies=h);var i={to:f.$task.model.id};h.push(i),d&&(d.removeFromTaskModel(),b.manager.removeDependency(d,!0));var j=b.manager.addDependency(e.$task,i);a.connection.$dependency=j,j.connection=a.connection,b.manager.api.dependencies.raise.change(j,d)}},g=function(a,c){if(c){var d=a.connection.$dependency;d.removeFromTaskModel(),b.manager.removeDependency(d,!0),b.manager.api.dependencies.raise.remove(d)}};this.manager.plumb.bind("connectionMoved",f),this.manager.plumb.bind("connection",e),this.manager.plumb.bind("connectionDetached",g)};return a}])}(),function(){"use strict";angular.module("gantt.dependencies").factory("GanttDependenciesManager",["GanttDependency","GanttDependenciesEvents","GanttDependencyTaskMouseHandler",function(a,b,c){var d=function(d,e,f){var g=this;this.gantt=d,this.pluginScope=e,this.api=f,this.api.registerEvent("dependencies","add"),this.api.registerEvent("dependencies","change"),this.api.registerEvent("dependencies","remove"),this.plumb=jsPlumb.getInstance(),this.plumb.importDefaults(this.pluginScope.jsPlumbDefaults),this.dependenciesFrom={},this.dependenciesTo={},this.tasksList=[],this.tasks={},this.events=new b(this),this.pluginScope.$watch("enabled",function(a,b){a!==b&&g.refresh()}),this.pluginScope.$watch("readOnly",function(a,b){a!==b&&(g.setTasks(g.tasksList),g.refresh())}),this.pluginScope.$watch("jsPlumbDefaults",function(a,b){a!==b&&(g.plumb.importDefaults(a),g.refresh())},!0),this.addDependenciesFromTask=function(a){if(this.pluginScope.enabled){var b=a.model.dependencies;if(void 0!==b&&b){angular.isArray(b)||(b=[b],a.model.dependencies=b);for(var c=0,d=b.length;c<d;c++){var e=g.addDependency(a,b[c]);e.connect()}}}},this.removeDependenciesFromTask=function(a,b){var c=this.getTaskDependencies(a);if(c)for(var d=0;d<c.length;d++)b||c[d].disconnect(),g.removeDependency(c[d])},this.addDependency=function(b,c){var d=new a(this,b,c),e=d.getFromTaskId(),f=d.getToTaskId();return e in this.dependenciesFrom||(this.dependenciesFrom[e]=[]),f in this.dependenciesTo||(this.dependenciesTo[f]=[]),e&&this.dependenciesFrom[e].push(d),f&&this.dependenciesTo[f].push(d),d},this.removeDependency=function(a,b){var c,d=this.dependenciesFrom[a.getFromTaskId()],e=[];if(d)for(c=0;c<d.length;c++)a===d[c]&&e.push(a);var f=this.dependenciesTo[a.getToTaskId()],g=[];if(f)for(c=0;c<f.length;c++)a===f[c]&&g.push(a);for(c=0;c<e.length;c++)b||e[c].disconnect(),d.splice(d.indexOf(a),1);for(c=0;c<g.length;c++)b||g[c].disconnect(),f.splice(f.indexOf(a),1);this.dependenciesFrom[a.getFromTaskId()]&&0===this.dependenciesFrom[a.getFromTaskId()].length&&delete this.dependenciesFrom[a.getFromTaskId()],this.dependenciesTo[a.getToTaskId()]&&0===this.dependenciesTo[a.getToTaskId()].length&&delete this.dependenciesTo[a.getToTaskId()]},this.getTaskDependencies=function(a){var b=[],c=g.dependenciesFrom[a.model.id];c&&(b=b.concat(c));var d=g.dependenciesTo[a.model.id];return d&&(b=b.concat(d)),b},this.setDraggingConnection=function(a){a?(g.draggingConnection=a,angular.forEach(g.tasks,function(a){a.dependencies.mouseHandler.release()})):(g.draggingConnection=void 0,angular.forEach(g.tasks,function(a){a.dependencies.mouseHandler.install()}))};var h=function(a){var b=a.row.model.dependencies;if(void 0!==b)return b!==!1;var c=a.model.dependencies;return void 0===c||c!==!1},i=function(a){if(a.dependencies||(a.dependencies={}),a.dependencies.endpoints=[],g.pluginScope.endpoints&&a.$element)for(var b=0;b<g.pluginScope.endpoints.length;b++){var c=g.plumb.addEndpoint(a.$element,g.pluginScope.endpoints[b]);c.setVisible(!1,!0,!0),c.$task=a,a.dependencies.endpoints.push(c)}},j=function(a){if(a.dependencies.endpoints){for(var b=0;b<a.dependencies.endpoints.length;b++){var c=a.dependencies.endpoints[b];g.plumb.deleteEndpoint(c),c.$task=void 0}a.dependencies.endpoints=void 0}},k=function(a){a.dependencies||(a.dependencies={}),g.pluginScope.readOnly||(a.dependencies.mouseHandler=new c(g,a),a.dependencies.mouseHandler.install())},l=function(a){a.dependencies.mouseHandler&&(a.dependencies.mouseHandler.release(),a.dependencies.mouseHandler=void 0)};this.setTasks=function(a){angular.forEach(g.tasks,function(a){l(a),j(a)});for(var b={},c=[],d=0;d<a.length;d++){var e=a[d];h(e)&&(b[e.model.id]=e,c.push(e),i(e),k(e))}g.tasks=b,g.tasksList=a};var m=function(a){var b=g.getTaskDependencies(a);if(b)for(var c=0;c<b.length;c++)b[c].disconnect();return b},n=function(a){var b=g.getTaskDependencies(a);if(b)for(var c=0;c<b.length;c++)b[c].connect();return b};this.setTask=function(a){g.plumb.setSuspendDrawing(!0);try{var b=g.tasks[a.model.id];void 0!==b&&(m(b),l(b),j(b)),h(a)&&(g.tasks[a.model.id]=a,i(a),k(a),n(a))}finally{g.plumb.setSuspendDrawing(!1,!0)}},this.getTask=function(a){return g.tasks[a]};var o=function(a){return a.dependencies.endpoints.filter(function(a){return a.isSource})},p=function(a){return a.dependencies.endpoints.filter(function(a){return a.isTarget})};this.connect=function(a,b,c){var d=o(a),e=p(b);if(d&&e){var f,h;f=c.connectParameters&&c.connectParameters.sourceEndpointIndex?d[c.connectParameters.sourceEndpointIndex]:d[0],h=c.connectParameters&&c.connectParameters.targetEndpointIndex?e[c.connectParameters.targetEndpointIndex]:e[0];var i=g.plumb.connect({source:f,target:h},c.connectParameters);return i}},this.getDependencies=function(){var a=[];return angular.forEach(this.dependenciesFrom,function(b){for(var c=0;c<b.length;c++)b[c]in a||a.push(b[c])}),a},this.refresh=function(a){g.plumb.setSuspendDrawing(!0);try{var b,c;a&&!angular.isArray(a)&&(a=[a]),void 0===a?(a=this.tasks,b=this.getDependencies()):(b=[],angular.forEach(a,function(a){var c=g.getTaskDependencies(a);angular.forEach(c,function(a){a in b||b.push(a)})}));for(c=0;c<b.length;c++)g.removeDependency(b[c]);angular.forEach(a,function(a){g.addDependenciesFromTask(a)})}finally{g.plumb.setSuspendDrawing(!1,!0)}},this.api.registerMethod("dependencies","refresh",this.refresh,this)};return d}])}(),function(){"use strict";angular.module("gantt.dependencies").factory("GanttDependency",["ganttUtils","ganttDom",function(a,b){var c=function(c,d,e){var f=this;this.manager=c,this.task=d,this.model=e,this.connection=void 0,this.fallbackEndpoints=[],this.isConnected=function(){return!!this.connection},this.disconnect=function(){this.connection&&(this.connection.endpoints&&this.manager.plumb.detach(this.connection),this.connection.$dependency=void 0,this.connection=void 0),this.deleteFallbackEndpoints()},this.deleteFallbackEndpoints=function(){if(this.fallbackEndpoints){for(var a=0;a<this.fallbackEndpoints.length;a++)f.manager.plumb.deleteEndpoint(this.fallbackEndpoints[a]);this.fallbackEndpoints=[]}},this.getFromTaskId=function(){return void 0!==this.model.from?this.model.from:this.task.model.id},this.getToTaskId=function(){return void 0!==this.model.to?this.model.to:this.task.model.id},this.getFromTask=function(){return void 0!==this.model.from?this.manager.getTask(this.model.from):this.task},this.getToTask=function(){return void 0!==this.model.to?this.manager.getTask(this.model.to):this.task},this.removeFromTaskModel=function(){var b=a.angularIndexOf(this.task.model.dependencies,this.model);return b>=0&&this.task.model.dependencies.splice(b,1),b};var g=function(a){if(void 0===a||void 0===a.$element)return!1;var c=a.$element[0];return b.isElementVisible(c)};this.connect=function(){var a=this.getFromTask(),b=this.getToTask();if(g(a)||(a=void 0),g(b)||(b=void 0),a&&b){var c=this.manager.connect(a,b,this.model);if(c)return c.$dependency=this,this.connection=c,!0}if(this.deleteFallbackEndpoints(),void 0!==a){var d=this.manager.pluginScope.fallbackEndpoints[1];this.fallbackEndpoints.push(this.manager.plumb.addEndpoint(a.$element,d))}if(void 0!==b){var e=this.manager.pluginScope.fallbackEndpoints[0];this.fallbackEndpoints.push(this.manager.plumb.addEndpoint(b.$element,e))}return!1}};return c}])}(),function(){"use strict";angular.module("gantt.dependencies").factory("GanttDependencyTaskMouseHandler",["$timeout",function(a){var b=function(b,c){var d=this;this.manager=b,this.task=c,this.installed=!1,this.elementHandlers=[],this.display=!0,this.hideEndpointsPromise=void 0;var e=function(b){this.element=b,this.mouseExitHandler=function(){a.cancel(d.hideEndpointsPromise),d.hideEndpointsPromise=a(d.hideEndpoints,1e3,!1)},this.mouseEnterHandler=function(){a.cancel(d.hideEndpointsPromise),d.displayEndpoints()},this.install=function(){this.element.bind("mouseenter",this.mouseEnterHandler),this.element.bind("mouseleave",this.mouseExitHandler)},this.release=function(){this.element.unbind("mouseenter",this.mouseEnterHandler),this.element.unbind("mouseleave",this.mouseExitHandler),a.cancel(d.hideEndpointsPromise)}};this.install=function(){d.installed||(d.hideEndpoints(),d.task.getContentElement()&&(d.elementHandlers.push(new e(d.task.getContentElement())),angular.forEach(d.task.dependencies.endpoints,function(a){d.elementHandlers.push(new e(angular.element(a.canvas)))}),angular.forEach(d.elementHandlers,function(a){a.install()}),d.installed=!0))},this.release=function(){d.installed&&(angular.forEach(d.elementHandlers,function(a){a.release()}),d.elementHandlers=[],d.displayEndpoints(),d.installed=!1)},this.displayEndpoints=function(){d.display=!0,angular.forEach(d.task.dependencies.endpoints,function(a){a.setVisible(!0,!0,!0)})},this.hideEndpoints=function(){angular.forEach(d.task.dependencies.endpoints,function(a){a.setVisible(!1,!0,!0)}),d.display=!1}};return b}])}(),angular.module("gantt.dependencies.templates",[]).run(["$templateCache",function(a){}]);
//# sourceMappingURL=angular-gantt-dependencies-plugin.min.js.map