/*
Project: angular-gantt v1.2.5 - Gantt chart component for AngularJS
Authors: Marco Schweighauser, Rémi Alvergnat
License: MIT
Homepage: http://www.angular-gantt.com
Github: https://github.com/angular-gantt/angular-gantt.git
*/

!function(){"use strict";angular.module("gantt.bounds",["gantt","gantt.bounds.templates"]).directive("ganttBounds",["moment","$compile","$document",function(a,b,c){return{restrict:"E",require:"^gantt",scope:{enabled:"=?"},link:function(d,e,f,g){var h=g.gantt.api;if(d.options&&"object"==typeof d.options.bounds)for(var i in d.options.bounds)d[i]=d.options[i];void 0===d.enabled&&(d.enabled=!0),h.directives.on["new"](d,function(a,e,g){if("ganttTask"===a){var h=e.$new();h.pluginScope=d;var i=c[0].createElement("div");angular.element(i).attr("data-ng-if","task.model.est && task.model.lct && pluginScope.enabled");var j=c[0].createElement("gantt-task-bounds");void 0!==f.templateUrl&&angular.element(j).attr("data-template-url",f.templateUrl),void 0!==f.template&&angular.element(j).attr("data-template",f.template),angular.element(i).append(j),g.append(b(i)(h))}}),h.tasks.on.clean(d,function(b){void 0===b.est||a.isMoment(b.est)||(b.est=a(b.est)),void 0===b.lct||a.isMoment(b.lct)||(b.lct=a(b.lct))})}}}])}(),function(){"use strict";angular.module("gantt.drawtask",["gantt"]).directive("ganttDrawTask",["$document","ganttMouseOffset","moment",function(a,b,c){return{restrict:"E",require:"^gantt",scope:{enabled:"=?",moveThreshold:"=?",taskModelFactory:"=taskFactory"},link:function(d,e,f,g){var h=g.gantt.api;void 0===d.enabled&&(d.enabled=!0),void 0===d.moveThreshold&&(d.moveThreshold=0),h.directives.on["new"](d,function(e,f,g){if("ganttRow"===e){var i=function(a){var b=h.core.getDateByPosition(a,!0),e=c(b),g=d.taskModelFactory();g.from=b,g.to=e;var i=f.row.addTask(g);i.isResizing=!0,i.updatePosAndSize(),f.row.updateVisibleTasks(),f.row.$scope.$digest()},j=function(c){var e=function(a){var f=b.getOffset(a).x;Math.abs(c-f)>=d.moveThreshold&&(g.off("mousemove",e),i(c))};g.on("mousemove",e),a.one("mouseup",function(){g.off("mousemove",e)})},k=function(a){var c=a.target?a.target:a.srcElement,e=angular.isFunction(d.enabled)?d.enabled(a):d.enabled;if(e&&c.className.indexOf("gantt-row")>-1){var f=b.getOffset(a).x;0===d.moveThreshold?i(f,f):j(f)}};g.on("mousedown",k),f.drawTaskHandler=k}}),h.directives.on.destroy(d,function(a,b,c){"ganttRow"===a&&(c.off("mousedown",b.drawTaskHandler),delete b.drawTaskHandler)})}}}])}(),function(){"use strict";angular.module("gantt.groups",["gantt","gantt.groups.templates"]).directive("ganttGroups",["ganttUtils","GanttHierarchy","$compile","$document",function(a,b,c,d){return{restrict:"E",require:"^gantt",scope:{enabled:"=?",display:"=?"},link:function(a,e,f,g){function h(){a.hierarchy.refresh(g.gantt.rowsManager.filteredRows)}var i=g.gantt.api;if(a.options&&"object"==typeof a.options.sortable)for(var j in a.options.sortable)a[j]=a.options[j];void 0===a.enabled&&(a.enabled=!0),void 0===a.display&&(a.display="group"),a.hierarchy=new b,g.gantt.api.registerMethod("groups","refresh",h,this),g.gantt.$scope.$watchCollection("gantt.rowsManager.filteredRows",function(){h()}),i.directives.on["new"](a,function(b,e,g){if("ganttRow"===b){var h=e.$new();h.pluginScope=a;var i=d[0].createElement("div");angular.element(i).attr("data-ng-if","pluginScope.enabled");var j=d[0].createElement("gantt-task-group");void 0!==f.templateUrl&&angular.element(j).attr("data-template-url",f.templateUrl),void 0!==f.template&&angular.element(j).attr("data-template",f.template),angular.element(i).append(j),g.append(c(i)(h))}})}}}])}(),function(){"use strict";angular.module("gantt.labels",["gantt","gantt.labels.templates"]).directive("ganttLabels",["ganttUtils","$compile","$document","$log",function(a,b,c,d){return{restrict:"E",require:"^gantt",scope:{enabled:"=?",header:"=?"},link:function(a,e,f,g){function h(){var a=g.gantt.side.$element[0].getElementsByClassName("gantt-row-label"),b=0;angular.forEach(a,function(a){var c=a.children[0].offsetWidth;b=Math.max(b,c)}),b>=0&&i.side.setWidth(b)}var i=g.gantt.api;if(d.warn("Angular Gantt Labels plugin is deprecated. Please use Table plugin instead."),a.options&&"object"==typeof a.options.sortable)for(var j in a.options.sortable)a[j]=a.options[j];void 0===a.enabled&&(a.enabled=!0),void 0===a.header&&(a.header="Name"),i.directives.on["new"](a,function(d,e,f){if("ganttSideContent"===d){var g=e.$new();g.pluginScope=a;var h=c[0].createElement("div");angular.element(h).attr("data-ng-if","pluginScope.enabled"),angular.element(h).addClass("side-element");var i=c[0].createElement("gantt-side-content-labels");angular.element(h).append(i),f.append(b(h)(g))}}),i.registerMethod("labels","fitSideWidth",h,this)}}}])}(),function(){"use strict";angular.module("gantt.movable",["gantt"]).directive("ganttMovable",["ganttMouseButton","ganttMouseOffset","ganttSmartEvent","ganttMovableOptions","ganttUtils","ganttDom","$window","$document","$timeout",function(a,b,c,d,e,f,g,h,i){return{restrict:"E",require:"^gantt",scope:{enabled:"=?",allowMoving:"=?",allowResizing:"=?",allowRowSwitching:"=?"},link:function(j,k,l,m){var n=m.gantt.api;if(j.options&&"object"==typeof j.options.movable)for(var o in j.options.movable)j[o]=j.options[o];d.initialize(j),n.registerEvent("tasks","move"),n.registerEvent("tasks","moveBegin"),n.registerEvent("tasks","moveEnd"),n.registerEvent("tasks","resize"),n.registerEvent("tasks","resizeBegin"),n.registerEvent("tasks","resizeEnd"),n.registerEvent("tasks","change");var p,q,r="ontouchstart"in g||g.DocumentTouch&&h[0]instanceof g.DocumentTouch,s="touchstart mousedown",t="touchmove mousemove",u="touchend mouseup",v=15,w=5,x=3,y=15,z=5;n.directives.on["new"](j,function(d,k,l){if("ganttTask"===d){var n,o=angular.element(g),A=k.row.rowsManager.gantt.body.$element,B=k.row.rowsManager.gantt.scroll.$element,C=!1,D=!1,E=k.task.getForegroundElement(),F=k.task.getContentElement(),G=function(c){c.preventDefault(),r&&(c=b.getTouch(c));var d=k.task.model.movable,f=k.task.row.model.movable;"boolean"==typeof d&&(d={enabled:d}),"boolean"==typeof f&&(f={enabled:f});var g=e.firstProperty([d,f],"enabled",j.enabled),h=angular.isFunction(g)?g(c):g;if(h){var i=b.getOffset(c).x,l=M(i);if(""!==l&&1===a.getButton(c)){var m=b.getOffsetForElement(A[0],c).x;P(l,m)}k.$digest()}};E.on(s,G),F.on(s,G);var H=function(a){var c=k.task.model.movable,d=k.task.row.model.movable;"boolean"==typeof c&&(c={enabled:c}),"boolean"==typeof d&&(d={enabled:d});var f=e.firstProperty([c,d],"enabled",j.enabled),g=angular.isFunction(f)?f(a):f;if(g&&!k.task.isMoving){var h=b.getOffset(a).x,i=M(h);""!==i&&"M"!==i?(E.css("cursor",N(i)),F.css("cursor",N(i))):(E.css("cursor",""),F.css("cursor",""))}};E.on("mousemove",H),F.on("mousemove",H);var I=function(a){k.task.isMoving&&!k.destroyed&&(L(),J(a),K(a))},J=function(a){var c=C,d=b.getOffsetForElement(A[0],a),g=d.x;k.task.mouseOffsetX=g;var i=k.task.row.rowsManager.gantt.options.value("taskOutOfRange"),l=k.task.model.movable,n=k.task.row.model.movable;if("boolean"==typeof l&&(l={enabled:l}),"boolean"==typeof n&&(n={enabled:n}),"M"===k.task.moveMode){var o=e.firstProperty([l,n],"allowRowSwitching",j.allowRowSwitching);if(o){var q=B[0].getBoundingClientRect(),r=q.left+q.width/2,s=angular.element(h[0].querySelectorAll(".gantt-body"));s.css("pointer-events","auto");var t=f.findElementFromPoint(r,a.clientY,function(a){return angular.element(a).hasClass("gantt-row")});s.css("pointer-events","");for(var u,v=m.gantt.rowsManager.rows,w=0,x=v.length;x>w;w++)if(t===v[w].$element[0]){u=v[w];break}var y=k.task.row;void 0!==u&&y!==u&&(u.moveTaskToRow(k.task,!0),y.$scope.$digest(),u.$scope.$digest(),C=!0)}var z=e.firstProperty([l,n],"allowMoving",j.allowMoving);z&&(g-=p,"truncate"!==i&&(0>g?g=0:g+k.task.width>=k.gantt.width&&(g=k.gantt.width-k.task.width)),k.task.moveTo(g,!0),k.$digest(),C&&k.row.rowsManager.gantt.api.tasks.raise.move(k.task),C=!0)}else"E"===k.task.moveMode?(g<=k.task.left&&(g=k.task.left,k.task.moveMode="W",O(N(k.task.moveMode))),"truncate"!==i&&g>=k.gantt.width&&(g=k.gantt.width),k.task.setTo(g,!0),k.$digest(),C&&k.row.rowsManager.gantt.api.tasks.raise.resize(k.task),C=!0):(g>k.task.left+k.task.width&&(g=k.task.left+k.task.width,k.task.moveMode="E",O(N(k.task.moveMode))),"truncate"!==i&&0>g&&(g=0),k.task.setFrom(g,!0),k.$digest(),C&&k.row.rowsManager.gantt.api.tasks.raise.resize(k.task),C=!0);if(!c&&C&&!D){var E=k.task.getBackgroundElement();"M"===k.task.moveMode?(E.addClass("gantt-task-moving"),k.row.rowsManager.gantt.api.tasks.raise.moveBegin(k.task)):(E.addClass("gantt-task-resizing"),k.row.rowsManager.gantt.api.tasks.raise.resizeBegin(k.task))}},K=function(a){var c=b.getOffsetForElement(A[0],a),d=B[0].scrollLeft,e=B[0].offsetWidth,f=B[0].scrollWidth,g=d+e,h=!1;c.x<q?d>0&&c.x<=d+z&&(c.x-=y,h=!0,k.row.rowsManager.gantt.api.scroll.left(y)):f>g&&c.x>=g-z&&(c.x+=y,h=!0,k.row.rowsManager.gantt.api.scroll.right(y)),h&&(n=i(function(){I(a)},100,!0))},L=function(){void 0!==n&&(i.cancel(n),n=void 0)},M=function(a){var b=0,c=k.task.model.movable,d=k.task.row.model.movable;"boolean"==typeof c&&(c={enabled:c}),"boolean"==typeof d&&(d={enabled:d});var f=e.firstProperty([c,d],"allowResizing",j.allowResizing),g=e.firstProperty([c,d],"allowRowSwitching",j.allowRowSwitching),h=e.firstProperty([c,d],"allowMoving",j.allowMoving);return f&&(b=E[0].offsetWidth<v?x:w),f&&a>E[0].offsetWidth-b?"E":f&&b>a?"W":(h||g)&&a>=b&&a<=E[0].offsetWidth-b?"M":""},N=function(a){switch(a){case"E":return"e-resize";case"W":return"w-resize";case"M":return"move"}},O=function(a){l.css("cursor",a),angular.element(h[0].body).css({"-moz-user-select":""===a?"":"-moz-none","-webkit-user-select":""===a?"":"none","-ms-user-select":""===a?"":"none","user-select":""===a?"":"none",cursor:a})},P=function(a,d){void 0===k.task.originalModel&&(k.task.originalRow=k.task.row,k.task.originalModel=k.task.model,k.task.model=angular.copy(k.task.originalModel)),D||(q=d,p=d-k.task.modelLeft),C=!1,k.task.moveMode=a,k.task.isMoving=!0,k.task.active=!0;var e=function(a){a.stopImmediatePropagation(),r&&(a=b.getTouch(a)),I(a)},f=c(k,o,t,e);f.bind(),c(k,o,u,function(a){r&&(a=b.getTouch(a)),f.unbind(),Q(a),k.$digest()}).bindOnce(),O(N(a))},Q=function(){var a=k.task.getBackgroundElement();if(a.removeClass("gantt-task-moving"),a.removeClass("gantt-task-resizing"),void 0!==k.task.originalModel){if(angular.extend(k.task.originalModel,k.task.model),k.task.model=k.task.originalModel,k.task.row.model.id!==k.task.originalRow.model.id){var b=k.task.row;b.removeTask(k.task.model.id,!1,!0),k.task.row=k.task.originalRow,b.moveTaskToRow(k.task,!1)}delete k.task.originalModel,delete k.task.originalRow,k.$apply()}D=!1,k.task.isMoving=!1,k.task.active=!1,L(),O(""),C===!0&&("M"===k.task.moveMode?k.row.rowsManager.gantt.api.tasks.raise.moveEnd(k.task):k.row.rowsManager.gantt.api.tasks.raise.resizeEnd(k.task),C=!1,k.task.row.sortTasks(),k.row.rowsManager.gantt.api.tasks.raise.change(k.task)),k.task.moveMode=void 0};k.$on("$destroy",function(){k.destroyed=!0,L()}),k.task.isResizing?(D=!0,P("E",k.task.mouseOffsetX),delete k.task.isResizing):k.task.isMoving&&(D=!0,P("M",k.task.mouseOffsetX))}})}}}])}(),function(){"use strict";angular.module("gantt.overlap",["gantt","gantt.overlap.templates"]).directive("ganttOverlap",["moment",function(a){return{restrict:"E",require:"^gantt",scope:{enabled:"=?"},link:function(b,c,d,e){var f=e.gantt.api;void 0===b.enabled&&(b.enabled=!0),b.enabled&&f.tasks.on.change(b,function(a){b.handleOverlaps(a)});var g={};b.handleOverlaps=function(b){var c=b.row.tasks,d={},e={};angular.forEach(c,function(a){e[a.model.id]=a}),angular.forEach(c,function(b){var f,h;b.model.from.isBefore(b.to)?(f=b.model.from,h=b.model.to):(f=b.model.to,h=b.model.from);var i=a().range(f,h);angular.forEach(c,function(c){if(b.model.id!==c.model.id){var f,h;c.model.from.isBefore(c.model.to)?(f=c.model.from,h=c.model.to):(f=c.model.to,h=c.model.from);var j=a().range(f,h);j.overlaps(i)&&(g.hasOwnProperty(c.model.id)||(d[c.model.id]=c),delete e[c.model.id],g.hasOwnProperty(b.model.id)||(d[b.model.id]=b),delete e[b.model.id])}})}),angular.forEach(e,function(a){a.$element.removeClass("gantt-task-overlaps"),delete g[a.model.id]}),angular.forEach(d,function(a){a.$element.addClass("gantt-task-overlaps"),g[a.model.id]=a}),g=d}}}}])}(),function(){"use strict";angular.module("gantt.progress",["gantt","gantt.progress.templates"]).directive("ganttProgress",["moment","$compile","$document",function(a,b,c){return{restrict:"E",require:"^gantt",scope:{enabled:"=?"},link:function(d,e,f,g){var h=g.gantt.api;if(d.options&&"object"==typeof d.options.progress)for(var i in d.options.progress)d[i]=d.options[i];void 0===d.enabled&&(d.enabled=!0),h.directives.on["new"](d,function(a,e,g){if("ganttTaskBackground"===a){var h=e.$new();h.pluginScope=d;var i=c[0].createElement("div");angular.element(i).attr("data-ng-if","task.model.progress !== undefined && pluginScope.enabled");var j=c[0].createElement("gantt-task-progress");void 0!==f.templateUrl&&angular.element(j).attr("data-template-url",f.templateUrl),void 0!==f.template&&angular.element(j).attr("data-template",f.template),angular.element(i).append(j),g.append(b(i)(h))}}),h.tasks.on.clean(d,function(b){void 0===b.est||a.isMoment(b.est)||(b.est=a(b.est)),void 0===b.lct||a.isMoment(b.lct)||(b.lct=a(b.lct))})}}}])}(),function(){"use strict";angular.module("gantt.resizeSensor",["gantt"]).directive("ganttResizeSensor",[function(){return{restrict:"E",require:"^gantt",scope:{enabled:"=?"},link:function(a,b,c,d){function e(){var a=b.parent().parent().parent()[0].querySelectorAll("div.gantt")[0];return new ResizeSensor(a,function(){d.gantt.$scope.ganttElementWidth=a.clientWidth,d.gantt.$scope.$apply()})}var f=d.gantt.api;if(a.options&&"object"==typeof a.options.progress)for(var g in a.options.progress)a[g]=a.options[g];void 0===a.enabled&&(a.enabled=!0);var h=!1;f.core.on.rendered(a,function(){h=!0,void 0!==i&&i.detach(),a.enabled&&(ElementQueries.update(),i=e())});var i;a.$watch("enabled",function(a){h&&(a&&void 0===i?(ElementQueries.update(),i=e()):a||void 0===i||(i.detach(),i=void 0))})}}}])}(),function(){"use strict";for(var a,b="gantt.sortable",c="ganttSortable",d=["gantt",{module:"ang-drag-drop",url:"https://github.com/ganarajpr/angular-dragdrop.git#master"}],e=[],f=[],g=0,h=d.length;h>g;g++){var i=d[g];try{angular.isString(i)&&(i={module:i},d[g]=i),angular.module(i.module),f.push(i.module)}catch(j){i.exception=j,e.push(i)}}e.length>0?angular.module(b,[]).directive(c,["$log",function(d){return{restrict:"E",require:"^gantt",scope:{enabled:"=?"},link:function(){d.warn(b+" module can't require some dependencies:");for(var f=0,g=e.length;g>f;f++){a=e[f];var h=a.module;a.url&&(h+=" ("+a.url+")"),a.exception&&a.exception.message&&(h+=": "+a.exception.message),d.warn(h)}d.warn(c+" plugin directive won't be available")}}}]):angular.module(b,f).directive(c,["ganttUtils","$compile",function(a,b){return{restrict:"E",require:"^gantt",scope:{enabled:"=?"},link:function(c,d,e,f){var g=f.gantt.api;if(c.options&&"object"==typeof c.options.sortable)for(var h in c.options.sortable)c[h]=c.options[h];void 0===c.enabled&&(c.enabled=!0),g.directives.on["new"](c,function(d,e,f){"ganttRowLabel"===d&&void 0===f.attr("drag")&&(e.checkDraggable=function(){var b=e.row.model.sortable;return"boolean"==typeof b&&(b={enabled:b}),a.firstProperty([b],"enabled",c.enabled)},e.onDropSuccess=function(){e.$evalAsync()},e.onDrop=function(a,b){var c=e.row.rowsManager.rowsMap[b.id];c!==e&&(e.row.rowsManager.moveRow(c,e.row),e.$evalAsync())},f.attr("ui-draggable","{{checkDraggable()}}"),f.attr("drag-channel","'sortable'"),f.attr("ui-on-drop","onDrop($event, $data)"),f.attr("on-drop-success","onDropSuccess()"),f.attr("drop-channel","'sortable'"),f.attr("drag","row.model"),b(f)(e))})}}}])}(),function(){"use strict";angular.module("gantt.table",["gantt","gantt.table.templates"]).directive("ganttTable",["ganttUtils","$compile","$document",function(a,b,c){return{restrict:"E",require:"^gantt",scope:{enabled:"=?",columns:"=?",headers:"=?",classes:"=?",contents:"=?",headerContents:"=?",formatters:"=?",headerFormatter:"=?"},link:function(a,d,e,f){var g=f.gantt.api;if(a.options&&"object"==typeof a.options.sortable)for(var h in a.options.sortable)a[h]=a.options[h];void 0===a.enabled&&(a.enabled=!0),void 0===a.columns&&(a.columns=["model.name"]),void 0===a.headers&&(a.headers={"model.name":"Name"}),void 0===a.contents&&(a.contents={}),void 0===a.headerContents&&(a.headerContents={}),void 0===a.classes&&(a.classes={}),void 0===a.formatters&&(a.formatters={}),g.directives.on["new"](a,function(d,e,f){if("ganttSideContent"===d){var g=e.$new();g.pluginScope=a;var h=c[0].createElement("div");angular.element(h).attr("data-ng-if","pluginScope.enabled"),angular.element(h).addClass("side-element");var i=c[0].createElement("gantt-side-content-table");angular.element(h).append(i),f.append(b(h)(g))}})}}}])}(),function(){"use strict";angular.module("gantt.tooltips",["gantt","gantt.tooltips.templates"]).directive("ganttTooltips",["$compile","$document",function(a,b){return{restrict:"E",require:"^gantt",scope:{enabled:"=?",dateFormat:"=?",content:"=?"},link:function(c,d,e,f){var g=f.gantt.api;if(c.options&&"object"==typeof c.options.tooltips)for(var h in c.options.tooltips)c[h]=c.options[h];void 0===c.enabled&&(c.enabled=!0),void 0===c.dateFormat&&(c.dateFormat="MMM DD, HH:mm"),void 0===c.content&&(c.content="{{task.model.name}}</br><small>{{task.isMilestone() === true && getFromLabel() || getFromLabel() + ' - ' + getToLabel()}}</small>"),c.api=g,g.directives.on["new"](c,function(d,f,g){if("ganttTask"===d){var h=f.$new();h.pluginScope=c;var i=b[0].createElement("div");angular.element(i).attr("data-ng-if","pluginScope.enabled");var j=b[0].createElement("gantt-tooltip");void 0!==e.templateUrl&&angular.element(j).attr("data-template-url",e.templateUrl),void 0!==e.template&&angular.element(j).attr("data-template",e.template),angular.element(i).append(j),g.append(a(i)(h))}})}}}])}(),function(){"use strict";angular.module("gantt.tree",["gantt","gantt.tree.templates","ui.tree"]).directive("ganttTree",["ganttUtils","$compile","$document",function(a,b,c){return{restrict:"E",require:"^gantt",scope:{enabled:"=?",header:"=?",content:"=?",headerContent:"=?",keepAncestorOnFilterRow:"=?"},link:function(a,d,e,f){var g=f.gantt.api;if(a.options&&"object"==typeof a.options.sortable)for(var h in a.options.sortable)a[h]=a.options[h];void 0===a.enabled&&(a.enabled=!0),void 0===a.header&&(a.header="Name"),void 0===a.headerContent&&(a.headerContent="{{getHeader()}}"),void 0===a.keepAncestorOnFilterRow&&(a.keepAncestorOnFilterRow=!1),g.directives.on["new"](a,function(d,e,f){if("ganttSideContent"===d){var g=e.$new();g.pluginScope=a;var h=c[0].createElement("div");angular.element(h).attr("data-ng-if","pluginScope.enabled"),angular.element(h).addClass("side-element");var i=c[0].createElement("gantt-side-content-tree");angular.element(h).append(i),f.append(b(h)(g))}})}}}])}(),function(){"use strict";angular.module("gantt.bounds").directive("ganttTaskBounds",["$templateCache","moment",function(a,b){return{restrict:"E",templateUrl:function(b,c){var d;return d=void 0===c.templateUrl?"plugins/bounds/taskBounds.tmpl.html":c.templateUrl,c.template&&a.put(d,c.template),d},replace:!0,scope:!0,controller:["$scope","$element",function(a,c){c.toggleClass("ng-hide",!0),a.simplifyMoment=function(a){return b.isMoment(a)?a.unix():a},a.$watchGroup(["simplifyMoment(task.model.est)","simplifyMoment(task.model.lct)","task.left","task.width"],function(){var b=a.task.rowsManager.gantt.getPositionByDate(a.task.model.est),d=a.task.rowsManager.gantt.getPositionByDate(a.task.model.lct);c.css("left",b-a.task.left+"px"),c.css("width",d-b+"px"),c.toggleClass("gantt-task-bounds-in",!1),c.toggleClass("gantt-task-bounds-out",!1),void 0===a.task.model.est||void 0===a.task.model.lct?c.toggleClass("gantt-task-bounds-in",!0):a.task.model.est>a.task.model.from?c.toggleClass("gantt-task-bounds-out",!0):a.task.model.lct<a.task.model.to?c.toggleClass("gantt-task-bounds-out",!0):c.toggleClass("gantt-task-bounds-in",!0)}),a.task.$element.bind("mouseenter",function(){c.toggleClass("ng-hide",!1)}),a.task.$element.bind("mouseleave",function(){c.toggleClass("ng-hide",!0)}),a.task.rowsManager.gantt.api.directives.raise["new"]("ganttBounds",a,c),a.$on("$destroy",function(){a.task.rowsManager.gantt.api.directives.raise.destroy("ganttBounds",a,c)})}]}}])}(),function(){"use strict";angular.module("gantt.groups").controller("GanttGroupController",["$scope","GanttTaskGroup","ganttUtils",function(a,b,c){var d=function(){var d=a.row.model.groups;"boolean"==typeof d&&(d={enabled:d});var e=c.firstProperty([d],"enabled",a.pluginScope.enabled);e?(a.display=c.firstProperty([d],"display",a.pluginScope.display),a.taskGroup=new b(a.row,a.pluginScope),a.row.setFromTo(),a.row.setFromToByValues(a.taskGroup.from,a.taskGroup.to)):(a.taskGroup=void 0,a.display=void 0)};a.gantt.api.tasks.on.change(a,function(b){if(void 0!==a.taskGroup)if(a.taskGroup.tasks.indexOf(b)>-1)a.$evalAsync(function(){d()});else{var c=a.pluginScope.hierarchy.descendants(a.row);c.indexOf(b.row)>-1&&a.$evalAsync(function(){d()})}}),a.pluginScope.$watch("display",function(){d()}),a.$watchCollection("gantt.rowsManager.filteredRows",function(){d()}),a.gantt.api.columns.on.refresh(a,function(){d()})}])}(),function(){"use strict";angular.module("gantt.groups").directive("ganttTaskGroup",["GanttDirectiveBuilder",function(a){var b=new a("ganttTaskGroup","plugins/groups/taskGroup.tmpl.html");return b.build()}])}(),function(){"use strict";angular.module("gantt").factory("GanttTaskGroup",["ganttUtils","GanttTask",function(a,b){var c=function(c,d){var e=this;e.row=c,e.pluginScope=d,e.descendants=e.pluginScope.hierarchy.descendants(e.row),e.tasks=[],e.overviewTasks=[],e.groupedTasks=[],e.promotedTasks=[];var f=e.row.model.groups;"boolean"==typeof f&&(f={enabled:f});var g=function(b){var c=b.model.groups;"boolean"==typeof c&&(c={enabled:c});var d=b.row.model.groups;"boolean"==typeof d&&(d={enabled:d});var g=a.firstProperty([c,d,f],"enabled",e.pluginScope.enabled);if(g){var h=a.firstProperty([c,d,f],"display",e.pluginScope.display);return h}};angular.forEach(e.descendants,function(a){angular.forEach(a.tasks,function(a){void 0!==g(a)&&e.tasks.push(a);var c=g(a);if(void 0!==c){var d=new b(e.row,a.model);"overview"===c?(e.overviewTasks.push(d),d.updatePosAndSize()):"promote"===c?e.promotedTasks.push(d):e.groupedTasks.push(d)}})}),e.from=void 0,angular.forEach(e.tasks,function(a){(void 0===e.from||a.model.from<e.from)&&(e.from=a.model.from)}),e.to=void 0,angular.forEach(e.tasks,function(a){(void 0===e.to||a.model.to>e.to)&&(e.to=a.model.to)}),e.left=c.rowsManager.gantt.getPositionByDate(e.from),e.width=c.rowsManager.gantt.getPositionByDate(e.to)-e.left};return c}])}(),function(){"use strict";angular.module("gantt").directive("ganttTaskOverview",["GanttDirectiveBuilder","moment",function(a,b){var c=new a("ganttTaskOverview","plugins/groups/taskOverview.tmpl.html");return c.controller=function(a,c){a.task.$element=c,a.task.$scope=a,a.simplifyMoment=function(a){return b.isMoment(a)?a.unix():a},a.$watchGroup(["simplifyMoment(task.model.from)","simplifyMoment(task.model.to)"],function(){a.task.updatePosAndSize()})},c.build()}])}(),function(){"use strict";angular.module("gantt.labels").directive("ganttLabelsBody",["GanttDirectiveBuilder","ganttLayout",function(a,b){var c=new a("ganttLabelsBody","plugins/labels/labelsBody.tmpl.html");return c.controller=function(a){var c=b.getScrollBarHeight();a.getLabelsCss=function(){var b={};if(a.maxHeight){var d=a.gantt.scroll.isHScrollbarVisible()?c:0;b["max-height"]=a.maxHeight-d-a.gantt.header.getHeight()+"px"}return b}},c.build()}])}(),function(){"use strict";angular.module("gantt.labels").directive("ganttLabelsHeader",["GanttDirectiveBuilder",function(a){var b=new a("ganttLabelsHeader","plugins/labels/labelsHeader.tmpl.html");return b.build()}])}(),function(){"use strict";angular.module("gantt.labels").directive("ganttSideContentLabels",["GanttDirectiveBuilder",function(a){var b=new a("ganttSideContentLabels","plugins/labels/sideContentLabels.tmpl.html");return b.build()}])}(),function(){"use strict";angular.module("gantt.movable").factory("ganttMovableOptions",[function(){return{initialize:function(a){return a.enabled=void 0!==a.enabled?!!a.enabled:!0,a.allowMoving=void 0!==a.allowMoving?!!a.allowMoving:!0,a.allowResizing=void 0!==a.allowResizing?!!a.allowResizing:!0,a.allowRowSwitching=void 0!==a.allowRowSwitching?!!a.allowRowSwitching:!0,a}}}])}(),function(){"use strict";angular.module("gantt.progress").directive("ganttTaskProgress",["$templateCache",function(a){return{restrict:"E",requires:"^ganttTask",templateUrl:function(b,c){var d;return d=void 0===c.templateUrl?"plugins/progress/taskProgress.tmpl.html":c.templateUrl,void 0!==c.template&&a.put(d,c.template),d},replace:!0,scope:!0,controller:["$scope","$element",function(a,b){a.getClasses=function(){var b=[];return"object"==typeof a.task.model.progress&&(b=a.task.model.progress.classes),b},a.getCss=function(){var b,c={};return void 0!==a.task.model.progress&&(b="object"==typeof a.task.model.progress?a.task.model.progress:{percent:a.task.model.progress}),b&&(c["background-color"]=b.color?b.color:"#6BC443",c.width=b.percent+"%"),c},a.task.rowsManager.gantt.api.directives.raise["new"]("ganttTaskProgress",a,b),a.$on("$destroy",function(){a.task.rowsManager.gantt.api.directives.raise.destroy("ganttTaskProgress",a,b)})}]}}])}(),function(){"use strict";angular.module("gantt.table").directive("ganttSideContentTable",["GanttDirectiveBuilder","ganttLayout",function(a,b){var c=new a("ganttSideContentTable","plugins/table/sideContentTable.tmpl.html");return c.controller=function(a){var c=b.getScrollBarHeight();a.getMaxHeightCss=function(){var b={};if(a.maxHeight){var d=a.gantt.scroll.isHScrollbarVisible()?c:0;b["max-height"]=a.maxHeight-d-a.gantt.header.getHeight()+"px"}return b}},c.build()}])}(),function(){"use strict";angular.module("gantt.table").controller("TableColumnController",["$scope",function(a){a.getHeader=function(){var b=a.pluginScope.headers[a.column];return void 0!==b?b:(void 0!==a.pluginScope.headerFormatter&&(b=a.pluginScope.headerFormatter(a.column)),void 0!==b?b:b)},a.getHeaderContent=function(){var b=a.pluginScope.headerContents[a.column];return void 0===b?"{{getHeader()}}":b},a.getClass=function(){return a.pluginScope.classes[a.column]}}])}(),function(){"use strict";angular.module("gantt.table").controller("TableColumnRowController",["$scope",function(a){a.getValue=function(){var b=a.$eval(a.column,a.row),c=a.pluginScope.formatters[a.column];return void 0!==c&&(b=c(b,a.column,a.row)),b},a.getRowContent=function(){var b;return a.row.model.columnContents&&(b=a.row.model.columnContents[a.column]),void 0===b&&"model.name"===a.column&&(b=a.row.model.content),void 0===b&&(b=a.pluginScope.contents[a.column]),void 0===b&&"model.name"===a.column&&(b=a.row.rowsManager.gantt.options.value("rowContent")),void 0===b&&void 0!==a.pluginScope.content&&(b=a.pluginScope.content),void 0===b?"{{getValue()}}":b}}])}(),function(){"use strict";angular.module("gantt.tooltips").directive("ganttTooltip",["$timeout","$compile","$document","$templateCache","ganttDebounce","ganttSmartEvent",function(a,b,c,d,e,f){return{restrict:"E",templateUrl:function(a,b){var c;return c=void 0===b.templateUrl?"plugins/tooltips/tooltip.tmpl.html":b.templateUrl,void 0!==b.template&&d.put(c,b.template),c},scope:!0,replace:!0,controller:["$scope","$element","ganttUtils",function(b,d,g){var h,i,j=angular.element(c[0].body),k=b.task.$element,l=!1;b.getFromLabel=function(){var a=b.task.model.tooltips,c=b.task.row.model.tooltips;"boolean"==typeof a&&(a={enabled:a}),"boolean"==typeof c&&(c={enabled:c});var d=g.firstProperty([a,c],"dateFormat",b.pluginScope.dateFormat);return b.task.model.from.format(d)},b.getToLabel=function(){var a=b.task.model.tooltips,c=b.task.row.model.tooltips;"boolean"==typeof a&&(a={enabled:a}),"boolean"==typeof c&&(c={enabled:c});var d=g.firstProperty([a,c],"dateFormat",b.pluginScope.dateFormat);return b.task.model.to.format(d)};var m=f(b,j,"mousemove",e(function(a){l?((a.clientX<b.taskRect.left||a.clientX>b.taskRect.right||a.clientY>b.taskRect.bottom||a.clientY<b.taskRect.top)&&n(!1,!1),q(a.clientX)):(i=a.clientX,n(!0,!1))},5,!1));b.task.getContentElement().bind("mousemove",function(a){i=a.clientX}),b.task.getContentElement().bind("mouseenter",function(a){i=a.clientX,n(!0,!0)}),b.task.getContentElement().bind("mouseleave",function(){n(!1)}),b.pluginScope.api.tasks.on.moveBegin&&(b.pluginScope.api.tasks.on.moveBegin(b,function(a){a===b.task&&n(!0)}),b.pluginScope.api.tasks.on.moveEnd(b,function(a){a===b.task&&n(!1)}),b.pluginScope.api.tasks.on.resizeBegin(b,function(a){a===b.task&&n(!0)}),b.pluginScope.api.tasks.on.resizeEnd(b,function(a){a===b.task&&n(!1)}));var n=function(c,d){h&&a.cancel(h);var e=b.task.model.tooltips,f=b.task.row.model.tooltips;"boolean"==typeof e&&(e={enabled:e}),"boolean"==typeof f&&(f={enabled:f});var j=g.firstProperty([e,f],"enabled",b.pluginScope.enabled);j&&!l&&c?d?h=a(function(){o(i)},500,!1):o(i):c||b.task.active||r()},o=function(a){l=!0,m.bind(),b.displayed=!0,b.$evalAsync(function(){var c;d.hasClass("ng-hide")&&(d.removeClass("ng-hide"),c=!0),b.elementHeight=d[0].offsetHeight,c&&d.addClass("ng-hide"),b.taskRect=k[0].getBoundingClientRect(),q(a)})},p=function(){var a=c[0];return a.documentElement.clientWidth||a.documentElement.getElementById("body")[0].clientWidth},q=function(a){a+d[0].offsetWidth>p()?(d.css("left",a+20-d[0].offsetWidth+"px"),b.isRightAligned=!0):(d.css("left",a-20+"px"),b.isRightAligned=!1)},r=function(){l=!1,m.unbind(),b.$evalAsync(function(){b.displayed=!1})};b.task.isMoving&&n(!0,!1),b.gantt.api.directives.raise["new"]("ganttTooltip",b,d),b.$on("$destroy",function(){b.gantt.api.directives.raise.destroy("ganttTooltip",b,d)})}]}}])}(),function(){"use strict";angular.module("gantt.tree").directive("ganttRowTreeLabel",["GanttDirectiveBuilder",function(a){var b=new a("ganttRowTreeLabel");return b.restrict="A",b.templateUrl=void 0,b.build()}])}(),function(){"use strict";angular.module("gantt.tree").directive("ganttSideContentTree",["GanttDirectiveBuilder",function(a){var b=new a("ganttSideContentTree","plugins/tree/sideContentTree.tmpl.html");return b.build()}])}(),function(){"use strict";angular.module("gantt.tree").controller("GanttTreeController",["$scope","$filter","GanttHierarchy",function(a,b,c){a.rootRows=[],a.getHeader=function(){return a.pluginScope.header};var d=new c;a.pluginScope.$watchGroup(["keepAncestorOnFilterRow","enabled"],function(c){var e=c[0]&&c[1];if(e){var f=function(a,c,e){d.refresh(a);var f=[];angular.forEach(a,function(a){var b=d.children(a);b&&0!==b.length||f.push(a)});var g=b("filter")(f,c,e),h=function(a){if(g.indexOf(a)>-1)return!0;for(var b=d.descendants(a),c=0;c<b.length;c++)if(g.indexOf(b[c])>-1)return!0;return!1};return b("filter")(a,h,e)};a.gantt.rowsManager.setFilterImpl(f)}else a.gantt.rowsManager.setFilterImpl(!1)});var e=function(b){for(var c=a.parent(b);void 0!==c;){if(void 0!==c&&c._collapsed)return!1;c=a.parent(c)}return!0},f=function(a){return a.filter(function(a){return e(a)})},g=function(b){var c=[],d=[],e=!1;angular.forEach(b,function(b){var c=a.parent(b);void 0===c?d.push(b):e=!0});var f=function(d){c.push(d);var e=a.children(d);if(void 0!==e&&e.length>0){var g=e.sort(function(a,c){return b.indexOf(a)-b.indexOf(c)});angular.forEach(g,function(a){f(a)})}};return angular.forEach(d,function(a){f(a)}),c};a.gantt.api.rows.addRowSorter(g),a.gantt.api.rows.addRowFilter(f),a.$on("$destroy",function(){a.gantt.api.rows.removeRowSorter(g),a.gantt.api.rows.removeRowFilter(f)});var h=function(){a.rootRows=d.refresh(a.gantt.rowsManager.filteredRows),a.gantt.rowsManager.filteredRows.length>0&&(a.gantt.api.rows.sort(),a.gantt.api.rows.refresh())},i=function(b){var c;return c="string"==typeof b?a.gantt.rowsManager.rowsMap[b]:b,void 0===c?void 0:void 0===c._collapsed?!1:c._collapsed},j=function(b){var c;if(c="string"==typeof b?a.gantt.rowsManager.rowsMap[b]:b,void 0!==c){var d=a.nodeScopes[c.model.id];d.collapsed&&d.toggle()
}},k=function(b){var c;if(c="string"==typeof b?a.gantt.rowsManager.rowsMap[b]:b,void 0!==c){var d=a.nodeScopes[c.model.id];d.collapsed||d.toggle()}},l=function(){return d};a.getHeaderContent=function(){return a.pluginScope.headerContent},a.gantt.api.registerMethod("tree","refresh",h,this),a.gantt.api.registerMethod("tree","isCollapsed",i,this),a.gantt.api.registerMethod("tree","expand",j,this),a.gantt.api.registerMethod("tree","collapse",k,this),a.gantt.api.registerEvent("tree","collapsed"),a.gantt.api.registerMethod("tree","getHierarchy",l,this),a.$watchCollection("gantt.rowsManager.filteredRows",function(){h()}),a.children=function(b){return void 0===b?a.rootRows:d.children(b)},a.parent=function(a){return d.parent(a)},a.nodeScopes={}}]).controller("GanttUiTreeController",["$scope",function(a){var b=function(){a.collapseAll()},c=function(){a.expandAll()};a.gantt.api.registerMethod("tree","collapseAll",b,a),a.gantt.api.registerMethod("tree","expandAll",c,a)}]).controller("GanttTreeNodeController",["$scope",function(a){a.$parent.nodeScopes[a.row.model.id]=a,a.$on("$destroy",function(){delete a.$parent.nodeScopes[a.row.model.id]}),a.$watch("children(row)",function(b){if(b){for(var c=a.row.rowsManager.filteredRows,d=[],e=0;e<b.length;e++){var f=b[e];c.indexOf(f)>-1&&d.push(f)}a.$parent.childrenRows=d}else a.$parent.childrenRows=b}),a.isCollapseDisabled=function(){return!a.$parent.childrenRows||0===a.$parent.childrenRows.length},a.getValue=function(){return a.row.model.name},a.getRowContent=function(){if(void 0!==a.row.model.content)return a.row.model.content;if(void 0!==a.pluginScope.content)return a.pluginScope.content;var b=a.row.rowsManager.gantt.options.value("rowContent");return void 0===b&&(b="{{row.model.name}}"),b},a.$watch("collapsed",function(b){if(a.$modelValue._collapsed!==b){var c=a.$modelValue._collapsed;a.$modelValue._collapsed=b,void 0!==c&&b!==c&&(a.gantt.api.tree.raise.collapsed(a,a.$modelValue,b),a.gantt.api.rows.refresh())}})}])}(),function(){"use strict";angular.module("gantt.tree").directive("ganttTreeBody",["GanttDirectiveBuilder","ganttLayout",function(a,b){var c=new a("ganttTreeBody","plugins/tree/treeBody.tmpl.html");return c.controller=function(a){var c=b.getScrollBarHeight();a.getLabelsCss=function(){var b={};if(a.maxHeight){var d=a.gantt.scroll.isHScrollbarVisible()?c:0;b["max-height"]=a.maxHeight-d-a.gantt.header.getHeight()+"px"}return b}},c.build()}])}(),function(){"use strict";angular.module("gantt.tree").directive("ganttTreeHeader",["GanttDirectiveBuilder",function(a){var b=new a("ganttTreeHeader","plugins/tree/treeHeader.tmpl.html");return b.build()}])}(),angular.module("gantt.bounds.templates",[]).run(["$templateCache",function(a){a.put("plugins/bounds/taskBounds.tmpl.html",'<div ng-cloak class="gantt-task-bounds" ng-style="getCss()" ng-class="getClass()"></div>\n')}]),angular.module("gantt.drawtask.templates",[]).run(["$templateCache",function(){}]),angular.module("gantt.groups.templates",[]).run(["$templateCache",function(a){a.put("plugins/groups/taskGroup.tmpl.html",'<div ng-controller="GanttGroupController">\n    <div class="gantt-task-group-overview" ng-show="taskGroup.overviewTasks.length > 0">\n        <gantt-task-overview ng-repeat="task in taskGroup.overviewTasks"></gantt-task-overview>\n    </div>\n    <div class="gantt-task-group-promote" ng-show="taskGroup.row._collapsed && taskGroup.promotedTasks.length > 0">\n        <gantt-task ng-repeat="task in taskGroup.promotedTasks"></gantt-task>\n    </div>\n    <div class="gantt-task-group"\n         ng-show="taskGroup.groupedTasks.length > 0"\n         ng-style="{\'left\': taskGroup.left + \'px\', \'width\': taskGroup.width + \'px\'}">\n        <div class="gantt-task-group-left-main"></div>\n        <div class="gantt-task-group-right-main"></div>\n        <div class="gantt-task-group-left-symbol"></div>\n        <div class="gantt-task-group-right-symbol"></div>\n    </div>\n</div>\n\n'),a.put("plugins/groups/taskOverview.tmpl.html",'<div class="gantt-task gantt-task-overview" ng-class="task.model.classes">\n    <gantt-task-background></gantt-task-background>\n    <gantt-task-content></gantt-task-content>\n    <gantt-task-foreground></gantt-task-foreground>\n</div>\n\n')}]),angular.module("gantt.labels.templates",[]).run(["$templateCache",function(a){a.put("plugins/labels/labelsBody.tmpl.html",'<div class="gantt-labels-body" ng-style="getLabelsCss()">\n    <div gantt-vertical-scroll-receiver>\n        <div ng-repeat="row in gantt.rowsManager.visibleRows track by row.model.id">\n            <div gantt-row-label\n                 class="gantt-row-label gantt-row-height"\n                 ng-class="row.model.classes"\n                 ng-style="{\'height\': row.model.height}">\n                <span class="gantt-label-text">{{row.model.name}}</span>\n            </div>\n        </div>\n    </div>\n</div>\n'),a.put("plugins/labels/labelsHeader.tmpl.html",'<div class="gantt-labels-header">\n    <div ng-show="gantt.columnsManager.columns.length > 0 && gantt.columnsManager.headers.length > 0">\n        <div ng-repeat="header in gantt.columnsManager.headers">\n            <div class="gantt-row-height" ng-class="{\'gantt-labels-header-row\': $last, \'gantt-labels-header-row-last\': $last}"><span>{{$last ? pluginScope.header : ""}}</span></div>\n        </div>\n    </div>\n</div>\n'),a.put("plugins/labels/sideContentLabels.tmpl.html",'<div class="gantt-side-content-labels">\n    <gantt-labels-header>\n    </gantt-labels-header>\n    <gantt-labels-body>\n    </gantt-labels-body>\n</div>\n')}]),angular.module("gantt.movable.templates",[]).run(["$templateCache",function(){}]),angular.module("gantt.overlap.templates",[]).run(["$templateCache",function(){}]),angular.module("gantt.progress.templates",[]).run(["$templateCache",function(a){a.put("plugins/progress/taskProgress.tmpl.html",'<div ng-cloak class="gantt-task-progress" ng-style="getCss()" ng-class="getClasses()"></div>\n')}]),angular.module("gantt.resizeSensor.templates",[]).run(["$templateCache",function(){}]),angular.module("gantt.sortable.templates",[]).run(["$templateCache",function(){}]),angular.module("gantt.table.templates",[]).run(["$templateCache",function(a){a.put("plugins/table/sideContentTable.tmpl.html",'<div class="gantt-side-content-table">\n\n    <div class="gantt-table-column {{getClass()}}" ng-repeat="column in pluginScope.columns" ng-controller="TableColumnController">\n\n        <div class="gantt-table-header" ng-style="{height: ganttHeaderHeight + \'px\'}">\n            <div ng-show="ganttHeaderHeight" class="gantt-row-label-header gantt-row-label gantt-table-row gantt-table-header-row">\n                <span class="gantt-label-text" gantt-bind-compile-html="getHeaderContent()"/>\n            </div>\n        </div>\n\n        <div class="gantt-table-content" ng-style="getMaxHeightCss()">\n            <div gantt-vertical-scroll-receiver>\n                <div class="gantt-table-row" ng-repeat="row in gantt.rowsManager.visibleRows track by row.model.id" ng-controller="TableColumnRowController">\n                    <div gantt-row-label class="gantt-row-label gantt-row-height" ng-class="row.model.classes" ng-style="{\'height\': row.model.height}">\n                        <div class="gantt-valign-container">\n                            <div class="gantt-valign-content">\n                                <span class="gantt-label-text" gantt-bind-compile-html="getRowContent()"></span>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n\n    </div>\n</div>\n')}]),angular.module("gantt.tooltips.templates",[]).run(["$templateCache",function(a){a.put("plugins/tooltips/tooltip.tmpl.html",'<div ng-cloak\n     class="gantt-task-info"\n     ng-show="displayed"\n     ng-class="isRightAligned ? \'gantt-task-infoArrowR\' : \'gantt-task-infoArrow\'"\n     ng-style="{top: taskRect.top + \'px\', marginTop: -elementHeight - 8 + \'px\'}">\n    <div class="gantt-task-info-content">\n        <div gantt-bind-compile-html="pluginScope.content"></div>\n    </div>\n</div>\n')}]),angular.module("gantt.tree.templates",[]).run(["$templateCache",function(a){a.put("plugins/tree/sideContentTree.tmpl.html",'<div class="gantt-side-content-tree" ng-controller="GanttTreeController">\n    <gantt-tree-header>\n    </gantt-tree-header>\n    <gantt-tree-body>\n    </gantt-tree-body>\n</div>\n'),a.put("plugins/tree/treeBody.tmpl.html",'<div class="gantt-tree-body" ng-style="getLabelsCss()">\n    <div gantt-vertical-scroll-receiver>\n        <div class="gantt-row-label-background">\n            <div class="gantt-row-label gantt-row-height"\n                 ng-class="row.model.classes"\n                 ng-style="{\'height\': row.model.height}"\n                 ng-repeat="row in gantt.rowsManager.visibleRows track by row.model.id">\n                &nbsp;\n            </div>\n        </div>\n        <div ui-tree ng-controller="GanttUiTreeController" data-drag-enabled="false" data-empty-place-holder-enabled="false">\n            <ol class="gantt-tree-root" ui-tree-nodes ng-model="rootRows">\n                <li ng-repeat="row in rootRows" ui-tree-node\n                    ng-include="\'plugins/tree/treeBodyChildren.tmpl.html\'">\n                </li>\n            </ol>\n        </div>\n    </div>\n</div>\n'),a.put("plugins/tree/treeBodyChildren.tmpl.html",'<div ng-controller="GanttTreeNodeController"\n     class="gantt-row-label gantt-row-height"\n     ng-class="row.model.classes"\n     ng-style="{\'height\': row.model.height}">\n    <div class="gantt-valign-container">\n        <div class="gantt-valign-content">\n            <a ng-disabled="isCollapseDisabled()" data-nodrag\n               class="gantt-tree-handle-button btn btn-xs"\n               ng-class="{\'gantt-tree-collapsed\': collapsed, \'gantt-tree-expanded\': !collapsed}"\n               ng-click="!isCollapseDisabled() && toggle()"><span\n                class="gantt-tree-handle glyphicon glyphicon-chevron-down"\n                ng-class="{\n                \'glyphicon-chevron-right\': collapsed, \'glyphicon-chevron-down\': !collapsed,\n                \'gantt-tree-collapsed\': collapsed, \'gantt-tree-expanded\': !collapsed}"></span>\n            </a>\n            <span gantt-row-label class="gantt-label-text" gantt-bind-compile-html="getRowContent()"/>\n        </div>\n    </div>\n</div>\n<ol ui-tree-nodes ng-class="{hidden: collapsed}" ng-model="childrenRows">\n    <li ng-repeat="row in childrenRows" ui-tree-node>\n        <div ng-include="\'plugins/tree/treeBodyChildren.tmpl.html\'"></div>\n    </li>\n</ol>\n'),a.put("plugins/tree/treeHeader.tmpl.html",'<div class="gantt-tree-header" ng-style="{height: $parent.ganttHeaderHeight + \'px\'}">\n    <div ng-if="$parent.ganttHeaderHeight" class="gantt-row-label gantt-row-label-header gantt-tree-row gantt-tree-header-row"><span class="gantt-label-text" gantt-bind-compile-html="getHeaderContent()"/></div>\n</div>\n')}]);
//# sourceMappingURL=angular-gantt-plugins.min.js.map